/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.jakarta_servlet;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.WebEndpoint;
import com.slack.api.bolt.handler.WebEndpointHandler;
import com.slack.api.bolt.jakarta_servlet.WebEndpointServletAdapter;
import com.slack.api.bolt.request.WebEndpointRequest;
import com.slack.api.bolt.response.Response;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebEndpointServlet
extends HttpServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebEndpointServlet.class);
    private final WebEndpoint endpoint;
    private final WebEndpointHandler handler;
    private final WebEndpointServletAdapter adapter;

    public WebEndpointServlet(WebEndpoint endpoint, WebEndpointHandler handler, AppConfig config) {
        this.endpoint = endpoint;
        this.handler = handler;
        this.adapter = new WebEndpointServletAdapter(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.endpoint.getMethod() == WebEndpoint.Method.GET && this.endpoint.getPath().equals(req.getRequestURI())) {
            this.runHandler(req, resp);
        } else {
            this.respondAsError(resp, 404, "{\"error\":\"Not found\"}");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.endpoint.getMethod() == WebEndpoint.Method.POST && this.endpoint.getPath().equals(req.getRequestURI())) {
            this.runHandler(req, resp);
        } else {
            this.respondAsError(resp, 404, "{\"error\":\"Not found\"}");
        }
    }

    private void runHandler(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WebEndpointRequest slackReq = this.adapter.buildSlackRequest(req);
        if (slackReq != null) {
            try {
                Response slackResp = this.handler.apply(slackReq, slackReq.getContext());
                this.adapter.writeResponse(resp, slackResp);
            }
            catch (Exception e) {
                log.error("Failed to handle a request - {}", (Object)e.getMessage(), (Object)e);
                this.respondAsError(resp, 500, "{\"error\":\"Something is wrong\"}");
            }
        }
    }

    protected void respondAsError(HttpServletResponse resp, int status, String json) throws IOException {
        resp.setStatus(status);
        resp.setContentType("application/json");
        resp.getWriter().write(json);
    }
}

