/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.jakarta_servlet;

import com.slack.api.bolt.App;
import com.slack.api.bolt.jakarta_servlet.SlackAppServletAdapter;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackOAuthAppServlet
extends HttpServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackOAuthAppServlet.class);
    private final App app;
    private final SlackAppServletAdapter adapter;

    public App getApp() {
        return this.app;
    }

    public SlackOAuthAppServlet(App app) {
        this.app = app;
        this.adapter = new SlackAppServletAdapter(app.config());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Request<?> slackReq = this.adapter.buildSlackRequest(req);
        if (slackReq != null) {
            try {
                Response slackResp = this.app.run(slackReq);
                this.adapter.writeResponse(resp, slackResp);
            }
            catch (Exception e) {
                log.error("Failed to handle a request - {}", (Object)e.getMessage(), (Object)e);
                resp.setStatus(500);
                resp.setContentType("application/json");
                resp.getWriter().write("{\"error\":\"Something is wrong\"}");
            }
        }
    }
}

