/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.jetty;

import com.slack.api.bolt.App;
import com.slack.api.bolt.WebEndpoint;
import com.slack.api.bolt.handler.WebEndpointHandler;
import com.slack.api.bolt.servlet.SlackAppServlet;
import com.slack.api.bolt.servlet.SlackOAuthAppServlet;
import com.slack.api.bolt.servlet.WebEndpointServlet;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackAppServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackAppServer.class);
    private final Server server;
    private final Map<String, App> pathToApp;
    private final boolean localDebug = System.getenv("SLACK_APP_LOCAL_DEBUG") != null;
    private ErrorHandler errorHandler = new ErrorHandler(){

        protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
            if (SlackAppServer.this.localDebug) {
                super.writeErrorPage(request, writer, code, message, showStacks);
            } else {
                writer.write("{\"status\":\"" + code + "\"}");
            }
        }
    };

    public SlackAppServer(App app) {
        this(app, "/slack/events", 3000);
    }

    public SlackAppServer(App app, String path) {
        this(app, path, 3000);
    }

    public SlackAppServer(App app, int port) {
        this(SlackAppServer.toApps(app, "/slack/events"), port);
    }

    public SlackAppServer(App app, String path, int port) {
        this(SlackAppServer.toApps(app, path), port);
    }

    public SlackAppServer(Map<String, App> pathToApp) {
        this(pathToApp, 3000);
    }

    public SlackAppServer(Map<String, App> pathToApp, int port) {
        this.pathToApp = pathToApp;
        this.server = new Server(port);
        SlackAppServer.removeServerHeader(this.server);
        ServletContextHandler handler = new ServletContextHandler();
        HashMap<String, App> addedOnes = new HashMap<String, App>();
        for (Map.Entry<String, App> entry : this.pathToApp.entrySet()) {
            String appPath = entry.getKey();
            App theApp = entry.getValue();
            theApp.config().setAppPath(appPath);
            handler.addServlet(new ServletHolder((Servlet)new SlackAppServlet(theApp)), appPath);
            if (theApp.config().isOAuthStartEnabled()) {
                if (theApp.config().isDistributedApp()) {
                    String oAuthStartPath = appPath + theApp.config().getOauthStartPath();
                    App oAuthStartApp = theApp.toOAuthStartApp();
                    handler.addServlet(new ServletHolder((Servlet)new SlackOAuthAppServlet(oAuthStartApp)), oAuthStartPath);
                    addedOnes.put(oAuthStartPath, oAuthStartApp);
                } else {
                    log.warn("The app is not ready for handling your Slack App installation URL. Make sure if you set all the necessary values in AppConfig.");
                }
            }
            if (theApp.config().isOAuthCallbackEnabled()) {
                if (theApp.config().isDistributedApp()) {
                    String oAuthCallbackPath = appPath + theApp.config().getOauthCallbackPath();
                    App oAuthCallbackApp = theApp.toOAuthCallbackApp();
                    handler.addServlet(new ServletHolder((Servlet)new SlackOAuthAppServlet(oAuthCallbackApp)), oAuthCallbackPath);
                    addedOnes.put(oAuthCallbackPath, oAuthCallbackApp);
                } else {
                    log.warn("The app is not ready for handling OAuth callback requests. Make sure if you set all the necessary values in AppConfig.");
                }
            }
            if (theApp.getWebEndpointHandlers() == null || theApp.getWebEndpointHandlers().size() <= 0) continue;
            for (Map.Entry ee : theApp.getWebEndpointHandlers().entrySet()) {
                WebEndpoint endpoint = (WebEndpoint)ee.getKey();
                WebEndpointHandler endpointHandler = (WebEndpointHandler)ee.getValue();
                ServletHolder servletHolder = new ServletHolder((Servlet)new WebEndpointServlet(endpoint, endpointHandler, theApp.config()));
                handler.addServlet(servletHolder, endpoint.getPath());
            }
        }
        pathToApp.putAll(addedOnes);
        this.server.setHandler((Handler)handler);
        this.server.setErrorHandler(this.errorHandler);
    }

    public void start() throws Exception {
        for (App app : this.pathToApp.values()) {
            app.start();
        }
        this.server.start();
        log.info("\u26a1\ufe0f Bolt app is running!");
        this.server.join();
    }

    public void stop() throws Exception {
        for (App app : this.pathToApp.values()) {
            app.stop();
        }
        log.info("\u26a1\ufe0f Your Bolt app has stopped...");
        this.server.stop();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private static Map<String, App> toApps(App app, String path) {
        HashMap<String, App> apps = new HashMap<String, App>();
        apps.put(path, app);
        return apps;
    }

    private static void removeServerHeader(Server server) {
        for (Connector y : server.getConnectors()) {
            for (ConnectionFactory x : y.getConnectionFactories()) {
                if (!(x instanceof HttpConnectionFactory)) continue;
                ((HttpConnectionFactory)x).getHttpConfiguration().setSendServerVersion(false);
            }
        }
    }
}

