/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.interactive_components.payload.BlockActionPayload;
import com.slack.api.bolt.context.builtin.ActionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class BlockActionRequest
extends Request<ActionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final BlockActionPayload payload;
    private ActionContext context = new ActionContext();

    public BlockActionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (BlockActionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, BlockActionPayload.class);
        if (this.payload != null) {
            this.getContext().setFunctionBotAccessToken(this.payload.getBotAccessToken());
            this.getContext().setResponseUrl(this.payload.getResponseUrl());
            this.getContext().setTriggerId(this.payload.getTriggerId());
            if (this.payload.getTriggerId() == null && this.payload.getInteractivity() != null && this.payload.getInteractivity().getInteractivityPointer() != null) {
                this.getContext().setTriggerId(this.payload.getInteractivity().getInteractivityPointer());
            }
            if (this.payload.getEnterprise() != null) {
                this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
            } else if (this.payload.getTeam() != null) {
                this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
            }
            if (this.payload.getTeam() != null && this.payload.getTeam().getId() != null) {
                this.getContext().setTeamId(this.payload.getTeam().getId());
            } else if (this.payload.getUser() != null && this.payload.getUser().getTeamId() != null) {
                this.getContext().setTeamId(this.payload.getUser().getTeamId());
            }
            this.getContext().setRequestUserId(this.payload.getUser().getId());
            if (this.payload.getFunctionData() != null) {
                this.getContext().setFunctionExecutionId(this.payload.getFunctionData().getExecutionId());
            }
        }
    }

    @Override
    public ActionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.BlockAction;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public BlockActionPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return this.getPayload() != null ? this.getPayload().getResponseUrl() : null;
    }

    @Override
    @Generated
    public String toString() {
        return "BlockActionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

