/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.app_backend.events.payload.Authorization;
import com.slack.api.app_backend.events.payload.EventsApiPayload;
import com.slack.api.bolt.request.builtin.EventRequest;
import com.slack.api.model.event.Event;
import com.slack.api.util.json.GsonFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsApiPayloadParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventsApiPayloadParser.class);
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private static final Map<Class<? extends Event>, String> eventTypeAndSubtypeValues = new HashMap<Class<? extends Event>, String>();

    public static final String getEventTypeAndSubtype(Class<? extends Event> clazz) {
        String cached = eventTypeAndSubtypeValues.get(clazz);
        if (cached != null) {
            return cached;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            try {
                Event event = (Event)constructor.newInstance(new Object[0]);
                String typeAndSubtype = event.getType();
                if (event.getSubtype() != null) {
                    typeAndSubtype = event.getType() + ":" + event.getSubtype();
                }
                eventTypeAndSubtypeValues.put(clazz, typeAndSubtype);
                return typeAndSubtype;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.error("Unexpectedly failed to load event type for the class {}", (Object)clazz.getCanonicalName());
                break;
            }
        }
        return null;
    }

    public static <E extends Event> EventsApiPayload<E> buildEventPayload(EventRequest request) {
        BoltEventPayload payload = (BoltEventPayload)GSON.fromJson(request.getRequestBodyAsString(), BoltEventPayload.class);
        Class<E> eventClass = EventsApiPayloadParser.getEventClass(request.getEventTypeAndSubtype());
        if (eventClass != null) {
            Event event = (Event)GSON.fromJson((JsonElement)((JsonElement)GSON.fromJson(request.getRequestBodyAsString(), JsonElement.class)).getAsJsonObject().get("event").getAsJsonObject(), eventClass);
            payload.setEvent(event);
        }
        return payload;
    }

    public static final <E extends Event> Class<E> getEventClass(String eventType) {
        for (Map.Entry<Class<? extends Event>, String> entry : eventTypeAndSubtypeValues.entrySet()) {
            if (!entry.getValue().equals(eventType)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isAssistantThreadStartedOrContextChangedEvent(JsonObject event) {
        return event.get("assistant_thread") != null && event.get("assistant_thread").getAsJsonObject().get("channel_id") != null && event.get("assistant_thread").getAsJsonObject().get("thread_ts") != null;
    }

    public static boolean isMessageEventInAssistantThread(JsonObject event) {
        if (event.get("channel_type") != null && event.get("channel_type").getAsString().equals("im")) {
            if (event.get("thread_ts") != null) {
                return true;
            }
            if (event.get("message") != null) {
                return EventsApiPayloadParser.isAssistantThreadMessageSubEvent(event, "message");
            }
            if (event.get("previous_message") != null) {
                return EventsApiPayloadParser.isAssistantThreadMessageSubEvent(event, "previous_message");
            }
        }
        return false;
    }

    public static boolean isAssistantThreadMessageSubEvent(JsonObject event, String message) {
        JsonElement subtype = event.get(message).getAsJsonObject().get("subtype");
        return subtype != null && subtype.getAsString().equals("assistant_app_thread") || event.get(message).getAsJsonObject().get("thread_ts") != null;
    }

    private static class BoltEventPayload<E extends Event>
    implements EventsApiPayload<E> {
        private String token;
        private String enterpriseId;
        private String teamId;
        private String apiAppId;
        private String type;
        private List<String> authedUsers;
        private List<String> authedTeams;
        private List<Authorization> authorizations;
        private boolean isExtSharedChannel;
        private String eventId;
        private Integer eventTime;
        private String eventContext;
        private transient E event;

        @Generated
        public BoltEventPayload() {
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public String getEnterpriseId() {
            return this.enterpriseId;
        }

        @Generated
        public String getTeamId() {
            return this.teamId;
        }

        @Generated
        public String getApiAppId() {
            return this.apiAppId;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public List<String> getAuthedUsers() {
            return this.authedUsers;
        }

        @Generated
        public List<String> getAuthedTeams() {
            return this.authedTeams;
        }

        @Generated
        public List<Authorization> getAuthorizations() {
            return this.authorizations;
        }

        @Generated
        public boolean isExtSharedChannel() {
            return this.isExtSharedChannel;
        }

        @Generated
        public String getEventId() {
            return this.eventId;
        }

        @Generated
        public Integer getEventTime() {
            return this.eventTime;
        }

        @Generated
        public String getEventContext() {
            return this.eventContext;
        }

        @Generated
        public E getEvent() {
            return this.event;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @Generated
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Generated
        public void setApiAppId(String apiAppId) {
            this.apiAppId = apiAppId;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setAuthedUsers(List<String> authedUsers) {
            this.authedUsers = authedUsers;
        }

        @Generated
        public void setAuthedTeams(List<String> authedTeams) {
            this.authedTeams = authedTeams;
        }

        @Generated
        public void setAuthorizations(List<Authorization> authorizations) {
            this.authorizations = authorizations;
        }

        @Generated
        public void setExtSharedChannel(boolean isExtSharedChannel) {
            this.isExtSharedChannel = isExtSharedChannel;
        }

        @Generated
        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Generated
        public void setEventTime(Integer eventTime) {
            this.eventTime = eventTime;
        }

        @Generated
        public void setEventContext(String eventContext) {
            this.eventContext = eventContext;
        }

        @Generated
        public void setEvent(E event) {
            this.event = event;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BoltEventPayload)) {
                return false;
            }
            BoltEventPayload other = (BoltEventPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExtSharedChannel() != other.isExtSharedChannel()) {
                return false;
            }
            Integer this$eventTime = this.getEventTime();
            Integer other$eventTime = other.getEventTime();
            if (this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$enterpriseId = this.getEnterpriseId();
            String other$enterpriseId = other.getEnterpriseId();
            if (this$enterpriseId == null ? other$enterpriseId != null : !this$enterpriseId.equals(other$enterpriseId)) {
                return false;
            }
            String this$teamId = this.getTeamId();
            String other$teamId = other.getTeamId();
            if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
                return false;
            }
            String this$apiAppId = this.getApiAppId();
            String other$apiAppId = other.getApiAppId();
            if (this$apiAppId == null ? other$apiAppId != null : !this$apiAppId.equals(other$apiAppId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<String> this$authedUsers = this.getAuthedUsers();
            List<String> other$authedUsers = other.getAuthedUsers();
            if (this$authedUsers == null ? other$authedUsers != null : !((Object)this$authedUsers).equals(other$authedUsers)) {
                return false;
            }
            List<String> this$authedTeams = this.getAuthedTeams();
            List<String> other$authedTeams = other.getAuthedTeams();
            if (this$authedTeams == null ? other$authedTeams != null : !((Object)this$authedTeams).equals(other$authedTeams)) {
                return false;
            }
            List<Authorization> this$authorizations = this.getAuthorizations();
            List<Authorization> other$authorizations = other.getAuthorizations();
            if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
                return false;
            }
            String this$eventId = this.getEventId();
            String other$eventId = other.getEventId();
            if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
                return false;
            }
            String this$eventContext = this.getEventContext();
            String other$eventContext = other.getEventContext();
            return !(this$eventContext == null ? other$eventContext != null : !this$eventContext.equals(other$eventContext));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BoltEventPayload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExtSharedChannel() ? 79 : 97);
            Integer $eventTime = this.getEventTime();
            result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $enterpriseId = this.getEnterpriseId();
            result = result * 59 + ($enterpriseId == null ? 43 : $enterpriseId.hashCode());
            String $teamId = this.getTeamId();
            result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
            String $apiAppId = this.getApiAppId();
            result = result * 59 + ($apiAppId == null ? 43 : $apiAppId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<String> $authedUsers = this.getAuthedUsers();
            result = result * 59 + ($authedUsers == null ? 43 : ((Object)$authedUsers).hashCode());
            List<String> $authedTeams = this.getAuthedTeams();
            result = result * 59 + ($authedTeams == null ? 43 : ((Object)$authedTeams).hashCode());
            List<Authorization> $authorizations = this.getAuthorizations();
            result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
            String $eventId = this.getEventId();
            result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
            String $eventContext = this.getEventContext();
            result = result * 59 + ($eventContext == null ? 43 : $eventContext.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EventsApiPayloadParser.BoltEventPayload(token=" + this.getToken() + ", enterpriseId=" + this.getEnterpriseId() + ", teamId=" + this.getTeamId() + ", apiAppId=" + this.getApiAppId() + ", type=" + this.getType() + ", authedUsers=" + this.getAuthedUsers() + ", authedTeams=" + this.getAuthedTeams() + ", authorizations=" + this.getAuthorizations() + ", isExtSharedChannel=" + this.isExtSharedChannel() + ", eventId=" + this.getEventId() + ", eventTime=" + this.getEventTime() + ", eventContext=" + this.getEventContext() + ", event=" + this.getEvent() + ")";
        }
    }
}

