/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.response.admin.analytics;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.slack.api.methods.SlackApiBinaryResponse;
import com.slack.api.model.ResponseMetadata;
import com.slack.api.util.json.GsonFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminAnalyticsGetFileResponse
implements SlackApiBinaryResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminAnalyticsGetFileResponse.class);
    private boolean ok;
    private String error;
    private ResponseMetadata responseMetadata;
    private InputStream fileStream;
    private byte[] loadedBytes = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] asBytes() throws IOException {
        byte[] byArray = this.loadedBytes;
        synchronized (this.loadedBytes) {
            if (this.loadedBytes.length == 0) {
                try (InputStream is = this.getFileStream();){
                    if (is == null) {
                        throw new IOException("The byte stream has been already consumed.");
                    }
                    try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                        int readSize;
                        byte[] data = new byte[1024];
                        while ((readSize = is.read(data, 0, data.length)) != -1) {
                            buffer.write(data, 0, readSize);
                        }
                        buffer.flush();
                        this.loadedBytes = buffer.toByteArray();
                    }
                }
                finally {
                    this.setFileStream(null);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.loadedBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<AnalyticsData> handler) throws IOException {
        Gson gson = GsonFactory.createSnakeCase();
        InputStream is = this.getFileStream();
        if (this.loadedBytes.length > 0) {
            is = new ByteArrayInputStream(this.loadedBytes);
        }
        if (is == null) {
            throw new IOException("The byte stream has been already consumed.");
        }
        try (GZIPInputStream gis = new GZIPInputStream(is);
             InputStreamReader isr = new InputStreamReader(gis);
             BufferedReader br = new BufferedReader(isr);){
            String json;
            while ((json = br.readLine()) != null) {
                try {
                    AnalyticsData data = (AnalyticsData)gson.fromJson(json, AnalyticsData.class);
                    handler.accept(data);
                }
                catch (JsonSyntaxException e) {
                    log.error("Failed to parse a row in analytics data - error: {}, data: {}", new Object[]{e.getMessage(), json, e});
                }
            }
        }
        finally {
            this.setFileStream(null);
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Generated
    public AdminAnalyticsGetFileResponse() {
    }

    @Generated
    public boolean isOk() {
        return this.ok;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public ResponseMetadata getResponseMetadata() {
        return this.responseMetadata;
    }

    @Generated
    public InputStream getFileStream() {
        return this.fileStream;
    }

    @Generated
    public void setOk(boolean ok) {
        this.ok = ok;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setResponseMetadata(ResponseMetadata responseMetadata) {
        this.responseMetadata = responseMetadata;
    }

    @Generated
    public void setFileStream(InputStream fileStream) {
        this.fileStream = fileStream;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminAnalyticsGetFileResponse)) {
            return false;
        }
        AdminAnalyticsGetFileResponse other = (AdminAnalyticsGetFileResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        ResponseMetadata this$responseMetadata = this.getResponseMetadata();
        ResponseMetadata other$responseMetadata = other.getResponseMetadata();
        if (this$responseMetadata == null ? other$responseMetadata != null : !this$responseMetadata.equals(other$responseMetadata)) {
            return false;
        }
        InputStream this$fileStream = this.getFileStream();
        InputStream other$fileStream = other.getFileStream();
        if (this$fileStream == null ? other$fileStream != null : !this$fileStream.equals(other$fileStream)) {
            return false;
        }
        return Arrays.equals(this.loadedBytes, other.loadedBytes);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdminAnalyticsGetFileResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        ResponseMetadata $responseMetadata = this.getResponseMetadata();
        result = result * 59 + ($responseMetadata == null ? 43 : $responseMetadata.hashCode());
        InputStream $fileStream = this.getFileStream();
        result = result * 59 + ($fileStream == null ? 43 : $fileStream.hashCode());
        result = result * 59 + Arrays.hashCode(this.loadedBytes);
        return result;
    }

    @Generated
    public String toString() {
        return "AdminAnalyticsGetFileResponse(ok=" + this.isOk() + ", error=" + this.getError() + ", responseMetadata=" + this.getResponseMetadata() + ", fileStream=" + this.getFileStream() + ", loadedBytes=" + Arrays.toString(this.loadedBytes) + ")";
    }

    public static class AnalyticsData {
        private String date;
        private String enterpriseId;
        private String enterpriseUserId;
        private String emailAddress;
        private String enterpriseEmployeeNumber;
        private Boolean isGuest;
        private Boolean isBillableSeat;
        private Boolean isActive;
        private Boolean isActiveIos;
        private Boolean isActiveAndroid;
        private Boolean isActiveDesktop;
        private Integer reactionsAddedCount;
        private Integer messagesPostedCount;
        private Integer channelMessagesPostedCount;
        private Integer filesAddedCount;
        private OriginatingTeam originatingTeam;
        private String channelId;
        private String channelType;
        private String visibility;
        private List<SharedWith> sharedWith;
        private Boolean isSharedExternally;
        private Integer dateCreated;
        private Integer dateLastActive;
        private Integer totalMembersCount;
        private Integer fullMembersCount;
        private Integer activeMembersCount;
        private Integer guestMembersCount;
        private Integer messagesPostedByMembersCount;
        private Integer membersWhoPostedCount;
        private Integer membersWhoViewedCount;
        private String name;
        private String topic;
        private String description;

        @Generated
        public AnalyticsData() {
        }

        @Generated
        public String getDate() {
            return this.date;
        }

        @Generated
        public String getEnterpriseId() {
            return this.enterpriseId;
        }

        @Generated
        public String getEnterpriseUserId() {
            return this.enterpriseUserId;
        }

        @Generated
        public String getEmailAddress() {
            return this.emailAddress;
        }

        @Generated
        public String getEnterpriseEmployeeNumber() {
            return this.enterpriseEmployeeNumber;
        }

        @Generated
        public Boolean getIsGuest() {
            return this.isGuest;
        }

        @Generated
        public Boolean getIsBillableSeat() {
            return this.isBillableSeat;
        }

        @Generated
        public Boolean getIsActive() {
            return this.isActive;
        }

        @Generated
        public Boolean getIsActiveIos() {
            return this.isActiveIos;
        }

        @Generated
        public Boolean getIsActiveAndroid() {
            return this.isActiveAndroid;
        }

        @Generated
        public Boolean getIsActiveDesktop() {
            return this.isActiveDesktop;
        }

        @Generated
        public Integer getReactionsAddedCount() {
            return this.reactionsAddedCount;
        }

        @Generated
        public Integer getMessagesPostedCount() {
            return this.messagesPostedCount;
        }

        @Generated
        public Integer getChannelMessagesPostedCount() {
            return this.channelMessagesPostedCount;
        }

        @Generated
        public Integer getFilesAddedCount() {
            return this.filesAddedCount;
        }

        @Generated
        public OriginatingTeam getOriginatingTeam() {
            return this.originatingTeam;
        }

        @Generated
        public String getChannelId() {
            return this.channelId;
        }

        @Generated
        public String getChannelType() {
            return this.channelType;
        }

        @Generated
        public String getVisibility() {
            return this.visibility;
        }

        @Generated
        public List<SharedWith> getSharedWith() {
            return this.sharedWith;
        }

        @Generated
        public Boolean getIsSharedExternally() {
            return this.isSharedExternally;
        }

        @Generated
        public Integer getDateCreated() {
            return this.dateCreated;
        }

        @Generated
        public Integer getDateLastActive() {
            return this.dateLastActive;
        }

        @Generated
        public Integer getTotalMembersCount() {
            return this.totalMembersCount;
        }

        @Generated
        public Integer getFullMembersCount() {
            return this.fullMembersCount;
        }

        @Generated
        public Integer getActiveMembersCount() {
            return this.activeMembersCount;
        }

        @Generated
        public Integer getGuestMembersCount() {
            return this.guestMembersCount;
        }

        @Generated
        public Integer getMessagesPostedByMembersCount() {
            return this.messagesPostedByMembersCount;
        }

        @Generated
        public Integer getMembersWhoPostedCount() {
            return this.membersWhoPostedCount;
        }

        @Generated
        public Integer getMembersWhoViewedCount() {
            return this.membersWhoViewedCount;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTopic() {
            return this.topic;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setDate(String date) {
            this.date = date;
        }

        @Generated
        public void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @Generated
        public void setEnterpriseUserId(String enterpriseUserId) {
            this.enterpriseUserId = enterpriseUserId;
        }

        @Generated
        public void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Generated
        public void setEnterpriseEmployeeNumber(String enterpriseEmployeeNumber) {
            this.enterpriseEmployeeNumber = enterpriseEmployeeNumber;
        }

        @Generated
        public void setIsGuest(Boolean isGuest) {
            this.isGuest = isGuest;
        }

        @Generated
        public void setIsBillableSeat(Boolean isBillableSeat) {
            this.isBillableSeat = isBillableSeat;
        }

        @Generated
        public void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Generated
        public void setIsActiveIos(Boolean isActiveIos) {
            this.isActiveIos = isActiveIos;
        }

        @Generated
        public void setIsActiveAndroid(Boolean isActiveAndroid) {
            this.isActiveAndroid = isActiveAndroid;
        }

        @Generated
        public void setIsActiveDesktop(Boolean isActiveDesktop) {
            this.isActiveDesktop = isActiveDesktop;
        }

        @Generated
        public void setReactionsAddedCount(Integer reactionsAddedCount) {
            this.reactionsAddedCount = reactionsAddedCount;
        }

        @Generated
        public void setMessagesPostedCount(Integer messagesPostedCount) {
            this.messagesPostedCount = messagesPostedCount;
        }

        @Generated
        public void setChannelMessagesPostedCount(Integer channelMessagesPostedCount) {
            this.channelMessagesPostedCount = channelMessagesPostedCount;
        }

        @Generated
        public void setFilesAddedCount(Integer filesAddedCount) {
            this.filesAddedCount = filesAddedCount;
        }

        @Generated
        public void setOriginatingTeam(OriginatingTeam originatingTeam) {
            this.originatingTeam = originatingTeam;
        }

        @Generated
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Generated
        public void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Generated
        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Generated
        public void setSharedWith(List<SharedWith> sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Generated
        public void setIsSharedExternally(Boolean isSharedExternally) {
            this.isSharedExternally = isSharedExternally;
        }

        @Generated
        public void setDateCreated(Integer dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Generated
        public void setDateLastActive(Integer dateLastActive) {
            this.dateLastActive = dateLastActive;
        }

        @Generated
        public void setTotalMembersCount(Integer totalMembersCount) {
            this.totalMembersCount = totalMembersCount;
        }

        @Generated
        public void setFullMembersCount(Integer fullMembersCount) {
            this.fullMembersCount = fullMembersCount;
        }

        @Generated
        public void setActiveMembersCount(Integer activeMembersCount) {
            this.activeMembersCount = activeMembersCount;
        }

        @Generated
        public void setGuestMembersCount(Integer guestMembersCount) {
            this.guestMembersCount = guestMembersCount;
        }

        @Generated
        public void setMessagesPostedByMembersCount(Integer messagesPostedByMembersCount) {
            this.messagesPostedByMembersCount = messagesPostedByMembersCount;
        }

        @Generated
        public void setMembersWhoPostedCount(Integer membersWhoPostedCount) {
            this.membersWhoPostedCount = membersWhoPostedCount;
        }

        @Generated
        public void setMembersWhoViewedCount(Integer membersWhoViewedCount) {
            this.membersWhoViewedCount = membersWhoViewedCount;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setTopic(String topic) {
            this.topic = topic;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalyticsData)) {
                return false;
            }
            AnalyticsData other = (AnalyticsData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isGuest = this.getIsGuest();
            Boolean other$isGuest = other.getIsGuest();
            if (this$isGuest == null ? other$isGuest != null : !((Object)this$isGuest).equals(other$isGuest)) {
                return false;
            }
            Boolean this$isBillableSeat = this.getIsBillableSeat();
            Boolean other$isBillableSeat = other.getIsBillableSeat();
            if (this$isBillableSeat == null ? other$isBillableSeat != null : !((Object)this$isBillableSeat).equals(other$isBillableSeat)) {
                return false;
            }
            Boolean this$isActive = this.getIsActive();
            Boolean other$isActive = other.getIsActive();
            if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
                return false;
            }
            Boolean this$isActiveIos = this.getIsActiveIos();
            Boolean other$isActiveIos = other.getIsActiveIos();
            if (this$isActiveIos == null ? other$isActiveIos != null : !((Object)this$isActiveIos).equals(other$isActiveIos)) {
                return false;
            }
            Boolean this$isActiveAndroid = this.getIsActiveAndroid();
            Boolean other$isActiveAndroid = other.getIsActiveAndroid();
            if (this$isActiveAndroid == null ? other$isActiveAndroid != null : !((Object)this$isActiveAndroid).equals(other$isActiveAndroid)) {
                return false;
            }
            Boolean this$isActiveDesktop = this.getIsActiveDesktop();
            Boolean other$isActiveDesktop = other.getIsActiveDesktop();
            if (this$isActiveDesktop == null ? other$isActiveDesktop != null : !((Object)this$isActiveDesktop).equals(other$isActiveDesktop)) {
                return false;
            }
            Integer this$reactionsAddedCount = this.getReactionsAddedCount();
            Integer other$reactionsAddedCount = other.getReactionsAddedCount();
            if (this$reactionsAddedCount == null ? other$reactionsAddedCount != null : !((Object)this$reactionsAddedCount).equals(other$reactionsAddedCount)) {
                return false;
            }
            Integer this$messagesPostedCount = this.getMessagesPostedCount();
            Integer other$messagesPostedCount = other.getMessagesPostedCount();
            if (this$messagesPostedCount == null ? other$messagesPostedCount != null : !((Object)this$messagesPostedCount).equals(other$messagesPostedCount)) {
                return false;
            }
            Integer this$channelMessagesPostedCount = this.getChannelMessagesPostedCount();
            Integer other$channelMessagesPostedCount = other.getChannelMessagesPostedCount();
            if (this$channelMessagesPostedCount == null ? other$channelMessagesPostedCount != null : !((Object)this$channelMessagesPostedCount).equals(other$channelMessagesPostedCount)) {
                return false;
            }
            Integer this$filesAddedCount = this.getFilesAddedCount();
            Integer other$filesAddedCount = other.getFilesAddedCount();
            if (this$filesAddedCount == null ? other$filesAddedCount != null : !((Object)this$filesAddedCount).equals(other$filesAddedCount)) {
                return false;
            }
            Boolean this$isSharedExternally = this.getIsSharedExternally();
            Boolean other$isSharedExternally = other.getIsSharedExternally();
            if (this$isSharedExternally == null ? other$isSharedExternally != null : !((Object)this$isSharedExternally).equals(other$isSharedExternally)) {
                return false;
            }
            Integer this$dateCreated = this.getDateCreated();
            Integer other$dateCreated = other.getDateCreated();
            if (this$dateCreated == null ? other$dateCreated != null : !((Object)this$dateCreated).equals(other$dateCreated)) {
                return false;
            }
            Integer this$dateLastActive = this.getDateLastActive();
            Integer other$dateLastActive = other.getDateLastActive();
            if (this$dateLastActive == null ? other$dateLastActive != null : !((Object)this$dateLastActive).equals(other$dateLastActive)) {
                return false;
            }
            Integer this$totalMembersCount = this.getTotalMembersCount();
            Integer other$totalMembersCount = other.getTotalMembersCount();
            if (this$totalMembersCount == null ? other$totalMembersCount != null : !((Object)this$totalMembersCount).equals(other$totalMembersCount)) {
                return false;
            }
            Integer this$fullMembersCount = this.getFullMembersCount();
            Integer other$fullMembersCount = other.getFullMembersCount();
            if (this$fullMembersCount == null ? other$fullMembersCount != null : !((Object)this$fullMembersCount).equals(other$fullMembersCount)) {
                return false;
            }
            Integer this$activeMembersCount = this.getActiveMembersCount();
            Integer other$activeMembersCount = other.getActiveMembersCount();
            if (this$activeMembersCount == null ? other$activeMembersCount != null : !((Object)this$activeMembersCount).equals(other$activeMembersCount)) {
                return false;
            }
            Integer this$guestMembersCount = this.getGuestMembersCount();
            Integer other$guestMembersCount = other.getGuestMembersCount();
            if (this$guestMembersCount == null ? other$guestMembersCount != null : !((Object)this$guestMembersCount).equals(other$guestMembersCount)) {
                return false;
            }
            Integer this$messagesPostedByMembersCount = this.getMessagesPostedByMembersCount();
            Integer other$messagesPostedByMembersCount = other.getMessagesPostedByMembersCount();
            if (this$messagesPostedByMembersCount == null ? other$messagesPostedByMembersCount != null : !((Object)this$messagesPostedByMembersCount).equals(other$messagesPostedByMembersCount)) {
                return false;
            }
            Integer this$membersWhoPostedCount = this.getMembersWhoPostedCount();
            Integer other$membersWhoPostedCount = other.getMembersWhoPostedCount();
            if (this$membersWhoPostedCount == null ? other$membersWhoPostedCount != null : !((Object)this$membersWhoPostedCount).equals(other$membersWhoPostedCount)) {
                return false;
            }
            Integer this$membersWhoViewedCount = this.getMembersWhoViewedCount();
            Integer other$membersWhoViewedCount = other.getMembersWhoViewedCount();
            if (this$membersWhoViewedCount == null ? other$membersWhoViewedCount != null : !((Object)this$membersWhoViewedCount).equals(other$membersWhoViewedCount)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                return false;
            }
            String this$enterpriseId = this.getEnterpriseId();
            String other$enterpriseId = other.getEnterpriseId();
            if (this$enterpriseId == null ? other$enterpriseId != null : !this$enterpriseId.equals(other$enterpriseId)) {
                return false;
            }
            String this$enterpriseUserId = this.getEnterpriseUserId();
            String other$enterpriseUserId = other.getEnterpriseUserId();
            if (this$enterpriseUserId == null ? other$enterpriseUserId != null : !this$enterpriseUserId.equals(other$enterpriseUserId)) {
                return false;
            }
            String this$emailAddress = this.getEmailAddress();
            String other$emailAddress = other.getEmailAddress();
            if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
                return false;
            }
            String this$enterpriseEmployeeNumber = this.getEnterpriseEmployeeNumber();
            String other$enterpriseEmployeeNumber = other.getEnterpriseEmployeeNumber();
            if (this$enterpriseEmployeeNumber == null ? other$enterpriseEmployeeNumber != null : !this$enterpriseEmployeeNumber.equals(other$enterpriseEmployeeNumber)) {
                return false;
            }
            OriginatingTeam this$originatingTeam = this.getOriginatingTeam();
            OriginatingTeam other$originatingTeam = other.getOriginatingTeam();
            if (this$originatingTeam == null ? other$originatingTeam != null : !((Object)this$originatingTeam).equals(other$originatingTeam)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$visibility = this.getVisibility();
            String other$visibility = other.getVisibility();
            if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
                return false;
            }
            List<SharedWith> this$sharedWith = this.getSharedWith();
            List<SharedWith> other$sharedWith = other.getSharedWith();
            if (this$sharedWith == null ? other$sharedWith != null : !((Object)this$sharedWith).equals(other$sharedWith)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AnalyticsData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isGuest = this.getIsGuest();
            result = result * 59 + ($isGuest == null ? 43 : ((Object)$isGuest).hashCode());
            Boolean $isBillableSeat = this.getIsBillableSeat();
            result = result * 59 + ($isBillableSeat == null ? 43 : ((Object)$isBillableSeat).hashCode());
            Boolean $isActive = this.getIsActive();
            result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
            Boolean $isActiveIos = this.getIsActiveIos();
            result = result * 59 + ($isActiveIos == null ? 43 : ((Object)$isActiveIos).hashCode());
            Boolean $isActiveAndroid = this.getIsActiveAndroid();
            result = result * 59 + ($isActiveAndroid == null ? 43 : ((Object)$isActiveAndroid).hashCode());
            Boolean $isActiveDesktop = this.getIsActiveDesktop();
            result = result * 59 + ($isActiveDesktop == null ? 43 : ((Object)$isActiveDesktop).hashCode());
            Integer $reactionsAddedCount = this.getReactionsAddedCount();
            result = result * 59 + ($reactionsAddedCount == null ? 43 : ((Object)$reactionsAddedCount).hashCode());
            Integer $messagesPostedCount = this.getMessagesPostedCount();
            result = result * 59 + ($messagesPostedCount == null ? 43 : ((Object)$messagesPostedCount).hashCode());
            Integer $channelMessagesPostedCount = this.getChannelMessagesPostedCount();
            result = result * 59 + ($channelMessagesPostedCount == null ? 43 : ((Object)$channelMessagesPostedCount).hashCode());
            Integer $filesAddedCount = this.getFilesAddedCount();
            result = result * 59 + ($filesAddedCount == null ? 43 : ((Object)$filesAddedCount).hashCode());
            Boolean $isSharedExternally = this.getIsSharedExternally();
            result = result * 59 + ($isSharedExternally == null ? 43 : ((Object)$isSharedExternally).hashCode());
            Integer $dateCreated = this.getDateCreated();
            result = result * 59 + ($dateCreated == null ? 43 : ((Object)$dateCreated).hashCode());
            Integer $dateLastActive = this.getDateLastActive();
            result = result * 59 + ($dateLastActive == null ? 43 : ((Object)$dateLastActive).hashCode());
            Integer $totalMembersCount = this.getTotalMembersCount();
            result = result * 59 + ($totalMembersCount == null ? 43 : ((Object)$totalMembersCount).hashCode());
            Integer $fullMembersCount = this.getFullMembersCount();
            result = result * 59 + ($fullMembersCount == null ? 43 : ((Object)$fullMembersCount).hashCode());
            Integer $activeMembersCount = this.getActiveMembersCount();
            result = result * 59 + ($activeMembersCount == null ? 43 : ((Object)$activeMembersCount).hashCode());
            Integer $guestMembersCount = this.getGuestMembersCount();
            result = result * 59 + ($guestMembersCount == null ? 43 : ((Object)$guestMembersCount).hashCode());
            Integer $messagesPostedByMembersCount = this.getMessagesPostedByMembersCount();
            result = result * 59 + ($messagesPostedByMembersCount == null ? 43 : ((Object)$messagesPostedByMembersCount).hashCode());
            Integer $membersWhoPostedCount = this.getMembersWhoPostedCount();
            result = result * 59 + ($membersWhoPostedCount == null ? 43 : ((Object)$membersWhoPostedCount).hashCode());
            Integer $membersWhoViewedCount = this.getMembersWhoViewedCount();
            result = result * 59 + ($membersWhoViewedCount == null ? 43 : ((Object)$membersWhoViewedCount).hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            String $enterpriseId = this.getEnterpriseId();
            result = result * 59 + ($enterpriseId == null ? 43 : $enterpriseId.hashCode());
            String $enterpriseUserId = this.getEnterpriseUserId();
            result = result * 59 + ($enterpriseUserId == null ? 43 : $enterpriseUserId.hashCode());
            String $emailAddress = this.getEmailAddress();
            result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
            String $enterpriseEmployeeNumber = this.getEnterpriseEmployeeNumber();
            result = result * 59 + ($enterpriseEmployeeNumber == null ? 43 : $enterpriseEmployeeNumber.hashCode());
            OriginatingTeam $originatingTeam = this.getOriginatingTeam();
            result = result * 59 + ($originatingTeam == null ? 43 : ((Object)$originatingTeam).hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $visibility = this.getVisibility();
            result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
            List<SharedWith> $sharedWith = this.getSharedWith();
            result = result * 59 + ($sharedWith == null ? 43 : ((Object)$sharedWith).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdminAnalyticsGetFileResponse.AnalyticsData(date=" + this.getDate() + ", enterpriseId=" + this.getEnterpriseId() + ", enterpriseUserId=" + this.getEnterpriseUserId() + ", emailAddress=" + this.getEmailAddress() + ", enterpriseEmployeeNumber=" + this.getEnterpriseEmployeeNumber() + ", isGuest=" + this.getIsGuest() + ", isBillableSeat=" + this.getIsBillableSeat() + ", isActive=" + this.getIsActive() + ", isActiveIos=" + this.getIsActiveIos() + ", isActiveAndroid=" + this.getIsActiveAndroid() + ", isActiveDesktop=" + this.getIsActiveDesktop() + ", reactionsAddedCount=" + this.getReactionsAddedCount() + ", messagesPostedCount=" + this.getMessagesPostedCount() + ", channelMessagesPostedCount=" + this.getChannelMessagesPostedCount() + ", filesAddedCount=" + this.getFilesAddedCount() + ", originatingTeam=" + this.getOriginatingTeam() + ", channelId=" + this.getChannelId() + ", channelType=" + this.getChannelType() + ", visibility=" + this.getVisibility() + ", sharedWith=" + this.getSharedWith() + ", isSharedExternally=" + this.getIsSharedExternally() + ", dateCreated=" + this.getDateCreated() + ", dateLastActive=" + this.getDateLastActive() + ", totalMembersCount=" + this.getTotalMembersCount() + ", fullMembersCount=" + this.getFullMembersCount() + ", activeMembersCount=" + this.getActiveMembersCount() + ", guestMembersCount=" + this.getGuestMembersCount() + ", messagesPostedByMembersCount=" + this.getMessagesPostedByMembersCount() + ", membersWhoPostedCount=" + this.getMembersWhoPostedCount() + ", membersWhoViewedCount=" + this.getMembersWhoViewedCount() + ", name=" + this.getName() + ", topic=" + this.getTopic() + ", description=" + this.getDescription() + ")";
        }
    }

    public static class SharedWith {
        private String teamId;
        private String name;

        @Generated
        public SharedWith() {
        }

        @Generated
        public String getTeamId() {
            return this.teamId;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SharedWith)) {
                return false;
            }
            SharedWith other = (SharedWith)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$teamId = this.getTeamId();
            String other$teamId = other.getTeamId();
            if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SharedWith;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $teamId = this.getTeamId();
            result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdminAnalyticsGetFileResponse.SharedWith(teamId=" + this.getTeamId() + ", name=" + this.getName() + ")";
        }
    }

    public static class OriginatingTeam {
        private String teamId;
        private String name;

        @Generated
        public OriginatingTeam() {
        }

        @Generated
        public String getTeamId() {
            return this.teamId;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginatingTeam)) {
                return false;
            }
            OriginatingTeam other = (OriginatingTeam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$teamId = this.getTeamId();
            String other$teamId = other.getTeamId();
            if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OriginatingTeam;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $teamId = this.getTeamId();
            result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdminAnalyticsGetFileResponse.OriginatingTeam(teamId=" + this.getTeamId() + ", name=" + this.getName() + ")";
        }
    }
}

