/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.event.MessageChangedEvent;
import java.lang.reflect.Type;

public class GsonMessageChangedEventPreviousMessageFactory
implements JsonDeserializer<MessageChangedEvent.PreviousMessage>,
JsonSerializer<MessageChangedEvent.PreviousMessage> {
    private static final String REPORT_THIS = "Please report this issue at https://github.com/slackapi/java-slack-sdk/issues";
    private final boolean failOnUnknownProperties;

    public GsonMessageChangedEventPreviousMessageFactory() {
        this(false);
    }

    public GsonMessageChangedEventPreviousMessageFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public MessageChangedEvent.PreviousMessage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MessageChangedEvent.PreviousMessage result = new MessageChangedEvent.PreviousMessage();
        if (json.isJsonArray()) {
            return result;
        }
        if (json.isJsonObject()) {
            result.setMessage((MessageChangedEvent.Message)context.deserialize(json, MessageChangedEvent.Message.class));
            return result;
        }
        if (this.failOnUnknownProperties) {
            String message = "The whole value (" + json + ") is unsupported. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return result;
    }

    public JsonElement serialize(MessageChangedEvent.PreviousMessage src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.getMessage() != null) {
            return context.serialize((Object)src.getMessage());
        }
        return new JsonArray();
    }
}

