/*
 * Copyright (C) 2022 Slack Technologies, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package slack.gradle

/**
 * This is generated from https://errorprone.info/bugpatterns. There's no automatic way to update
 * these currently, but copying them from the page and pasting them in is generally easy to do with
 * IntelliJ's magic cursors.
 *
 * Current Error-Prone version: 2.3.4
 */
@Suppress("TopLevelPropertyNaming")
internal val ERROR_PRONE_CHECKS =
  listOf(
    // Error checks
    "AndroidInjectionBeforeSuper",
    "ArrayEquals",
    "ArrayFillIncompatibleType",
    "ArrayHashCode",
    "ArrayToString",
    "ArraysAsListPrimitiveArray",
    "AsyncCallableReturnsNull",
    "AsyncFunctionReturnsNull",
    "AutoValueConstructorOrderChecker",
    "BadShiftAmount",
    "BundleDeserializationCast",
    "ChainingConstructorIgnoresParameter",
    "CheckNotNullMultipleTimes",
    "CheckReturnValue",
    "CollectionIncompatibleType",
    "CollectionToArraySafeParameter",
    "ComparableType",
    "ComparingThisWithNull",
    "ComparisonOutOfRange",
    "CompatibleWithAnnotationMisuse",
    "CompileTimeConstant",
    "ConditionalExpressionNumericPromotion",
    "ConstantOverflow",
    "DaggerProvidesNull",
    "DeadException",
    "DeadThread",
    "DiscardedPostfixExpression",
    "DoNotCall",
    "DoNotMock",
    "DuplicateMapKeys",
    "DurationFrom",
    "DurationGetTemporalUnit",
    "DurationTemporalUnit",
    "DurationToLongTimeUnit",
    "EqualsHashCode",
    "EqualsNaN",
    "EqualsReference",
    "EqualsWrongThing",
    "ExtendsAutoValue",
    "ForOverride",
    "FormatString",
    "FormatStringAnnotation",
    "FunctionalInterfaceMethodChanged",
    "FuturesGetCheckedIllegalExceptionType",
    "GetClassOnAnnotation",
    "GetClassOnClass",
    "GuardedBy",
    "GuiceAssistedInjectScoping",
    "GuiceAssistedParameters",
    "GuiceInjectOnFinalField",
    "HashtableContains",
    "IdentityBinaryExpression",
    "Immutable",
    "ImmutableModification",
    "Incomparable",
    "IncompatibleArgumentType",
    "IncompatibleModifiers",
    "IndexOfChar",
    "InexactVarargsConditional",
    "InfiniteRecursion",
    "InjectMoreThanOneScopeAnnotationOnClass",
    "InjectOnMemberAndConstructor",
    "InstantTemporalUnit",
    "InvalidJavaTimeConstant",
    "InvalidPatternSyntax",
    "InvalidTimeZoneID",
    "InvalidZoneId",
    "IsInstanceOfClass",
    "IsLoggableTagLength",
    "JUnit3TestNotRun",
    "JUnit4ClassAnnotationNonStatic",
    "JUnit4SetUpNotRun",
    "JUnit4TearDownNotRun",
    "JUnit4TestNotRun",
    "JUnitAssertSameCheck",
    "JavaxInjectOnAbstractMethod",
    "LiteByteStringUtf8",
    "LocalDateTemporalAmount",
    "LoopConditionChecker",
    "MathRoundIntLong",
    "MislabeledAndroidString",
    "MissingSuperCall",
    "MissingTestCall",
    "MisusedWeekYear",
    "MockitoCast",
    "MockitoUsage",
    "ModifyingCollectionWithItself",
    "MoreThanOneInjectableConstructor",
    "MustBeClosedChecker",
    "NCopiesOfChar",
    "NonCanonicalStaticImport",
    "NonFinalCompileTimeConstant",
    "NonRuntimeAnnotation",
    "NullTernary",
    "OptionalEquality",
    "OverlappingQualifierAndScopeAnnotation",
    "OverridesJavaxInjectableMethod",
    "PackageInfo",
    "ParametersButNotParameterized",
    "ParcelableCreator",
    "PeriodFrom",
    "PeriodGetTemporalUnit",
    "PeriodTimeMath",
    "PredicateIncompatibleType",
    "PrivateSecurityContractProtoAccess",
    "ProtoFieldNullComparison",
    "ProtoStringFieldReferenceEquality",
    "ProtoTruthMixedDescriptors",
    "ProtocolBufferOrdinal",
    "ProvidesMethodOutsideOfModule",
    "RandomCast",
    "RandomModInteger",
    "RectIntersectReturnValueIgnored",
    "RefersToDaggerCodegen",
    "RestrictedApiChecker",
    "ReturnValueIgnored",
    "SelfAssignment",
    "SelfComparison",
    "SelfEquals",
    "ShouldHaveEvenArgs",
    "SizeGreaterThanOrEqualsZero",
    "StreamToString",
    "StringBuilderInitWithChar",
    "SubstringOfZero",
    "SuppressWarningsDeprecated",
    "TemporalAccessorGetChronoField",
    "TheoryButNoTheories",
    "ThrowIfUncheckedKnownChecked",
    "ThrowNull",
    "TruthSelfEquals",
    "TryFailThrowable",
    "TypeParameterQualifier",
    "UnnecessaryCheckNotNull",
    "UnnecessaryTypeArgument",
    "UnusedAnonymousClass",
    "UnusedCollectionModifiedInPlace",
    "VarTypeName",
    "XorPower",

    // Warnings
    "AmbiguousMethodReference",
    "AnnotateFormatMethod",
    "ArgumentSelectionDefectChecker",
    "ArrayAsKeyOfSetOrMap",
    "AssertEqualsArgumentOrderChecker",
    "AssertThrowsMultipleStatements",
    "AssertionFailureIgnored",
    "AssignmentToMock",
    "AutoValueFinalMethods",
    "AutoValueImmutableFields",
    "BadAnnotationImplementation",
    "BadComparable",
    "BadImport",
    "BadInstanceof",
    "BigDecimalEquals",
    "BigDecimalLiteralDouble",
    "BoxedPrimitiveConstructor",
    "BoxedPrimitiveEquality",
    "ByteBufferBackingArray",
    "CannotMockFinalClass",
    "CanonicalDuration",
    "CatchAndPrintStackTrace",
    "CatchFail",
    "ChainedAssertionLosesContext",
    "ClassCanBeStatic",
    "ClassNewInstance",
    "CloseableProvides",
    "CollectorShouldNotUseState",
    "ComparableAndComparator",
    "CompareToZero",
    "ComplexBooleanConstant",
    "DateFormatConstant",
    "DefaultCharset",
    "DoubleBraceInitialization",
    "DoubleCheckedLocking",
    "EqualsGetClass",
    "EqualsIncompatibleType",
    "EqualsUnsafeCast",
    "EqualsUsingHashCode",
    "ExtendingJUnitAssert",
    "FallThrough",
    "Finally",
    "FloatCast",
    "FloatingPointAssertionWithinEpsilon",
    "FloatingPointLiteralPrecision",
    "FragmentInjection",
    "FragmentNotInstantiable",
    "FutureReturnValueIgnored",
    "GetClassOnEnum",
    "HidingField",
    "ImmutableAnnotationChecker",
    "ImmutableEnumChecker",
    "InconsistentCapitalization",
    "InconsistentHashCode",
    "IncrementInForLoopAndHeader",
    "InjectOnConstructorOfAbstractClass",
    "InputStreamSlowMultibyteRead",
    "InstanceOfAndCastMatchWrongType",
    "IntLongMath",
    "IterableAndIterator",
    "JUnit3FloatingPointComparisonWithoutDelta",
    "JUnit4ClassUsedInJUnit3",
    "JUnitAmbiguousTestClass",
    "JavaDurationGetSecondsGetNano",
    "JavaDurationWithNanos",
    "JavaDurationWithSeconds",
    "JavaInstantGetSecondsGetNano",
    "JavaLangClash",
    "JavaLocalDateTimeGetNano",
    "JavaLocalTimeGetNano",
    "JavaPeriodGetDays",
    "JavaTimeDefaultTimeZone",
    "JdkObsolete",
    "LiteEnumValueOf",
    "LiteProtoToString",
    "LockNotBeforeTry",
    "LogicalAssignment",
    "MathAbsoluteRandom",
    "MissingCasesInEnumSwitch",
    "MissingFail",
    "MissingOverride",
    "MixedDescriptors",
    "MixedMutabilityReturnType",
    "ModifiedButNotUsed",
    "ModifyCollectionInEnhancedForLoop",
    "ModifySourceCollectionInStream",
    "MultipleParallelOrSequentialCalls",
    "MutableConstantField",
    "NarrowingCompoundAssignment",
    "NestedInstanceOfConditions",
    "NonAtomicVolatileUpdate",
    "NonOverridingEquals",
    "NullableConstructor",
    "NullablePrimitive",
    "NullableVoid",
    "ObjectToString",
    "ObjectsHashCodePrimitive",
    "OperatorPrecedence",
    "OptionalMapToOptional",
    "OptionalNotPresent",
    "OrphanedFormatString",
    "OutlineNone",
    "OverrideThrowableToString",
    "Overrides",
    "OverridesGuiceInjectableMethod",
    "ParameterName",
    "PreconditionsCheckNotNullRepeated",
    "PreconditionsInvalidPlaceholder",
    "PreferJavaTimeOverload",
    "PrimitiveAtomicReference",
    "ProtoDurationGetSecondsGetNano",
    "ProtoRedundantSet",
    "ProtoTimestampGetSecondsGetNano",
    "QualifierOrScopeOnInjectMethod",
    "ReachabilityFenceUsage",
    "ReferenceEquality",
    "RequiredModifiers",
    "RxReturnValueIgnored",
    "SameNameButDifferent",
    "ShortCircuitBoolean",
    "StaticGuardedByInstance",
    "StreamResourceLeak",
    "StringSplitter",
    "SwigMemoryLeak",
    "SynchronizeOnNonFinalField",
    "ThreadJoinLoop",
    "ThreadLocalUsage",
    "ThreadPriorityCheck",
    "ThreeLetterTimeZoneID",
    "TimeUnitConversionChecker",
    "ToStringReturnsNull",
    "TreeToString",
    "TruthAssertExpected",
    "TruthConstantAsserts",
    "TruthIncompatibleType",
    "TypeEquals",
    "TypeNameShadowing",
    "TypeParameterShadowing",
    "TypeParameterUnusedInFormals",
    "URLEqualsHashCode",
    "UndefinedEquals",
    "UnnecessaryAnonymousClass",
    "UnnecessaryLambda",
    "UnnecessaryMethodInvocationMatcher",
    "UnnecessaryParentheses",
    "UnsafeFinalization",
    "UnsafeReflectiveConstructionCast",
    "UnsynchronizedOverridesSynchronized",
    "UnusedMethod",
    "UnusedNestedClass",
    "UnusedVariable",
    "UseCorrectAssertInTests",
    "VariableNameSameAsType",
    "WaitNotInLoop",
    "WakelockReleasedDangerously",
    "WithSignatureDiscouraged",

    // Experimental errors
    "AndroidJdkLibsChecker",
    "AssistedInjectAndInjectOnSameConstructor",
    "AutoFactoryAtInject",
    "ClassName",
    "ComparisonContractViolated",
    "DeduplicateConstants",
    "DepAnn",
    "DescribeMatch",
    "DivZero",
    "EmptyIf",
    "FuzzyEqualsShouldNotBeUsedInEqualsMethod",
    "InjectInvalidTargetingOnScopingAnnotation",
    "InjectMoreThanOneQualifier",
    "InjectScopeAnnotationOnInterfaceOrAbstractClass",
    "InjectScopeOrQualifierAnnotationRetention",
    "InjectedConstructorAnnotations",
    "InsecureCryptoUsage",
    "IterablePathParameter",
    "JMockTestWithoutRunWithOrRuleAnnotation",
    "Java7ApiChecker",
    "JavaxInjectOnFinalField",
    "LockMethodChecker",
    "LongLiteralLowerCaseSuffix",
    "NoAllocation",
    "NumericEquality",
    "ParameterPackage",
    "StaticOrDefaultInterfaceMethod",
    "UnlockMethod",

    // Experimental warnings
    "AlmostJavadoc",
    "AnnotationPosition",
    "AssertFalse",
    "AssistedInjectAndInjectOnConstructors",
    "BinderIdentityRestoredDangerously",
    "BindingToUnqualifiedCommonType",
    "ConstructorInvokesOverridable",
    "ConstructorLeaksThis",
    "EmptyBlockTag",
    "EmptyTopLevelDeclaration",
    "EqualsBrokenForNull",
    "EscapedEntity",
    "ExpectedExceptionChecker",
    "FunctionalInterfaceClash",
    "HardCodedSdCardPath",
    "InconsistentOverloads",
    "InheritDoc",
    "InterfaceWithOnlyStatics",
    "InterruptedExceptionSwallowed",
    //    "InvalidBlockTag",  // This check is fairly volatile and often breaks docs.
    "InvalidInlineTag",
    "InvalidParam",
    "InvalidThrows",
    "MissingDefault",
    "MissingSummary",
    "MutableMethodReturnType",
    "NoFunctionalReturnType",
    "NonCanonicalStaticMemberImport",
    "NullableDereference",
    "PrimitiveArrayPassedToVarargsMethod",
    "ProtosAsKeyOfSetOrMap",
    "ProvidesFix",
    "QualifierWithTypeUse",
    "RedundantOverride",
    "RedundantThrows",
    "ReturnFromVoid",
    "StaticQualifiedUsingExpression",
    "StringEquality",
    "SystemExitOutsideMain",
    "TestExceptionChecker",
    "ThrowSpecificExceptions",
    "TimeUnitMismatch",
    "TransientMisuse",
    //    "UnescapedEntity",  // This check is fairly volatile and often breaks docs.
    "UnnecessaryDefaultInEnumSwitch",
    "UnusedException",
    //    "Var",  // This is an invasive shift (all local vars/params final by default).

    // Experimental suggestion
    "BooleanParameter",
    "ClassNamedLikeTypeParameter",
    "ConstantField",
    "EmptySetMultibindingContributions",
    "ExpectedExceptionRefactoring",
    "FieldCanBeFinal",
    "FieldCanBeLocal",
    "FieldMissingNullable",
    "ImmutableRefactoring",
    "ImplementAssertionWithChaining",
    "LambdaFunctionalInterface",
    "MethodCanBeStatic",
    "MixedArrayDimensions",
    "MultiVariableDeclaration",
    "MultipleTopLevelClasses",
    "MultipleUnaryOperatorsInMethodCall",
    "PackageLocation",
    "ParameterComment",
    "ParameterNotNullable",
    "PrivateConstructorForNoninstantiableModule",
    "PrivateConstructorForUtilityClass",
    "RemoveUnusedImports",
    "ReturnMissingNullable",
    "ScopeOnModule",
    "SwitchDefault",
    "TestExceptionRefactoring",
    "ThrowsUncheckedException",
    "TryFailRefactoring",
    "TypeParameterNaming",
    "UngroupedOverloads",
    "UnnecessaryBoxedAssignment",
    "UnnecessaryBoxedVariable",
    "UnnecessarySetDefault",
    "UnnecessaryStaticImport",
    "UseBinds",
    "WildcardImport"
  )
