/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import slack.gradle.SlackToolsKt;
import slack.gradle.agp.AgpHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lslack/gradle/AndroidSourcesConfigurer;", "", "()V", "MARKER_FILE_NAME", "", "patchSdkSources", "", "requestedSdkVersion", "", "sdkDir", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "latest", "rootProject", "Lorg/gradle/api/Project;", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nAndroidSourcesConfigurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidSourcesConfigurer.kt\nslack/gradle/AndroidSourcesConfigurer\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,118:1\n17#2,6:119\n*S KotlinDebug\n*F\n+ 1 AndroidSourcesConfigurer.kt\nslack/gradle/AndroidSourcesConfigurer\n*L\n87#1:119,6\n*E\n"})
public final class AndroidSourcesConfigurer {
    @NotNull
    public static final AndroidSourcesConfigurer INSTANCE = new AndroidSourcesConfigurer();
    @NotNull
    public static final String MARKER_FILE_NAME = "slack_patched_marker";

    private AndroidSourcesConfigurer() {
    }

    public final void patchSdkSources(int requestedSdkVersion, @NotNull Project rootProject, int latest) {
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        AgpHandler agpHandler2 = SlackToolsKt.slackTools(rootProject).getAgpHandler();
        File file = rootProject.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getProjectDir(...)");
        ProviderFactory providerFactory = rootProject.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"getProviders(...)");
        File sdkDir = agpHandler2.getAndroidSdkDirectory(file, providerFactory);
        Logger logger = rootProject.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.patchSdkSources(requestedSdkVersion, sdkDir, logger, latest);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void patchSdkSources(int requestedSdkVersion, @NotNull File sdkDir, @NotNull Logger logger, int latest) {
        long l;
        File file;
        Intrinsics.checkNotNullParameter((Object)sdkDir, (String)"sdkDir");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (requestedSdkVersion == latest) {
            File marker = new File(sdkDir, "sources/android-" + latest + "/slack_patched_marker");
            if (marker.exists()) {
                File sourcesDir = marker.getParentFile();
                logger.lifecycle("Clearing patched SDK " + latest + " sources dir at " + sourcesDir + " so AGP will download the final, real sources. Restart Android Studio + re-sync once after this!");
                Intrinsics.checkNotNull((Object)sourcesDir);
                FilesKt.deleteRecursively((File)sourcesDir);
                return;
            }
            logger.debug("Skipping Android sources patching");
            return;
        }
        if (!(requestedSdkVersion - latest == 1)) {
            boolean $i$a$-check-AndroidSourcesConfigurer$patchSdkSources$22 = false;
            String $i$a$-check-AndroidSourcesConfigurer$patchSdkSources$22 = "Expected a maximum compile SDK delta of just 1. Cannot patch sources between " + requestedSdkVersion + " and latest " + latest;
            throw new IllegalStateException($i$a$-check-AndroidSourcesConfigurer$patchSdkSources$22.toString());
        }
        File requestedSources = new File(sdkDir, "sources/android-" + requestedSdkVersion);
        if (requestedSources.exists()) {
            logger.debug("Skipping Android sources patching");
            return;
        }
        File latestSources = new File(sdkDir, "sources/android-" + latest);
        if (!latestSources.exists()) {
            logger.error("Cannot patch android sources jar for requested SDK version " + requestedSdkVersion + ". This could be because your SDK has not downloaded it yet. Android SDK sources will not work in this project until you do download them though. You can do so manually via the SDK manager in Android studio.");
            return;
        }
        logger.lifecycle("Patching Android sources from " + latest + " as requested SDK version " + requestedSdkVersion);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        requestedSources.mkdirs();
        FilesKt.copyRecursively$default((File)latestSources, (File)requestedSources, (boolean)true, null, (int)4, null);
        File $this$patchSdkSources_u24lambda_u242_u24lambda_u241 = file = new File(requestedSources, MARKER_FILE_NAME);
        boolean bl2 = false;
        $this$patchSdkSources_u24lambda_u242_u24lambda_u241.createNewFile();
        FilesKt.writeText$default((File)$this$patchSdkSources_u24lambda_u242_u24lambda_u241, (String)StringsKt.trimIndent((String)("\n            Hello curious reader! This file exists solely as a marker for the\n            AndroidSourcesConfigurer util to know if these are patched sdk sources. This sources\n            directory is a copy of API " + latest + " sources.\n\n            Did you know if you drive from Houston to LA, El Paso is halfway?\n              ")), null, (int)2, null);
        long it = l = System.currentTimeMillis() - start$iv;
        boolean bl3 = false;
        logger.lifecycle("Successfully patched Android sources for SDK " + requestedSdkVersion + " in " + it + "ms. Restart Android Studio + re-sync once after this!");
    }
}

