/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;
import slack.gradle.ConfigureBuildTagsKt;
import slack.gradle.GradleExtKt;
import slack.gradle.ScanApi;
import slack.gradle.SlackGradleUtilKt;
import slack.gradle.util.GitExecValueSourceKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001c\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0011\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\f\u0010\u0014\u001a\u00020\r*\u00020\u000eH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u001a\u001a\u00020\r*\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u001c\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u001e\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u001a\f\u0010\u001f\u001a\u00020\r*\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"GITHUB_ORIGIN_REGEX", "Lkotlin/text/Regex;", "customValueSearchParams", "", "search", "", "isGitInstalled", "", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "urlEncode", "url", "addCiMetadata", "", "Lslack/gradle/ScanApi;", "project", "Lorg/gradle/api/Project;", "addCustomLinkWithSearchTerms", "title", "addGitMetadata", "addGradleEnterpriseVersion", "addTestParallelization", "appendIfMissing", "suffix", "configureBuildScanMetadata", "scanApi", "reportTo", "Lorg/gradle/api/configuration/BuildFeatures;", "tagCiOrLocal", "isCi", "tagIde", "tagOs", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nconfigureBuildTags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 configureBuildTags.kt\nslack/gradle/ConfigureBuildTagsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class ConfigureBuildTagsKt {
    @NotNull
    private static final Regex GITHUB_ORIGIN_REGEX = new Regex("(.*)github\\.com[/|:](.*)");

    public static final void reportTo(@NotNull BuildFeatures $this$reportTo, @NotNull ScanApi scanApi) {
        Intrinsics.checkNotNullParameter((Object)$this$reportTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scanApi, (String)"scanApi");
        Object object = $this$reportTo.getConfigurationCache().getRequested().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        scanApi.value("bf-configuration-cache-requested", (Boolean)object);
        Object object2 = $this$reportTo.getConfigurationCache().getActive().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        scanApi.value("bf-configuration-cache-active", (Boolean)object2);
        Object object3 = $this$reportTo.getIsolatedProjects().getRequested().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getOrElse(...)");
        scanApi.value("bf-isolated-projects-requested", (Boolean)object3);
        Object object4 = $this$reportTo.getIsolatedProjects().getActive().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getOrElse(...)");
        scanApi.value("bf-isolated-projects-active", (Boolean)object4);
    }

    public static final void configureBuildScanMetadata(@NotNull Project $this$configureBuildScanMetadata, @NotNull ScanApi scanApi) {
        Intrinsics.checkNotNullParameter((Object)$this$configureBuildScanMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scanApi, (String)"scanApi");
        if (GradleExtKt.getInvokedFromIde($this$configureBuildScanMetadata)) {
            scanApi.tag("ide");
            if (GradleExtKt.isSyncing($this$configureBuildScanMetadata)) {
                scanApi.tag("studio-sync");
            }
        }
        String string = JavaVersion.current().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        scanApi.value("java-version", string);
        String string2 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        scanApi.value("Architecture", string2);
        boolean isCi = SlackGradleUtilKt.isCi($this$configureBuildScanMetadata);
        ConfigureBuildTagsKt.tagOs(scanApi);
        Project project = $this$configureBuildScanMetadata.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigureBuildTagsKt.tagIde(scanApi, project, isCi);
        ConfigureBuildTagsKt.tagCiOrLocal(scanApi, isCi);
        if (isCi) {
            Project project2 = $this$configureBuildScanMetadata.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            ConfigureBuildTagsKt.addCiMetadata(scanApi, project2);
        }
        Project project3 = $this$configureBuildScanMetadata.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ConfigureBuildTagsKt.addGitMetadata(scanApi, project3);
        Project project4 = $this$configureBuildScanMetadata.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        ConfigureBuildTagsKt.addTestParallelization(scanApi, project4);
        ConfigureBuildTagsKt.addGradleEnterpriseVersion(scanApi);
    }

    private static final void tagOs(ScanApi $this$tagOs) {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        $this$tagOs.tag(string);
    }

    private static final void tagIde(ScanApi $this$tagIde, Project project, boolean isCi) {
        if (project.hasProperty("android.injected.invoked.from.ide")) {
            $this$tagIde.tag("Android Studio");
            Object object = project.findProperty("android.studio.version");
            if (object != null) {
                Object it = object;
                boolean bl = false;
                $this$tagIde.value("Android Studio version", it.toString());
            }
        } else if (System.getProperty("idea.version") != null) {
            $this$tagIde.tag("IntelliJ IDEA");
        } else if (!isCi) {
            $this$tagIde.tag("Cmd Line");
        }
    }

    private static final void tagCiOrLocal(ScanApi $this$tagCiOrLocal, boolean isCi) {
        $this$tagCiOrLocal.tag(isCi ? "CI" : "LOCAL");
    }

    private static final void addCiMetadata(ScanApi $this$addCiMetadata, Project project) {
        if (SlackGradleUtilKt.isActionsCi(project)) {
            if (System.getenv("GITHUB_REPOSITORY") != null && System.getenv("GITHUB_RUN_ID") != null) {
                $this$addCiMetadata.link("GitHub Actions build", "https://github.com/" + System.getenv("GITHUB_REPOSITORY") + "/actions/runs/" + System.getenv("GITHUB_RUN_ID"));
            }
            if (System.getenv("GITHUB_WORKFLOW") != null) {
                String workflowNameLabel = "GitHub workflow";
                String workflowName = System.getenv("GITHUB_WORKFLOW");
                Intrinsics.checkNotNull((Object)workflowName);
                $this$addCiMetadata.value(workflowNameLabel, workflowName);
                ConfigureBuildTagsKt.addCustomLinkWithSearchTerms($this$addCiMetadata, "GitHub workflow build scans", MapsKt.mapOf((Pair)TuplesKt.to((Object)workflowNameLabel, (Object)workflowName)));
            }
        }
    }

    private static final void addGitMetadata(ScanApi $this$addGitMetadata, Project project) {
        ProviderFactory providerFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"getProviders(...)");
        ProviderFactory providers = providerFactory;
        $this$addGitMetadata.background((Function1<? super ScanApi, Unit>)((Function1)new Function1<ScanApi, Unit>(providers){
            final /* synthetic */ ProviderFactory $providers;
            {
                this.$providers = $providers;
                super(1);
            }

            public final void invoke(@NotNull ScanApi $this$background) {
                Intrinsics.checkNotNullParameter((Object)$this$background, (String)"$this$background");
                if (!ConfigureBuildTagsKt.access$isGitInstalled(this.$providers)) {
                    return;
                }
                String[] stringArray = new String[]{"git", "rev-parse", "--short=8", "--verify", "HEAD"};
                String gitCommitId = (String)GitExecValueSourceKt.gitExecProvider(this.$providers, stringArray).getOrNull();
                String[] stringArray2 = new String[]{"git", "rev-parse", "--abbrev-ref", "HEAD"};
                String gitBranchName = (String)GitExecValueSourceKt.gitExecProvider(this.$providers, stringArray2).getOrNull();
                String[] stringArray3 = new String[]{"git", "status", "--porcelain"};
                String gitStatus = (String)GitExecValueSourceKt.gitExecProvider(this.$providers, stringArray3).getOrNull();
                if (gitCommitId != null) {
                    String gitCommitIdLabel = "Git commit id";
                    $this$background.value(gitCommitIdLabel, gitCommitId);
                    ConfigureBuildTagsKt.access$addCustomLinkWithSearchTerms($this$background, "Git commit id build scans", MapsKt.mapOf((Pair)TuplesKt.to((Object)gitCommitIdLabel, (Object)gitCommitId)));
                    String[] stringArray4 = new String[]{"git", "config", "--get", "remote.origin.url"};
                    String originUrl = (String)GitExecValueSourceKt.gitExecProvider(this.$providers, stringArray4).getOrNull();
                    if (originUrl != null && (StringsKt.contains$default((CharSequence)originUrl, (CharSequence)"github.com/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)originUrl, (CharSequence)"github.com:", (boolean)false, (int)2, null))) {
                        Object object = Regex.find$default((Regex)ConfigureBuildTagsKt.access$getGITHUB_ORIGIN_REGEX$p(), (CharSequence)originUrl, (int)0, (int)2, null);
                        if (object != null && (object = object.getGroups()) != null && (object = object.get(2)) != null && (object = object.getValue()) != null && (object = StringsKt.removeSuffix((String)object, (CharSequence)".git")) != null) {
                            Object repoPath = object;
                            boolean bl = false;
                            $this$background.link("Github Source", "https://github.com/" + (String)repoPath + "/tree/" + gitCommitId);
                        }
                    }
                }
                if (gitBranchName != null) {
                    $this$background.tag(gitBranchName);
                    $this$background.value("Git branch", gitBranchName);
                }
                if (gitStatus != null) {
                    $this$background.tag("Dirty");
                    $this$background.value("Git status", gitStatus);
                }
            }
        }));
    }

    public static final void addTestParallelization(@NotNull ScanApi $this$addTestParallelization, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$addTestParallelization, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getTasks().withType(Test.class).configureEach(new Action($this$addTestParallelization){
            final /* synthetic */ ScanApi $this_addTestParallelization;
            {
                this.$this_addTestParallelization = $receiver;
            }

            public final void execute(@NotNull Test $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                $this$configureEach.doFirst(new Action(this.$this_addTestParallelization, $this$configureEach){
                    final /* synthetic */ ScanApi $this_addTestParallelization;
                    final /* synthetic */ Test $this_configureEach;
                    {
                        this.$this_addTestParallelization = $receiver;
                        this.$this_configureEach = $this_configureEach;
                    }

                    public final void execute(@NotNull Task $this$doFirst) {
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        this.$this_addTestParallelization.value(this.$this_configureEach.getIdentityPath() + "#maxParallelForks", String.valueOf(this.$this_configureEach.getMaxParallelForks()));
                    }
                });
            }
        });
    }

    private static final void addGradleEnterpriseVersion(ScanApi $this$addGradleEnterpriseVersion) {
        block0: {
            URL uRL = $this$addGradleEnterpriseVersion.getClass().getClassLoader().getResource("com.gradle.scan.plugin.internal.meta.buildAgentVersion.txt");
            if (uRL == null) break block0;
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            String buildAgentVersion = new String(byArray, charset);
            boolean bl = false;
            $this$addGradleEnterpriseVersion.value("GE Gradle plugin version", buildAgentVersion);
        }
    }

    private static final void addCustomLinkWithSearchTerms(ScanApi $this$addCustomLinkWithSearchTerms, String title, Map<String, String> search) {
        block0: {
            String string = $this$addCustomLinkWithSearchTerms.getServer();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            String searchParams = ConfigureBuildTagsKt.customValueSearchParams(search);
            String url = ConfigureBuildTagsKt.appendIfMissing(it, "/") + "scans?" + searchParams + "#selection.buildScanB=" + ConfigureBuildTagsKt.urlEncode("{SCAN_ID}");
            $this$addCustomLinkWithSearchTerms.link(title, url);
        }
    }

    private static final String customValueSearchParams(Map<String, String> search) {
        return CollectionsKt.joinToString$default((Iterable)search.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)customValueSearchParams.1.INSTANCE, (int)30, null);
    }

    private static final String appendIfMissing(String $this$appendIfMissing, String suffix) {
        return StringsKt.endsWith$default((String)$this$appendIfMissing, (String)suffix, (boolean)false, (int)2, null) ? $this$appendIfMissing : $this$appendIfMissing + suffix;
    }

    private static final String urlEncode(String url) {
        String string = URLEncoder.encode(url, Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    private static final boolean isGitInstalled(ProviderFactory providers) {
        boolean bl;
        try {
            GitExecValueSourceKt.gitVersionProvider(providers).isPresent();
            bl = true;
        }
        catch (IOException ignored) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isGitInstalled(ProviderFactory providers) {
        return ConfigureBuildTagsKt.isGitInstalled(providers);
    }

    public static final /* synthetic */ void access$addCustomLinkWithSearchTerms(ScanApi $receiver, String title, Map search) {
        ConfigureBuildTagsKt.addCustomLinkWithSearchTerms($receiver, title, search);
    }

    public static final /* synthetic */ Regex access$getGITHUB_ORIGIN_REGEX$p() {
        return GITHUB_ORIGIN_REGEX;
    }

    public static final /* synthetic */ String access$urlEncode(String url) {
        return ConfigureBuildTagsKt.urlEncode(url);
    }
}

