/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle;

import com.autonomousapps.DependencyAnalysisExtension;
import com.github.benmanes.gradle.versions.updates.DependencyUpdatesTask;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ComponentFilter;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ComponentSelectionWithCurrent;
import com.gradle.scan.plugin.BuildResult;
import com.gradle.scan.plugin.BuildScanExtension;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.cli.AppleSiliconCompat;
import slack.dependencyrake.MissingIdentifiersAggregatorTask;
import slack.gradle.AndroidSourcesConfigurer;
import slack.gradle.ConfigureBuildTagsKt;
import slack.gradle.ScanApi;
import slack.gradle.SlackGradleUtilKt;
import slack.gradle.SlackProperties;
import slack.gradle.SlackRootPlugin;
import slack.gradle.SlackRootPluginKt;
import slack.gradle.SlackTools;
import slack.gradle.agp.VersionNumber;
import slack.gradle.avoidance.ComputeAffectedProjectsTask;
import slack.gradle.avoidance.GenerateAndroidTestProjectPathsTask;
import slack.gradle.avoidance.GenerateDependencyGraphTask;
import slack.gradle.lint.DetektTasks;
import slack.gradle.lint.LintTasks;
import slack.gradle.tasks.AndroidTestApksTask;
import slack.gradle.tasks.GjfDownloadTask;
import slack.gradle.tasks.KtLintDownloadTask;
import slack.gradle.tasks.KtfmtDownloadTask;
import slack.gradle.tasks.SortDependenciesDownloadTask;
import slack.gradle.tasks.robolectric.UpdateRobolectricJarsTask;
import slack.gradle.util.GitExecValueSourceKt;
import slack.gradle.util.HasConfigurableValuesKt;
import slack.gradle.util.JsonTools;
import slack.gradle.util.PropertyUtil;
import slack.gradle.util.StartParameterProperties;
import slack.gradle.util.Thermals;
import slack.gradle.util.ThermalsData;
import slack.stats.ModuleStatsTasks;
import slack.unittest.UnitTests;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J&\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lslack/gradle/SlackRootPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "buildFeatures", "Lorg/gradle/api/configuration/BuildFeatures;", "(Lorg/gradle/api/configuration/BuildFeatures;)V", "apply", "", "project", "configureRootProject", "slackProperties", "Lslack/gradle/SlackProperties;", "thermalsLogJsonFileProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "isStable", "", "version", "", "configureGit", "Companion", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nSlackRootPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlackRootPlugin.kt\nslack/gradle/SlackRootPlugin\n+ 2 GradleExt.kt\nslack/gradle/GradleExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,549:1\n161#2:550\n161#2:551\n161#2:552\n161#2:553\n1747#3,3:554\n*S KotlinDebug\n*F\n+ 1 SlackRootPlugin.kt\nslack/gradle/SlackRootPlugin\n*L\n234#1:550\n242#1:551\n250#1:552\n258#1:553\n416#1:554,3\n*E\n"})
public final class SlackRootPlugin
implements Plugin<Project> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildFeatures buildFeatures;
    @NotNull
    private static final VersionNumber MIN_GIT_VERSION_FOR_IGNORE_REVS = VersionNumber.Companion.parse("2.23");
    @NotNull
    private static final Regex STABLE_REGEX = new Regex("^[0-9,.v-]+(-android)?(-r)?$");

    @Inject
    public SlackRootPlugin(@NotNull BuildFeatures buildFeatures) {
        Intrinsics.checkNotNullParameter((Object)buildFeatures, (String)"buildFeatures");
        this.buildFeatures = buildFeatures;
    }

    public void apply(@NotNull Project project) {
        boolean enableSkippy;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!Intrinsics.areEqual((Object)project, (Object)project.getRootProject())) {
            boolean $i$a$-require-SlackRootPlugin$apply$22 = false;
            String $i$a$-require-SlackRootPlugin$apply$22 = "Slack plugin should only be applied on the root project!";
            throw new IllegalArgumentException($i$a$-require-SlackRootPlugin$apply$22.toString());
        }
        AppleSiliconCompat.INSTANCE.validate((Function0)apply.2.INSTANCE);
        Map map = project.getGradle().getStartParameter().getProjectProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getProjectProperties(...)");
        Map startParameters = map;
        Provider provider2 = project.getProviders().of(StartParameterProperties.class, new Action(startParameters){
            final /* synthetic */ Map<String, String> $startParameters;
            {
                this.$startParameters = $startParameters;
            }

            public final void execute(@NotNull ValueSourceSpec<StartParameterProperties.Parameters> $this$of) {
                Intrinsics.checkNotNullParameter($this$of, (String)"$this$of");
                HasConfigurableValuesKt.setDisallowChanges(((StartParameterProperties.Parameters)$this$of.getParameters()).getProperties(), this.$startParameters);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"of(...)");
        Provider startParameterProperties2 = provider2;
        Provider provider3 = PropertyUtil.createPropertiesProvider(project, "local.properties").map((Transformer)apply.localProperties.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"map(...)");
        Provider localProperties2 = provider3;
        Function1 startParameterProperty2 = (Function1)new Function1<String, Provider<String>>((Provider<Map<String, String>>)startParameterProperties2){
            final /* synthetic */ Provider<Map<String, String>> $startParameterProperties;
            {
                this.$startParameterProperties = $startParameterProperties;
                super(1);
            }

            @NotNull
            public final Provider<String> invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Provider provider2 = this.$startParameterProperties.map(new Transformer(key){
                    final /* synthetic */ String $key;
                    {
                        this.$key = $key;
                    }

                    @NotNull
                    public final @Nullable String transform(@NotNull Map<String, String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return PropertyUtil.sneakyNull(it.get(this.$key));
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
                return provider2;
            }
        };
        Function1 globalLocalProperty2 = (Function1)new Function1<String, Provider<String>>((Provider<Map<String, String>>)localProperties2){
            final /* synthetic */ Provider<Map<String, String>> $localProperties;
            {
                this.$localProperties = $localProperties;
                super(1);
            }

            @NotNull
            public final Provider<String> invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Provider provider2 = this.$localProperties.map(new Transformer(key){
                    final /* synthetic */ String $key;
                    {
                        this.$key = $key;
                    }

                    @NotNull
                    public final @Nullable String transform(@NotNull Map<String, String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return PropertyUtil.sneakyNull(it.get(this.$key));
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
                return provider2;
            }
        };
        SlackProperties slackProperties = new SlackProperties(project, (Function1<? super String, ? extends Provider<String>>)startParameterProperty2, (Function1<? super String, ? extends Provider<String>>)globalLocalProperty2);
        Provider provider4 = project.getLayout().getBuildDirectory().file("outputs/logs/last-build-thermals.json");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"file(...)");
        Provider thermalsLogJsonFile = provider4;
        boolean logThermals = slackProperties.getLogThermals();
        File file = slackProperties.getAffectedProjects();
        boolean bl = file != null ? file.exists() : (enableSkippy = false);
        if (enableSkippy) {
            project.getLogger().lifecycle("Enabling Skippy using projects in " + slackProperties.getAffectedProjects());
        } else if (slackProperties.getAffectedProjects() != null) {
            project.getLogger().lifecycle("Skippy is disabled because file '" + slackProperties.getAffectedProjects() + "' does not exist.");
        } else {
            project.getLogger().debug("Skippy is disabled");
        }
        boolean bl2 = slackProperties.getVerboseLogging();
        Provider provider5 = this.buildFeatures.getConfigurationCache().getRequested();
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"getRequested(...)");
        SlackTools.Companion.register$slack_plugin(project, logThermals, enableSkippy, bl2, (Provider<RegularFile>)thermalsLogJsonFile, (Provider<Boolean>)provider5, (Provider<Map<String, String>>)startParameterProperties2, (Provider<Map<String, String>>)localProperties2);
        this.configureRootProject(project, slackProperties, (Provider<RegularFile>)thermalsLogJsonFile);
    }

    private final void configureRootProject(Project project, SlackProperties slackProperties, Provider<RegularFile> thermalsLogJsonFileProvider) {
        String name$iv;
        TaskContainer $this$register$iv;
        boolean $i$f$register;
        Action configuration$iv;
        if (slackProperties.getStrictJdk()) {
            Object object = project.getProviders().systemProperty("java.specification.version").get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int runtimeVersion = Integer.parseInt((String)object);
            int jdk = slackProperties.getJdkVersion();
            if (!(jdk == runtimeVersion)) {
                boolean $i$a$-check-SlackRootPlugin$configureRootProject$22 = false;
                String $i$a$-check-SlackRootPlugin$configureRootProject$22 = StringsKt.trimIndent((String)("\n          Current Java version (" + runtimeVersion + ") does not match the enforced version (" + jdk + ").\n          Run ./slackw bootstrap to upgrade and be sure to set your JAVA_HOME to the JDK path it\n          prints out.\n\n          If you're seeing this error from Studio, ensure Studio is using JDK " + jdk + " in\n          Preferences > Build, Execution, Deployment > Build tools > Gradle > Gradle JVM\n        "));
                throw new IllegalStateException($i$a$-check-SlackRootPlugin$configureRootProject$22.toString());
            }
        }
        if (!SlackGradleUtilKt.isCi(project)) {
            String string = slackProperties.getCompileSdkVersion();
            if (string != null && (string = StringsKt.substringAfter$default((String)string, (String)"-", null, (int)2, null)) != null) {
                int compileSdk = Integer.parseInt(string);
                boolean bl = false;
                int latestCompileSdkWithSources = slackProperties.latestCompileSdkWithSources(compileSdk);
                AndroidSourcesConfigurer.INSTANCE.patchSdkSources(compileSdk, project, latestCompileSdkWithSources);
            }
            this.configureGit(project, slackProperties);
        }
        SlackRootPluginKt.access$configureSlackRootBuildscript(project, (JvmVendorSpec)slackProperties.getJvmVendor().map((Transformer)configureRootProject.3.INSTANCE).getOrNull());
        LintTasks.INSTANCE.configureRootProject(project);
        DetektTasks.INSTANCE.configureRootProject(project, slackProperties);
        SlackRootPluginKt.access$configureMisc(project, slackProperties);
        UnitTests.INSTANCE.configureRootProject(project);
        ModuleStatsTasks.INSTANCE.configureRoot$slack_plugin(project, slackProperties);
        TaskProvider<GenerateDependencyGraphTask> generateDependencyGraphTask = GenerateDependencyGraphTask.Companion.register(project, slackProperties);
        TaskProvider<GenerateAndroidTestProjectPathsTask> generateAndroidTestProjectsTask = GenerateAndroidTestProjectPathsTask.Companion.register(project);
        Provider provider2 = generateDependencyGraphTask.flatMap((Transformer)configureRootProject.4.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"flatMap(...)");
        Provider provider3 = generateAndroidTestProjectsTask.flatMap((Transformer)configureRootProject.5.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"flatMap(...)");
        ComputeAffectedProjectsTask.Companion.register(project, slackProperties, (Provider<RegularFile>)provider2, (Provider<RegularFile>)provider3);
        String string = slackProperties.getVersions$slack_plugin().getRobolectric();
        if (string != null) {
            String it = string;
            boolean bl = false;
            UpdateRobolectricJarsTask.Companion.register(project, slackProperties);
        }
        ScanApi scanApi = new ScanApi(project);
        if (slackProperties.getApplyCommonBuildTags()) {
            ConfigureBuildTagsKt.configureBuildScanMetadata(project, scanApi);
        }
        if (scanApi.isAvailable()) {
            ConfigureBuildTagsKt.reportTo(this.buildFeatures, scanApi);
            File file = ((RegularFile)thermalsLogJsonFileProvider.get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            File thermalsLogJsonFile = file;
            BuildScanExtension $this$configureRootProject_u24lambda_u244 = scanApi.requireExtension();
            boolean bl = false;
            $this$configureRootProject_u24lambda_u244.buildFinished(new Action($this$configureRootProject_u24lambda_u244, thermalsLogJsonFile){
                final /* synthetic */ BuildScanExtension $this_with;
                final /* synthetic */ File $thermalsLogJsonFile;
                {
                    this.$this_with = $receiver;
                    this.$thermalsLogJsonFile = $thermalsLogJsonFile;
                }

                public final void execute(@NotNull BuildResult $this$buildFinished) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildFinished, (String)"$this$buildFinished");
                    this.$this_with.background(new Action(this.$thermalsLogJsonFile){
                        final /* synthetic */ File $thermalsLogJsonFile;
                        {
                            this.$thermalsLogJsonFile = $thermalsLogJsonFile;
                        }

                        public final void execute(@NotNull BuildScanExtension $this$background) {
                            block4: {
                                String text;
                                Intrinsics.checkNotNullParameter((Object)$this$background, (String)"$this$background");
                                Thermals thermals = null;
                                if (this.$thermalsLogJsonFile.exists() && ((CharSequence)(text = FilesKt.readText$default((File)this.$thermalsLogJsonFile, null, (int)1, null))).length() > 0) {
                                    try {
                                        Moshi moshi2 = JsonTools.INSTANCE.getMOSHI();
                                        Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"<get-MOSHI>(...)");
                                        Moshi $this$adapter$iv = moshi2;
                                        boolean $i$f$adapter = false;
                                        thermals = (Thermals)_MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(Thermals.class)).fromJson(FilesKt.readText$default((File)this.$thermalsLogJsonFile, null, (int)1, null));
                                    }
                                    catch (Exception e) {
                                        Logging.getLogger((String)"SGP").error("Failed to parse thermals log", (Throwable)e);
                                    }
                                }
                                Thermals thermals2 = thermals;
                                if (thermals2 == null) break block4;
                                Thermals $this$execute_u24lambda_u240 = thermals2;
                                boolean bl = false;
                                if ($this$execute_u24lambda_u240 instanceof ThermalsData && $this$execute_u24lambda_u240.getWasThrottled()) {
                                    System.out.println((Object)"\ud83d\udd25 \u001b[33mBuild was thermally throttled!\u001b[0m");
                                    $this$background.tag("THROTTLED");
                                    $this$background.link("Thermal Performance", ((ThermalsData)$this$execute_u24lambda_u240).chartUrl(100000));
                                    $this$background.value("Throttle - Chart URL", ((ThermalsData)$this$execute_u24lambda_u240).chartUrl(100000));
                                    $this$background.value("Throttle - Lowest", String.valueOf(((ThermalsData)$this$execute_u24lambda_u240).getLowest()));
                                    $this$background.value("Throttle - Average", String.valueOf(((ThermalsData)$this$execute_u24lambda_u240).getAverage()));
                                    $this$background.value("Throttle - Time throttled", String.valueOf(((ThermalsData)$this$execute_u24lambda_u240).getPercentThrottled()));
                                    $this$background.value("Throttle - All", ((ThermalsData)$this$execute_u24lambda_u240).getAllSpeedLimits().toString());
                                }
                            }
                        }
                    });
                }
            });
        }
        String string2 = slackProperties.getVersions$slack_plugin().getKtlint();
        if (string2 != null) {
            String ktlintVersion = string2;
            boolean bl = false;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            TaskContainer taskContainer2 = taskContainer;
            String string3 = "updateKtLint";
            configuration$iv = new Action(ktlintVersion, project){
                final /* synthetic */ String $ktlintVersion;
                final /* synthetic */ Project $project;
                {
                    this.$ktlintVersion = $ktlintVersion;
                    this.$project = $project;
                }

                public final void execute(@NotNull KtLintDownloadTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    HasConfigurableValuesKt.setDisallowChanges($this$register.getVersion(), this.$ktlintVersion);
                    HasConfigurableValuesKt.setDisallowChanges((Property)$this$register.getOutputFile(), this.$project.getLayout().getProjectDirectory().file("config/bin/ktlint"));
                }
            };
            $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register(name$iv, KtLintDownloadTask.class, configuration$iv);
            v9 = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        } else {
            v9 = null;
        }
        String string4 = slackProperties.getVersions$slack_plugin().getGjf();
        if (string4 != null) {
            String gjfVersion = string4;
            boolean bl = false;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            $this$register$iv = taskContainer;
            name$iv = "updateGjf";
            configuration$iv = new Action(gjfVersion, project){
                final /* synthetic */ String $gjfVersion;
                final /* synthetic */ Project $project;
                {
                    this.$gjfVersion = $gjfVersion;
                    this.$project = $project;
                }

                public final void execute(@NotNull GjfDownloadTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    HasConfigurableValuesKt.setDisallowChanges($this$register.getVersion(), this.$gjfVersion);
                    HasConfigurableValuesKt.setDisallowChanges((Property)$this$register.getOutputFile(), this.$project.getLayout().getProjectDirectory().file("config/bin/gjf"));
                }
            };
            $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register(name$iv, GjfDownloadTask.class, configuration$iv);
            v13 = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        } else {
            v13 = null;
        }
        String string5 = slackProperties.getVersions$slack_plugin().getKtfmt();
        if (string5 != null) {
            String ktfmtVersion = string5;
            boolean bl = false;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            $this$register$iv = taskContainer;
            name$iv = "updateKtfmt";
            configuration$iv = new Action(ktfmtVersion, project){
                final /* synthetic */ String $ktfmtVersion;
                final /* synthetic */ Project $project;
                {
                    this.$ktfmtVersion = $ktfmtVersion;
                    this.$project = $project;
                }

                public final void execute(@NotNull KtfmtDownloadTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    HasConfigurableValuesKt.setDisallowChanges($this$register.getVersion(), this.$ktfmtVersion);
                    HasConfigurableValuesKt.setDisallowChanges((Property)$this$register.getOutputFile(), this.$project.getLayout().getProjectDirectory().file("config/bin/ktfmt"));
                }
            };
            $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register(name$iv, KtfmtDownloadTask.class, configuration$iv);
            v17 = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        } else {
            v17 = null;
        }
        String string6 = slackProperties.getVersions$slack_plugin().getSortDependencies();
        if (string6 != null) {
            String sortDependenciesVersion = string6;
            boolean bl = false;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            $this$register$iv = taskContainer;
            name$iv = "updateSortDependencies";
            configuration$iv = new Action(sortDependenciesVersion, project){
                final /* synthetic */ String $sortDependenciesVersion;
                final /* synthetic */ Project $project;
                {
                    this.$sortDependenciesVersion = $sortDependenciesVersion;
                    this.$project = $project;
                }

                public final void execute(@NotNull SortDependenciesDownloadTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    HasConfigurableValuesKt.setDisallowChanges($this$register.getVersion(), this.$sortDependenciesVersion);
                    HasConfigurableValuesKt.setDisallowChanges((Property)$this$register.getOutputFile(), this.$project.getLayout().getProjectDirectory().file("config/bin/sort-dependencies"));
                }
            };
            $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register(name$iv, SortDependenciesDownloadTask.class, configuration$iv);
            v21 = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
        } else {
            v21 = null;
        }
        project.getPluginManager().withPlugin("com.autonomousapps.dependency-analysis", new Action(slackProperties, project){
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ Project $project;
            {
                this.$slackProperties = $slackProperties;
                this.$project = $project;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                void $this$configure$iv;
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                if (this.$slackProperties.getEnableAnalysisPlugin()) {
                    MissingIdentifiersAggregatorTask.Companion.register(this.$project);
                }
                Project project = this.$project;
                Action action$iv = configureRootProject.1.INSTANCE;
                boolean $i$f$configure = false;
                ExtensionContainer extensionContainer = $this$configure$iv.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
                ExtensionContainer $this$getByType$iv$iv = extensionContainer;
                boolean $i$f$getByType = false;
                Object p0$iv = $this$getByType$iv$iv.getByType(TypeOf.typeOf((Type)TypesJVMKt.getJavaType((KType)Reflection.typeOf(DependencyAnalysisExtension.class))));
                boolean bl = false;
                action$iv.execute(p0$iv);
            }
        });
        project.getPluginManager().withPlugin("com.github.ben-manes.versions", new Action(project, slackProperties, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ SlackRootPlugin this$0;
            {
                this.$project = $project;
                this.$slackProperties = $slackProperties;
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.$project.getTasks().withType(DependencyUpdatesTask.class).configureEach(new Action(this.$slackProperties, this.this$0, this.$project){
                    final /* synthetic */ SlackProperties $slackProperties;
                    final /* synthetic */ SlackRootPlugin this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.$slackProperties = $slackProperties;
                        this.this$0 = $receiver;
                        this.$project = $project;
                    }

                    public final void execute(@NotNull DependencyUpdatesTask $this$configureEach) {
                        Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                        $this$configureEach.rejectVersionIf(new ComponentFilter(this.$slackProperties, this.this$0, this.$project){
                            final /* synthetic */ SlackProperties $slackProperties;
                            final /* synthetic */ SlackRootPlugin this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.$slackProperties = $slackProperties;
                                this.this$0 = $receiver;
                                this.$project = $project;
                            }

                            public final boolean reject(@NotNull ComponentSelectionWithCurrent $this$rejectVersionIf) {
                                Intrinsics.checkNotNullParameter((Object)$this$rejectVersionIf, (String)"$this$rejectVersionIf");
                                if (Intrinsics.areEqual((Object)$this$rejectVersionIf.getCandidate().getModuleIdentifier().toString(), (Object)"com.google.guava:guava")) {
                                    String string = $this$rejectVersionIf.getCandidate().getVersion();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
                                    return StringsKt.contains$default((CharSequence)string, (CharSequence)"-android", (boolean)false, (int)2, null);
                                }
                                String string = $this$rejectVersionIf.getCandidate().getGroup();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
                                if (StringsKt.startsWith$default((String)string, (String)"androidx.test", (boolean)false, (int)2, null)) {
                                    return false;
                                }
                                if (Intrinsics.areEqual((Object)$this$rejectVersionIf.getCandidate().getModuleIdentifier().toString(), (Object)"com.slack.android:analytics")) {
                                    return true;
                                }
                                if (Intrinsics.areEqual((Object)$this$rejectVersionIf.getCandidate().getModuleIdentifier().toString(), (Object)"com.slack.data:client-thrifty")) {
                                    return true;
                                }
                                if (Intrinsics.areEqual((Object)$this$rejectVersionIf.getCandidate().getGroup(), (Object)"com.slack.android.chime")) {
                                    return true;
                                }
                                if (!this.$slackProperties.getVersionsPluginAllowUnstable()) {
                                    boolean currentIsStable = SlackRootPlugin.access$isStable(this.this$0, $this$rejectVersionIf.getCurrentVersion());
                                    String string2 = $this$rejectVersionIf.getCandidate().getVersion();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersion(...)");
                                    boolean candidateIsStable = SlackRootPlugin.access$isStable(this.this$0, string2);
                                    if (!currentIsStable) {
                                        boolean bothAreUnstable;
                                        if (candidateIsStable) {
                                            return false;
                                        }
                                        VersionNumber candidateVersion = VersionNumber.Companion.parse($this$rejectVersionIf.getCandidate().getVersion());
                                        VersionNumber currentVersion = VersionNumber.Companion.parse($this$rejectVersionIf.getCurrentVersion());
                                        boolean bl = bothAreUnstable = !candidateVersion.equals((Object)VersionNumber.Companion.getUNKNOWN()) && !currentVersion.equals((Object)VersionNumber.Companion.getUNKNOWN());
                                        if (bothAreUnstable) {
                                            boolean shouldReject;
                                            boolean bl2 = shouldReject = candidateVersion.getBaseVersion().compareTo(currentVersion.getBaseVersion()) > 0;
                                            if (shouldReject) {
                                                this.$project.getLogger().debug("Rejecting unstable " + $this$rejectVersionIf.getCandidate() + " because its base version is greater than " + currentVersion + ".");
                                            }
                                            return shouldReject;
                                        }
                                    }
                                    return !candidateIsStable && currentIsStable;
                                }
                                return false;
                            }
                        });
                    }
                });
            }
        });
        AndroidTestApksTask.Companion.register$slack_plugin(project);
    }

    private final boolean isStable(String version) {
        boolean bl;
        block3: {
            Object[] objectArray = new String[]{"RELEASE", "FINAL", "GA"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = version;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string2 = string.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean stableKeyword = bl;
        return stableKeyword || STABLE_REGEX.matches((CharSequence)version);
    }

    private final void configureGit(Project $this$configureGit, SlackProperties slackProperties) {
        if (!SlackGradleUtilKt.isCi($this$configureGit)) {
            File file = slackProperties.getGitHooksFile();
            if (file != null) {
                File hooksPath = file;
                boolean bl = false;
                ProviderFactory providerFactory = $this$configureGit.getProviders();
                Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"getProviders(...)");
                String[] stringArray = new String[4];
                stringArray[0] = "git";
                stringArray[1] = "config";
                stringArray[2] = "core.hooksPath";
                Intrinsics.checkNotNullExpressionValue((Object)hooksPath.getCanonicalPath(), (String)"getCanonicalPath(...)");
                String cfr_ignored_0 = (String)GitExecValueSourceKt.gitExecProvider(providerFactory, stringArray).get();
            }
            File file2 = slackProperties.getGitIgnoreRevsFile();
            if (file2 == null) {
                return;
            }
            File revsFile = file2;
            ProviderFactory providerFactory = $this$configureGit.getProviders();
            Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"getProviders(...)");
            Object object = GitExecValueSourceKt.gitVersionProvider(providerFactory).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String gitVersion = (String)object;
            VersionNumber versionNumber = SlackGradleUtilKt.parseGitVersion(gitVersion);
            if (versionNumber.equals((Object)VersionNumber.Companion.getUNKNOWN())) {
                $this$configureGit.getLogger().lifecycle("Could not infer git env from '" + gitVersion + "'. This can happen if it's the pre-installed git version from Apple, please consider using a custom git installation from Homebrew or otherwise.");
            } else if (versionNumber.compareTo(MIN_GIT_VERSION_FOR_IGNORE_REVS) < 0) {
                $this$configureGit.getLogger().lifecycle("Current git version (" + versionNumber + ") is too low to use blame.ignoreRevsFile (2.23+). Please consider updating!");
            } else {
                $this$configureGit.getLogger().debug("Configuring blame.ignoreRevsFile");
                ProviderFactory providerFactory2 = $this$configureGit.getProviders();
                Intrinsics.checkNotNullExpressionValue((Object)providerFactory2, (String)"getProviders(...)");
                String[] stringArray = new String[4];
                stringArray[0] = "git";
                stringArray[1] = "config";
                stringArray[2] = "blame.ignoreRevsFile";
                Intrinsics.checkNotNullExpressionValue((Object)$this$configureGit.file((Object)revsFile).getCanonicalPath(), (String)"getCanonicalPath(...)");
                GitExecValueSourceKt.gitExecProvider(providerFactory2, stringArray).get();
            }
        }
    }

    public static final /* synthetic */ boolean access$isStable(SlackRootPlugin $this, String version) {
        return $this.isStable(version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lslack/gradle/SlackRootPlugin$Companion;", "", "()V", "MIN_GIT_VERSION_FOR_IGNORE_REVS", "Lslack/gradle/agp/VersionNumber;", "getMIN_GIT_VERSION_FOR_IGNORE_REVS", "()Lslack/gradle/agp/VersionNumber;", "STABLE_REGEX", "Lkotlin/text/Regex;", "slack-plugin"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionNumber getMIN_GIT_VERSION_FOR_IGNORE_REVS() {
            return MIN_GIT_VERSION_FOR_IGNORE_REVS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

