/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle;

import com.google.common.collect.Sets;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.internal.os.OperatingSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.cli.AppleSiliconCompat;
import slack.gradle.GlobalConfig;
import slack.gradle.SlackTools;
import slack.gradle.SlackToolsDependencies;
import slack.gradle.SlackToolsExtension;
import slack.gradle.ThermalsReporter;
import slack.gradle.agp.AgpHandler;
import slack.gradle.util.HasConfigurableValuesKt;
import slack.gradle.util.JsonTools;
import slack.gradle.util.OkHttpExtKt;
import slack.gradle.util.PropertyUtil;
import slack.gradle.util.Thermals;
import slack.gradle.util.ThermalsWatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 K2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003JKLB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010.\u001a\u00020/H\u0016J\u001c\u00100\u001a\u00020/2\u0006\u00101\u001a\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002J'\u00105\u001a\u0004\u0018\u0001H6\"\b\b\u0000\u00106*\u00020\u00132\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u0002H60\u0012\u00a2\u0006\u0002\u00108J\u001b\u00109\u001a\b\u0012\u0004\u0012\u0002020:2\u0006\u0010;\u001a\u000202H\u0000\u00a2\u0006\u0002\b<J\u001b\u0010=\u001a\b\u0012\u0004\u0012\u0002020:2\u0006\u0010;\u001a\u000202H\u0000\u00a2\u0006\u0002\b>J\u001d\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u0002022\u0006\u0010A\u001a\u000202H\u0000\u00a2\u0006\u0002\bBJ\n\u0010C\u001a\u0004\u0018\u00010$H\u0002J\u001e\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u0002022\f\u0010F\u001a\b\u0012\u0004\u0012\u00020/0GH\u0002J\b\u0010H\u001a\u00020IH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR0\u0010\u000b\u001a$\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u000e*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lslack/gradle/SlackTools;", "Lorg/gradle/api/services/BuildService;", "Lslack/gradle/SlackTools$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "agpHandler", "Lslack/gradle/agp/AgpHandler;", "getAgpHandler", "()Lslack/gradle/agp/AgpHandler;", "agpHandler$delegate", "Lkotlin/Lazy;", "avoidedTasks", "", "Lslack/gradle/SlackTools$AvoidedTask;", "kotlin.jvm.PlatformType", "", "extensions", "", "Ljava/lang/Class;", "Lslack/gradle/SlackToolsExtension;", "globalConfig", "Lslack/gradle/GlobalConfig;", "getGlobalConfig", "()Lslack/gradle/GlobalConfig;", "setGlobalConfig", "(Lslack/gradle/GlobalConfig;)V", "logger", "Lorg/gradle/api/logging/Logger;", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi", "()Lcom/squareup/moshi/Moshi;", "okHttpClient", "Lkotlin/Lazy;", "Lokhttp3/OkHttpClient;", "thermals", "Lslack/gradle/util/Thermals;", "getThermals", "()Lslack/gradle/util/Thermals;", "thermalsAtClose", "thermalsExecutor", "Ljava/util/concurrent/ExecutorService;", "thermalsReporter", "Lslack/gradle/ThermalsReporter;", "thermalsWatcher", "Lslack/gradle/util/ThermalsWatcher;", "close", "", "debugLog", "message", "", "throwable", "", "findExtension", "T", "type", "(Ljava/lang/Class;)Lslack/gradle/SlackToolsExtension;", "globalLocalProperty", "Lorg/gradle/api/provider/Provider;", "key", "globalLocalProperty$slack_plugin", "globalStartParameterProperty", "globalStartParameterProperty$slack_plugin", "logAvoidedTask", "taskType", "taskName", "logAvoidedTask$slack_plugin", "peekThermals", "runCatchingWithLog", "errorMessage", "block", "Lkotlin/Function0;", "thermalsFile", "Ljava/io/File;", "AvoidedTask", "Companion", "Parameters", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nSlackTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlackTools.kt\nslack/gradle/SlackTools\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1313#2,2:359\n1#3:361\n*S KotlinDebug\n*F\n+ 1 SlackTools.kt\nslack/gradle/SlackTools\n*L\n125#1:359,2\n*E\n"})
public abstract class SlackTools
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy agpHandler$delegate = LazyKt.lazy((Function0)agpHandler.2.INSTANCE);
    public GlobalConfig globalConfig;
    private final Logger logger = Logging.getLogger((String)"SlackTools");
    @NotNull
    private final Map<Class<? extends SlackToolsExtension>, SlackToolsExtension> extensions;
    @NotNull
    private final Lazy<OkHttpClient> okHttpClient = LazyKt.lazy((Function0)okHttpClient.1.INSTANCE);
    @Nullable
    private ThermalsReporter thermalsReporter;
    @Nullable
    private final ThermalsWatcher thermalsWatcher;
    @Nullable
    private final ExecutorService thermalsExecutor;
    @Nullable
    private Thermals thermalsAtClose;
    @NotNull
    private final Set<AvoidedTask> avoidedTasks;
    @NotNull
    public static final String SERVICE_NAME = "SlackTools";

    /*
     * WARNING - void declaration
     */
    public SlackTools() {
        void $this$forEach$iv;
        Map map;
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentHashSet(...)");
        this.avoidedTasks = set;
        SlackTools.debugLog$default(this, "SlackTools created", null, 2, null);
        Object object = ((Parameters)this.getParameters()).getLogThermals().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        boolean canLogThermals = (Boolean)object;
        if (canLogThermals) {
            Object object2 = ((Parameters)this.getParameters()).getConfigurationCacheEnabled().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            if (((Boolean)object2).booleanValue() && AppleSiliconCompat.Arch.Companion.get() != AppleSiliconCompat.Arch.ARM64) {
                this.logger.warn("Thermals logging is enabled but configuration cache is enabled and this is not an Apple Silicon machine. Thermals logging will be disabled. Please set 'slack.log-thermals' to false in your home gradle.properties.");
                canLogThermals = false;
            }
        }
        if (canLogThermals) {
            this.thermalsExecutor = Executors.newSingleThreadExecutor(1.INSTANCE);
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            this.thermalsWatcher = ThermalsWatcher.Companion.invoke(logger, (Function0<? extends File>)((Function0)new Function0<File>((Object)this){

                @NotNull
                public final File invoke() {
                    return ((SlackTools)this.receiver).thermalsFile();
                }
            }));
            this.thermalsWatcher.start(this.thermalsExecutor);
        } else {
            this.thermalsWatcher = null;
            this.thermalsExecutor = null;
        }
        Map map2 = map = MapsKt.createMapBuilder();
        SlackTools slackTools = this;
        boolean bl = false;
        Stream<ServiceLoader.Provider<SlackToolsExtension>> stream = ServiceLoader.load(SlackToolsExtension.class, SlackToolsExtension.class.getClassLoader()).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        Sequence sequence = StreamsKt.asSequence(stream);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$_init__u24lambda_u242;
            SlackToolsExtension slackToolsExtension;
            ServiceLoader.Provider provider2 = (ServiceLoader.Provider)element$iv;
            boolean bl2 = false;
            try {
                slackToolsExtension = (SlackToolsExtension)provider2.get();
            }
            catch (InstantiationException e) {
                this.logger.error("Failed to load extension " + provider2.type().getSimpleName(), (Throwable)e);
                continue;
            }
            SlackToolsExtension extension = slackToolsExtension;
            Class type = provider2.type();
            SlackTools.debugLog$default(this, "Loaded extension " + type.getSimpleName(), null, 2, null);
            Intrinsics.checkNotNull(type);
            Intrinsics.checkNotNull((Object)extension);
            SlackToolsExtension previous = $this$_init__u24lambda_u242.put(type, extension);
            if (previous == null) continue;
            boolean bl3 = false;
            String string = "Duplicate extension registered for " + provider2.type().getSimpleName();
            throw new IllegalStateException(string.toString());
        }
        slackTools.extensions = MapsKt.build((Map)map);
        if (!this.extensions.isEmpty()) {
            SlackToolsDependencies dependencies2 = new SlackToolsDependencies(this){
                final /* synthetic */ SlackTools this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public Lazy<OkHttpClient> getOkHttpClient() {
                    return SlackTools.access$getOkHttpClient$p(this.this$0);
                }
            };
            SlackToolsExtension.Context context2 = new SlackToolsExtension.Context(this, dependencies2){
                final /* synthetic */ SlackTools this$0;
                final /* synthetic */ dependencies.1 $dependencies;
                {
                    this.this$0 = $receiver;
                    this.$dependencies = $dependencies;
                }

                public boolean isOffline() {
                    Object object = ((Parameters)this.this$0.getParameters()).getOffline().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    return (Boolean)object;
                }

                @NotNull
                public SlackToolsDependencies getSharedDependencies() {
                    return this.$dependencies;
                }
            };
            for (SlackToolsExtension extension : this.extensions.values()) {
                extension.bind(context2);
                if (!(extension instanceof ThermalsReporter)) continue;
                if (this.thermalsReporter != null) {
                    this.logger.warn("Multiple thermals reporters registered, only the last one will be used");
                }
                this.thermalsReporter = (ThermalsReporter)((Object)extension);
            }
        }
    }

    @NotNull
    public final AgpHandler getAgpHandler() {
        Lazy lazy = this.agpHandler$delegate;
        return (AgpHandler)lazy.getValue();
    }

    @NotNull
    public final Moshi getMoshi() {
        Moshi moshi2 = JsonTools.INSTANCE.getMOSHI();
        Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"<get-MOSHI>(...)");
        return moshi2;
    }

    @NotNull
    public final GlobalConfig getGlobalConfig() {
        GlobalConfig globalConfig = this.globalConfig;
        if (globalConfig != null) {
            return globalConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"globalConfig");
        return null;
    }

    public final void setGlobalConfig(@NotNull GlobalConfig globalConfig) {
        Intrinsics.checkNotNullParameter((Object)globalConfig, (String)"<set-?>");
        this.globalConfig = globalConfig;
    }

    @Nullable
    public final Thermals getThermals() {
        Thermals thermals = this.thermalsAtClose;
        if (thermals == null) {
            thermals = this.peekThermals();
        }
        return thermals;
    }

    private final void debugLog(String message, Throwable throwable) {
        Object object = ((Parameters)this.getParameters()).getLogVerbosely().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            this.logger.lifecycle(message, throwable);
        } else {
            this.logger.debug(message, throwable);
        }
    }

    static /* synthetic */ void debugLog$default(SlackTools slackTools, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: debugLog");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        slackTools.debugLog(string, throwable);
    }

    private final File thermalsFile() {
        Object object = ((Parameters)this.getParameters()).getThermalsOutputFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Object object2 = object;
        File $this$thermalsFile_u24lambda_u243 = (File)object2;
        boolean bl = false;
        if (!$this$thermalsFile_u24lambda_u243.exists()) {
            $this$thermalsFile_u24lambda_u243.getParentFile().mkdirs();
            $this$thermalsFile_u24lambda_u243.createNewFile();
        }
        return (File)object2;
    }

    private final Thermals peekThermals() {
        ThermalsWatcher thermalsWatcher = this.thermalsWatcher;
        return thermalsWatcher != null ? thermalsWatcher.peek() : null;
    }

    @Nullable
    public final <T extends SlackToolsExtension> T findExtension(@NotNull Class<? extends T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)this.extensions.get(type);
    }

    public final void logAvoidedTask$slack_plugin(@NotNull String taskType, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        SlackTools.debugLog$default(this, "[Skippy] Skipping '" + taskType + "' task: " + taskName, null, 2, null);
        this.avoidedTasks.add(new AvoidedTask(taskType, taskName));
    }

    @Override
    public void close() {
        ThermalsWatcher thermalsWatcher = this.thermalsWatcher;
        this.thermalsAtClose = thermalsWatcher != null ? thermalsWatcher.stop() : null;
        this.runCatchingWithLog("Failed to report thermals", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SlackTools this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                block9: {
                    Thermals thermals = SlackTools.access$getThermalsAtClose$p(this.this$0);
                    if (thermals == null) break block9;
                    Thermals thermals2 = thermals;
                    SlackTools slackTools = this.this$0;
                    Thermals thermalsAtClose = thermals2;
                    boolean bl = false;
                    File file = ((RegularFile)((Parameters)slackTools.getParameters()).getThermalsOutputJsonFile().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                    File thermalsJsonFile = file;
                    if (thermalsJsonFile.exists()) {
                        thermalsJsonFile.delete();
                    }
                    thermalsJsonFile.getParentFile().mkdirs();
                    thermalsJsonFile.createNewFile();
                    Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)thermalsJsonFile, (boolean)false, (int)1, null)));
                    Throwable throwable = null;
                    try {
                        JsonWriter writer = (JsonWriter)closeable;
                        boolean bl2 = false;
                        Moshi $this$adapter$iv = slackTools.getMoshi();
                        boolean $i$f$adapter = false;
                        _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(Thermals.class)).toJson(writer, (Object)thermalsAtClose);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (!((Boolean)((Parameters)slackTools.getParameters()).getOffline().get()).booleanValue()) {
                        ThermalsReporter thermalsReporter = SlackTools.access$getThermalsReporter$p(slackTools);
                        if (thermalsReporter != null) {
                            thermalsReporter.reportThermals(thermalsAtClose);
                        }
                    }
                }
            }
        }));
        Object object = ((Parameters)this.getParameters()).getEnableSkippyDiagnostics().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            this.runCatchingWithLog("Failed to write Skippy diagnostics", (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SlackTools this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$mapValuesTo$iv$iv;
                    Object key$iv$iv;
                    Map $this$groupByTo$iv$iv;
                    File file = ((RegularFile)((Parameters)this.this$0.getParameters()).getSkippyDiagnosticsOutputFile().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                    File outputFile = file;
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    outputFile.getParentFile().mkdirs();
                    Iterable $this$groupBy$iv = SlackTools.access$getAvoidedTasks$p(this.this$0);
                    boolean $i$f$groupBy = false;
                    Object object = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    Iterator<T> iterator = $this$groupByTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object object2;
                        T element$iv$iv = iterator.next();
                        AvoidedTask it = (AvoidedTask)element$iv$iv;
                        boolean bl = false;
                        key$iv$iv = it.getType();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Map $this$mapValues$iv = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    $this$groupByTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (E element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void $this$mapTo$iv$iv;
                        void it$iv$iv;
                        key$iv$iv = (Map.Entry)element$iv$iv$iv;
                        Map map = destination$iv$iv;
                        boolean bl = false;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        K k = it$iv$iv.getKey();
                        Map map2 = map;
                        boolean bl3 = false;
                        List tasks = (List)entry.getValue();
                        Iterable $this$map$iv = tasks;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            AvoidedTask avoidedTask = (AvoidedTask)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl4 = false;
                            collection.add(it.getTaskName());
                        }
                        List list = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                        map2.put(k, list);
                    }
                    Map $this$forEach$iv = MapsKt.toSortedMap((Map)destination$iv$iv);
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = (Map.Entry)object.next();
                        boolean bl = false;
                        String type = (String)entry.getKey();
                        List tasks = (List)entry.getValue();
                        FilesKt.appendText$default((File)outputFile, (String)(type + ":\n"), null, (int)2, null);
                        for (String task2 : tasks) {
                            FilesKt.appendText$default((File)outputFile, (String)("  " + task2 + "\n"), null, (int)2, null);
                        }
                    }
                }
            }));
        }
        this.runCatchingWithLog("Failed to close extension", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SlackTools this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Iterable $this$forEach$iv = SlackTools.access$getExtensions$p(this.this$0).values();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SlackToolsExtension p0 = (SlackToolsExtension)element$iv;
                    boolean bl = false;
                    p0.close();
                }
            }
        }));
        ExecutorService executorService = this.thermalsExecutor;
        if (executorService != null) {
            executorService.shutdown();
        }
        if (this.okHttpClient.isInitialized()) {
            OkHttpExtKt.shutdown((OkHttpClient)this.okHttpClient.getValue());
        }
    }

    private final void runCatchingWithLog(String errorMessage, Function0<Unit> block) {
        block2: {
            Throwable throwable;
            Object object;
            try {
                object = Result.constructor-impl((Object)block.invoke());
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable t = throwable = throwable3;
            boolean bl = false;
            this.logger.error(errorMessage, t);
        }
    }

    @NotNull
    public final Provider<String> globalStartParameterProperty$slack_plugin(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Provider provider2 = ((Parameters)this.getParameters()).getStartParameterProperties().map(new Transformer(key){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
            }

            @NotNull
            public final @Nullable String transform(@NotNull Map<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return PropertyUtil.sneakyNull(it.get(this.$key));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        return provider2;
    }

    @NotNull
    public final Provider<String> globalLocalProperty$slack_plugin(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Provider provider2 = ((Parameters)this.getParameters()).getLocalProperties().map(new Transformer(key){
            final /* synthetic */ String $key;
            {
                this.$key = $key;
            }

            @NotNull
            public final @Nullable String transform(@NotNull Map<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return PropertyUtil.sneakyNull(it.get(this.$key));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        return provider2;
    }

    public static final /* synthetic */ Thermals access$getThermalsAtClose$p(SlackTools $this) {
        return $this.thermalsAtClose;
    }

    public static final /* synthetic */ ThermalsReporter access$getThermalsReporter$p(SlackTools $this) {
        return $this.thermalsReporter;
    }

    public static final /* synthetic */ Set access$getAvoidedTasks$p(SlackTools $this) {
        return $this.avoidedTasks;
    }

    public static final /* synthetic */ Map access$getExtensions$p(SlackTools $this) {
        return $this.extensions;
    }

    public static final /* synthetic */ Lazy access$getOkHttpClient$p(SlackTools $this) {
        return $this.okHttpClient;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lslack/gradle/SlackTools$AvoidedTask;", "", "type", "", "taskName", "(Ljava/lang/String;Ljava/lang/String;)V", "getTaskName", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "slack-plugin"})
    private static final class AvoidedTask {
        @NotNull
        private final String type;
        @NotNull
        private final String taskName;

        public AvoidedTask(@NotNull String type, @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.type = type;
            this.taskName = taskName;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.taskName;
        }

        @NotNull
        public final AvoidedTask copy(@NotNull String type, @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return new AvoidedTask(type, taskName);
        }

        public static /* synthetic */ AvoidedTask copy$default(AvoidedTask avoidedTask, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = avoidedTask.type;
            }
            if ((n & 2) != 0) {
                string2 = avoidedTask.taskName;
            }
            return avoidedTask.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AvoidedTask(type=" + this.type + ", taskName=" + this.taskName + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.taskName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AvoidedTask)) {
                return false;
            }
            AvoidedTask avoidedTask = (AvoidedTask)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)avoidedTask.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.taskName, (Object)avoidedTask.taskName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0083\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00120\u00062\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00120\u0006H\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lslack/gradle/SlackTools$Companion;", "", "()V", "SERVICE_NAME", "", "register", "Lorg/gradle/api/provider/Provider;", "Lslack/gradle/SlackTools;", "project", "Lorg/gradle/api/Project;", "logThermals", "", "enableSkippyDiagnostics", "logVerbosely", "thermalsLogJsonFileProvider", "Lorg/gradle/api/file/RegularFile;", "isConfigurationCacheRequested", "startParameterProperties", "", "globalLocalProperties", "register$slack_plugin", "slack-plugin"})
    @SourceDebugExtension(value={"SMAP\nSlackTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlackTools.kt\nslack/gradle/SlackTools$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1#2:359\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<SlackTools> register$slack_plugin(@NotNull Project project, boolean logThermals, boolean enableSkippyDiagnostics, boolean logVerbosely, @NotNull Provider<RegularFile> thermalsLogJsonFileProvider, @NotNull Provider<Boolean> isConfigurationCacheRequested, @NotNull Provider<Map<String, String>> startParameterProperties2, @NotNull Provider<Map<String, String>> globalLocalProperties) {
            Provider provider2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(thermalsLogJsonFileProvider, (String)"thermalsLogJsonFileProvider");
            Intrinsics.checkNotNullParameter(isConfigurationCacheRequested, (String)"isConfigurationCacheRequested");
            Intrinsics.checkNotNullParameter(startParameterProperties2, (String)"startParameterProperties");
            Intrinsics.checkNotNullParameter(globalLocalProperties, (String)"globalLocalProperties");
            Provider $this$register_u24lambda_u241 = provider2 = project.getGradle().getSharedServices().registerIfAbsent(SlackTools.SERVICE_NAME, SlackTools.class, new Action(project, thermalsLogJsonFileProvider, isConfigurationCacheRequested, enableSkippyDiagnostics, logVerbosely, globalLocalProperties, startParameterProperties2, logThermals){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<RegularFile> $thermalsLogJsonFileProvider;
                final /* synthetic */ Provider<Boolean> $isConfigurationCacheRequested;
                final /* synthetic */ boolean $enableSkippyDiagnostics;
                final /* synthetic */ boolean $logVerbosely;
                final /* synthetic */ Provider<Map<String, String>> $globalLocalProperties;
                final /* synthetic */ Provider<Map<String, String>> $startParameterProperties;
                final /* synthetic */ boolean $logThermals;
                {
                    this.$project = $project;
                    this.$thermalsLogJsonFileProvider = $thermalsLogJsonFileProvider;
                    this.$isConfigurationCacheRequested = $isConfigurationCacheRequested;
                    this.$enableSkippyDiagnostics = $enableSkippyDiagnostics;
                    this.$logVerbosely = $logVerbosely;
                    this.$globalLocalProperties = $globalLocalProperties;
                    this.$startParameterProperties = $startParameterProperties;
                    this.$logThermals = $logThermals;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void execute(@NotNull BuildServiceSpec<Parameters> $this$registerIfAbsent) {
                    boolean bl;
                    Property<Boolean> property;
                    block3: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter($this$registerIfAbsent, (String)"$this$registerIfAbsent");
                        Property property2 = (Property)((Parameters)$this$registerIfAbsent.getParameters()).getThermalsOutputFile();
                        Provider provider2 = this.$project.getLayout().getBuildDirectory().file("outputs/logs/last-build-thermals.log");
                        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"file(...)");
                        HasConfigurableValuesKt.setDisallowChanges(property2, provider2);
                        HasConfigurableValuesKt.setDisallowChanges((Property)((Parameters)$this$registerIfAbsent.getParameters()).getThermalsOutputJsonFile(), this.$thermalsLogJsonFileProvider);
                        HasConfigurableValuesKt.setDisallowChanges(((Parameters)$this$registerIfAbsent.getParameters()).getOffline(), this.$project.getGradle().getStartParameter().isOffline());
                        Property<Boolean> property3 = ((Parameters)$this$registerIfAbsent.getParameters()).getCleanRequested();
                        List list = this.$project.getGradle().getStartParameter().getTaskNames();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTaskNames(...)");
                        Iterable iterable = list;
                        property = property3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.equals((String)it, (String)"clean", (boolean)true)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    boolean bl3 = bl;
                    HasConfigurableValuesKt.setDisallowChanges(property, bl3);
                    Property<Boolean> property4 = ((Parameters)$this$registerIfAbsent.getParameters()).getLogThermals();
                    Provider provider3 = this.$project.provider(new Callable(this.$logThermals, $this$registerIfAbsent){
                        final /* synthetic */ boolean $logThermals;
                        final /* synthetic */ BuildServiceSpec<Parameters> $this_registerIfAbsent;
                        {
                            this.$logThermals = $logThermals;
                            this.$this_registerIfAbsent = $this_registerIfAbsent;
                        }

                        @Nullable
                        public final Boolean call() {
                            return this.$logThermals && (Boolean)((Parameters)this.$this_registerIfAbsent.getParameters()).getCleanRequested().get() == false && OperatingSystem.current().isMacOsX();
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"provider(...)");
                    HasConfigurableValuesKt.setDisallowChanges(property4, provider3);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)$this$registerIfAbsent.getParameters()).getConfigurationCacheEnabled(), this.$isConfigurationCacheRequested);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)$this$registerIfAbsent.getParameters()).getEnableSkippyDiagnostics(), this.$enableSkippyDiagnostics);
                    Property property5 = (Property)((Parameters)$this$registerIfAbsent.getParameters()).getSkippyDiagnosticsOutputFile();
                    Provider provider4 = this.$project.getLayout().getBuildDirectory().file("outputs/logs/skippy-diagnostics.txt");
                    Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"file(...)");
                    HasConfigurableValuesKt.setDisallowChanges(property5, provider4);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)$this$registerIfAbsent.getParameters()).getLogVerbosely(), this.$logVerbosely);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)$this$registerIfAbsent.getParameters()).getLocalProperties(), this.$globalLocalProperties);
                    HasConfigurableValuesKt.setDisallowChanges(((Parameters)$this$registerIfAbsent.getParameters()).getStartParameterProperties(), this.$startParameterProperties);
                }
            });
            boolean bl = false;
            Object object = $this$register_u24lambda_u241.get();
            SlackTools $this$register_u24lambda_u241_u24lambda_u240 = (SlackTools)object;
            boolean bl2 = false;
            $this$register_u24lambda_u241_u24lambda_u240.setGlobalConfig(GlobalConfig.Companion.invoke(project));
            Provider provider3 = provider2;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"apply(...)");
            return provider3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0012\u0010\u001c\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0012\u0010\u001e\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Lslack/gradle/SlackTools$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "cleanRequested", "Lorg/gradle/api/provider/Property;", "", "getCleanRequested", "()Lorg/gradle/api/provider/Property;", "configurationCacheEnabled", "getConfigurationCacheEnabled", "enableSkippyDiagnostics", "getEnableSkippyDiagnostics", "localProperties", "Lorg/gradle/api/provider/MapProperty;", "", "getLocalProperties", "()Lorg/gradle/api/provider/MapProperty;", "logThermals", "getLogThermals", "logVerbosely", "getLogVerbosely", "offline", "getOffline", "skippyDiagnosticsOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSkippyDiagnosticsOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "startParameterProperties", "getStartParameterProperties", "thermalsOutputFile", "getThermalsOutputFile", "thermalsOutputJsonFile", "getThermalsOutputJsonFile", "slack-plugin"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getThermalsOutputFile();

        @NotNull
        public RegularFileProperty getThermalsOutputJsonFile();

        @NotNull
        public Property<Boolean> getOffline();

        @NotNull
        public Property<Boolean> getCleanRequested();

        @NotNull
        public Property<Boolean> getLogThermals();

        @NotNull
        public Property<Boolean> getConfigurationCacheEnabled();

        @NotNull
        public Property<Boolean> getEnableSkippyDiagnostics();

        @NotNull
        public RegularFileProperty getSkippyDiagnosticsOutputFile();

        @NotNull
        public Property<Boolean> getLogVerbosely();

        @NotNull
        public MapProperty<String, String> getLocalProperties();

        @NotNull
        public MapProperty<String, String> getStartParameterProperties();
    }
}

