/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.artifacts;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import slack.gradle.artifacts.ArtifactUtilKt;
import slack.gradle.artifacts.ResolverKt;
import slack.gradle.artifacts.SgpArtifact;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001dB3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aR\u0010\u0010\b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lslack/gradle/artifacts/Resolver;", "T", "Ljava/io/Serializable;", "", "project", "Lorg/gradle/api/Project;", "attr", "Lorg/gradle/api/attributes/Attribute;", "artifact", "declarableName", "", "category", "(Lorg/gradle/api/Project;Lorg/gradle/api/attributes/Attribute;Ljava/io/Serializable;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/io/Serializable;", "declarable", "Lorg/gradle/api/artifacts/Configuration;", "getDeclarable", "()Lorg/gradle/api/artifacts/Configuration;", "internal", "Lorg/gradle/api/NamedDomainObjectProvider;", "getInternal", "()Lorg/gradle/api/NamedDomainObjectProvider;", "internalName", "addSubprojectDependencies", "", "artifactView", "Lorg/gradle/api/provider/Provider;", "", "Ljava/io/File;", "Companion", "slack-plugin"})
public final class Resolver<T extends Serializable> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Attribute<T> attr;
    @NotNull
    private final T artifact;
    @NotNull
    private final String internalName;
    @NotNull
    private final Configuration declarable;
    @NotNull
    private final NamedDomainObjectProvider<? extends Configuration> internal;

    public Resolver(@NotNull Project project, @NotNull Attribute<T> attr, @NotNull T artifact, @NotNull String declarableName, @NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(attr, (String)"attr");
        Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)declarableName, (String)"declarableName");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.attr = attr;
        this.artifact = artifact;
        this.internalName = declarableName + "Classpath";
        Object object = project.getConfigurations().dependencyScope(declarableName).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.declarable = (Configuration)object;
        NamedDomainObjectProvider namedDomainObjectProvider = project.getConfigurations().resolvable(this.internalName, new Action(this, project, category){
            final /* synthetic */ Resolver<T> this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $category;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$category = $category;
            }

            public final void execute(@NotNull ResolvableConfiguration $this$resolvable) {
                Intrinsics.checkNotNullParameter((Object)$this$resolvable, (String)"$this$resolvable");
                Configuration[] configurationArray = new Configuration[]{this.this$0.getDeclarable()};
                $this$resolvable.extendsFrom(configurationArray);
                $this$resolvable.attributes(new Action(this.this$0, this.$project, this.$category){
                    final /* synthetic */ Resolver<T> this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $category;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$category = $category;
                    }

                    public final void execute(@NotNull AttributeContainer $this$attributes) {
                        Intrinsics.checkNotNullParameter((Object)$this$attributes, (String)"$this$attributes");
                        $this$attributes.attribute(Resolver.access$getAttr$p(this.this$0), (Object)Resolver.access$getArtifact$p(this.this$0));
                        ArtifactUtilKt.addCommonAttributes($this$attributes, this.$project, this.$category);
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider, (String)"resolvable(...)");
        this.internal = namedDomainObjectProvider;
    }

    @NotNull
    public final Configuration getDeclarable() {
        return this.declarable;
    }

    @NotNull
    public final NamedDomainObjectProvider<? extends Configuration> getInternal() {
        return this.internal;
    }

    @NotNull
    public final Provider<Set<File>> artifactView() {
        return ResolverKt.access$artifactView(this.internal, this.attr, this.artifact);
    }

    public final void addSubprojectDependencies(@NotNull Project project) {
        DependencyHandler dependencyHandler;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DependencyHandler $this$addSubprojectDependencies_u24lambda_u240 = dependencyHandler = project.getDependencies();
        boolean bl = false;
        for (Project subproject : project.getSubprojects()) {
            File projectDir;
            Intrinsics.checkNotNullExpressionValue((Object)subproject.getProjectDir(), (String)"getProjectDir(...)");
            if (!new File(projectDir, "build.gradle.kts").exists() && !new File(projectDir, "build.gradle").exists()) continue;
            $this$addSubprojectDependencies_u24lambda_u240.add(this.declarable.getName(), (Object)project.project(subproject.getPath()));
        }
    }

    public static final /* synthetic */ Attribute access$getAttr$p(Resolver $this) {
        return $this.attr;
    }

    public static final /* synthetic */ Serializable access$getArtifact$p(Resolver $this) {
        return $this.artifact;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u0002H\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0013"}, d2={"Lslack/gradle/artifacts/Resolver$Companion;", "", "()V", "interProjectResolver", "Lslack/gradle/artifacts/Resolver;", "T", "Ljava/io/Serializable;", "project", "Lorg/gradle/api/Project;", "attr", "Lorg/gradle/api/attributes/Attribute;", "artifact", "declarableName", "", "category", "addDependencies", "", "(Lorg/gradle/api/Project;Lorg/gradle/api/attributes/Attribute;Ljava/io/Serializable;Ljava/lang/String;Ljava/lang/String;Z)Lslack/gradle/artifacts/Resolver;", "Lslack/gradle/artifacts/SgpArtifact;", "slack-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Resolver<SgpArtifact> interProjectResolver(@NotNull Project project, @NotNull SgpArtifact artifact, boolean addDependencies) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            return this.interProjectResolver(project, artifact.getAttribute(), (Serializable)artifact, artifact.getDeclarableName(), artifact.getCategory(), addDependencies);
        }

        public static /* synthetic */ Resolver interProjectResolver$default(Companion companion, Project project, SgpArtifact sgpArtifact, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.interProjectResolver(project, sgpArtifact, bl);
        }

        @NotNull
        public final <T extends Serializable> Resolver<T> interProjectResolver(@NotNull Project project, @NotNull Attribute<T> attr, @NotNull T artifact, @NotNull String declarableName, @NotNull String category, boolean addDependencies) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(attr, (String)"attr");
            Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)declarableName, (String)"declarableName");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            project.getLogger().debug("Creating resolver for " + artifact);
            Resolver<T> resolver = new Resolver<T>(project, attr, artifact, declarableName, category);
            if (addDependencies) {
                project.getLogger().debug("Adding subproject dependencies to " + artifact + " via " + declarableName);
                resolver.addSubprojectDependencies(project);
            }
            return resolver;
        }

        public static /* synthetic */ Resolver interProjectResolver$default(Companion companion, Project project, Attribute attribute, Serializable serializable, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 0x20) != 0) {
                bl = true;
            }
            return companion.interProjectResolver(project, attribute, serializable, string, string2, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

