/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.compose;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.ComposeExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmCompilerOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompilationTask;
import slack.gradle.SlackProperties;
import slack.gradle.compose.ComposeUtilKt;
import slack.gradle.util.KgpUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"COMPOSE_COMPILER_GOOGLE_GROUP", "", "COMPOSE_COMPILER_JB_GROUP", "COMPOSE_COMPILER_OPTION_PREFIX", "configureComposeCompiler", "", "Lorg/gradle/api/Project;", "slackProperties", "Lslack/gradle/SlackProperties;", "isMultiplatform", "", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nComposeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUtil.kt\nslack/gradle/compose/ComposeUtilKt\n+ 2 GradleExt.kt\nslack/gradle/GradleExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n164#2:121\n180#2:122\n165#2:124\n1#3:123\n*S KotlinDebug\n*F\n+ 1 ComposeUtil.kt\nslack/gradle/compose/ComposeUtilKt\n*L\n71#1:121\n71#1:122\n71#1:124\n71#1:123\n*E\n"})
public final class ComposeUtilKt {
    @NotNull
    private static final String COMPOSE_COMPILER_GOOGLE_GROUP = "androidx.compose.compiler";
    @NotNull
    private static final String COMPOSE_COMPILER_JB_GROUP = "org.jetbrains.compose.compiler";
    @NotNull
    public static final String COMPOSE_COMPILER_OPTION_PREFIX = "plugin:androidx.compose.compiler.plugins.kotlin";

    /*
     * WARNING - void declaration
     */
    public static final void configureComposeCompiler(@NotNull Project $this$configureComposeCompiler, @NotNull SlackProperties slackProperties, boolean isMultiplatform) {
        boolean suppressComposeKotlinVersion;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$configureComposeCompiler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)slackProperties, (String)"slackProperties");
        String kotlinVersion = slackProperties.getVersions$slack_plugin().getKotlin();
        if (isMultiplatform && !slackProperties.getForceAndroidXComposeCompilerForComposeMultiplatform()) {
            String string = slackProperties.getVersions$slack_plugin().getComposeJb();
            if (string == null) {
                throw new IllegalStateException("No compose-jb version defined in libs.versions.toml".toString());
            }
            String composeJbDepVersion = string;
            String string2 = slackProperties.getVersions$slack_plugin().getComposeJbKotlinVersion();
            if (string2 == null) {
                throw new IllegalStateException("No compose-jb-kotlinVersion version defined in libs.versions.toml".toString());
            }
            String composeJbKotlinVersion = string2;
            pair = TuplesKt.to((Object)("org.jetbrains.compose.compiler:compiler:" + composeJbDepVersion), (Object)composeJbKotlinVersion);
        } else {
            String string = slackProperties.getVersions$slack_plugin().getComposeCompiler();
            if (string == null) {
                throw new IllegalStateException("No compose-compiler version defined in libs.versions.toml".toString());
            }
            String composeDepVersion = string;
            String string3 = slackProperties.getVersions$slack_plugin().getComposeCompilerKotlinVersion();
            if (string3 == null) {
                throw new IllegalStateException("No compose-compiler-kotlinVersion version defined in libs.versions.toml".toString());
            }
            String composeKotlinVersion = string3;
            pair = TuplesKt.to((Object)("androidx.compose.compiler:compiler:" + composeDepVersion), (Object)composeKotlinVersion);
        }
        Pair pair2 = pair;
        String compilerDep = (String)pair2.component1();
        String composeCompilerKotlinVersion = (String)pair2.component2();
        if (isMultiplatform) {
            void $this$configure$iv;
            Project project = $this$configureComposeCompiler;
            Action action$iv = new Action(compilerDep){
                final /* synthetic */ String $compilerDep;
                {
                    this.$compilerDep = $compilerDep;
                }

                public final void execute(@NotNull ComposeExtension $this$configure) {
                    Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                    $this$configure.getKotlinCompilerPlugin().set((Object)this.$compilerDep);
                }
            };
            boolean $i$f$configure = false;
            ExtensionContainer extensionContainer = $this$configure$iv.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
            Object $this$getByType$iv$iv = extensionContainer;
            boolean $i$f$getByType = false;
            Object p0$iv = $this$getByType$iv$iv = $this$getByType$iv$iv.getByType(TypeOf.typeOf((Type)TypesJVMKt.getJavaType((KType)Reflection.typeOf(ComposeExtension.class))));
            boolean bl = false;
            action$iv.execute(p0$iv);
        }
        boolean bl = suppressComposeKotlinVersion = !Intrinsics.areEqual((Object)kotlinVersion, (Object)composeCompilerKotlinVersion);
        if (suppressComposeKotlinVersion) {
            TaskContainer taskContainer = $this$configureComposeCompiler.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            KgpUtilKt.configureKotlinCompilationTask$default(taskContainer, false, false, new Function1<KotlinCompilationTask<?>, Unit>(kotlinVersion){
                final /* synthetic */ String $kotlinVersion;
                {
                    this.$kotlinVersion = $kotlinVersion;
                    super(1);
                }

                public final void invoke(@NotNull KotlinCompilationTask<?> $this$configureKotlinCompilationTask) {
                    Intrinsics.checkNotNullParameter($this$configureKotlinCompilationTask, (String)"$this$configureKotlinCompilationTask");
                    $this$configureKotlinCompilationTask.compilerOptions((Function1)new Function1<KotlinCommonCompilerOptions, Unit>($this$configureKotlinCompilationTask, this.$kotlinVersion){
                        final /* synthetic */ KotlinCompilationTask<?> $this_configureKotlinCompilationTask;
                        final /* synthetic */ String $kotlinVersion;
                        {
                            this.$this_configureKotlinCompilationTask = $this_configureKotlinCompilationTask;
                            this.$kotlinVersion = $kotlinVersion;
                            super(1);
                        }

                        public final void invoke(@NotNull KotlinCommonCompilerOptions $this$compilerOptions) {
                            Intrinsics.checkNotNullParameter((Object)$this$compilerOptions, (String)"$this$compilerOptions");
                            this.$this_configureKotlinCompilationTask.getLogger().debug("Configuring compose compiler args in " + this.$this_configureKotlinCompilationTask.getProject().getPath() + ":" + this.$this_configureKotlinCompilationTask.getName());
                            if ($this$compilerOptions instanceof KotlinJvmCompilerOptions) {
                                Object[] objectArray = new String[]{"-Xskip-prerelease-check", "-P", "plugin:androidx.compose.compiler.plugins.kotlin:suppressKotlinVersionCompatibilityCheck=" + this.$kotlinVersion};
                                $this$compilerOptions.getFreeCompilerArgs().addAll(objectArray);
                            }
                        }
                    });
                }
            }, 3, null);
        } else {
            $this$configureComposeCompiler.getLogger().debug("Not configuring compose compiler args in " + $this$configureComposeCompiler.getProject().getPath() + ", kotlin and compose compiler versions are aligned");
        }
        if (isMultiplatform) {
            DependencyHandler dependencyHandler;
            DependencyHandler $this$configureComposeCompiler_u24lambda_u240 = dependencyHandler = $this$configureComposeCompiler.getDependencies();
            boolean bl2 = false;
            $this$configureComposeCompiler_u24lambda_u240.add("kotlinCompilerPluginClasspath", (Object)compilerDep);
            $this$configureComposeCompiler_u24lambda_u240.add("kotlinNativeCompilerPluginClasspath", (Object)compilerDep);
            $this$configureComposeCompiler.getConfigurations().matching((Spec)configureComposeCompiler.4.INSTANCE).configureEach(new Action(slackProperties, $this$configureComposeCompiler){
                final /* synthetic */ SlackProperties $slackProperties;
                final /* synthetic */ Project $this_configureComposeCompiler;
                {
                    this.$slackProperties = $slackProperties;
                    this.$this_configureComposeCompiler = $receiver;
                }

                public final void execute(@NotNull Configuration $this$configureEach) {
                    Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                    String group = this.$slackProperties.getForceAndroidXComposeCompilerForComposeMultiplatform() ? "org.jetbrains.compose.compiler" : "androidx.compose.compiler";
                    this.$this_configureComposeCompiler.getLogger().debug("Excluding compose compiler plugin group '" + group + "' from configuration '" + $this$configureEach.getName() + "'");
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)group), TuplesKt.to((Object)"module", (Object)"compiler")};
                    $this$configureEach.exclude(MapsKt.mapOf((Pair[])pairArray));
                }
            });
        }
    }
}

