/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.lint;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektCreateBaselineTask;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.GradleExtKt;
import slack.gradle.SlackProperties;
import slack.gradle.artifacts.Publisher;
import slack.gradle.artifacts.Resolver;
import slack.gradle.artifacts.SgpArtifact;
import slack.gradle.avoidance.SkippyArtifacts;
import slack.gradle.lint.DetektTasks;
import slack.gradle.tasks.DetektDownloadTask;
import slack.gradle.tasks.FileTasksKt;
import slack.gradle.tasks.SimpleFileProducerTask;
import slack.gradle.tasks.SimpleFilesConsumerTask;
import slack.gradle.util.HasConfigurableValuesKt;
import slack.gradle.util.PropertyUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lslack/gradle/lint/DetektTasks;", "", "()V", "CI_DETEKT_TASK_NAME", "", "GLOBAL_CI_DETEKT_TASK_NAME", "LOG", "configureRootProject", "", "project", "Lorg/gradle/api/Project;", "slackProperties", "Lslack/gradle/SlackProperties;", "configureSubProject", "affectedProjects", "", "jvmTarget", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nDetektTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetektTasks.kt\nslack/gradle/lint/DetektTasks\n+ 2 GradleExt.kt\nslack/gradle/GradleExtKt\n*L\n1#1,156:1\n161#2:157\n*S KotlinDebug\n*F\n+ 1 DetektTasks.kt\nslack/gradle/lint/DetektTasks\n*L\n53#1:157\n*E\n"})
public final class DetektTasks {
    @NotNull
    public static final DetektTasks INSTANCE = new DetektTasks();
    @NotNull
    private static final String GLOBAL_CI_DETEKT_TASK_NAME = "globalCiDetekt";
    @NotNull
    private static final String CI_DETEKT_TASK_NAME = "ciDetekt";
    @NotNull
    private static final String LOG = "SlackDetekt:";

    private DetektTasks() {
    }

    /*
     * WARNING - void declaration
     */
    public final void configureRootProject(@NotNull Project project, @NotNull SlackProperties slackProperties) {
        block0: {
            void name$iv;
            void $this$register$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)slackProperties, (String)"slackProperties");
            String string = slackProperties.getVersions$slack_plugin().getDetekt();
            if (string == null) break block0;
            String detektVersion = string;
            boolean bl = false;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            TaskContainer taskContainer2 = taskContainer;
            String string2 = "updateDetekt";
            Action configuration$iv = new Action(detektVersion, project){
                final /* synthetic */ String $detektVersion;
                final /* synthetic */ Project $project;
                {
                    this.$detektVersion = $detektVersion;
                    this.$project = $project;
                }

                public final void execute(@NotNull DetektDownloadTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    HasConfigurableValuesKt.setDisallowChanges($this$register.getVersion(), this.$detektVersion);
                    HasConfigurableValuesKt.setDisallowChanges((Property)$this$register.getOutputFile(), this.$project.getLayout().getProjectDirectory().file("config/bin/detekt"));
                }
            };
            boolean $i$f$register = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register((String)name$iv, DetektDownloadTask.class, configuration$iv), (String)"register(...)");
            Resolver resolver = Resolver.Companion.interProjectResolver$default(Resolver.Companion, project, SgpArtifact.SKIPPY_DETEKT.INSTANCE, false, 4, null);
            SimpleFilesConsumerTask.Companion.registerOrConfigure$default(SimpleFilesConsumerTask.Companion, project, GLOBAL_CI_DETEKT_TASK_NAME, "Global lifecycle task to run all dependent detekt tasks.", resolver.artifactView(), null, null, null, 112, null);
        }
    }

    public final void configureSubProject(@NotNull Project project, @NotNull SlackProperties slackProperties, @Nullable Set<String> affectedProjects, @NotNull String jvmTarget2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)slackProperties, (String)"slackProperties");
        Intrinsics.checkNotNullParameter((Object)jvmTarget2, (String)"jvmTarget");
        if (!(!GradleExtKt.isRootProject(project))) {
            boolean bl = false;
            String string = "This method should only be called for subprojects, not the root project.";
            throw new IllegalStateException(string.toString());
        }
        if (slackProperties.getVersions$slack_plugin().getDetekt() == null) {
            return;
        }
        project.getPluginManager().withPlugin("io.gitlab.arturbosch.detekt", new Action(project, affectedProjects, slackProperties, jvmTarget2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<String> $affectedProjects;
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ String $jvmTarget;
            {
                this.$project = $project;
                this.$affectedProjects = $affectedProjects;
                this.$slackProperties = $slackProperties;
                this.$jvmTarget = $jvmTarget;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                block4: {
                    TaskContainer $this$configureEach$iv;
                    String log;
                    Publisher<SgpArtifact> publisher;
                    void $this$configure$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                    this.$project.getLogger().debug("SlackDetekt: Configuring Detekt tasks for project " + this.$project.getPath() + "...");
                    Project project = this.$project;
                    Action action$iv = new Action(this.$slackProperties, this.$project){
                        final /* synthetic */ SlackProperties $slackProperties;
                        final /* synthetic */ Project $project;
                        {
                            this.$slackProperties = $slackProperties;
                            this.$project = $project;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void execute(@NotNull DetektExtension $this$configure) {
                            File file;
                            Object configs;
                            Project project;
                            Object object;
                            Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                            $this$configure.setBuildUponDefaultConfig(true);
                            String string = this.$slackProperties.getVersions$slack_plugin().getDetekt();
                            if (string == null) {
                                throw new IllegalStateException("missing 'detekt' version in version catalog".toString());
                            }
                            $this$configure.setToolVersion(string);
                            this.$project.getRootProject().file((Object)"config/detekt/detekt.yml");
                            List<String> list = this.$slackProperties.getDetektConfigs();
                            if (list != null) {
                                object = list;
                                project = this.$project;
                                configs = object;
                                boolean bl = false;
                                Iterator<String> iterator = configs.iterator();
                                while (iterator.hasNext()) {
                                    String configFile = iterator.next();
                                    Object[] objectArray = new Object[]{project.getRootProject().file((Object)configFile)};
                                    $this$configure.getConfig().from(objectArray);
                                }
                            }
                            DetektExtension detektExtension = $this$configure;
                            String string2 = this.$slackProperties.getDetektBaselineFileName();
                            if (string2 != null) {
                                void baselineFile;
                                object = string2;
                                project = this.$project;
                                configs = object;
                                DetektExtension detektExtension2 = detektExtension;
                                boolean bl = false;
                                file = project.getLayout().getProjectDirectory().file((String)baselineFile).getAsFile();
                                detektExtension = detektExtension2;
                            } else {
                                file = null;
                            }
                            detektExtension.setBaseline(file);
                        }
                    };
                    boolean $i$f$configure = false;
                    ExtensionContainer extensionContainer = $this$configure$iv.getExtensions();
                    Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
                    Object $this$getByType$iv$iv = extensionContainer;
                    boolean $i$f$getByType = false;
                    Object p0$iv = $this$getByType$iv$iv = $this$getByType$iv$iv.getByType(TypeOf.typeOf((Type)TypesJVMKt.getJavaType((KType)Reflection.typeOf(DetektExtension.class))));
                    boolean bl = false;
                    action$iv.execute(p0$iv);
                    if (this.$affectedProjects == null || this.$affectedProjects.contains(this.$project.getPath())) {
                        publisher = Publisher.Companion.interProjectPublisher(this.$project, SgpArtifact.SKIPPY_DETEKT.INSTANCE);
                    } else {
                        log = "SlackDetekt: Skipping " + this.$project.getPath() + ":detekt because it is not affected.";
                        if (this.$slackProperties.getDebug()) {
                            this.$project.getLogger().lifecycle(log);
                        } else {
                            this.$project.getLogger().debug(log);
                        }
                        SkippyArtifacts.INSTANCE.publishSkippedTask(this.$project, "detekt");
                        publisher = null;
                    }
                    Publisher<SgpArtifact> publisher2 = publisher;
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
                    log = taskContainer;
                    Function1 action$iv2 = (Function1)new Function1<Detekt, Unit>(this.$jvmTarget){
                        final /* synthetic */ String $jvmTarget;
                        {
                            this.$jvmTarget = $jvmTarget;
                            super(1);
                        }

                        public final void invoke(@NotNull Detekt $this$configureEach) {
                            Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                            $this$configureEach.setJvmTarget(this.$jvmTarget);
                            String[] stringArray = new String[]{"**/build/**"};
                            $this$configureEach.exclude(stringArray);
                            $this$configureEach.getJdkHome().set(PropertyUtil.sneakyNull$default(null, 1, null));
                        }
                    };
                    boolean $i$f$configureEach = false;
                    $this$configureEach$iv.withType(Detekt.class).configureEach(new Action(action$iv2){
                        private final /* synthetic */ Function1 function;
                        {
                            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                            this.function = function;
                        }

                        public final /* synthetic */ void execute(Object p0) {
                            this.function.invoke(p0);
                        }
                    });
                    TaskContainer taskContainer2 = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
                    $this$configureEach$iv = taskContainer2;
                    action$iv2 = (Function1)new Function1<DetektCreateBaselineTask, Unit>(this.$jvmTarget){
                        final /* synthetic */ String $jvmTarget;
                        {
                            this.$jvmTarget = $jvmTarget;
                            super(1);
                        }

                        public final void invoke(@NotNull DetektCreateBaselineTask $this$configureEach) {
                            Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                            $this$configureEach.setJvmTarget(this.$jvmTarget);
                            String[] stringArray = new String[]{"**/build/**"};
                            $this$configureEach.exclude(stringArray);
                            $this$configureEach.getJdkHome().set(PropertyUtil.sneakyNull$default(null, 1, null));
                        }
                    };
                    $i$f$configureEach = false;
                    $this$configureEach$iv.withType(DetektCreateBaselineTask.class).configureEach(new /* invalid duplicate definition of identical inner class */);
                    Spec taskSpec2 = this.$slackProperties.getEnableFullDetekt() ? (Spec)configureSubProject.taskSpec.1.INSTANCE : (Spec)configureSubProject.taskSpec.2.INSTANCE;
                    TaskCollection taskCollection = this.$project.getTasks().withType(Detekt.class).matching(taskSpec2);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"matching(...)");
                    TaskCollection matchingTasks = taskCollection;
                    TaskProvider ciDetekt2 = SimpleFileProducerTask.Companion.registerOrConfigure$default(SimpleFileProducerTask.Companion, this.$project, "ciDetekt", "Lifecycle task to run detekt for " + this.$project.getPath() + ".", null, null, "verification", new Action((TaskCollection<Detekt>)matchingTasks){
                        final /* synthetic */ TaskCollection<Detekt> $matchingTasks;
                        {
                            this.$matchingTasks = $matchingTasks;
                        }

                        public final void execute(@NotNull SimpleFileProducerTask $this$registerOrConfigure) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$registerOrConfigure), (String)"$this$registerOrConfigure");
                            Object[] objectArray = new Object[]{this.$matchingTasks};
                            $this$registerOrConfigure.dependsOn(objectArray);
                        }
                    }, 24, null);
                    Publisher<SgpArtifact> publisher3 = publisher2;
                    if (publisher3 == null) break block4;
                    FileTasksKt.publish(publisher3, (TaskProvider<SimpleFileProducerTask>)ciDetekt2);
                }
            }
        });
    }
}

