/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.lint;

import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.dsl.Lint;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestPlugin;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.LintModelWriterTask;
import com.android.build.gradle.internal.lint.SourceProviderInput;
import com.android.build.gradle.internal.lint.VariantInputs;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.ExtensionFunctionType;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.tooling.core.ClosureKt;
import slack.gradle.SlackGradleUtilKt;
import slack.gradle.SlackProperties;
import slack.gradle.artifacts.Publisher;
import slack.gradle.artifacts.Resolver;
import slack.gradle.artifacts.SgpArtifact;
import slack.gradle.avoidance.SkippyArtifacts;
import slack.gradle.lint.LintTasks;
import slack.gradle.tasks.FileTasksKt;
import slack.gradle.tasks.SimpleFileProducerTask;
import slack.gradle.tasks.SimpleFilesConsumerTask;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ@\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0011J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J\f\u0010\u0017\u001a\u00020\b*\u00020\nH\u0002J\f\u0010\u0018\u001a\u00020\b*\u00020\nH\u0002J>\u0010\u0019\u001a\u00020\b*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0011H\u0002J`\u0010\u001a\u001a\u00020\b*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00112\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J>\u0010 \u001a\u00020\b*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0011H\u0002J\u0014\u0010!\u001a\u00020\b*\u00020\n2\u0006\u0010\"\u001a\u00020\u0004H\u0002J%\u0010#\u001a\u00020\b*\u00020$2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\b0&\u00a2\u0006\u0002\b'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lslack/gradle/lint/LintTasks;", "", "()V", "CI_LINT_TASK_NAME", "", "GLOBAL_CI_LINT_TASK_NAME", "LOG", "configureRootProject", "", "project", "Lorg/gradle/api/Project;", "configureSubProject", "slackProperties", "Lslack/gradle/SlackProperties;", "affectedProjects", "", "onProjectSkipped", "Lkotlin/Function2;", "createCiLintTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lslack/gradle/tasks/SimpleFileProducerTask;", "action", "Lorg/gradle/api/Action;", "addSourceSetsForAndroidMultiplatformAfterEvaluate", "addSourceSetsForMultiplatformAfterEvaluate", "configureAndroidProjectForLint", "configureLint", "lint", "Lcom/android/build/api/dsl/Lint;", "ciLint", "androidSdkVersions", "Lslack/gradle/SlackProperties$AndroidSdkProperties;", "configureNonAndroidProjectForLint", "log", "message", "withChangesAllowed", "Lorg/gradle/api/file/ConfigurableFileCollection;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nLintTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintTasks.kt\nslack/gradle/lint/LintTasks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 GradleExt.kt\nslack/gradle/GradleExtKt\n+ 5 closure.kt\norg/jetbrains/kotlin/tooling/core/ClosureKt\n*L\n1#1,457:1\n1549#2:458\n1620#2,3:459\n1549#2:462\n1620#2,3:463\n1855#2:466\n1603#2,9:467\n1855#2:476\n1856#2:478\n1612#2:479\n1855#2,2:480\n1856#2:482\n1855#2:484\n1603#2,9:485\n1855#2:494\n1856#2:496\n1612#2:497\n1360#2:498\n1446#2,5:499\n1360#2:504\n1446#2,5:505\n1855#2,2:510\n1856#2:512\n1855#2,2:526\n1855#2,2:539\n1#3:477\n1#3:495\n180#4:483\n42#5,5:513\n151#5,2:518\n47#5:520\n157#5:521\n144#5,3:522\n158#5:525\n159#5:528\n49#5,10:529\n*S KotlinDebug\n*F\n+ 1 LintTasks.kt\nslack/gradle/lint/LintTasks\n*L\n356#1:458\n356#1:459,3\n357#1:462\n357#1:463,3\n358#1:466\n362#1:467,9\n362#1:476\n362#1:478\n362#1:479\n363#1:480,2\n358#1:482\n369#1:484\n373#1:485,9\n373#1:494\n373#1:496\n373#1:497\n374#1:498\n374#1:499,5\n375#1:504\n375#1:505,5\n376#1:510,2\n369#1:512\n400#1:526,2\n408#1:539,2\n362#1:477\n373#1:495\n368#1:483\n400#1:513,5\n400#1:518,2\n400#1:520\n400#1:521\n400#1:522,3\n400#1:525\n400#1:528\n400#1:529,10\n*E\n"})
public final class LintTasks {
    @NotNull
    public static final LintTasks INSTANCE = new LintTasks();
    @NotNull
    private static final String GLOBAL_CI_LINT_TASK_NAME = "globalCiLint";
    @NotNull
    private static final String CI_LINT_TASK_NAME = "ciLint";
    @NotNull
    private static final String LOG = "SlackLints:";

    private LintTasks() {
    }

    private final void log(Project $this$log, String message) {
        $this$log.getLogger().debug("SlackLints: " + message);
    }

    public final void configureRootProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Resolver resolver = Resolver.Companion.interProjectResolver$default(Resolver.Companion, project, SgpArtifact.SKIPPY_LINT.INSTANCE, false, 4, null);
        SimpleFilesConsumerTask.Companion.registerOrConfigure$default(SimpleFilesConsumerTask.Companion, project, GLOBAL_CI_LINT_TASK_NAME, "Global lifecycle task to run all ciUnitTest tasks.", resolver.artifactView(), null, null, null, 112, null);
    }

    public final void configureSubProject(@NotNull Project project, @NotNull SlackProperties slackProperties, @Nullable Set<String> affectedProjects, @NotNull Function2<? super String, ? super String, Unit> onProjectSkipped) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)slackProperties, (String)"slackProperties");
        Intrinsics.checkNotNullParameter(onProjectSkipped, (String)"onProjectSkipped");
        this.log(project, "Configuring lint tasks for project " + project.getPath());
        boolean enabled = slackProperties.getCiLintEnabled();
        if (!enabled) {
            this.log(project, "Skipping creation of \"ciLint\" task");
            return;
        }
        Action projectAllAction2 = new Action(project, slackProperties, affectedProjects, onProjectSkipped){
            final /* synthetic */ Project $project;
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ Set<String> $affectedProjects;
            final /* synthetic */ Function2<String, String, Unit> $onProjectSkipped;
            {
                this.$project = $project;
                this.$slackProperties = $slackProperties;
                this.$affectedProjects = $affectedProjects;
                this.$onProjectSkipped = $onProjectSkipped;
            }

            public final void execute(@NotNull Plugin<?> $this$Action) {
                Intrinsics.checkNotNullParameter($this$Action, (String)"$this$Action");
                Plugin<?> plugin = $this$Action;
                if (plugin instanceof AppPlugin ? true : plugin instanceof LibraryPlugin) {
                    LintTasks.access$configureAndroidProjectForLint(LintTasks.INSTANCE, this.$project, this.$slackProperties, this.$affectedProjects, this.$onProjectSkipped);
                } else if (plugin instanceof TestPlugin) {
                    if (this.$slackProperties.getEnableLintInAndroidTestProjects()) {
                        LintTasks.access$configureAndroidProjectForLint(LintTasks.INSTANCE, this.$project, this.$slackProperties, this.$affectedProjects, this.$onProjectSkipped);
                    }
                } else if (plugin instanceof JavaPlugin) {
                    if (SlackGradleUtilKt.getMultiplatformExtension(this.$project) == null) {
                        LintTasks.access$configureNonAndroidProjectForLint(LintTasks.INSTANCE, this.$project, this.$slackProperties, this.$affectedProjects, this.$onProjectSkipped);
                    }
                } else if (plugin instanceof KotlinBasePlugin && SlackGradleUtilKt.getMultiplatformExtension(this.$project) != null && !this.$project.getPlugins().hasPlugin(AppPlugin.class) && !this.$project.getPlugins().hasPlugin(LibraryPlugin.class)) {
                    LintTasks.access$configureNonAndroidProjectForLint(LintTasks.INSTANCE, this.$project, this.$slackProperties, this.$affectedProjects, this.$onProjectSkipped);
                }
            }
        };
        project.getPlugins().all(projectAllAction2);
    }

    private final void configureAndroidProjectForLint(Project $this$configureAndroidProjectForLint, SlackProperties slackProperties, Set<String> affectedProjects, Function2<? super String, ? super String, Unit> onProjectSkipped) {
        SlackGradleUtilKt.getAndroidExtension($this$configureAndroidProjectForLint).finalizeDsl(new Function1<CommonExtension<?, ?, ?, ?, ?>, Unit>($this$configureAndroidProjectForLint, slackProperties, affectedProjects, onProjectSkipped){
            final /* synthetic */ Project $this_configureAndroidProjectForLint;
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ Set<String> $affectedProjects;
            final /* synthetic */ Function2<String, String, Unit> $onProjectSkipped;
            {
                this.$this_configureAndroidProjectForLint = $receiver;
                this.$slackProperties = $slackProperties;
                this.$affectedProjects = $affectedProjects;
                this.$onProjectSkipped = $onProjectSkipped;
                super(1);
            }

            public final void invoke(@NotNull CommonExtension<?, ?, ?, ?, ?> extension) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                LintTasks.access$log(LintTasks.INSTANCE, this.$this_configureAndroidProjectForLint, "Applying ciLint to Android project");
                LintTasks.access$log(LintTasks.INSTANCE, this.$this_configureAndroidProjectForLint, "Configuring android lint tasks. isApp=" + (extension instanceof ApplicationAndroidComponentsExtension));
                LintTasks.access$log(LintTasks.INSTANCE, this.$this_configureAndroidProjectForLint, "Creating ciLint task");
                Project project = this.$this_configureAndroidProjectForLint.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                TaskProvider ciLintTask = LintTasks.createCiLintTask$default(LintTasks.INSTANCE, project, null, 2, null);
                String ciLintVariants = this.$slackProperties.getCiLintVariants();
                if (ciLintVariants != null) {
                    ciLintTask.configure(new Action(ciLintVariants){
                        final /* synthetic */ String $ciLintVariants;
                        {
                            this.$ciLintVariants = $ciLintVariants;
                        }

                        public final void execute(@NotNull SimpleFileProducerTask $this$configure) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), (String)"$this$configure");
                            char[] cArray = new char[]{','};
                            Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)this.$ciLintVariants, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                String variant = (String)element$iv;
                                boolean bl = false;
                                $this$configure.getLogger().debug("Using variant " + variant + " for ciLint task");
                                String lintTaskName = "lint" + SlackGradleUtilKt.capitalizeUS(variant);
                                Object[] objectArray = new Object[]{lintTaskName};
                                $this$configure.dependsOn(objectArray);
                            }
                        }
                    });
                } else {
                    AndroidComponentsExtension.onVariants$default(SlackGradleUtilKt.getAndroidExtension(this.$this_configureAndroidProjectForLint), null, (Function1)((Function1)new Function1<Variant, Unit>(this.$this_configureAndroidProjectForLint, (TaskProvider<SimpleFileProducerTask>)ciLintTask){
                        final /* synthetic */ Project $this_configureAndroidProjectForLint;
                        final /* synthetic */ TaskProvider<SimpleFileProducerTask> $ciLintTask;
                        {
                            this.$this_configureAndroidProjectForLint = $receiver;
                            this.$ciLintTask = $ciLintTask;
                            super(1);
                        }

                        public final void invoke(@NotNull Variant variant) {
                            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                            String lintTaskName = "lint" + SlackGradleUtilKt.capitalizeUS(variant.getName());
                            LintTasks.access$log(LintTasks.INSTANCE, this.$this_configureAndroidProjectForLint, "Adding " + lintTaskName + " to ciLint task");
                            this.$ciLintTask.configure(new Action(lintTaskName){
                                final /* synthetic */ String $lintTaskName;
                                {
                                    this.$lintTaskName = $lintTaskName;
                                }

                                public final void execute(@NotNull SimpleFileProducerTask $this$configure) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)$this$configure), (String)"$this$configure");
                                    Object[] objectArray = new Object[]{this.$lintTaskName};
                                    $this$configure.dependsOn(objectArray);
                                }
                            });
                        }
                    }), (int)1, null);
                }
                LintTasks.access$configureLint(LintTasks.INSTANCE, this.$this_configureAndroidProjectForLint, extension.getLint(), ciLintTask, this.$slackProperties, this.$affectedProjects, this.$onProjectSkipped, this.$slackProperties.requireAndroidSdkProperties$slack_plugin());
            }
        });
    }

    private final void configureNonAndroidProjectForLint(Project $this$configureNonAndroidProjectForLint, SlackProperties slackProperties, Set<String> affectedProjects, Function2<? super String, ? super String, Unit> onProjectSkipped) {
        $this$configureNonAndroidProjectForLint.afterEvaluate(new Action(slackProperties, affectedProjects, onProjectSkipped){
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ Set<String> $affectedProjects;
            final /* synthetic */ Function2<String, String, Unit> $onProjectSkipped;
            {
                this.$slackProperties = $slackProperties;
                this.$affectedProjects = $affectedProjects;
                this.$onProjectSkipped = $onProjectSkipped;
            }

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                LintTasks.access$addSourceSetsForMultiplatformAfterEvaluate(LintTasks.INSTANCE, $this$afterEvaluate);
                $this$afterEvaluate.getPluginManager().apply("com.android.lint");
                TaskProvider taskProvider = $this$afterEvaluate.getTasks().named("lint");
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"named(...)");
                TaskProvider lintTask = taskProvider;
                $this$afterEvaluate.getTasks().register("lintDebug", new Action((TaskProvider<Task>)lintTask){
                    final /* synthetic */ TaskProvider<Task> $lintTask;
                    {
                        this.$lintTask = $lintTask;
                    }

                    public final void execute(@NotNull Task $this$register) {
                        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                        Object[] objectArray = new Object[]{this.$lintTask};
                        $this$register.dependsOn(objectArray);
                        $this$register.setEnabled(false);
                    }
                });
                $this$afterEvaluate.getTasks().register("lintRelease", new Action((TaskProvider<Task>)lintTask){
                    final /* synthetic */ TaskProvider<Task> $lintTask;
                    {
                        this.$lintTask = $lintTask;
                    }

                    public final void execute(@NotNull Task $this$register) {
                        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                        Object[] objectArray = new Object[]{this.$lintTask};
                        $this$register.dependsOn(objectArray);
                        $this$register.setEnabled(false);
                    }
                });
                LintTasks.access$log(LintTasks.INSTANCE, $this$afterEvaluate, "Creating ciLint task");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                TaskProvider ciLint2 = LintTasks.access$createCiLintTask(LintTasks.INSTANCE, project, new Action((TaskProvider<Task>)lintTask){
                    final /* synthetic */ TaskProvider<Task> $lintTask;
                    {
                        this.$lintTask = $lintTask;
                    }

                    public final void execute(@NotNull SimpleFileProducerTask $this$createCiLintTask) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$createCiLintTask), (String)"$this$createCiLintTask");
                        Object[] objectArray = new Object[]{this.$lintTask};
                        $this$createCiLintTask.dependsOn(objectArray);
                    }
                });
                ExtensionContainer extensionContainer = $this$afterEvaluate.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
                ExtensionContainer $this$getByType$iv = extensionContainer;
                boolean $i$f$getByType = false;
                LintTasks.configureLint$default(LintTasks.INSTANCE, $this$afterEvaluate, (Lint)$this$getByType$iv.getByType(TypeOf.typeOf((Type)TypesJVMKt.getJavaType((KType)Reflection.typeOf(Lint.class)))), ciLint2, this.$slackProperties, this.$affectedProjects, this.$onProjectSkipped, null, 32, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void configureLint(Project $this$configureLint, Lint lint, TaskProvider<SimpleFileProducerTask> ciLint2, SlackProperties slackProperties, Set<String> affectedProjects, Function2<? super String, ? super String, Unit> onProjectSkipped, SlackProperties.AndroidSdkProperties androidSdkVersions) {
        File file;
        Lint lint2;
        boolean isMultiplatform = SlackGradleUtilKt.getMultiplatformExtension($this$configureLint) != null;
        slackProperties.getVersions$slack_plugin().getBundles().getCommonLint().ifPresent(new Consumer($this$configureLint){
            final /* synthetic */ Project $this_configureLint;
            {
                this.$this_configureLint = $receiver;
            }

            public final void accept(@NotNull Provider<ExternalModuleDependencyBundle> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$this_configureLint.getDependencies().add("lintChecks", it);
            }
        });
        if (affectedProjects != null && !affectedProjects.contains($this$configureLint.getPath())) {
            String taskPath = $this$configureLint.getPath() + ":ciLint";
            String log = "Skipping " + taskPath + " because it is not affected.";
            onProjectSkipped.invoke((Object)GLOBAL_CI_LINT_TASK_NAME, (Object)taskPath);
            if (slackProperties.getDebug()) {
                this.log($this$configureLint, log);
            } else {
                this.log($this$configureLint, log);
            }
            Project project = $this$configureLint.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            SkippyArtifacts.INSTANCE.publishSkippedTask(project, CI_LINT_TASK_NAME);
        } else {
            Project project = $this$configureLint.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Publisher<SgpArtifact> publisher = Publisher.Companion.interProjectPublisher(project, SgpArtifact.SKIPPY_LINT.INSTANCE);
            FileTasksKt.publish(publisher, ciLint2);
        }
        $this$configureLint.afterEvaluate((Action)configureLint.2.INSTANCE);
        Lint $this$configureLint_u24lambda_u242 = lint2 = lint;
        boolean bl = false;
        $this$configureLint_u24lambda_u242.setIgnoreWarnings(slackProperties.getLintErrorsOnly());
        $this$configureLint_u24lambda_u242.setIgnoreTestSources(slackProperties.getLintIgnoreTestSources());
        $this$configureLint_u24lambda_u242.setCheckTestSources(slackProperties.getLintCheckTestSources());
        $this$configureLint_u24lambda_u242.setTextReport(true);
        $this$configureLint_u24lambda_u242.setXmlReport(true);
        $this$configureLint_u24lambda_u242.setHtmlReport(true);
        $this$configureLint_u24lambda_u242.setSarifReport(true);
        $this$configureLint_u24lambda_u242.setExplainIssues(true);
        $this$configureLint_u24lambda_u242.setNoLines(false);
        $this$configureLint_u24lambda_u242.setQuiet(true);
        $this$configureLint_u24lambda_u242.setCheckReleaseBuilds(false);
        $this$configureLint_u24lambda_u242.setCheckDependencies(false);
        if (!slackProperties.isTestLibrary()) {
            ((Collection)$this$configureLint_u24lambda_u242.getFatal()).add("VisibleForTests");
        }
        if (isMultiplatform) {
            ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("LintError");
        }
        ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("KtxExtensionAvailable");
        ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("GradleDependency");
        ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("ObsoleteLintCustomCheck");
        ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("StopShip");
        ((Collection)$this$configureLint_u24lambda_u242.getFatal()).add("Assert");
        ((Collection)$this$configureLint_u24lambda_u242.getFatal()).add("NewApi");
        ((Collection)$this$configureLint_u24lambda_u242.getFatal()).add("ObsoleteSdkInt");
        ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("SyntheticAccessor");
        ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("EnsureInitializerMetadata");
        if (SlackGradleUtilKt.getAndroidExtensionNullable($this$configureLint) instanceof ApplicationAndroidComponentsExtension) {
            $this$configureLint_u24lambda_u242.setCheckDependencies(true);
        }
        SlackProperties.AndroidSdkProperties androidSdkProperties = androidSdkVersions;
        if (androidSdkProperties != null) {
            SlackProperties.AndroidSdkProperties sdkVersions2 = androidSdkProperties;
            boolean bl2 = false;
            if (sdkVersions2.getMinSdk() >= 28) {
                ((Collection)$this$configureLint_u24lambda_u242.getDisable()).add("Instantiatable");
            }
        }
        $this$configureLint_u24lambda_u242.setLintConfig($this$configureLint.getRootProject().getLayout().getProjectDirectory().file("config/lint/lint.xml").getAsFile());
        Lint lint3 = $this$configureLint_u24lambda_u242;
        String string = slackProperties.getLintBaselineFileName();
        if (string != null) {
            void it;
            String bl2 = string;
            Lint lint4 = lint3;
            boolean bl3 = false;
            file = $this$configureLint.getProject().getLayout().getProjectDirectory().file((String)it).getAsFile();
            lint3 = lint4;
        } else {
            file = null;
        }
        lint3.setBaseline(file);
    }

    static /* synthetic */ void configureLint$default(LintTasks lintTasks, Project project, Lint lint, TaskProvider taskProvider, SlackProperties slackProperties, Set set, Function2 function2, SlackProperties.AndroidSdkProperties androidSdkProperties, int n, Object object) {
        if ((n & 0x20) != 0) {
            androidSdkProperties = null;
        }
        lintTasks.configureLint(project, lint, (TaskProvider<SimpleFileProducerTask>)taskProvider, slackProperties, set, (Function2<? super String, ? super String, Unit>)function2, androidSdkProperties);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSourceSetsForMultiplatformAfterEvaluate(Project $this$addSourceSetsForMultiplatformAfterEvaluate) {
        Object element$iv;
        Iterator $this$mapTo$iv$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        KotlinMultiplatformExtension kotlinMultiplatformExtension = SlackGradleUtilKt.getMultiplatformExtension($this$addSourceSetsForMultiplatformAfterEvaluate);
        if (kotlinMultiplatformExtension == null || (kotlinMultiplatformExtension = kotlinMultiplatformExtension.getTargets()) == null) {
            return;
        }
        KotlinMultiplatformExtension kmpTargets = kotlinMultiplatformExtension;
        Iterable $this$map$iv = (Iterable)kmpTargets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            KotlinTarget kotlinTarget = (KotlinTarget)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getApiElementsConfigurationName());
        }
        List kmpApiElements = (List)destination$iv$iv;
        Object[] $this$map$iv2 = (Object[])kmpTargets;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        item$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            void it;
            Object item$iv$iv3 = item$iv$iv2.next();
            KotlinTarget bl = (KotlinTarget)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getRuntimeElementsConfigurationName());
        }
        List kmpRuntimeElements = (List)destination$iv$iv2;
        $this$map$iv2 = new Pair[]{TuplesKt.to((Object)kmpRuntimeElements, (Object)"runtimeElements"), TuplesKt.to((Object)kmpApiElements, (Object)"apiElements")};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])$this$map$iv2);
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            void $this$forEach$iv2;
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Pair $i$f$mapTo22 = (Pair)element$iv2;
            boolean bl = false;
            List kmpConfigNames = (List)$i$f$mapTo22.component1();
            String targetConfigName = (String)$i$f$mapTo22.component2();
            Object bl2 = $this$addSourceSetsForMultiplatformAfterEvaluate.getConfigurations().maybeCreate(targetConfigName);
            Configuration $this$addSourceSetsForMultiplatformAfterEvaluate_u24lambda_u248_u24lambda_u247 = (Configuration)bl2;
            boolean bl3 = false;
            Iterable iterable2 = kmpConfigNames;
            boolean $i$f$mapNotNull = false;
            void var18_40 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach22 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                Configuration it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv;
                boolean bl4 = false;
                String configName = (String)element$iv$iv;
                boolean bl5 = false;
                if ((Configuration)$this$addSourceSetsForMultiplatformAfterEvaluate.getConfigurations().findByName(configName) == null) continue;
                boolean bl6 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach3 = false;
            $this$mapNotNullTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$mapNotNullTo$iv$iv.hasNext()) {
                element$iv = $this$mapNotNullTo$iv$iv.next();
                Configuration config = (Configuration)element$iv;
                boolean bl7 = false;
                Configuration[] $i$f$forEach22 = new Configuration[]{config};
                $this$addSourceSetsForMultiplatformAfterEvaluate_u24lambda_u248_u24lambda_u247.extendsFrom($i$f$forEach22);
            }
        }
        Object[] objectArray = $this$addSourceSetsForMultiplatformAfterEvaluate.getProject().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
        Object[] $this$getByType$iv = objectArray;
        boolean $i$f$getByType = false;
        JavaPluginExtension javaExtension = (JavaPluginExtension)$this$getByType$iv.getByType(TypeOf.typeOf((Type)TypesJVMKt.getJavaType((KType)Reflection.typeOf(JavaPluginExtension.class))));
        $this$getByType$iv = new Pair[]{TuplesKt.to((Object)"main", (Object)"main"), TuplesKt.to((Object)"test", (Object)"test")};
        Iterable $this$forEach$iv3 = CollectionsKt.listOf((Object[])$this$getByType$iv);
        boolean $i$f$forEach4 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            void $this$forEach$iv4;
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object element$iv$iv$iv;
            Pair pair = (Pair)element$iv3;
            boolean bl = false;
            String kmpCompilationName = (String)pair.component1();
            String targetSourceSetName = (String)pair.component2();
            Object object = javaExtension.getSourceSets().maybeCreate(targetSourceSetName);
            SourceSet $this$addSourceSetsForMultiplatformAfterEvaluate_u24lambda_u2414_u24lambda_u2413 = (SourceSet)object;
            boolean bl8 = false;
            Iterable $i$f$forEach3 = (Iterable)kmpTargets;
            boolean $i$f$mapNotNull = false;
            element$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach5 = false;
            element$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv$iv.hasNext()) {
                KotlinCompilation it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
                boolean bl9 = false;
                KotlinTarget target = (KotlinTarget)element$iv$iv;
                boolean bl10 = false;
                if ((KotlinCompilation)target.getCompilations().findByName(kmpCompilationName) == null) continue;
                boolean bl11 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv4;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinCompilation compilation = (KotlinCompilation)element$iv$iv;
                boolean bl12 = false;
                list$iv$iv = compilation.getKotlinSourceSets();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv4;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv4 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinSourceSet sourceSet = (KotlinSourceSet)element$iv$iv;
                boolean bl13 = false;
                Set set = sourceSet.getKotlin().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
                list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv4;
            boolean $i$f$forEach6 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                File srcDirs = (File)element$iv4;
                boolean bl14 = false;
                Set set = $this$addSourceSetsForMultiplatformAfterEvaluate_u24lambda_u2414_u24lambda_u2413.getJava().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
                ((Collection)set).add(srcDirs);
            }
        }
    }

    private final void addSourceSetsForAndroidMultiplatformAfterEvaluate(Project $this$addSourceSetsForAndroidMultiplatformAfterEvaluate) {
        Set set;
        block7: {
            List list;
            boolean bl;
            KotlinSourceSet p0;
            KotlinSourceSet $this$withClosure$iv;
            block8: {
                Iterable initialEdges$iv;
                block5: {
                    block6: {
                        KotlinSourceSet androidMain;
                        KotlinMultiplatformExtension kotlinMultiplatformExtension = SlackGradleUtilKt.getMultiplatformExtension($this$addSourceSetsForAndroidMultiplatformAfterEvaluate);
                        if (kotlinMultiplatformExtension == null) {
                            return;
                        }
                        KotlinMultiplatformExtension multiplatformExtension = kotlinMultiplatformExtension;
                        if ((KotlinTarget)multiplatformExtension.getTargets().findByName("android") == null) {
                            return;
                        }
                        KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)multiplatformExtension.getSourceSets().findByName("androidMain");
                        if (kotlinSourceSet == null) {
                            throw new GradleException("Failed to find source set with name 'androidMain'");
                        }
                        $this$withClosure$iv = androidMain = kotlinSourceSet;
                        boolean $i$f$withClosure = false;
                        p0 = $this$withClosure$iv;
                        bl = false;
                        initialEdges$iv = p0.getDependsOn();
                        if (!(initialEdges$iv instanceof Collection)) break block5;
                        if (!((Collection)initialEdges$iv).isEmpty()) break block6;
                        set = SetsKt.setOf((Object)$this$withClosure$iv);
                        break block7;
                    }
                    Collection elements$iv$iv = (Collection)initialEdges$iv;
                    boolean $i$f$createDequeue = false;
                    list = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(elements$iv$iv) : (List)new ArrayList(elements$iv$iv);
                    break block8;
                }
                boolean $i$f$createDequeueFromIterable = false;
                int initialSize$iv$iv$iv = 16;
                boolean $i$f$createDequeue = false;
                List $this$createDequeueFromIterable_u24lambda_u242$iv$iv = initialSize$iv$iv$iv = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(initialSize$iv$iv$iv) : (List)new ArrayList(initialSize$iv$iv$iv);
                boolean bl2 = false;
                Iterable $this$forEach$iv$iv$iv = initialEdges$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    $this$createDequeueFromIterable_u24lambda_u242$iv$iv.add(element$iv$iv);
                }
                list = initialSize$iv$iv$iv;
            }
            List dequeue$iv = list;
            Set results$iv = ClosureKt.createResultSet((int)dequeue$iv.size());
            results$iv.add($this$withClosure$iv);
            while (!((Collection)dequeue$iv).isEmpty()) {
                Object element$iv = dequeue$iv.remove(0);
                if (!results$iv.add(element$iv)) continue;
                p0 = (KotlinSourceSet)element$iv;
                Collection collection = dequeue$iv;
                bl = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)p0.getDependsOn());
            }
            set = results$iv;
        }
        Set dependencySourceSets = set;
        $this$addSourceSetsForAndroidMultiplatformAfterEvaluate.getTasks().withType(AndroidLintAnalysisTask.class).configureEach(new Action(dependencySourceSets){
            final /* synthetic */ Set<KotlinSourceSet> $dependencySourceSets;
            {
                this.$dependencySourceSets = $dependencySourceSets;
            }

            public final void execute(@NotNull AndroidLintAnalysisTask $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                LintTasks.access$addSourceSetsForAndroidMultiplatformAfterEvaluate$addSourceSets($this$configureEach.getVariantInputs(), this.$dependencySourceSets);
            }
        });
        $this$addSourceSetsForAndroidMultiplatformAfterEvaluate.getTasks().withType(LintModelWriterTask.class).configureEach(new Action(dependencySourceSets){
            final /* synthetic */ Set<KotlinSourceSet> $dependencySourceSets;
            {
                this.$dependencySourceSets = $dependencySourceSets;
            }

            public final void execute(@NotNull LintModelWriterTask $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                LintTasks.access$addSourceSetsForAndroidMultiplatformAfterEvaluate$addSourceSets($this$configureEach.getVariantInputs(), this.$dependencySourceSets);
            }
        });
    }

    private final void withChangesAllowed(ConfigurableFileCollection $this$withChangesAllowed, @ExtensionFunctionType Function1<? super ConfigurableFileCollection, Unit> block) {
        Field disallowChanges = $this$withChangesAllowed.getClass().getDeclaredField("disallowChanges");
        disallowChanges.setAccessible(true);
        disallowChanges.set($this$withChangesAllowed, false);
        block.invoke((Object)$this$withChangesAllowed);
        disallowChanges.set($this$withChangesAllowed, true);
    }

    private final TaskProvider<SimpleFileProducerTask> createCiLintTask(Project project, Action<SimpleFileProducerTask> action) {
        project.getLogger().debug("Creating ciLint task: " + project.getPath() + ":ciLint");
        TaskProvider task2 = SimpleFileProducerTask.Companion.registerOrConfigure$default(SimpleFileProducerTask.Companion, project, CI_LINT_TASK_NAME, "Lifecycle task to run all lint tasks on this project.", null, null, "verification", action, 24, null);
        return task2;
    }

    static /* synthetic */ TaskProvider createCiLintTask$default(LintTasks lintTasks, Project project, Action action, int n, Object object) {
        if ((n & 2) != 0) {
            action = createCiLintTask.1.INSTANCE;
        }
        return lintTasks.createCiLintTask(project, (Action<SimpleFileProducerTask>)action);
    }

    private static final void addSourceSetsForAndroidMultiplatformAfterEvaluate$addSourceSets(VariantInputs $this$addSourceSetsForAndroidMultiplatformAfterEvaluate_u24addSourceSets, Set<? extends KotlinSourceSet> dependencySourceSets) {
        Object object = $this$addSourceSetsForAndroidMultiplatformAfterEvaluate_u24addSourceSets.getSourceProviders().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        SourceProviderInput sourceProviderInput = (SourceProviderInput)CollectionsKt.firstOrNull((List)((List)object));
        if (sourceProviderInput == null) {
            return;
        }
        SourceProviderInput sourceProvider = sourceProviderInput;
        Iterable $this$forEach$iv = dependencySourceSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinSourceSet sourceSet = (KotlinSourceSet)element$iv;
            boolean bl = false;
            INSTANCE.withChangesAllowed(sourceProvider.getJavaDirectories(), (Function1<? super ConfigurableFileCollection, Unit>)((Function1)new Function1<ConfigurableFileCollection, Unit>(sourceSet){
                final /* synthetic */ KotlinSourceSet $sourceSet;
                {
                    this.$sourceSet = $sourceSet;
                    super(1);
                }

                public final void invoke(@NotNull ConfigurableFileCollection $this$withChangesAllowed) {
                    Intrinsics.checkNotNullParameter((Object)$this$withChangesAllowed, (String)"$this$withChangesAllowed");
                    Object[] objectArray = new Object[]{this.$sourceSet.getKotlin().getSourceDirectories()};
                    $this$withChangesAllowed.from(objectArray);
                }
            }));
        }
    }

    public static final /* synthetic */ void access$configureAndroidProjectForLint(LintTasks $this, Project $receiver, SlackProperties slackProperties, Set affectedProjects, Function2 onProjectSkipped) {
        $this.configureAndroidProjectForLint($receiver, slackProperties, affectedProjects, (Function2<? super String, ? super String, Unit>)onProjectSkipped);
    }

    public static final /* synthetic */ void access$configureNonAndroidProjectForLint(LintTasks $this, Project $receiver, SlackProperties slackProperties, Set affectedProjects, Function2 onProjectSkipped) {
        $this.configureNonAndroidProjectForLint($receiver, slackProperties, affectedProjects, (Function2<? super String, ? super String, Unit>)onProjectSkipped);
    }

    public static final /* synthetic */ void access$log(LintTasks $this, Project $receiver, String message) {
        $this.log($receiver, message);
    }

    public static final /* synthetic */ void access$configureLint(LintTasks $this, Project $receiver, Lint lint, TaskProvider ciLint2, SlackProperties slackProperties, Set affectedProjects, Function2 onProjectSkipped, SlackProperties.AndroidSdkProperties androidSdkVersions) {
        $this.configureLint($receiver, lint, (TaskProvider<SimpleFileProducerTask>)ciLint2, slackProperties, affectedProjects, (Function2<? super String, ? super String, Unit>)onProjectSkipped, androidSdkVersions);
    }

    public static final /* synthetic */ void access$addSourceSetsForMultiplatformAfterEvaluate(LintTasks $this, Project $receiver) {
        $this.addSourceSetsForMultiplatformAfterEvaluate($receiver);
    }

    public static final /* synthetic */ TaskProvider access$createCiLintTask(LintTasks $this, Project project, Action action) {
        return $this.createCiLintTask(project, (Action<SimpleFileProducerTask>)action);
    }

    public static final /* synthetic */ void access$addSourceSetsForAndroidMultiplatformAfterEvaluate(LintTasks $this, Project $receiver) {
        $this.addSourceSetsForAndroidMultiplatformAfterEvaluate($receiver);
    }

    public static final /* synthetic */ void access$addSourceSetsForAndroidMultiplatformAfterEvaluate$addSourceSets(VariantInputs $receiver, Set dependencySourceSets) {
        LintTasks.addSourceSetsForAndroidMultiplatformAfterEvaluate$addSourceSets($receiver, dependencySourceSets);
    }
}

