/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.tasks;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ParameterName;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.jetbrains.annotations.NotNull;
import slack.gradle.agp.VersionNumber;
import slack.gradle.tasks.BaseDownloadTaskKt;
import slack.gradle.tasks.BootstrapTask;
import slack.gradle.tasks.ProgressLoggerProgressListener;
import slack.gradle.tasks.ProgressReportingInterceptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B:\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lslack/gradle/tasks/BaseDownloadTask;", "Lorg/gradle/api/DefaultTask;", "Lslack/gradle/tasks/BootstrapTask;", "targetName", "", "addExecPrefix", "", "urlTemplate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "version", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "progressLoggerFactory", "Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;", "getProgressLoggerFactory", "()Lorg/gradle/internal/logging/progress/ProgressLoggerFactory;", "Lorg/gradle/api/provider/Property;", "getVersion", "()Lorg/gradle/api/provider/Property;", "download", "", "slack-plugin"})
public abstract class BaseDownloadTask
extends DefaultTask
implements BootstrapTask {
    @NotNull
    private final String targetName;
    private final boolean addExecPrefix;
    @NotNull
    private final Function1<@ParameterName(name="version") String, String> urlTemplate;

    public BaseDownloadTask(@NotNull String targetName, boolean addExecPrefix, @NotNull Function1<@ParameterName(name="version") ? super String, String> urlTemplate) {
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter(urlTemplate, (String)"urlTemplate");
        this.targetName = targetName;
        this.addExecPrefix = addExecPrefix;
        this.urlTemplate = urlTemplate;
    }

    public /* synthetic */ BaseDownloadTask(String string, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl, (Function1<? super String, String>)function1);
    }

    @Inject
    @NotNull
    public abstract ProgressLoggerFactory getProgressLoggerFactory();

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void download() {
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String version = (String)object;
        ProgressLogger progressLogger = this.getProgressLoggerFactory().newOperation(this.getClass());
        if (!(!VersionNumber.Companion.parse(version).equals((Object)VersionNumber.Companion.getUNKNOWN()))) {
            boolean $i$a$-check-BaseDownloadTask$download$22 = false;
            String $i$a$-check-BaseDownloadTask$download$22 = "Not a valid " + this.targetName + " version number! " + version;
            throw new IllegalStateException($i$a$-check-BaseDownloadTask$download$22.toString());
        }
        String url = (String)this.urlTemplate.invoke((Object)version);
        this.getLogger().debug("Downloading " + url);
        Request request = new Request.Builder().url(url).build();
        String fileName = StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null);
        progressLogger.start("Download " + fileName, "Starting download");
        Intrinsics.checkNotNull((Object)progressLogger);
        ProgressLoggerProgressListener progressListener = new ProgressLoggerProgressListener(fileName, progressLogger);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new ProgressReportingInterceptor(progressListener)).build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            Object object2 = this.getOutputFile().getAsFile().get();
            File $this$download_u24lambda_u244_u24lambda_u241 = (File)object2;
            boolean bl2 = false;
            if (!$this$download_u24lambda_u244_u24lambda_u241.exists()) {
                $this$download_u24lambda_u244_u24lambda_u241.createNewFile();
            } else {
                $this$download_u24lambda_u244_u24lambda_u241.delete();
            }
            Object object3 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"apply(...)");
            File destinationFile = (File)object3;
            progressLogger.progress("Writing to " + destinationFile);
            Closeable closeable2 = (Closeable)response.body().source();
            object2 = null;
            try {
                long l;
                BufferedSource source2 = (BufferedSource)closeable2;
                boolean bl3 = false;
                Closeable closeable3 = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)destinationFile, (boolean)false, (int)1, null));
                Throwable throwable2 = null;
                try {
                    BufferedSink sink = (BufferedSink)closeable3;
                    boolean bl4 = false;
                    if (this.addExecPrefix) {
                        sink.writeUtf8(BaseDownloadTaskKt.access$getEXEC_PREFIX$p());
                    }
                    l = sink.writeAll((Source)source2);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                object2 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
            }
            progressLogger.progress("Setting permissions");
            destinationFile.setExecutable(true);
            progressLogger.completed("Finished!", false);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

