/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import slack.gradle.tasks.BootstrapTaskKt;
import slack.gradle.tasks.BootstrapUtils;
import slack.gradle.util.PropertyUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J|\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lslack/gradle/tasks/BootstrapUtils;", "", "()V", "jdkOpensAndExports", "", "", "computeDaemonArgs", "Lslack/gradle/tasks/BootstrapUtils$DaemonArgs;", "isCi", "", "customMemoryMultiplier", "Lorg/gradle/api/provider/Provider;", "customCoreMultiplier", "gradleMemoryPercentage", "minGradleXmx", "", "extraJvmArgs", "garbageCollector", "diagnostic", "Lkotlin/Function1;", "", "DaemonArgs", "DaemonArgsProvider", "GradleDaemonArgs", "KotlinDaemonArgs", "slack-plugin"})
public final class BootstrapUtils {
    @NotNull
    public static final BootstrapUtils INSTANCE = new BootstrapUtils();
    @NotNull
    private static final List<String> jdkOpensAndExports;

    private BootstrapUtils() {
    }

    @NotNull
    public final DaemonArgs computeDaemonArgs(boolean isCi, @NotNull Provider<String> customMemoryMultiplier, @NotNull Provider<String> customCoreMultiplier, @NotNull Provider<String> gradleMemoryPercentage, @NotNull Provider<Integer> minGradleXmx, @NotNull Provider<List<String>> extraJvmArgs, @NotNull Provider<String> garbageCollector, @NotNull Function1<? super String, Unit> diagnostic) {
        double d;
        double memoryMultiplier;
        Intrinsics.checkNotNullParameter(customMemoryMultiplier, (String)"customMemoryMultiplier");
        Intrinsics.checkNotNullParameter(customCoreMultiplier, (String)"customCoreMultiplier");
        Intrinsics.checkNotNullParameter(gradleMemoryPercentage, (String)"gradleMemoryPercentage");
        Intrinsics.checkNotNullParameter(minGradleXmx, (String)"minGradleXmx");
        Intrinsics.checkNotNullParameter(extraJvmArgs, (String)"extraJvmArgs");
        Intrinsics.checkNotNullParameter(garbageCollector, (String)"garbageCollector");
        Intrinsics.checkNotNullParameter(diagnostic, (String)"diagnostic");
        if (customMemoryMultiplier.isPresent()) {
            Object object = customMemoryMultiplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            v1 = (double)Integer.parseInt((String)object) / 100.0;
        } else {
            v1 = memoryMultiplier = ((Number)BootstrapUtils.computeDaemonArgs$pickValue(isCi, 0.75, 0.5)).doubleValue();
        }
        if (customCoreMultiplier.isPresent()) {
            Object object = customCoreMultiplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            d = (double)Integer.parseInt((String)object) / 100.0;
        } else {
            d = ((Number)BootstrapUtils.computeDaemonArgs$pickValue(isCi, 1.0, 0.5)).doubleValue();
        }
        double coreMultiplier = d;
        HardwareAbstractionLayer hardware = new SystemInfo().getHardware();
        int memoryGb = MathKt.roundToInt((double)((double)hardware.getMemory().getTotal() / BootstrapTaskKt.access$getBYTES_PER_GB$p()));
        int cores = hardware.getProcessor().getLogicalProcessorCount();
        diagnostic.invoke((Object)("Memory: " + memoryGb + "GB"));
        diagnostic.invoke((Object)("Cores: " + cores));
        int rawXmx = BootstrapTaskKt.access$floorInt((double)memoryGb * memoryMultiplier, 1);
        int rawXms = ((Number)BootstrapUtils.computeDaemonArgs$pickValue(isCi, rawXmx, BootstrapTaskKt.access$floorInt(0.15 * (double)memoryGb, 1))).intValue();
        Object object = gradleMemoryPercentage.map((Transformer)computeDaemonArgs.gradleMemoryPercent.1.INSTANCE).getOrElse((Object)Float.valueOf(0.5f));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        float gradleMemoryPercent2 = ((Number)object).floatValue();
        float kotlinMemoryPercent = 1.0f - gradleMemoryPercent2;
        float f = (float)rawXmx * gradleMemoryPercent2;
        Object object2 = minGradleXmx.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int gradleXmx = BootstrapTaskKt.access$floorInt(f, ((Number)object2).intValue());
        int gradleXms = BootstrapTaskKt.access$floorInt((float)rawXms * gradleMemoryPercent2, 1);
        int kotlinXmx = BootstrapTaskKt.access$floorInt((float)rawXmx * kotlinMemoryPercent, 1);
        int kotlinXms = BootstrapTaskKt.access$floorInt((float)rawXms * kotlinMemoryPercent, 1);
        int maxWorkers = BootstrapTaskKt.access$floorInt((double)cores * coreMultiplier, 1);
        diagnostic.invoke((Object)("Gradle xms: " + gradleXms + "GB"));
        diagnostic.invoke((Object)("Gradle xmx: " + gradleXmx + "GB"));
        diagnostic.invoke((Object)("Kotlin Daemon xms: " + kotlinXms + "GB"));
        diagnostic.invoke((Object)("Kotlin Daemon xmx: " + kotlinXmx + "GB"));
        List gradleGcArgs = new ArrayList();
        List kotlinDaemonGcArgs = new ArrayList();
        String customGc = (String)garbageCollector.getOrNull();
        if (customGc != null && !Intrinsics.areEqual((Object)customGc, (Object)"default")) {
            Object[] objectArray = new String[]{"-XX:+" + customGc, "-XX:+UnlockExperimentalVMOptions"};
            List args = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)gradleGcArgs, (Iterable)args);
            CollectionsKt.addAll((Collection)kotlinDaemonGcArgs, (Iterable)args);
        } else {
            int simplePercent = 67;
            Object[] objectArray = new String[]{"-XX:+UseG1GC", "-XX:+UnlockExperimentalVMOptions", "-XX:G1NewSizePercent=" + simplePercent, "-XX:G1MaxNewSizePercent=" + simplePercent};
            List args = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)gradleGcArgs, (Iterable)args);
            CollectionsKt.addAll((Collection)kotlinDaemonGcArgs, (Iterable)args);
        }
        CollectionsKt.addAll((Collection)kotlinDaemonGcArgs, (Iterable)jdkOpensAndExports);
        List<String> jdkArgs = jdkOpensAndExports;
        Collection collection = CollectionsKt.plus((Collection)gradleGcArgs, (Iterable)jdkArgs);
        Object object3 = extraJvmArgs.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String extraArgs = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object3)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray = new String[]{"-Xms" + gradleXms + "g", "-Xmx" + gradleXmx + "g", "-XX:MaxMetaspaceSize=1g"};
        GradleDaemonArgs gradleDaemonArgs = new GradleDaemonArgs(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Object)extraArgs), maxWorkers);
        Object[] objectArray2 = new String[]{"-Xms" + kotlinXms + "g", "-Xmx" + kotlinXmx + "g"};
        KotlinDaemonArgs kotlinDaemonArgs = new KotlinDaemonArgs(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray2), (Iterable)kotlinDaemonGcArgs));
        return new DaemonArgs(gradleDaemonArgs, kotlinDaemonArgs);
    }

    private static final <T> T computeDaemonArgs$pickValue(boolean $isCi, T ci, T local) {
        return $isCi ? ci : local;
    }

    static {
        Object[] objectArray = new String[]{"--add-opens=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "--add-opens=jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "--add-opens=jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED", "--add-opens=jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "--add-opens=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "--add-opens=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "--add-opens=java.base/java.io=ALL-UNNAMED"};
        jdkOpensAndExports = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lslack/gradle/tasks/BootstrapUtils$DaemonArgs;", "", "gradle", "Lslack/gradle/tasks/BootstrapUtils$GradleDaemonArgs;", "kotlin", "Lslack/gradle/tasks/BootstrapUtils$KotlinDaemonArgs;", "(Lslack/gradle/tasks/BootstrapUtils$GradleDaemonArgs;Lslack/gradle/tasks/BootstrapUtils$KotlinDaemonArgs;)V", "getGradle", "()Lslack/gradle/tasks/BootstrapUtils$GradleDaemonArgs;", "getKotlin", "()Lslack/gradle/tasks/BootstrapUtils$KotlinDaemonArgs;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "slack-plugin"})
    public static final class DaemonArgs {
        @NotNull
        private final GradleDaemonArgs gradle;
        @NotNull
        private final KotlinDaemonArgs kotlin;

        public DaemonArgs(@NotNull GradleDaemonArgs gradle, @NotNull KotlinDaemonArgs kotlin) {
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
            Intrinsics.checkNotNullParameter((Object)kotlin, (String)"kotlin");
            this.gradle = gradle;
            this.kotlin = kotlin;
        }

        @NotNull
        public final GradleDaemonArgs getGradle() {
            return this.gradle;
        }

        @NotNull
        public final KotlinDaemonArgs getKotlin() {
            return this.kotlin;
        }

        @NotNull
        public final GradleDaemonArgs component1() {
            return this.gradle;
        }

        @NotNull
        public final KotlinDaemonArgs component2() {
            return this.kotlin;
        }

        @NotNull
        public final DaemonArgs copy(@NotNull GradleDaemonArgs gradle, @NotNull KotlinDaemonArgs kotlin) {
            Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
            Intrinsics.checkNotNullParameter((Object)kotlin, (String)"kotlin");
            return new DaemonArgs(gradle, kotlin);
        }

        public static /* synthetic */ DaemonArgs copy$default(DaemonArgs daemonArgs, GradleDaemonArgs gradleDaemonArgs, KotlinDaemonArgs kotlinDaemonArgs, int n, Object object) {
            if ((n & 1) != 0) {
                gradleDaemonArgs = daemonArgs.gradle;
            }
            if ((n & 2) != 0) {
                kotlinDaemonArgs = daemonArgs.kotlin;
            }
            return daemonArgs.copy(gradleDaemonArgs, kotlinDaemonArgs);
        }

        @NotNull
        public String toString() {
            return "DaemonArgs(gradle=" + this.gradle + ", kotlin=" + this.kotlin + ")";
        }

        public int hashCode() {
            int result = this.gradle.hashCode();
            result = result * 31 + this.kotlin.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DaemonArgs)) {
                return false;
            }
            DaemonArgs daemonArgs = (DaemonArgs)other;
            if (!Intrinsics.areEqual((Object)this.gradle, (Object)daemonArgs.gradle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlin, (Object)daemonArgs.kotlin);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B_\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lslack/gradle/tasks/BootstrapUtils$DaemonArgsProvider;", "", "customMemoryMultiplier", "Lorg/gradle/api/provider/Provider;", "", "customCoreMultiplier", "gradleMemoryPercentage", "minGradleXmx", "", "extraJvmArgs", "", "garbageCollector", "(Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "getCustomCoreMultiplier", "()Lorg/gradle/api/provider/Provider;", "getCustomMemoryMultiplier", "getExtraJvmArgs", "getGarbageCollector", "getGradleMemoryPercentage", "getMinGradleXmx", "Companion", "slack-plugin"})
    public static final class DaemonArgsProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Provider<String> customMemoryMultiplier;
        @NotNull
        private final Provider<String> customCoreMultiplier;
        @NotNull
        private final Provider<String> gradleMemoryPercentage;
        @NotNull
        private final Provider<Integer> minGradleXmx;
        @NotNull
        private final Provider<List<String>> extraJvmArgs;
        @NotNull
        private final Provider<String> garbageCollector;

        public DaemonArgsProvider(@NotNull Provider<String> customMemoryMultiplier, @NotNull Provider<String> customCoreMultiplier, @NotNull Provider<String> gradleMemoryPercentage, @NotNull Provider<Integer> minGradleXmx, @NotNull Provider<List<String>> extraJvmArgs, @NotNull Provider<String> garbageCollector) {
            Intrinsics.checkNotNullParameter(customMemoryMultiplier, (String)"customMemoryMultiplier");
            Intrinsics.checkNotNullParameter(customCoreMultiplier, (String)"customCoreMultiplier");
            Intrinsics.checkNotNullParameter(gradleMemoryPercentage, (String)"gradleMemoryPercentage");
            Intrinsics.checkNotNullParameter(minGradleXmx, (String)"minGradleXmx");
            Intrinsics.checkNotNullParameter(extraJvmArgs, (String)"extraJvmArgs");
            Intrinsics.checkNotNullParameter(garbageCollector, (String)"garbageCollector");
            this.customMemoryMultiplier = customMemoryMultiplier;
            this.customCoreMultiplier = customCoreMultiplier;
            this.gradleMemoryPercentage = gradleMemoryPercentage;
            this.minGradleXmx = minGradleXmx;
            this.extraJvmArgs = extraJvmArgs;
            this.garbageCollector = garbageCollector;
        }

        @NotNull
        public final Provider<String> getCustomMemoryMultiplier() {
            return this.customMemoryMultiplier;
        }

        @NotNull
        public final Provider<String> getCustomCoreMultiplier() {
            return this.customCoreMultiplier;
        }

        @NotNull
        public final Provider<String> getGradleMemoryPercentage() {
            return this.gradleMemoryPercentage;
        }

        @NotNull
        public final Provider<Integer> getMinGradleXmx() {
            return this.minGradleXmx;
        }

        @NotNull
        public final Provider<List<String>> getExtraJvmArgs() {
            return this.extraJvmArgs;
        }

        @NotNull
        public final Provider<String> getGarbageCollector() {
            return this.garbageCollector;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lslack/gradle/tasks/BootstrapUtils$DaemonArgsProvider$Companion;", "", "()V", "fromProviders", "Lslack/gradle/tasks/BootstrapUtils$DaemonArgsProvider;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "slack-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DaemonArgsProvider fromProviders(@NotNull ProviderFactory providers) {
                Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
                Provider provider2 = providers.environmentVariable("BOOTSTRAP_MEMORY_MULTIPLIER");
                Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"environmentVariable(...)");
                Provider provider3 = providers.environmentVariable("BOOTSTRAP_CORE_MULTIPLIER");
                Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"environmentVariable(...)");
                Provider provider4 = providers.environmentVariable("GRADLE_MEMORY_PERCENT");
                Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"environmentVariable(...)");
                Provider provider5 = providers.gradleProperty("slack.bootstrap.minGradleXmx");
                Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"gradleProperty(...)");
                Provider provider6 = PropertyUtil.mapToInt((Provider<String>)provider5).orElse((Object)1);
                Intrinsics.checkNotNullExpressionValue((Object)provider6, (String)"orElse(...)");
                Provider provider7 = providers.provider((Callable)fromProviders.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)provider7, (String)"provider(...)");
                Provider provider8 = providers.environmentVariable("BOOTSTRAP_GC");
                Intrinsics.checkNotNullExpressionValue((Object)provider8, (String)"environmentVariable(...)");
                return new DaemonArgsProvider((Provider<String>)provider2, (Provider<String>)provider3, (Provider<String>)provider4, (Provider<Integer>)provider6, (Provider<List<String>>)provider7, (Provider<String>)provider8);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lslack/gradle/tasks/BootstrapUtils$GradleDaemonArgs;", "", "args", "", "", "maxWorkers", "", "(Ljava/util/List;I)V", "getArgs", "()Ljava/util/List;", "getMaxWorkers", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "slack-plugin"})
    public static final class GradleDaemonArgs {
        @NotNull
        private final List<String> args;
        private final int maxWorkers;

        public GradleDaemonArgs(@NotNull List<String> args, int maxWorkers) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.args = args;
            this.maxWorkers = maxWorkers;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        public final int getMaxWorkers() {
            return this.maxWorkers;
        }

        @NotNull
        public final List<String> component1() {
            return this.args;
        }

        public final int component2() {
            return this.maxWorkers;
        }

        @NotNull
        public final GradleDaemonArgs copy(@NotNull List<String> args, int maxWorkers) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new GradleDaemonArgs(args, maxWorkers);
        }

        public static /* synthetic */ GradleDaemonArgs copy$default(GradleDaemonArgs gradleDaemonArgs, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = gradleDaemonArgs.args;
            }
            if ((n2 & 2) != 0) {
                n = gradleDaemonArgs.maxWorkers;
            }
            return gradleDaemonArgs.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "GradleDaemonArgs(args=" + this.args + ", maxWorkers=" + this.maxWorkers + ")";
        }

        public int hashCode() {
            int result = ((Object)this.args).hashCode();
            result = result * 31 + Integer.hashCode(this.maxWorkers);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GradleDaemonArgs)) {
                return false;
            }
            GradleDaemonArgs gradleDaemonArgs = (GradleDaemonArgs)other;
            if (!Intrinsics.areEqual(this.args, gradleDaemonArgs.args)) {
                return false;
            }
            return this.maxWorkers == gradleDaemonArgs.maxWorkers;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lslack/gradle/tasks/BootstrapUtils$KotlinDaemonArgs;", "", "args", "", "", "(Ljava/util/List;)V", "getArgs", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "slack-plugin"})
    public static final class KotlinDaemonArgs {
        @NotNull
        private final List<String> args;

        public KotlinDaemonArgs(@NotNull List<String> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.args = args;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        @NotNull
        public final List<String> component1() {
            return this.args;
        }

        @NotNull
        public final KotlinDaemonArgs copy(@NotNull List<String> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new KotlinDaemonArgs(args);
        }

        public static /* synthetic */ KotlinDaemonArgs copy$default(KotlinDaemonArgs kotlinDaemonArgs, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = kotlinDaemonArgs.args;
            }
            return kotlinDaemonArgs.copy(list);
        }

        @NotNull
        public String toString() {
            return "KotlinDaemonArgs(args=" + this.args + ")";
        }

        public int hashCode() {
            return ((Object)this.args).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KotlinDaemonArgs)) {
                return false;
            }
            KotlinDaemonArgs kotlinDaemonArgs = (KotlinDaemonArgs)other;
            return Intrinsics.areEqual(this.args, kotlinDaemonArgs.args);
        }
    }
}

