/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.tasks;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Okio;
import okio.Source;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import slack.gradle.tasks.PermissionAllowlistException;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lslack/gradle/tasks/CheckManifestPermissionsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "inputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputFile", "getOutputFile", "permissionAllowlist", "Lorg/gradle/api/provider/SetProperty;", "", "getPermissionAllowlist", "()Lorg/gradle/api/provider/SetProperty;", "permissionAllowlistFile", "getPermissionAllowlistFile", "check", "", "Companion", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nCheckManifestPermissionsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckManifestPermissionsTask.kt\nslack/gradle/tasks/CheckManifestPermissionsTask\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n17#2,6:122\n1#3:128\n*S KotlinDebug\n*F\n+ 1 CheckManifestPermissionsTask.kt\nslack/gradle/tasks/CheckManifestPermissionsTask\n*L\n57#1:122,6\n*E\n"})
public abstract class CheckManifestPermissionsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOG = "[CheckManifestPermissionsTask]";

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getInputFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPermissionAllowlistFile();

    @Input
    @NotNull
    public abstract SetProperty<String> getPermissionAllowlist();

    @TaskAction
    public final void check() {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object object = this.getInputFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        File manifestFile = (File)object;
        this.getLogger().debug("[CheckManifestPermissionsTask] Using manifest at " + manifestFile);
        Object object2 = this.getPermissionAllowlistFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        File allowlistFile = (File)object2;
        this.getLogger().debug("[CheckManifestPermissionsTask] Using allowlist permissions at " + manifestFile);
        Object object3 = this.getPermissionAllowlist().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Set allowlist2 = (Set)object3;
        this.getLogger().debug("[CheckManifestPermissionsTask] " + allowlist2.size() + " allowlisted permissions: " + allowlist2);
        Set<String> permissions = Companion.parseXmlPermissions$slack_plugin(manifestFile);
        this.getLogger().debug("[CheckManifestPermissionsTask] " + permissions.size() + " parsed permissions: " + permissions);
        Set added = SetsKt.minus(permissions, (Iterable)allowlist2);
        if (!((Collection)added).isEmpty()) {
            throw new PermissionAllowlistException("New permission(s) detected! If this is intentional, please add them to " + allowlistFile + " and update your PR (a code owners group will be added for review). Added permissions: " + added);
        }
        Set removed = SetsKt.minus((Set)allowlist2, (Iterable)permissions);
        if (!((Collection)removed).isEmpty()) {
            throw new PermissionAllowlistException("Removed permission(s) detected! If this is intentional, please remove them to " + allowlistFile + " and update your PR (a code owners group will be added for review). Removed permissions: " + removed);
        }
        Object object4 = this.getOutputFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        FilesKt.copyTo$default((File)manifestFile, (File)((File)object4), (boolean)true, (int)0, (int)4, null);
        long it = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        this.getLogger().debug("[CheckManifestPermissionsTask] Manifest perm checks took " + it + " ms");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lslack/gradle/tasks/CheckManifestPermissionsTask$Companion;", "", "()V", "LOG", "", "parseXmlPermissions", "", "file", "Ljava/io/File;", "parseXmlPermissions$slack_plugin", "parsePermissionValues", "Lorg/w3c/dom/NodeList;", "slack-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> parseXmlPermissions$slack_plugin(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(Okio.buffer((Source)Okio.source((File)file)).inputStream());
            NodeList permissions = doc.getElementsByTagName("uses-permission");
            NodeList permissions23 = doc.getElementsByTagName("uses-permission-sdk-23");
            Intrinsics.checkNotNull((Object)permissions);
            Set<String> set = this.parsePermissionValues(permissions);
            Intrinsics.checkNotNull((Object)permissions23);
            return SetsKt.plus(set, (Iterable)this.parsePermissionValues(permissions23));
        }

        private final Set<String> parsePermissionValues(NodeList $this$parsePermissionValues) {
            Set perms = new LinkedHashSet();
            int n = $this$parsePermissionValues.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                Node node = $this$parsePermissionValues.item(i2);
                NamedNodeMap attrs = node.getAttributes();
                Node perm = attrs.getNamedItem("android:name");
                if (perm == null) continue;
                String string = perm.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeValue(...)");
                perms.add(string);
            }
            return perms;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

