/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.tasks;

import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="This is run on-demand")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lslack/gradle/tasks/InstallCommitHooksTask;", "Lorg/gradle/api/DefaultTask;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/file/ProjectLayout;Lorg/gradle/api/model/ObjectFactory;)V", "names", "Lorg/gradle/api/provider/SetProperty;", "", "getNames", "()Lorg/gradle/api/provider/SetProperty;", "outputHooksDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputHooksDir", "()Lorg/gradle/api/file/DirectoryProperty;", "install", "", "Companion", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nInstallCommitHooksTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallCommitHooksTask.kt\nslack/gradle/tasks/InstallCommitHooksTask\n+ 2 GradleExt.kt\nslack/gradle/GradleExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n304#2:92\n1271#3,2:93\n1285#3,4:95\n*S KotlinDebug\n*F\n+ 1 InstallCommitHooksTask.kt\nslack/gradle/tasks/InstallCommitHooksTask\n*L\n45#1:92\n68#1:93,2\n68#1:95,4\n*E\n"})
public abstract class InstallCommitHooksTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SetProperty<String> names;
    @NotNull
    private final DirectoryProperty outputHooksDir;
    @NotNull
    private static final String NAME = "installCommitHooks";

    @Inject
    public InstallCommitHooksTask(@NotNull ProjectLayout layout, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        ObjectFactory $this$setProperty$iv = objects;
        boolean $i$f$setProperty = false;
        SetProperty setProperty = $this$setProperty$iv.setProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"setProperty(...)");
        Object[] objectArray = new String[]{"post-checkout", "post-commit", "post-merge", "pre-commit", "pre-push"};
        SetProperty setProperty2 = setProperty.convention((Iterable)SetsKt.setOf((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)setProperty2, (String)"convention(...)");
        this.names = setProperty2;
        DirectoryProperty directoryProperty = objects.directoryProperty().convention(layout.getProjectDirectory().dir("config/git/hooks"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(...)");
        this.outputHooksDir = directoryProperty;
        this.setGroup("slack");
        this.setDescription("Installs basic git hook files for formatting to a given output directory.");
    }

    @Input
    @NotNull
    public final SetProperty<String> getNames() {
        return this.names;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputHooksDir() {
        return this.outputHooksDir;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void install() {
        Object object = this.names.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$associateWith$iv = (Iterable)object;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            URL uRL;
            void name;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Resources.getResource((String)("githook-" + (String)name)), (String)"getResource(...)");
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            String string2 = new String(byArray, charset);
            map.put(t, string2);
        }
        Map hookFiles = result$iv;
        Object object2 = this.outputHooksDir.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        File outputDir = (File)object2;
        this.getLogger().lifecycle("Writing git hooks to " + outputDir);
        outputDir.mkdirs();
        for (Map.Entry entry : hookFiles.entrySet()) {
            String name = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.getLogger().lifecycle("Writing " + name);
            FilesKt.writeText$default((File)new File(outputDir, name), (String)text, null, (int)2, null);
        }
        this.getLogger().lifecycle("Finished! Be sure to point git at the hooks location: \"git config core.hooksPath " + outputDir + "\"");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lslack/gradle/tasks/InstallCommitHooksTask$Companion;", "", "()V", "NAME", "", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lslack/gradle/tasks/InstallCommitHooksTask;", "rootProject", "Lorg/gradle/api/Project;", "slack-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TaskProvider<InstallCommitHooksTask> register(@NotNull Project rootProject) {
            Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
            TaskProvider taskProvider = rootProject.getTasks().register(InstallCommitHooksTask.NAME, InstallCommitHooksTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
            return taskProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

