/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.tasks.robolectric;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.tasks.robolectric.DependencyJar;
import slack.gradle.tasks.robolectric.Sdk;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c2\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lslack/gradle/tasks/robolectric/DefaultSdk;", "Lslack/gradle/tasks/robolectric/Sdk;", "apiLevel", "", "androidVersion", "", "robolectricVersion", "androidCodeName", "requiredJavaVersion", "iVersion", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;II)V", "getAndroidCodeName", "()Ljava/lang/String;", "getAndroidVersion", "getApiLevel", "()I", "dependencyCoordinates", "getDependencyCoordinates", "version", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "dependencyJar", "Lslack/gradle/tasks/robolectric/DependencyJar;", "equals", "", "other", "", "hashCode", "toString", "Companion", "slack-plugin"})
public final class DefaultSdk
extends Sdk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int apiLevel;
    @NotNull
    private final String androidVersion;
    @NotNull
    private final String robolectricVersion;
    @NotNull
    private final String androidCodeName;
    private final int requiredJavaVersion;
    private final int iVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String dependencyCoordinates;
    @NotNull
    private static final String GROUP_ID = "org.robolectric";
    @NotNull
    private static final String ARTIFACT_ID = "android-all-instrumented";

    public DefaultSdk(int apiLevel, @NotNull String androidVersion, @NotNull String robolectricVersion, @NotNull String androidCodeName, int requiredJavaVersion, int iVersion) {
        Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
        Intrinsics.checkNotNullParameter((Object)robolectricVersion, (String)"robolectricVersion");
        Intrinsics.checkNotNullParameter((Object)androidCodeName, (String)"androidCodeName");
        super(null);
        this.apiLevel = apiLevel;
        this.androidVersion = androidVersion;
        this.robolectricVersion = robolectricVersion;
        this.androidCodeName = androidCodeName;
        this.requiredJavaVersion = requiredJavaVersion;
        this.iVersion = iVersion;
        this.version = this.getAndroidVersion() + "-robolectric-" + this.robolectricVersion + "-i" + this.iVersion;
        this.dependencyCoordinates = "org.robolectric:android-all-instrumented:" + this.version;
    }

    @Override
    public int getApiLevel() {
        return this.apiLevel;
    }

    @Override
    @NotNull
    public String getAndroidVersion() {
        return this.androidVersion;
    }

    @Override
    @NotNull
    public String getAndroidCodeName() {
        return this.androidCodeName;
    }

    @Override
    @NotNull
    public DependencyJar dependencyJar() {
        return new DependencyJar(GROUP_ID, ARTIFACT_ID, this.version, null);
    }

    @Override
    @NotNull
    public String getDependencyCoordinates() {
        return this.dependencyCoordinates;
    }

    public final int component1() {
        return this.apiLevel;
    }

    @NotNull
    public final String component2() {
        return this.androidVersion;
    }

    private final String component3() {
        return this.robolectricVersion;
    }

    @NotNull
    public final String component4() {
        return this.androidCodeName;
    }

    private final int component5() {
        return this.requiredJavaVersion;
    }

    private final int component6() {
        return this.iVersion;
    }

    @NotNull
    public final DefaultSdk copy(int apiLevel, @NotNull String androidVersion, @NotNull String robolectricVersion, @NotNull String androidCodeName, int requiredJavaVersion, int iVersion) {
        Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
        Intrinsics.checkNotNullParameter((Object)robolectricVersion, (String)"robolectricVersion");
        Intrinsics.checkNotNullParameter((Object)androidCodeName, (String)"androidCodeName");
        return new DefaultSdk(apiLevel, androidVersion, robolectricVersion, androidCodeName, requiredJavaVersion, iVersion);
    }

    public static /* synthetic */ DefaultSdk copy$default(DefaultSdk defaultSdk, int n, String string, String string2, String string3, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = defaultSdk.apiLevel;
        }
        if ((n4 & 2) != 0) {
            string = defaultSdk.androidVersion;
        }
        if ((n4 & 4) != 0) {
            string2 = defaultSdk.robolectricVersion;
        }
        if ((n4 & 8) != 0) {
            string3 = defaultSdk.androidCodeName;
        }
        if ((n4 & 0x10) != 0) {
            n2 = defaultSdk.requiredJavaVersion;
        }
        if ((n4 & 0x20) != 0) {
            n3 = defaultSdk.iVersion;
        }
        return defaultSdk.copy(n, string, string2, string3, n2, n3);
    }

    @NotNull
    public String toString() {
        return "DefaultSdk(apiLevel=" + this.apiLevel + ", androidVersion=" + this.androidVersion + ", robolectricVersion=" + this.robolectricVersion + ", androidCodeName=" + this.androidCodeName + ", requiredJavaVersion=" + this.requiredJavaVersion + ", iVersion=" + this.iVersion + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.apiLevel);
        result = result * 31 + this.androidVersion.hashCode();
        result = result * 31 + this.robolectricVersion.hashCode();
        result = result * 31 + this.androidCodeName.hashCode();
        result = result * 31 + Integer.hashCode(this.requiredJavaVersion);
        result = result * 31 + Integer.hashCode(this.iVersion);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultSdk)) {
            return false;
        }
        DefaultSdk defaultSdk = (DefaultSdk)other;
        if (this.apiLevel != defaultSdk.apiLevel) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.androidVersion, (Object)defaultSdk.androidVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.robolectricVersion, (Object)defaultSdk.robolectricVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.androidCodeName, (Object)defaultSdk.androidCodeName)) {
            return false;
        }
        if (this.requiredJavaVersion != defaultSdk.requiredJavaVersion) {
            return false;
        }
        return this.iVersion == defaultSdk.iVersion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lslack/gradle/tasks/robolectric/DefaultSdk$Companion;", "", "()V", "ARTIFACT_ID", "", "GROUP_ID", "slack-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

