/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.tasks.robolectric;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.SlackGradleUtilKt;
import slack.gradle.SlackProperties;
import slack.gradle.tasks.BootstrapTask;
import slack.gradle.tasks.robolectric.DefaultSdk;
import slack.gradle.tasks.robolectric.UpdateRobolectricJarsTaskKt;
import slack.gradle.util.HasConfigurableValuesKt;

@UntrackedTask(because="State for this is handled elsewhere.")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask;", "Lorg/gradle/api/DefaultTask;", "Lslack/gradle/tasks/BootstrapTask;", "()V", "allJars", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getAllJars", "()Lorg/gradle/api/provider/ListProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "download", "", "Companion", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nUpdateRobolectricJarsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateRobolectricJarsTask.kt\nslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n1222#2,4:165\n215#3,2:169\n*S KotlinDebug\n*F\n+ 1 UpdateRobolectricJarsTask.kt\nslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask\n*L\n73#1:165,4\n84#1:169,2\n*E\n"})
public abstract class UpdateRobolectricJarsTask
extends DefaultTask
implements BootstrapTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "[RobolectricJarsDownloadTask]";
    @NotNull
    public static final String NAME = "updateRobolectricJars";

    public UpdateRobolectricJarsTask() {
        this.setGroup("slack");
        this.setDescription("Downloads the Robolectric android-all jars.");
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFiles
    @NotNull
    public abstract ListProperty<File> getAllJars();

    @Internal
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void download() {
        Iterator $this$associateByTo$iv;
        Object object = this.getOutputDir().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        File destinationDir = (File)object;
        this.getLogger().debug("[RobolectricJarsDownloadTask] Copying downloaded robolectric jars");
        File file = destinationDir;
        Object $this$download_u24lambda_u240 = file;
        boolean bl = false;
        if (!((File)$this$download_u24lambda_u240).exists()) {
            ((File)$this$download_u24lambda_u240).mkdirs();
        }
        $this$download_u24lambda_u240 = Companion.jarsIn(destinationDir);
        Map destination$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv.iterator();
        while (iterator.hasNext()) {
            void p0;
            Object element$iv = iterator.next();
            File file2 = (File)element$iv;
            Map map = destination$iv;
            boolean bl2 = false;
            map.put(p0.getName(), element$iv);
        }
        LinkedHashMap existingJars = (LinkedHashMap)destination$iv;
        for (File jarToCopy : (List)this.getAllJars().get()) {
            existingJars.remove(jarToCopy.getName());
            File destinationFile = new File(destinationDir, jarToCopy.getName());
            if (destinationFile.exists()) {
                this.getLogger().debug("[RobolectricJarsDownloadTask] Skipping " + jarToCopy + ", already copied \ud83d\udc4d.");
                continue;
            }
            this.getLogger().lifecycle("[RobolectricJarsDownloadTask] Copying " + jarToCopy + " to " + destinationFile + ".");
            Intrinsics.checkNotNull((Object)jarToCopy);
            FilesKt.copyTo$default((File)jarToCopy, (File)destinationFile, (boolean)false, (int)0, (int)6, null);
        }
        Map $this$forEach$iv = existingJars;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            String name = (String)entry.getKey();
            File file3 = (File)entry.getValue();
            this.getLogger().lifecycle("Deleting unused Robolectric jar '" + name + "'");
            file3.delete();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask$Companion;", "", "()V", "NAME", "", "TAG", "jarsIn", "", "Ljava/io/File;", "dir", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask;", "project", "Lorg/gradle/api/Project;", "slackProperties", "Lslack/gradle/SlackProperties;", "slack-plugin"})
    @SourceDebugExtension(value={"SMAP\nUpdateRobolectricJarsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateRobolectricJarsTask.kt\nslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 GradleExt.kt\nslack/gradle/GradleExtKt\n*L\n1#1,164:1\n18#2:165\n26#3:166\n4307#4,2:167\n161#5:169\n*S KotlinDebug\n*F\n+ 1 UpdateRobolectricJarsTask.kt\nslack/gradle/tasks/robolectric/UpdateRobolectricJarsTask$Companion\n*L\n95#1:165\n95#1:166\n95#1:167,2\n102#1:169\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<File> jarsIn(@NotNull File dir) {
            void var3_4;
            void $this$filterTo$iv;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            File[] $this$orEmpty$iv = dir.listFiles();
            boolean $i$f$orEmpty = false;
            File[] fileArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                fileArray = new File[]{};
            }
            $this$orEmpty$iv = fileArray;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv;
                void it = element$iv = $this$filterTo$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"jar")) continue;
                destination$iv.add(element$iv);
            }
            return (Set)var3_4;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<UpdateRobolectricJarsTask> register(@NotNull Project project, @NotNull SlackProperties slackProperties) {
            void name$iv;
            void $this$register$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)slackProperties, (String)"slackProperties");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            TaskContainer taskContainer2 = taskContainer;
            String string = UpdateRobolectricJarsTask.NAME;
            Action configuration$iv = new Action(slackProperties, project){
                final /* synthetic */ SlackProperties $slackProperties;
                final /* synthetic */ Project $project;
                {
                    this.$slackProperties = $slackProperties;
                    this.$project = $project;
                }

                public final void execute(@NotNull UpdateRobolectricJarsTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    int iVersion = this.$slackProperties.getRobolectricIVersion();
                    Iterator<Integer> iterator = this.$slackProperties.getRobolectricTestSdks().iterator();
                    while (iterator.hasNext()) {
                        Configuration configuration;
                        int sdkInt = ((Number)iterator.next()).intValue();
                        DefaultSdk sdk = UpdateRobolectricJarsTaskKt.access$sdkFor(sdkInt, iVersion);
                        String depCoordinates = sdk.getDependencyCoordinates();
                        Dependency[] dependencyArray = new Dependency[]{this.$project.getDependencies().create((Object)depCoordinates)};
                        Intrinsics.checkNotNullExpressionValue((Object)this.$project.getConfigurations().detachedConfiguration(dependencyArray), (String)"detachedConfiguration(...)");
                        $this$register.getLogger().debug("Adding '" + depCoordinates + "' to Robolectric jars in configuration '" + configuration.getName() + "'");
                        $this$register.getAllJars().addAll(UpdateRobolectricJarsTaskKt.access$artifactView(configuration));
                    }
                    File file = this.$project.getGradle().getGradleUserHomeDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getGradleUserHomeDir(...)");
                    File gradleUserHomeDir = file;
                    Property property = (Property)$this$register.getOutputDir();
                    Provider provider2 = this.$project.getLayout().dir(this.$project.provider(new Callable(gradleUserHomeDir){
                        final /* synthetic */ File $gradleUserHomeDir;
                        {
                            this.$gradleUserHomeDir = $gradleUserHomeDir;
                        }

                        @Nullable
                        public final File call() {
                            return SlackGradleUtilKt.robolectricJars$default(this.$gradleUserHomeDir, false, 2, null);
                        }
                    }));
                    Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"dir(...)");
                    HasConfigurableValuesKt.setDisallowChanges(property, provider2);
                }
            };
            boolean $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register((String)name$iv, UpdateRobolectricJarsTask.class, configuration$iv);
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
            return taskProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

