/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.observers.DisposableObserver;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.File;
import java.time.LocalDateTime;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.util.AppleSiliconThermals;
import slack.gradle.util.JnaThermalState;
import slack.gradle.util.ThermLog;
import slack.gradle.util.Thermals;
import slack.gradle.util.ThermalsWatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lslack/gradle/util/AppleSiliconThermals;", "Lslack/gradle/util/ThermalsWatcher;", "logger", "Lorg/gradle/api/logging/Logger;", "thermalsFileProvider", "Lkotlin/Function0;", "Ljava/io/File;", "(Lorg/gradle/api/logging/Logger;Lkotlin/jvm/functions/Function0;)V", "emissions", "Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "Lslack/gradle/util/Thermals;", "heartbeat", "Lio/reactivex/rxjava3/disposables/Disposable;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "thermalsFile", "getThermalState", "Lslack/gradle/util/AppleSiliconThermals$ThermalState;", "peek", "start", "", "executor", "Ljava/util/concurrent/Executor;", "stop", "ThermalState", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nThermalsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/AppleSiliconThermals\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public final class AppleSiliconThermals
implements ThermalsWatcher {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function0<File> thermalsFileProvider;
    @NotNull
    private BehaviorSubject<Thermals> emissions;
    @Nullable
    private Disposable heartbeat;
    @Nullable
    private File thermalsFile;
    @NotNull
    private final AtomicBoolean started;

    public AppleSiliconThermals(@NotNull Logger logger, @NotNull Function0<? extends File> thermalsFileProvider) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(thermalsFileProvider, (String)"thermalsFileProvider");
        this.logger = logger;
        this.thermalsFileProvider = thermalsFileProvider;
        BehaviorSubject behaviorSubject = BehaviorSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject, (String)"create(...)");
        this.emissions = behaviorSubject;
        this.started = new AtomicBoolean(false);
    }

    @Override
    public void start(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (!(!this.started.getAndSet(true))) {
            boolean bl = false;
            String string = "Already started.";
            throw new IllegalStateException(string.toString());
        }
        this.thermalsFile = (File)this.thermalsFileProvider.invoke();
        this.heartbeat = (Disposable)Observable.interval((long)5L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.from((Executor)executor)).map(new Function(this){
            final /* synthetic */ AppleSiliconThermals this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final ThermLog apply(long it) {
                LocalDateTime localDateTime = LocalDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
                ThermalState thermalState = AppleSiliconThermals.access$getThermalState(this.this$0);
                return new ThermLog(localDateTime, 0, 0, switch (thermalState == null ? -1 : start.WhenMappings.$EnumSwitchMapping$0[thermalState.ordinal()]) {
                    case 1 -> 100;
                    case 2 -> 75;
                    case 3 -> 50;
                    case 4 -> 25;
                    case -1 -> -1;
                    default -> throw new NoWhenBranchMatchedException();
                });
            }
        }).takeUntil((Predicate)start.3.INSTANCE).doOnNext(new Consumer(this){
            final /* synthetic */ AppleSiliconThermals this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull ThermLog it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    File file = AppleSiliconThermals.access$getThermalsFile$p(this.this$0);
                    if (file == null) break block0;
                    FilesKt.appendText$default((File)file, (String)("\n" + it.getTimestamp() + " - " + it.getSpeedLimit()), null, (int)2, null);
                }
            }
        }).scanWith((Supplier)start.5.INSTANCE, (BiFunction)start.6.INSTANCE).subscribeWith((Observer)new DisposableObserver<Thermals>(this){
            final /* synthetic */ AppleSiliconThermals this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNext(@NotNull Thermals thermals) {
                Intrinsics.checkNotNullParameter((Object)thermals, (String)"thermals");
                AppleSiliconThermals.access$getEmissions$p(this.this$0).onNext((Object)thermals);
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AppleSiliconThermals.access$getLogger$p(this.this$0).error("Error in thermals watcher:\n" + ExceptionsKt.stackTraceToString((Throwable)e));
            }

            public void onComplete() {
                AppleSiliconThermals.access$getLogger$p(this.this$0).error("Could not read thermals for this build.");
            }
        });
    }

    @Override
    @NotNull
    public Thermals peek() {
        if (!this.started.get()) {
            boolean bl = false;
            String string = "Not started.";
            throw new IllegalStateException(string.toString());
        }
        Thermals thermals = (Thermals)this.emissions.getValue();
        if (thermals == null) {
            thermals = Thermals.Empty.INSTANCE;
        }
        return thermals;
    }

    @Override
    @NotNull
    public Thermals stop() {
        if (!this.started.getAndSet(false)) {
            boolean bl = false;
            String string = "Not started.";
            throw new IllegalStateException(string.toString());
        }
        Disposable disposable = this.heartbeat;
        if (disposable != null) {
            disposable.dispose();
        }
        this.heartbeat = null;
        this.thermalsFile = null;
        Thermals thermals = (Thermals)this.emissions.getValue();
        if (thermals == null) {
            thermals = Thermals.Empty.INSTANCE;
        }
        Thermals thermals2 = thermals;
        Intrinsics.checkNotNull((Object)thermals2);
        Thermals thermals3 = thermals2;
        BehaviorSubject behaviorSubject = BehaviorSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject, (String)"create(...)");
        this.emissions = behaviorSubject;
        return thermals3;
    }

    private final ThermalState getThermalState() {
        int n;
        try {
            n = JnaThermalState.Companion.getINSTANCE().thermal_state();
        }
        catch (Throwable t) {
            this.logger.error("Could not read thermals state: " + t.getMessage());
            return null;
        }
        int rawValue = n;
        return (0 <= rawValue ? rawValue <= ThermalState.values().length : false) ? ThermalState.values()[rawValue] : null;
    }

    public static final /* synthetic */ ThermalState access$getThermalState(AppleSiliconThermals $this) {
        return $this.getThermalState();
    }

    public static final /* synthetic */ File access$getThermalsFile$p(AppleSiliconThermals $this) {
        return $this.thermalsFile;
    }

    public static final /* synthetic */ BehaviorSubject access$getEmissions$p(AppleSiliconThermals $this) {
        return $this.emissions;
    }

    public static final /* synthetic */ Logger access$getLogger$p(AppleSiliconThermals $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lslack/gradle/util/AppleSiliconThermals$ThermalState;", "", "rawValue", "", "(Ljava/lang/String;II)V", "getRawValue", "()I", "NOMINAL", "FAIR", "SERIOUS", "CRITICAL", "slack-plugin"})
    public static final class ThermalState
    extends Enum<ThermalState> {
        private final int rawValue;
        public static final /* enum */ ThermalState NOMINAL = new ThermalState(0);
        public static final /* enum */ ThermalState FAIR = new ThermalState(1);
        public static final /* enum */ ThermalState SERIOUS = new ThermalState(2);
        public static final /* enum */ ThermalState CRITICAL = new ThermalState(3);
        private static final /* synthetic */ ThermalState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ThermalState(int rawValue) {
            this.rawValue = rawValue;
        }

        public final int getRawValue() {
            return this.rawValue;
        }

        public static ThermalState[] values() {
            return (ThermalState[])$VALUES.clone();
        }

        public static ThermalState valueOf(String value2) {
            return Enum.valueOf(ThermalState.class, value2);
        }

        @NotNull
        public static EnumEntries<ThermalState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = thermalStateArray = new ThermalState[]{ThermalState.NOMINAL, ThermalState.FAIR, ThermalState.SERIOUS, ThermalState.CRITICAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

