/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.util.Thermals;
import slack.gradle.util.ThermalsWatcher;
import slack.gradle.util.ThermlogParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lslack/gradle/util/IntelThermalsParser;", "Lslack/gradle/util/ThermalsWatcher;", "thermalsFileProvider", "Lkotlin/Function0;", "Ljava/io/File;", "(Lkotlin/jvm/functions/Function0;)V", "process", "Ljava/lang/Process;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "thermalsFile", "getThermalsFileProvider", "()Lkotlin/jvm/functions/Function0;", "peek", "Lslack/gradle/util/Thermals;", "start", "", "executor", "Ljava/util/concurrent/Executor;", "stop", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nThermalsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/IntelThermalsParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public final class IntelThermalsParser
implements ThermalsWatcher {
    @NotNull
    private final Function0<File> thermalsFileProvider;
    @Nullable
    private Process process;
    @Nullable
    private File thermalsFile;
    @NotNull
    private final AtomicBoolean started;

    public IntelThermalsParser(@NotNull Function0<? extends File> thermalsFileProvider) {
        Intrinsics.checkNotNullParameter(thermalsFileProvider, (String)"thermalsFileProvider");
        this.thermalsFileProvider = thermalsFileProvider;
        this.started = new AtomicBoolean(false);
    }

    @NotNull
    public final Function0<File> getThermalsFileProvider() {
        return this.thermalsFileProvider;
    }

    @Override
    public void start(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (!(!this.started.getAndSet(true))) {
            boolean bl = false;
            String string = "Already started";
            throw new IllegalStateException(string.toString());
        }
        this.thermalsFile = (File)this.thermalsFileProvider.invoke();
        String[] stringArray = new String[]{"pmset", "-g", "thermlog"};
        this.process = new ProcessBuilder(stringArray).redirectOutput(this.thermalsFile).start();
    }

    @Override
    @NotNull
    public Thermals peek() {
        Thermals thermals;
        if (!this.started.get()) {
            boolean $i$a$-check-IntelThermalsParser$peek$22 = false;
            String $i$a$-check-IntelThermalsParser$peek$22 = "Not started";
            throw new IllegalStateException($i$a$-check-IntelThermalsParser$peek$22.toString());
        }
        File file = this.thermalsFile;
        if (file == null) {
            return Thermals.Empty.INSTANCE;
        }
        File file2 = file;
        if (file2.exists()) {
            String thermalsLog = FilesKt.readText$default((File)file2, null, (int)1, null);
            thermals = ThermlogParser.INSTANCE.parse$slack_plugin(thermalsLog);
        } else {
            thermals = Thermals.Empty.INSTANCE;
        }
        return thermals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Thermals stop() {
        Process process;
        Thermals thermals;
        if (!this.started.get()) {
            boolean bl = false;
            String string = "Not started";
            throw new IllegalStateException(string.toString());
        }
        try {
            thermals = this.peek();
            process = this.process;
        }
        catch (Throwable throwable) {
            Process process2 = this.process;
            Process process3 = process2;
            if (process2 == null) throw throwable;
            Process process4 = process3.destroyForcibly();
            process3 = process4;
            if (process4 == null) throw throwable;
            process3.waitFor();
            throw throwable;
        }
        Process process5 = process;
        if (process != null && (process5 = process5.destroyForcibly()) != null) {
            process5.waitFor();
        }
        Thermals thermals2 = thermals;
        this.started.set(false);
        this.process = null;
        this.thermalsFile = null;
        return thermals2;
    }
}

