/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\f"}, d2={"Lslack/gradle/util/LocalDateTimeJsonAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Ljava/time/LocalDateTime;", "()V", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "slack-plugin"})
final class LocalDateTimeJsonAdapter
extends JsonAdapter<LocalDateTime> {
    @NotNull
    public LocalDateTime fromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        long timestamp = reader.nextLong();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable LocalDateTime value2) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value2 == null) {
            writer.nullValue();
            return;
        }
        long timestamp = value2.atZone(ZoneId.systemDefault()).toEpochSecond();
        writer.value(timestamp);
    }
}

