/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util;

import com.squareup.moshi.JsonClass;
import dev.zacsweers.moshix.sealed.annotations.TypeLabel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.util.ThermLog;
import slack.gradle.util.Thermals;
import slack.gradle.util.ThermalsData;
import slack.gradle.util.charting.ChartCreator;

@TypeLabel(label="data")
@JsonClass(generateAdapter=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00182\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020\u0007H\u00d6\u0001J\t\u0010%\u001a\u00020\u001dH\u00d6\u0001R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001b\u0010\u0011\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0012\u0010\u000eR\u001b\u0010\u0014\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0015\u0010\u000eR\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000b\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lslack/gradle/util/ThermalsData;", "Lslack/gradle/util/Thermals;", "logs", "", "Lslack/gradle/util/ThermLog;", "(Ljava/util/List;)V", "allSpeedLimits", "", "getAllSpeedLimits", "()Ljava/util/List;", "allSpeedLimits$delegate", "Lkotlin/Lazy;", "average", "getAverage", "()I", "average$delegate", "getLogs", "lowest", "getLowest", "lowest$delegate", "percentThrottled", "getPercentThrottled", "percentThrottled$delegate", "wasThrottled", "", "getWasThrottled", "()Z", "wasThrottled$delegate", "chartUrl", "", "urlCharLimit", "component1", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nThermalsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/ThermalsData\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,408:1\n123#2,2:409\n*S KotlinDebug\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/ThermalsData\n*L\n254#1:409,2\n*E\n"})
public final class ThermalsData
extends Thermals {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ThermLog> logs;
    @NotNull
    private final Lazy wasThrottled$delegate;
    @NotNull
    private final Lazy lowest$delegate;
    @NotNull
    private final Lazy average$delegate;
    @NotNull
    private final Lazy percentThrottled$delegate;
    @NotNull
    private final Lazy allSpeedLimits$delegate;
    @Deprecated
    public static final int MINIMUM_CHAR_LIMIT = 1000;

    public ThermalsData(@NotNull List<ThermLog> logs) {
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        super(null);
        this.logs = logs;
        if (!(!((Collection)this.logs).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.wasThrottled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ThermalsData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.this$0.getLogs();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ThermLog it = (ThermLog)element$iv;
                            boolean bl2 = false;
                            if (!it.isThrottled()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
        this.lowest$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ThermalsData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                Iterator<T> iterator = ((Iterable)this.this$0.getLogs()).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                ThermLog it = (ThermLog)iterator.next();
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSpeedLimit());
                while (iterator.hasNext()) {
                    ThermLog it2 = (ThermLog)iterator.next();
                    $i$a$-minOf-ThermalsData$lowest$2$1 = false;
                    Comparable comparable2 = Integer.valueOf(it2.getSpeedLimit());
                    if (comparable.compareTo(comparable2) <= 0) continue;
                    comparable = comparable2;
                }
                return (Integer)comparable;
            }
        }));
        this.average$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ThermalsData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                Iterable iterable = this.this$0.getLogs();
                int n = 0;
                for (T t : iterable) {
                    void it;
                    ThermLog thermLog = (ThermLog)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.getSpeedLimit();
                    n = n2 + n3;
                }
                return n / this.this$0.getLogs().size();
            }
        }));
        this.percentThrottled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ThermalsData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                boolean bl;
                Iterable $this$count$iv = this.this$0.getLogs();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    bl = false;
                } else {
                    void var3_3;
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        ThermLog it = (ThermLog)element$iv;
                        boolean bl2 = false;
                        if (!(it.getSpeedLimit() < 100) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    bl = var3_3;
                }
                return (int)((double)bl / (double)this.this$0.getLogs().size() * (double)100);
            }
        }));
        this.allSpeedLimits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Integer>>(this){
            final /* synthetic */ ThermalsData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Integer> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.this$0.getLogs();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ThermLog thermLog = (ThermLog)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getSpeedLimit());
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @NotNull
    public final List<ThermLog> getLogs() {
        return this.logs;
    }

    @Override
    public boolean getWasThrottled() {
        Lazy lazy = this.wasThrottled$delegate;
        return (Boolean)lazy.getValue();
    }

    public final int getLowest() {
        Lazy lazy = this.lowest$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getAverage() {
        Lazy lazy = this.average$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getPercentThrottled() {
        Lazy lazy = this.percentThrottled$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final List<Integer> getAllSpeedLimits() {
        Lazy lazy = this.allSpeedLimits$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String chartUrl(int urlCharLimit) {
        Object element$iv2;
        block2: {
            void $this$first$iv;
            if (!(urlCharLimit >= 1000)) {
                boolean $i$a$-require-ThermalsData$chartUrl$22 = false;
                String $i$a$-require-ThermalsData$chartUrl$22 = "Input limit " + urlCharLimit + " is below the minimum of 1000.";
                throw new IllegalArgumentException($i$a$-require-ThermalsData$chartUrl$22.toString());
            }
            int xLength = (int)Duration.between(((ThermLog)CollectionsKt.first(this.logs)).getTimestamp(), ((ThermLog)CollectionsKt.last(this.logs)).getTimestamp()).getSeconds();
            IntRange xRange = new IntRange(0, xLength);
            IntRange yRange = new IntRange(0, 100);
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)1, (Function1)chartUrl.2.INSTANCE), (Function1)((Function1)new Function1<Integer, String>(this, xRange, yRange){
                final /* synthetic */ ThermalsData this$0;
                final /* synthetic */ IntRange $xRange;
                final /* synthetic */ IntRange $yRange;
                {
                    this.this$0 = $receiver;
                    this.$xRange = $xRange;
                    this.$yRange = $yRange;
                    super(1);
                }

                @NotNull
                public final String invoke(int sampleSize) {
                    List<Integer> sampleValues = ThermalsData.access$getCompanion$p().sample(this.this$0.getAllSpeedLimits(), sampleSize);
                    return ChartCreator.INSTANCE.createChartUrl(sampleValues, this.$xRange, this.$yRange);
                }
            }));
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                if (!(it.length() < urlCharLimit)) continue;
                break block2;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (String)element$iv2;
    }

    @NotNull
    public final List<ThermLog> component1() {
        return this.logs;
    }

    @NotNull
    public final ThermalsData copy(@NotNull List<ThermLog> logs) {
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        return new ThermalsData(logs);
    }

    public static /* synthetic */ ThermalsData copy$default(ThermalsData thermalsData, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = thermalsData.logs;
        }
        return thermalsData.copy(list);
    }

    @NotNull
    public String toString() {
        return "ThermalsData(logs=" + this.logs + ")";
    }

    public int hashCode() {
        return ((Object)this.logs).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThermalsData)) {
            return false;
        }
        ThermalsData thermalsData = (ThermalsData)other;
        return Intrinsics.areEqual(this.logs, thermalsData.logs);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006*\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lslack/gradle/util/ThermalsData$Companion;", "", "()V", "MINIMUM_CHAR_LIMIT", "", "sample", "", "sampleSize", "slack-plugin"})
    @SourceDebugExtension(value={"SMAP\nThermalsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/ThermalsData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,408:1\n777#2:409\n788#2:410\n1864#2,2:411\n789#2,2:413\n1866#2:415\n791#2:416\n*S KotlinDebug\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/ThermalsData$Companion\n*L\n262#1:409\n262#1:410\n262#1:411,2\n262#1:413,2\n262#1:415\n262#1:416\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Integer> sample(@NotNull List<Integer> $this$sample, int sampleSize) {
            void $this$filterIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$sample, (String)"<this>");
            Iterable $this$filterIndexed$iv = $this$sample;
            boolean $i$f$filterIndexed = false;
            Iterable iterable = $this$filterIndexed$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                ((Number)element$iv$iv).intValue();
                int index = index$iv$iv;
                boolean bl2 = false;
                if (!(index % sampleSize == 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

