/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import slack.gradle.util.ThermLog;
import slack.gradle.util.Thermals;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lslack/gradle/util/ThermlogParser;", "", "()V", "TIMESTAMP_PATTERN", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getTIMESTAMP_PATTERN$slack_plugin", "()Ljava/time/format/DateTimeFormatter;", "parse", "Lslack/gradle/util/Thermals;", "log", "", "parse$slack_plugin", "parseDiagnostic", "", "line", "parseLogs", "", "Lslack/gradle/util/ThermLog;", "parseTimestamp", "Ljava/time/LocalDateTime;", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nThermalsWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThermalsWatcher.kt\nslack/gradle/util/ThermlogParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public final class ThermlogParser {
    @NotNull
    public static final ThermlogParser INSTANCE = new ThermlogParser();
    private static final DateTimeFormatter TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z");

    private ThermlogParser() {
    }

    public final DateTimeFormatter getTIMESTAMP_PATTERN$slack_plugin() {
        return TIMESTAMP_PATTERN;
    }

    @NotNull
    public final Thermals parse$slack_plugin(@NotNull String log) {
        List<ThermLog> list;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)log, (String)"log");
                list = this.parseLogs(log);
                if (list == null) break block2;
                List<ThermLog> list2 = list;
                Thermals.Companion companion = Thermals.Companion;
                List<ThermLog> p0 = list2;
                boolean bl = false;
                Thermals thermals = companion.create(p0);
                list = thermals;
                if (thermals != null) break block3;
            }
            list = Thermals.Empty.INSTANCE;
        }
        return list;
    }

    private final List<ThermLog> parseLogs(String log) {
        List logs = new ArrayList();
        Ref.ObjectRef currentTime = new Ref.ObjectRef();
        Ref.ObjectRef currentScheduler = new Ref.ObjectRef();
        Ref.ObjectRef availableCpus = new Ref.ObjectRef();
        Ref.ObjectRef speedLimit = new Ref.ObjectRef();
        Object object = StringsKt.lineSequence((CharSequence)log).iterator();
        while (object.hasNext()) {
            String line = (String)object.next();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"CPU Power notify", (boolean)false, (int)2, null)) {
                LocalDateTime localDateTime;
                ThermlogParser.parseLogs$flush((Ref.ObjectRef<LocalDateTime>)currentTime, (Ref.ObjectRef<Integer>)currentScheduler, (Ref.ObjectRef<Integer>)availableCpus, (Ref.ObjectRef<Integer>)speedLimit, logs);
                currentTime.element = null;
                currentScheduler.element = null;
                availableCpus.element = null;
                speedLimit.element = null;
                try {
                    localDateTime = this.parseTimestamp(line);
                }
                catch (DateTimeParseException e) {
                    localDateTime = null;
                }
                LocalDateTime localCurrentTime = localDateTime;
                currentTime.element = localCurrentTime;
                continue;
            }
            if (currentTime.element != null && currentScheduler.element == null && StringsKt.contains$default((CharSequence)line, (CharSequence)"CPU_Scheduler_Limit", (boolean)false, (int)2, null)) {
                currentScheduler.element = this.parseDiagnostic(line);
                continue;
            }
            if (currentTime.element != null && availableCpus.element == null && StringsKt.contains$default((CharSequence)line, (CharSequence)"CPU_Available_CPUs", (boolean)false, (int)2, null)) {
                availableCpus.element = this.parseDiagnostic(line);
                continue;
            }
            if (currentTime.element == null || speedLimit.element != null || !StringsKt.contains$default((CharSequence)line, (CharSequence)"CPU_Speed_Limit", (boolean)false, (int)2, null)) continue;
            speedLimit.element = this.parseDiagnostic(line);
        }
        ThermlogParser.parseLogs$flush((Ref.ObjectRef<LocalDateTime>)currentTime, (Ref.ObjectRef<Integer>)currentScheduler, (Ref.ObjectRef<Integer>)availableCpus, (Ref.ObjectRef<Integer>)speedLimit, logs);
        Object it = object = logs;
        boolean bl = false;
        return !((Collection)it).isEmpty() ? object : null;
    }

    private final int parseDiagnostic(String line) {
        return Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)"=", null, (int)2, null))).toString());
    }

    private final LocalDateTime parseTimestamp(String line) throws DateTimeParseException {
        LocalDateTime localDateTime = LocalDateTime.parse(((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)line, (String)"CPU", null, (int)2, null))).toString(), TIMESTAMP_PATTERN);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
        return localDateTime;
    }

    private static final void parseLogs$flush(Ref.ObjectRef<LocalDateTime> currentTime, Ref.ObjectRef<Integer> currentScheduler, Ref.ObjectRef<Integer> availableCpus, Ref.ObjectRef<Integer> speedLimit, List<ThermLog> logs) {
        LocalDateTime prevCurrentTime = (LocalDateTime)currentTime.element;
        Integer prevCurrentScheduler = (Integer)currentScheduler.element;
        Integer prevAvailableCpus = (Integer)availableCpus.element;
        Integer prevSpeedLimit = (Integer)speedLimit.element;
        if (prevCurrentTime != null && prevCurrentScheduler != null && prevAvailableCpus != null && prevSpeedLimit != null) {
            ((Collection)logs).add(new ThermLog(prevCurrentTime, prevCurrentScheduler, prevAvailableCpus, prevSpeedLimit));
        }
    }
}

