/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util.charting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import slack.gradle.util.charting.AxisRange;
import slack.gradle.util.charting.AxisStyle;
import slack.gradle.util.charting.ChartData;
import slack.gradle.util.charting.ChartFill;
import slack.gradle.util.charting.ChartProperty;
import slack.gradle.util.charting.ChartPropertyKt;
import slack.gradle.util.charting.ChartSize;
import slack.gradle.util.charting.ChartType;
import slack.gradle.util.charting.Color;
import slack.gradle.util.charting.ColorRange;
import slack.gradle.util.charting.SeriesColors;
import slack.gradle.util.charting.VisibleAxis;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lslack/gradle/util/charting/ChartCreator;", "", "()V", "GREEN", "Lslack/gradle/util/charting/Color;", "RED", "YELLOW", "colorForValue", "value", "", "createChartUrl", "", "data", "", "xRange", "Lkotlin/ranges/IntRange;", "yRange", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nChartCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartCreator.kt\nslack/gradle/util/charting/ChartCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1864#3,3:96\n*S KotlinDebug\n*F\n+ 1 ChartCreator.kt\nslack/gradle/util/charting/ChartCreator\n*L\n50#1:96,3\n*E\n"})
public final class ChartCreator {
    @NotNull
    public static final ChartCreator INSTANCE = new ChartCreator();
    @NotNull
    private static final Color RED = new Color(16279914);
    @NotNull
    private static final Color YELLOW = new Color(16705411);
    @NotNull
    private static final Color GREEN = new Color(7717756);

    private ChartCreator() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createChartUrl(@NotNull List<Integer> data, @NotNull IntRange xRange, @NotNull IntRange yRange) {
        List list;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        if (!(!((Collection)data).isEmpty())) {
            boolean $i$a$-check-ChartCreator$createChartUrl$22 = false;
            String $i$a$-check-ChartCreator$createChartUrl$22 = "Empty data!";
            throw new IllegalStateException($i$a$-check-ChartCreator$createChartUrl$22.toString());
        }
        Color currentColor = null;
        currentColor = this.colorForValue(((Number)CollectionsKt.first(data)).intValue());
        List colorRanges = new ArrayList();
        int startIndex = 0;
        Iterable $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl = false;
            Color color = INSTANCE.colorForValue((int)value2);
            if (Intrinsics.areEqual((Object)currentColor, (Object)color)) continue;
            ((Collection)colorRanges).add(new ColorRange(currentColor, startIndex, index - 1));
            currentColor = color;
            startIndex = index - 1;
        }
        ((Collection)colorRanges).add(new ColorRange(currentColor, startIndex, data.size() - 1));
        List $this$createChartUrl_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createChartUrl_u24lambda_u242.add(ChartType.LineChart.INSTANCE);
        $this$createChartUrl_u24lambda_u242.add(new ChartSize(1000, 300));
        $this$createChartUrl_u24lambda_u242.add(new ChartFill(ChartFill.FillType.BACKGROUND, Color.Companion.getBLACK()));
        $this$createChartUrl_u24lambda_u242.add(VisibleAxis.XAxis.INSTANCE.plus(VisibleAxis.YAxis.INSTANCE));
        $this$createChartUrl_u24lambda_u242.add(new AxisStyle(0, Color.Companion.getWHITE()).plus(new AxisStyle(1, Color.Companion.getWHITE())));
        $this$createChartUrl_u24lambda_u242.add(new AxisRange(0, xRange.getFirst(), xRange.getLast()).plus(new AxisRange(1, yRange.getFirst(), yRange.getLast())));
        $this$createChartUrl_u24lambda_u242.add(new ChartData.SimpleData(data, 0, 2, null));
        $this$createChartUrl_u24lambda_u242.add(new SeriesColors(Color.Companion.getWHITE()));
        $this$createChartUrl_u24lambda_u242.add(ChartPropertyKt.collapse(colorRanges));
        List chartProperties = CollectionsKt.build((List)list);
        List $this$createChartUrl_u24lambda_u243 = list = new HttpUrl.Builder().scheme("https").host("chart.googleapis.com").addPathSegment("chart");
        boolean bl2 = false;
        for (ChartProperty prop : chartProperties) {
            $this$createChartUrl_u24lambda_u243.addQueryParameter(prop.getKey(), prop.getValue());
        }
        return list.build().toString();
    }

    public static /* synthetic */ String createChartUrl$default(ChartCreator chartCreator, List list, IntRange intRange, IntRange intRange2, int n, Object object) {
        if ((n & 2) != 0) {
            intRange = new IntRange(1, list.size());
        }
        if ((n & 4) != 0) {
            Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)list);
            intRange2 = new IntRange(0, n2 != null ? n2 : 0);
        }
        return chartCreator.createChartUrl(list, intRange, intRange2);
    }

    private final Color colorForValue(int value2) {
        return value2 <= 70 ? RED : (value2 <= 90 ? YELLOW : GREEN);
    }
}

