/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util.charting;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.util.charting.ChartProperty;
import slack.gradle.util.charting.ValuesEncoder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lslack/gradle/util/charting/ChartData;", "Lslack/gradle/util/charting/ChartProperty;", "()V", "key", "", "getKey", "()Ljava/lang/String;", "SimpleData", "TimeSeriesData", "Lslack/gradle/util/charting/ChartData$SimpleData;", "Lslack/gradle/util/charting/ChartData$TimeSeriesData;", "slack-plugin"})
public abstract class ChartData
implements ChartProperty {
    @NotNull
    private final String key;

    private ChartData() {
        this.key = "chd";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public /* synthetic */ ChartData(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lslack/gradle/util/charting/ChartData$SimpleData;", "Lslack/gradle/util/charting/ChartData;", "data", "", "", "maxValue", "(Ljava/util/List;I)V", "getData", "()Ljava/util/List;", "getMaxValue", "()I", "value", "", "getValue", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "slack-plugin"})
    public static final class SimpleData
    extends ChartData {
        @NotNull
        private final List<Integer> data;
        private final int maxValue;

        public SimpleData(@NotNull List<Integer> data, int maxValue) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            super(null);
            this.data = data;
            this.maxValue = maxValue;
        }

        public /* synthetic */ SimpleData(List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                Integer n3 = (Integer)CollectionsKt.maxOrNull((Iterable)list);
                n = n3 != null ? n3 : 0;
            }
            this(list, n);
        }

        @NotNull
        public final List<Integer> getData() {
            return this.data;
        }

        public final int getMaxValue() {
            return this.maxValue;
        }

        @Override
        @NotNull
        public String getValue() {
            return ValuesEncoder.INSTANCE.encodeExtendedSeries(this.data, this.maxValue);
        }

        @NotNull
        public final List<Integer> component1() {
            return this.data;
        }

        public final int component2() {
            return this.maxValue;
        }

        @NotNull
        public final SimpleData copy(@NotNull List<Integer> data, int maxValue) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new SimpleData(data, maxValue);
        }

        public static /* synthetic */ SimpleData copy$default(SimpleData simpleData, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = simpleData.data;
            }
            if ((n2 & 2) != 0) {
                n = simpleData.maxValue;
            }
            return simpleData.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "SimpleData(data=" + this.data + ", maxValue=" + this.maxValue + ")";
        }

        public int hashCode() {
            int result = ((Object)this.data).hashCode();
            result = result * 31 + Integer.hashCode(this.maxValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimpleData)) {
                return false;
            }
            SimpleData simpleData = (SimpleData)other;
            if (!Intrinsics.areEqual(this.data, simpleData.data)) {
                return false;
            }
            return this.maxValue == simpleData.maxValue;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\tH\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lslack/gradle/util/charting/ChartData$TimeSeriesData;", "Lslack/gradle/util/charting/ChartData;", "data", "", "", "(Ljava/util/Map;)V", "getData", "()Ljava/util/Map;", "value", "", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "slack-plugin"})
    public static final class TimeSeriesData
    extends ChartData {
        @NotNull
        private final Map<Integer, Integer> data;

        public TimeSeriesData(@NotNull Map<Integer, Integer> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            super(null);
            this.data = data;
        }

        @NotNull
        public final Map<Integer, Integer> getData() {
            return this.data;
        }

        @Override
        @NotNull
        public String getValue() {
            return ValuesEncoder.INSTANCE.encodePositionSeries(this.data);
        }

        @NotNull
        public final Map<Integer, Integer> component1() {
            return this.data;
        }

        @NotNull
        public final TimeSeriesData copy(@NotNull Map<Integer, Integer> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new TimeSeriesData(data);
        }

        public static /* synthetic */ TimeSeriesData copy$default(TimeSeriesData timeSeriesData, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = timeSeriesData.data;
            }
            return timeSeriesData.copy(map);
        }

        @NotNull
        public String toString() {
            return "TimeSeriesData(data=" + this.data + ")";
        }

        public int hashCode() {
            return ((Object)this.data).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimeSeriesData)) {
                return false;
            }
            TimeSeriesData timeSeriesData = (TimeSeriesData)other;
            return Intrinsics.areEqual(this.data, timeSeriesData.data);
        }
    }
}

