/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util.charting;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lslack/gradle/util/charting/Color;", "", "value", "", "(I)V", "hex", "", "(Ljava/lang/String;)V", "getHex", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "slack-plugin"})
public final class Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hex;
    @NotNull
    private static final Color BLACK = new Color(0);
    @NotNull
    private static final Color WHITE = new Color(0xFFFFFF);

    public Color(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        this.hex = hex;
    }

    @NotNull
    public final String getHex() {
        return this.hex;
    }

    public Color(int value2) {
        String string = "%06X";
        Object[] objectArray = new Object[]{0xFFFFFF & value2};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this(string2);
    }

    @NotNull
    public final String component1() {
        return this.hex;
    }

    @NotNull
    public final Color copy(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return new Color(hex);
    }

    public static /* synthetic */ Color copy$default(Color color, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = color.hex;
        }
        return color.copy(string);
    }

    @NotNull
    public String toString() {
        return "Color(hex=" + this.hex + ")";
    }

    public int hashCode() {
        return this.hex.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Color)) {
            return false;
        }
        Color color = (Color)other;
        return Intrinsics.areEqual((Object)this.hex, (Object)color.hex);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lslack/gradle/util/charting/Color$Companion;", "", "()V", "BLACK", "Lslack/gradle/util/charting/Color;", "getBLACK", "()Lslack/gradle/util/charting/Color;", "WHITE", "getWHITE", "slack-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getBLACK() {
            return BLACK;
        }

        @NotNull
        public final Color getWHITE() {
            return WHITE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

