/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util.charting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import slack.gradle.util.charting.ChartPropertyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\b\u0002\u0010\n\u001a\u00020\u0006J\u001a\u0010\u000b\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lslack/gradle/util/charting/ValuesEncoder;", "", "()V", "EXTENDED_MAP", "", "EXTENDED_MAP_LENGTH", "", "encodeExtendedSeries", "data", "", "maxValue", "encodePositionSeries", "", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nValuesEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValuesEncoder.kt\nslack/gradle/util/charting/ValuesEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n1855#2,2:70\n215#3,2:72\n*S KotlinDebug\n*F\n+ 1 ValuesEncoder.kt\nslack/gradle/util/charting/ValuesEncoder\n*L\n32#1:70,2\n56#1:72,2\n*E\n"})
public final class ValuesEncoder {
    @NotNull
    public static final ValuesEncoder INSTANCE = new ValuesEncoder();
    @NotNull
    private static final String EXTENDED_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.";
    private static final int EXTENDED_MAP_LENGTH = 64;

    private ValuesEncoder() {
    }

    @NotNull
    public final String encodeExtendedSeries(@NotNull List<Integer> data, int maxValue) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object chartData = null;
        chartData = "e:";
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int numericVal = ((Number)element$iv).intValue();
            boolean bl = false;
            float scaledVal = (float)Math.floor((float)4096 * ((float)numericVal / (float)maxValue));
            if (scaledVal > 4095.0f) {
                chartData = chartData + "..";
                continue;
            }
            if (scaledVal < 0.0f) {
                chartData = chartData + "__";
                continue;
            }
            int quotient = (int)Math.floor(scaledVal / (float)64);
            int remainder = (int)(scaledVal - (float)(64 * quotient));
            chartData = "" + chartData + EXTENDED_MAP.charAt(quotient) + EXTENDED_MAP.charAt(remainder);
        }
        return chartData;
    }

    public static /* synthetic */ String encodeExtendedSeries$default(ValuesEncoder valuesEncoder, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            Integer n3 = (Integer)CollectionsKt.maxOrNull((Iterable)list);
            n = n3 != null ? n3 : 0;
        }
        return valuesEncoder.encodeExtendedSeries(list, n);
    }

    @NotNull
    public final String encodePositionSeries(@NotNull Map<Integer, Integer> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        List xValues = new ArrayList();
        List yValues = new ArrayList();
        Map<Integer, Integer> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> element$iv;
            Map.Entry<Integer, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            int key = ((Number)entry.getKey()).intValue();
            int value2 = ((Number)entry.getValue()).intValue();
            Integer n = key;
            ((Collection)xValues).add(n);
            n = value2;
            ((Collection)yValues).add(n);
        }
        String[] stringArray = new String[]{CollectionsKt.joinToString$default((Iterable)xValues, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), CollectionsKt.joinToString$default((Iterable)yValues, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
        return "t:" + ChartPropertyKt.multiline(stringArray);
    }
}

