/*
 * Decompiled with CFR 0.152.
 */
package slack.gradle.util.charting;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.util.charting.ChartProperty;
import slack.gradle.util.charting.VisibleAxis;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0096\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lslack/gradle/util/charting/VisibleAxis;", "Lslack/gradle/util/charting/ChartProperty;", "()V", "key", "", "getKey", "()Ljava/lang/String;", "plus", "axis", "MultipleVisibleAxes", "RAxis", "TAxis", "XAxis", "YAxis", "Lslack/gradle/util/charting/VisibleAxis$MultipleVisibleAxes;", "Lslack/gradle/util/charting/VisibleAxis$RAxis;", "Lslack/gradle/util/charting/VisibleAxis$TAxis;", "Lslack/gradle/util/charting/VisibleAxis$XAxis;", "Lslack/gradle/util/charting/VisibleAxis$YAxis;", "slack-plugin"})
public abstract class VisibleAxis
implements ChartProperty {
    @NotNull
    private final String key;

    private VisibleAxis() {
        this.key = "chxt";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public VisibleAxis plus(@NotNull VisibleAxis axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Object[] objectArray = new VisibleAxis[]{this, axis};
        return new MultipleVisibleAxes(SetsKt.setOf((Object[])objectArray));
    }

    public /* synthetic */ VisibleAxis(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c2\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0011\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lslack/gradle/util/charting/VisibleAxis$MultipleVisibleAxes;", "Lslack/gradle/util/charting/VisibleAxis;", "axes", "", "(Ljava/util/Set;)V", "value", "", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "plus", "axis", "toString", "slack-plugin"})
    private static final class MultipleVisibleAxes
    extends VisibleAxis {
        @NotNull
        private final Set<VisibleAxis> axes;
        @NotNull
        private final String value;

        public MultipleVisibleAxes(@NotNull Set<? extends VisibleAxis> axes) {
            Intrinsics.checkNotNullParameter(axes, (String)"axes");
            super(null);
            this.axes = axes;
            this.value = CollectionsKt.joinToString$default((Iterable)this.axes, (CharSequence)",", null, null, (int)0, null, (Function1)value.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public VisibleAxis plus(@NotNull VisibleAxis axis) {
            Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
            return new MultipleVisibleAxes(SetsKt.plus(this.axes, (Object)axis));
        }

        private final Set<VisibleAxis> component1() {
            return this.axes;
        }

        @NotNull
        public final MultipleVisibleAxes copy(@NotNull Set<? extends VisibleAxis> axes) {
            Intrinsics.checkNotNullParameter(axes, (String)"axes");
            return new MultipleVisibleAxes(axes);
        }

        public static /* synthetic */ MultipleVisibleAxes copy$default(MultipleVisibleAxes multipleVisibleAxes, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = multipleVisibleAxes.axes;
            }
            return multipleVisibleAxes.copy(set);
        }

        @NotNull
        public String toString() {
            return "MultipleVisibleAxes(axes=" + this.axes + ")";
        }

        public int hashCode() {
            return ((Object)this.axes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MultipleVisibleAxes)) {
                return false;
            }
            MultipleVisibleAxes multipleVisibleAxes = (MultipleVisibleAxes)other;
            return Intrinsics.areEqual(this.axes, multipleVisibleAxes.axes);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lslack/gradle/util/charting/VisibleAxis$RAxis;", "Lslack/gradle/util/charting/VisibleAxis;", "()V", "value", "", "getValue", "()Ljava/lang/String;", "slack-plugin"})
    public static final class RAxis
    extends VisibleAxis {
        @NotNull
        public static final RAxis INSTANCE = new RAxis();
        @NotNull
        private static final String value = "r";

        private RAxis() {
            super(null);
        }

        @Override
        @NotNull
        public String getValue() {
            return value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lslack/gradle/util/charting/VisibleAxis$TAxis;", "Lslack/gradle/util/charting/VisibleAxis;", "()V", "value", "", "getValue", "()Ljava/lang/String;", "slack-plugin"})
    public static final class TAxis
    extends VisibleAxis {
        @NotNull
        public static final TAxis INSTANCE = new TAxis();
        @NotNull
        private static final String value = "t";

        private TAxis() {
            super(null);
        }

        @Override
        @NotNull
        public String getValue() {
            return value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lslack/gradle/util/charting/VisibleAxis$XAxis;", "Lslack/gradle/util/charting/VisibleAxis;", "()V", "value", "", "getValue", "()Ljava/lang/String;", "slack-plugin"})
    public static final class XAxis
    extends VisibleAxis {
        @NotNull
        public static final XAxis INSTANCE = new XAxis();
        @NotNull
        private static final String value = "x";

        private XAxis() {
            super(null);
        }

        @Override
        @NotNull
        public String getValue() {
            return value;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lslack/gradle/util/charting/VisibleAxis$YAxis;", "Lslack/gradle/util/charting/VisibleAxis;", "()V", "value", "", "getValue", "()Ljava/lang/String;", "slack-plugin"})
    public static final class YAxis
    extends VisibleAxis {
        @NotNull
        public static final YAxis INSTANCE = new YAxis();
        @NotNull
        private static final String value = "y";

        private YAxis() {
            super(null);
        }

        @Override
        @NotNull
        public String getValue() {
            return value;
        }
    }
}

