/*
 * Decompiled with CFR 0.152.
 */
package slack.stats;

import com.squareup.moshi.JsonClass;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.stats.LanguageStats;
import slack.stats.LanguageStatsKt;

@JsonClass(generateAdapter=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J_\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\""}, d2={"Lslack/stats/ModuleStats;", "", "modulePath", "", "source", "", "Lslack/stats/LanguageStats;", "generated", "tags", "", "deps", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;)V", "getDeps", "()Ljava/util/Set;", "getGenerated", "()Ljava/util/Map;", "getModulePath", "()Ljava/lang/String;", "getSource", "getTags", "totalSource", "getTotalSource", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "slack-plugin"})
public final class ModuleStats {
    @NotNull
    private final String modulePath;
    @NotNull
    private final Map<String, LanguageStats> source;
    @NotNull
    private final Map<String, LanguageStats> generated;
    @NotNull
    private final Set<String> tags;
    @NotNull
    private final Set<String> deps;

    public ModuleStats(@NotNull String modulePath, @NotNull Map<String, LanguageStats> source2, @NotNull Map<String, LanguageStats> generated, @NotNull Set<String> tags, @NotNull Set<String> deps) {
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter(source2, (String)"source");
        Intrinsics.checkNotNullParameter(generated, (String)"generated");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        this.modulePath = modulePath;
        this.source = source2;
        this.generated = generated;
        this.tags = tags;
        this.deps = deps;
    }

    @NotNull
    public final String getModulePath() {
        return this.modulePath;
    }

    @NotNull
    public final Map<String, LanguageStats> getSource() {
        return this.source;
    }

    @NotNull
    public final Map<String, LanguageStats> getGenerated() {
        return this.generated;
    }

    @NotNull
    public final Set<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final Set<String> getDeps() {
        return this.deps;
    }

    @NotNull
    public final Map<String, LanguageStats> getTotalSource() {
        return LanguageStatsKt.mergeWith(this.source, this.generated);
    }

    @NotNull
    public final String component1() {
        return this.modulePath;
    }

    @NotNull
    public final Map<String, LanguageStats> component2() {
        return this.source;
    }

    @NotNull
    public final Map<String, LanguageStats> component3() {
        return this.generated;
    }

    @NotNull
    public final Set<String> component4() {
        return this.tags;
    }

    @NotNull
    public final Set<String> component5() {
        return this.deps;
    }

    @NotNull
    public final ModuleStats copy(@NotNull String modulePath, @NotNull Map<String, LanguageStats> source2, @NotNull Map<String, LanguageStats> generated, @NotNull Set<String> tags, @NotNull Set<String> deps) {
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter(source2, (String)"source");
        Intrinsics.checkNotNullParameter(generated, (String)"generated");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        return new ModuleStats(modulePath, source2, generated, tags, deps);
    }

    public static /* synthetic */ ModuleStats copy$default(ModuleStats moduleStats, String string, Map map, Map map2, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            string = moduleStats.modulePath;
        }
        if ((n & 2) != 0) {
            map = moduleStats.source;
        }
        if ((n & 4) != 0) {
            map2 = moduleStats.generated;
        }
        if ((n & 8) != 0) {
            set = moduleStats.tags;
        }
        if ((n & 0x10) != 0) {
            set2 = moduleStats.deps;
        }
        return moduleStats.copy(string, map, map2, set, set2);
    }

    @NotNull
    public String toString() {
        return "ModuleStats(modulePath=" + this.modulePath + ", source=" + this.source + ", generated=" + this.generated + ", tags=" + this.tags + ", deps=" + this.deps + ")";
    }

    public int hashCode() {
        int result = this.modulePath.hashCode();
        result = result * 31 + ((Object)this.source).hashCode();
        result = result * 31 + ((Object)this.generated).hashCode();
        result = result * 31 + ((Object)this.tags).hashCode();
        result = result * 31 + ((Object)this.deps).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModuleStats)) {
            return false;
        }
        ModuleStats moduleStats = (ModuleStats)other;
        if (!Intrinsics.areEqual((Object)this.modulePath, (Object)moduleStats.modulePath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.source, moduleStats.source)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.generated, moduleStats.generated)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, moduleStats.tags)) {
            return false;
        }
        return Intrinsics.areEqual(this.deps, moduleStats.deps);
    }
}

