/*
 * Decompiled with CFR 0.152.
 */
package slack.stats;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.Graph;
import org.jgrapht.alg.scoring.BetweennessCentrality;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedAcyclicGraph;
import slack.gradle.util.JsonTools;
import slack.stats.AggregateModuleScore;
import slack.stats.LanguageStats;
import slack.stats.LanguageStatsKt;
import slack.stats.ModuleScore;
import slack.stats.ModuleStats;
import slack.stats.ModuleStatsKt;
import slack.stats.Weights;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u0017R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lslack/stats/ModuleStatsAggregatorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "includeGenerated", "Lorg/gradle/api/provider/Property;", "", "getIncludeGenerated$slack_plugin", "()Lorg/gradle/api/provider/Property;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "projectPathsToAccessors", "Lorg/gradle/api/provider/MapProperty;", "", "getProjectPathsToAccessors$slack_plugin", "()Lorg/gradle/api/provider/MapProperty;", "statsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getStatsFiles$slack_plugin", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "dumpStats", "", "dumpStats$slack_plugin", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nModuleStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleStats.kt\nslack/stats/ModuleStatsAggregatorTask\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,596:1\n29#2:597\n29#2:629\n1549#3:598\n1620#3,2:599\n1622#3:602\n1045#3:603\n1549#3:604\n1620#3,3:605\n2661#3,7:608\n1179#3,2:615\n1253#3,2:617\n1549#3:619\n1620#3,3:620\n1256#3:623\n1549#3:624\n1620#3,3:625\n1054#3:628\n1#4:601\n*S KotlinDebug\n*F\n+ 1 ModuleStats.kt\nslack/stats/ModuleStatsAggregatorTask\n*L\n315#1:597\n362#1:629\n317#1:598\n317#1:599,2\n317#1:602\n317#1:603\n319#1:604\n319#1:605,3\n319#1:608,7\n323#1:615,2\n323#1:617,2\n324#1:619\n324#1:620,3\n323#1:623\n352#1:624\n352#1:625,3\n358#1:628\n*E\n"})
public abstract class ModuleStatsAggregatorTask
extends DefaultTask {
    public ModuleStatsAggregatorTask() {
        this.setGroup("slack");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    @SkipWhenEmpty
    @NotNull
    public abstract ConfigurableFileCollection getStatsFiles$slack_plugin();

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeGenerated$slack_plugin();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getProjectPathsToAccessors$slack_plugin();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void dumpStats$slack_plugin() {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object subproject;
        void $this$associateTo$iv$iv;
        Object p0;
        void $this$reduce$iv;
        void $this$mapTo$iv$iv2;
        Object p022;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Moshi moshi2 = JsonTools.INSTANCE.getMOSHI();
        Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"<get-MOSHI>(...)");
        Moshi $this$adapter$iv = moshi2;
        boolean $i$f$adapter = false;
        JsonAdapter adapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(ModuleStats.class));
        Iterable $this$map$iv2 = (Iterable)this.getStatsFiles$slack_plugin();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Object object;
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((File)it));
            Throwable throwable = null;
            try {
                p022 = (BufferedSource)closeable;
                boolean bl2 = false;
                p022 = (ModuleStats)adapter.fromJson((BufferedSource)p022);
                object = p022;
            }
            catch (Throwable p022) {
                throwable = p022;
                throw p022;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNull((Object)object);
            collection.add(object);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List allStats = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleStats it = (ModuleStats)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getModulePath());
                it = (ModuleStats)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getModulePath())));
            }
        });
        Iterable $this$map$iv3 = allStats;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ModuleStats bl = (ModuleStats)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it.getTotalSource());
        }
        $this$map$iv3 = (List)destination$iv$iv2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            Map $i$f$mapTo22 = (Map)iterator$iv.next();
            p0 = (Map)accumulator$iv;
            boolean bl = false;
            accumulator$iv = LanguageStatsKt.mergeWith((Map<String, LanguageStats>)p0, (Map<String, LanguageStats>)p1);
        }
        Map globalStats = (Map)accumulator$iv;
        Object object = this.getProjectPathsToAccessors$slack_plugin().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map projectAccessorsMapping = (Map)object;
        Iterable $this$associate$iv = allStats;
        boolean $i$f$associate = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        p0 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv4;
            void $this$map$iv4;
            p022 = destination$iv$iv3;
            ModuleStats stats = (ModuleStats)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = stats.getDeps();
            String string = stats.getModulePath();
            boolean $i$f$map3 = false;
            void var20_57 = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv4;
                boolean bl4 = false;
                collection2.add((String)MapsKt.getValue((Map)projectAccessorsMapping, (Object)it));
            }
            stats = TuplesKt.to((Object)string, (Object)((List)destination$iv$iv4));
            p022.put(stats.getFirst(), stats.getSecond());
        }
        Map shallowProjectDeps = destination$iv$iv3;
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph(DefaultEdge.class);
        for (Map.Entry capacity$iv2 : shallowProjectDeps.entrySet()) {
            subproject = (String)capacity$iv2.getKey();
            List dependencies2 = (List)capacity$iv2.getValue();
            graph.addVertex(subproject);
            for (String dependency : dependencies2) {
                graph.addVertex((Object)dependency);
                try {
                    graph.addEdge(subproject, (Object)dependency);
                }
                catch (IllegalArgumentException e) {
                    if (StringsKt.contains$default((CharSequence)((CharSequence)subproject), (CharSequence)"model", (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNull((Object)dependency);
                        if (StringsKt.contains$default((CharSequence)dependency, (CharSequence)"model", (boolean)false, (int)2, null)) continue;
                    }
                    throw new RuntimeException("Cycle from " + (String)subproject + " to " + dependency + ". Please modularize this better!", e);
                }
            }
        }
        Map centralities = new BetweennessCentrality((Graph)graph).getScores();
        subproject = allStats;
        boolean $i$f$map4 = false;
        void $i$f$associateTo22 = $this$map$iv;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModuleStats bl = (ModuleStats)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)centralities);
            Double centrality = (Double)MapsKt.getValue((Map)centralities, (Object)it.getModulePath());
            Intrinsics.checkNotNull((Object)it);
            Intrinsics.checkNotNull((Object)centrality);
            Weights weights = ModuleStatsKt.access$weighted((ModuleStats)it, globalStats, centrality);
            long score = weights.score();
            String string = it.getModulePath();
            Object object2 = this.getIncludeGenerated$slack_plugin().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            collection.add(new ModuleScore(string, score, weights, (Boolean)object2));
        }
        $this$map$iv = (List)destination$iv$iv5;
        boolean $i$f$sortedByDescending = false;
        List scores = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleScore it = (ModuleScore)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getScore());
                it = (ModuleScore)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getScore()));
            }
        });
        this.getLogger().debug("Scores are " + CollectionsKt.joinToString$default((Iterable)scores, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Object object3 = this.getOutputFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)((File)object3), (boolean)false, (int)1, null));
        Throwable throwable = null;
        try {
            BufferedSink sink = (BufferedSink)closeable;
            boolean bl = false;
            Moshi moshi3 = JsonTools.INSTANCE.getMOSHI();
            Intrinsics.checkNotNullExpressionValue((Object)moshi3, (String)"<get-MOSHI>(...)");
            Moshi $this$adapter$iv2 = moshi3;
            boolean $i$f$adapter2 = false;
            _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv2, (KType)Reflection.typeOf(AggregateModuleScore.class)).toJson(sink, (Object)new AggregateModuleScore(scores));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

