/*
 * Decompiled with CFR 0.152.
 */
package slack.stats;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import slack.gradle.util.JsonTools;
import slack.stats.LanguageStats;
import slack.stats.LocTask;
import slack.stats.ModuleStats;
import slack.stats.StatsUtils;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lslack/stats/ModuleStatsCollectorTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "buildFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildFileProperty", "()Lorg/gradle/api/file/RegularFileProperty;", "includeGenerated", "Lorg/gradle/api/provider/Property;", "", "getIncludeGenerated", "()Lorg/gradle/api/provider/Property;", "locDataFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLocDataFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "modulePath", "", "getModulePath", "outputFile", "getOutputFile", "tags", "Lorg/gradle/api/provider/SetProperty;", "getTags", "()Lorg/gradle/api/provider/SetProperty;", "dumpStats", "", "Companion", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nModuleStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleStats.kt\nslack/stats/ModuleStatsCollectorTask\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,596:1\n29#2:597\n29#2:598\n*S KotlinDebug\n*F\n+ 1 ModuleStats.kt\nslack/stats/ModuleStatsCollectorTask\n*L\n414#1:597\n424#1:598\n*E\n"})
public abstract class ModuleStatsCollectorTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigurableFileCollection locDataFiles;
    @NotNull
    public static final String TAG_KAPT = "kapt";
    @NotNull
    public static final String TAG_KSP = "ksp";
    @NotNull
    public static final String TAG_KOTLIN = "kotlin";
    @NotNull
    public static final String TAG_DAGGER_COMPILER = "dagger-compiler";
    @NotNull
    public static final String TAG_VIEW_BINDING = "viewbinding";
    @NotNull
    public static final String TAG_ANDROID = "android";
    @NotNull
    public static final String TAG_WIRE = "wire";
    @NotNull
    public static final String TAG_SQLDELIGHT = "sqldelight";
    @NotNull
    public static final String TAG_RESOURCES_ENABLED = "android-resources";
    @NotNull
    public static final String TAG_PARCELIZE = "android-parcelize";
    @NotNull
    public static final String TAG_VARIANTS = "android-variants";

    @Inject
    public ModuleStatsCollectorTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        ConfigurableFileCollection configurableFileCollection = objects.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.locDataFiles = configurableFileCollection;
        this.setGroup("slack");
    }

    @Input
    @NotNull
    public abstract Property<String> getModulePath();

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeGenerated();

    @Input
    @NotNull
    public abstract SetProperty<String> getTags();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildFileProperty();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getLocDataFiles() {
        return this.locDataFiles;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void dumpStats() {
        LocTask.LocData locData;
        Set set = this.locDataFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Set locSrcFiles = set;
        if (!((Collection)locSrcFiles).isEmpty()) {
            File file = this.locDataFiles.getSingleFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSingleFile(...)");
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((File)file));
            Throwable throwable = null;
            try {
                Object it = (BufferedSource)closeable;
                boolean bl = false;
                Moshi moshi2 = JsonTools.INSTANCE.getMOSHI();
                Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"<get-MOSHI>(...)");
                Moshi $this$adapter$iv = moshi2;
                boolean $i$f$adapter = false;
                Object object = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(LocTask.LocData.class)).fromJson(it);
                Intrinsics.checkNotNull((Object)object);
                it = (LocTask.LocData)object;
                locData = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            locData = LocTask.LocData.Companion.getEMPTY();
        }
        LocTask.LocData locData2 = locData;
        Map<String, LanguageStats> sources = locData2.component1();
        Map<String, LanguageStats> generatedSources = locData2.component2();
        Object object = this.getBuildFileProperty().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Set<String> dependencies2 = StatsUtils.INSTANCE.parseProjectDeps((File)object);
        this.getLogger().debug("Writing stats to " + this.getOutputFile().getAsFile().get());
        Object object2 = this.getOutputFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)((File)object2), (boolean)false, (int)1, null));
        Throwable throwable = null;
        try {
            BufferedSink sink = (BufferedSink)closeable;
            boolean bl = false;
            Moshi moshi3 = JsonTools.INSTANCE.getMOSHI();
            Intrinsics.checkNotNullExpressionValue((Object)moshi3, (String)"<get-MOSHI>(...)");
            Moshi $this$adapter$iv = moshi3;
            boolean $i$f$adapter = false;
            JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(ModuleStats.class));
            Object object3 = this.getModulePath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            String string = (String)object3;
            Object object4 = this.getTags().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            jsonAdapter.toJson(sink, (Object)new ModuleStats(string, sources, generatedSources, (Set)object4, dependencies2));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lslack/stats/ModuleStatsCollectorTask$Companion;", "", "()V", "TAG_ANDROID", "", "TAG_DAGGER_COMPILER", "TAG_KAPT", "TAG_KOTLIN", "TAG_KSP", "TAG_PARCELIZE", "TAG_RESOURCES_ENABLED", "TAG_SQLDELIGHT", "TAG_VARIANTS", "TAG_VIEW_BINDING", "TAG_WIRE", "slack-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

