/*
 * Decompiled with CFR 0.152.
 */
package slack.stats;

import com.squareup.moshi.JsonClass;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003JU\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0007H\u00d6\u0001J\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lslack/stats/Weights;", "", "percentOfTotalCode", "", "javaKotlinRatio", "centrality", "loc", "", "locGenerated", "tags", "", "", "modulePath", "(DDDIILjava/util/Set;Ljava/lang/String;)V", "getCentrality", "()D", "getJavaKotlinRatio", "getLoc", "()I", "getLocGenerated", "getModulePath", "()Ljava/lang/String;", "getPercentOfTotalCode", "getTags", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "score", "", "toString", "slack-plugin"})
public final class Weights {
    private final double percentOfTotalCode;
    private final double javaKotlinRatio;
    private final double centrality;
    private final int loc;
    private final int locGenerated;
    @NotNull
    private final Set<String> tags;
    @NotNull
    private final String modulePath;

    public Weights(double percentOfTotalCode, double javaKotlinRatio, double centrality, int loc, int locGenerated, @NotNull Set<String> tags, @NotNull String modulePath) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        this.percentOfTotalCode = percentOfTotalCode;
        this.javaKotlinRatio = javaKotlinRatio;
        this.centrality = centrality;
        this.loc = loc;
        this.locGenerated = locGenerated;
        this.tags = tags;
        this.modulePath = modulePath;
    }

    public final double getPercentOfTotalCode() {
        return this.percentOfTotalCode;
    }

    public final double getJavaKotlinRatio() {
        return this.javaKotlinRatio;
    }

    public final double getCentrality() {
        return this.centrality;
    }

    public final int getLoc() {
        return this.loc;
    }

    public final int getLocGenerated() {
        return this.locGenerated;
    }

    @NotNull
    public final Set<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final String getModulePath() {
        return this.modulePath;
    }

    public final long score() {
        long score = 0L;
        double dampenedCentrality = this.centrality * (double)0.25f;
        score += (long)((int)dampenedCentrality);
        if (this.percentOfTotalCode > 10.0) {
            score += (long)((int)this.percentOfTotalCode);
        }
        score += (long)((int)(this.javaKotlinRatio / (double)10));
        boolean kapt = this.tags.contains("kapt");
        boolean ksp = this.tags.contains("ksp");
        boolean android = this.tags.contains("android");
        boolean resourcesEnabled = this.tags.contains("android-resources");
        boolean resourcesHavePublicXml = true;
        boolean androidVariants = this.tags.contains("android-variants");
        boolean daggerCompiler = this.tags.contains("dagger-compiler");
        if (kapt) {
            score = daggerCompiler ? (score += (long)5) : (score += (long)10);
        }
        if (ksp) {
            score += (long)2;
        }
        if (ksp && kapt) {
            score += (long)10;
        }
        if (android) {
            score += (long)5;
        }
        if (resourcesEnabled) {
            ++score;
        }
        if (androidVariants) {
            score += (long)10;
        }
        return score;
    }

    public final double component1() {
        return this.percentOfTotalCode;
    }

    public final double component2() {
        return this.javaKotlinRatio;
    }

    public final double component3() {
        return this.centrality;
    }

    public final int component4() {
        return this.loc;
    }

    public final int component5() {
        return this.locGenerated;
    }

    @NotNull
    public final Set<String> component6() {
        return this.tags;
    }

    @NotNull
    public final String component7() {
        return this.modulePath;
    }

    @NotNull
    public final Weights copy(double percentOfTotalCode, double javaKotlinRatio, double centrality, int loc, int locGenerated, @NotNull Set<String> tags, @NotNull String modulePath) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        return new Weights(percentOfTotalCode, javaKotlinRatio, centrality, loc, locGenerated, tags, modulePath);
    }

    public static /* synthetic */ Weights copy$default(Weights weights, double d, double d2, double d3, int n, int n2, Set set, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            d = weights.percentOfTotalCode;
        }
        if ((n3 & 2) != 0) {
            d2 = weights.javaKotlinRatio;
        }
        if ((n3 & 4) != 0) {
            d3 = weights.centrality;
        }
        if ((n3 & 8) != 0) {
            n = weights.loc;
        }
        if ((n3 & 0x10) != 0) {
            n2 = weights.locGenerated;
        }
        if ((n3 & 0x20) != 0) {
            set = weights.tags;
        }
        if ((n3 & 0x40) != 0) {
            string = weights.modulePath;
        }
        return weights.copy(d, d2, d3, n, n2, set, string);
    }

    @NotNull
    public String toString() {
        return "Weights(percentOfTotalCode=" + this.percentOfTotalCode + ", javaKotlinRatio=" + this.javaKotlinRatio + ", centrality=" + this.centrality + ", loc=" + this.loc + ", locGenerated=" + this.locGenerated + ", tags=" + this.tags + ", modulePath=" + this.modulePath + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.percentOfTotalCode);
        result = result * 31 + Double.hashCode(this.javaKotlinRatio);
        result = result * 31 + Double.hashCode(this.centrality);
        result = result * 31 + Integer.hashCode(this.loc);
        result = result * 31 + Integer.hashCode(this.locGenerated);
        result = result * 31 + ((Object)this.tags).hashCode();
        result = result * 31 + this.modulePath.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Weights)) {
            return false;
        }
        Weights weights = (Weights)other;
        if (Double.compare(this.percentOfTotalCode, weights.percentOfTotalCode) != 0) {
            return false;
        }
        if (Double.compare(this.javaKotlinRatio, weights.javaKotlinRatio) != 0) {
            return false;
        }
        if (Double.compare(this.centrality, weights.centrality) != 0) {
            return false;
        }
        if (this.loc != weights.loc) {
            return false;
        }
        if (this.locGenerated != weights.locGenerated) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, weights.tags)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.modulePath, (Object)weights.modulePath);
    }
}

