/*
 * Decompiled with CFR 0.152.
 */
package slack.unittest;

import com.gradle.enterprise.gradleplugin.testretry.TestRetryExtension;
import com.gradle.enterprise.gradleplugin.testretry.TestRetryKt;
import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testretry.TestRetryTaskExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slack.gradle.SlackGradleUtilKt;
import slack.gradle.SlackProperties;
import slack.gradle.artifacts.Publisher;
import slack.gradle.artifacts.Resolver;
import slack.gradle.artifacts.SgpArtifact;
import slack.gradle.avoidance.SkippyArtifacts;
import slack.gradle.tasks.FileTasksKt;
import slack.gradle.tasks.SimpleFileProducerTask;
import slack.gradle.tasks.SimpleFilesConsumerTask;
import slack.gradle.util.HasConfigurableValuesKt;
import slack.gradle.util.PropertyUtil;
import slack.unittest.UnitTests;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJH\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0013J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lslack/unittest/UnitTests;", "", "()V", "CI_UNIT_TEST_TASK_NAME", "", "COMPILE_CI_UNIT_TEST_NAME", "GLOBAL_CI_UNIT_TEST_TASK_NAME", "LOG", "configureRootProject", "", "project", "Lorg/gradle/api/Project;", "configureSubproject", "pluginId", "slackProperties", "Lslack/gradle/SlackProperties;", "affectedProjects", "", "onProjectSkipped", "Lkotlin/Function2;", "configureTestTasks", "createAndroidCiUnitTestTask", "unitTestsPublisher", "Lslack/gradle/artifacts/Publisher;", "Lslack/gradle/artifacts/SgpArtifact;", "maxForks", "", "registerCiUnitTest", "Lorg/gradle/api/tasks/TaskProvider;", "Lslack/gradle/tasks/SimpleFileProducerTask;", "dependencyTaskName", "slack-plugin"})
@SourceDebugExtension(value={"SMAP\nUnitTests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitTests.kt\nslack/unittest/UnitTests\n+ 2 GradleExt.kt\nslack/gradle/GradleExtKt\n*L\n1#1,288:1\n174#2,2:289\n*S KotlinDebug\n*F\n+ 1 UnitTests.kt\nslack/unittest/UnitTests\n*L\n168#1:289,2\n*E\n"})
public final class UnitTests {
    @NotNull
    public static final UnitTests INSTANCE = new UnitTests();
    @NotNull
    private static final String GLOBAL_CI_UNIT_TEST_TASK_NAME = "globalCiUnitTest";
    @NotNull
    private static final String CI_UNIT_TEST_TASK_NAME = "ciUnitTest";
    @NotNull
    private static final String COMPILE_CI_UNIT_TEST_NAME = "compileCiUnitTest";
    @NotNull
    private static final String LOG = "SlackUnitTests:";

    private UnitTests() {
    }

    private final int maxForks(SlackProperties slackProperties) {
        float multiplier = slackProperties.getUnitTestParallelismMultiplier();
        return Math.max(MathKt.roundToInt((float)((float)Runtime.getRuntime().availableProcessors() * multiplier)), 1);
    }

    public final void configureRootProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Resolver resolver = Resolver.Companion.interProjectResolver$default(Resolver.Companion, project, SgpArtifact.SKIPPY_UNIT_TESTS.INSTANCE, false, 4, null);
        SimpleFilesConsumerTask.Companion companion = SimpleFilesConsumerTask.Companion;
        Provider<Set<File>> provider2 = resolver.artifactView();
        SimpleFilesConsumerTask.Companion.registerOrConfigure$default(companion, project, GLOBAL_CI_UNIT_TEST_TASK_NAME, "Global lifecycle task to run all ciUnitTest tasks.", provider2, null, "verification", null, 80, null);
    }

    public final void configureSubproject(@NotNull Project project, @NotNull String pluginId, @NotNull SlackProperties slackProperties, @Nullable Set<String> affectedProjects, @NotNull Function2<? super String, ? super String, Unit> onProjectSkipped) {
        Publisher<SgpArtifact> publisher;
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)slackProperties, (String)"slackProperties");
        Intrinsics.checkNotNullParameter(onProjectSkipped, (String)"onProjectSkipped");
        boolean bl = enabled = slackProperties.getCiUnitTestEnabled() && !Intrinsics.areEqual((Object)pluginId, (Object)"com.android.test");
        if (!enabled) {
            project.getLogger().debug("SlackUnitTests: Skipping creation of \"ciUnitTest\" task");
            return;
        }
        slackProperties.getVersions$slack_plugin().getBundles().getCommonTest().ifPresent(new Consumer(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void accept(@NotNull Provider<ExternalModuleDependencyBundle> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$project.getDependencies().add("testImplementation", it);
            }
        });
        if (slackProperties.getCiUnitTestEnableKover() && !Intrinsics.areEqual((Object)project.getPath(), (Object)slackProperties.getPlatformProjectPath())) {
            project.afterEvaluate(new Action(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(@NotNull Project $this$afterEvaluate) {
                    Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                    this.$project.getPluginManager().apply("org.jetbrains.kotlinx.kover");
                }
            });
        }
        if (affectedProjects == null || affectedProjects.contains(project.getPath())) {
            publisher = Publisher.Companion.interProjectPublisher(project, SgpArtifact.SKIPPY_UNIT_TESTS.INSTANCE);
        } else {
            String taskPath = project.getPath() + ":ciUnitTest";
            onProjectSkipped.invoke((Object)GLOBAL_CI_UNIT_TEST_TASK_NAME, (Object)taskPath);
            String log = "SlackUnitTests: Skipping " + taskPath + " because it is not affected.";
            if (slackProperties.getDebug()) {
                project.getLogger().lifecycle(log);
            } else {
                project.getLogger().debug(log);
            }
            SkippyArtifacts.INSTANCE.publishSkippedTask(project, CI_UNIT_TEST_TASK_NAME);
            publisher = null;
        }
        Publisher<SgpArtifact> unitTestsPublisher = publisher;
        String string = pluginId;
        if (Intrinsics.areEqual((Object)string, (Object)"com.android.application") ? true : Intrinsics.areEqual((Object)string, (Object)"com.android.library")) {
            this.createAndroidCiUnitTestTask(project, unitTestsPublisher);
        } else {
            project.getLogger().debug("SlackUnitTests: Creating CI unit test tasks");
            TaskProvider<SimpleFileProducerTask> ciUnitTest = this.registerCiUnitTest(project, "test");
            Publisher<SgpArtifact> publisher2 = unitTestsPublisher;
            if (publisher2 != null) {
                FileTasksKt.publish(publisher2, ciUnitTest);
            }
            project.getTasks().register(COMPILE_CI_UNIT_TEST_NAME, (Action)configureSubproject.3.INSTANCE);
        }
        this.configureTestTasks(project, slackProperties);
    }

    private final void createAndroidCiUnitTestTask(Project project, Publisher<SgpArtifact> unitTestsPublisher) {
        String variant = SlackGradleUtilKt.ciUnitTestAndroidVariant(project);
        String variantUnitTestTaskName = "test" + variant + "UnitTest";
        String variantCompileUnitTestTaskName = "compile" + variant + "UnitTestSources";
        project.getLogger().debug("SlackUnitTests: Creating CI unit test tasks for variant '" + variant + "'");
        TaskProvider<SimpleFileProducerTask> ciUnitTest = this.registerCiUnitTest(project, variantUnitTestTaskName);
        Publisher<SgpArtifact> publisher = unitTestsPublisher;
        if (publisher != null) {
            FileTasksKt.publish(publisher, ciUnitTest);
        }
        project.getTasks().register(COMPILE_CI_UNIT_TEST_NAME, new Action(variantCompileUnitTestTaskName){
            final /* synthetic */ String $variantCompileUnitTestTaskName;
            {
                this.$variantCompileUnitTestTaskName = $variantCompileUnitTestTaskName;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("verification");
                Object[] objectArray = new Object[]{this.$variantCompileUnitTestTaskName};
                $this$register.dependsOn(objectArray);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void configureTestTasks(Project project, SlackProperties slackProperties) {
        void $this$configureEach$iv;
        boolean isCi = SlackGradleUtilKt.isCi(project);
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer taskContainer2 = taskContainer;
        Function1 action$iv = (Function1)new Function1<Test, Unit>(slackProperties, project){
            final /* synthetic */ SlackProperties $slackProperties;
            final /* synthetic */ Project $project;
            {
                this.$slackProperties = $slackProperties;
                this.$project = $project;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Test $this$configureEach) {
                void it;
                int n;
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                int n2 = n = UnitTests.access$maxForks(UnitTests.INSTANCE, this.$slackProperties);
                Test test = $this$configureEach;
                boolean bl = false;
                $this$configureEach.getLogger().debug("SlackUnitTests: Setting maxParallelForks to " + (int)it);
                test.setMaxParallelForks(n);
                Property property = $this$configureEach.getReports().getJunitXml().getMergeReruns();
                Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getMergeReruns(...)");
                HasConfigurableValuesKt.setDisallowChanges(property, true);
                $this$configureEach.setForkEvery(this.$slackProperties.getUnitTestForkEvery());
                $this$configureEach.setMinHeapSize("128m");
                $this$configureEach.setMaxHeapSize("1g");
                Object[] objectArray = new Object[]{"--add-opens=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED", "-Xss1m"};
                $this$configureEach.jvmArgs(objectArray);
                $this$configureEach.systemProperty("robolectric.graphicsMode", (Object)"NATIVE");
                if (this.$slackProperties.getTestVerboseLogging()) {
                    $this$configureEach.testLogging((Action)configureTestTasks.2.INSTANCE);
                    String workspaceDir = SlackGradleUtilKt.isActionsCi(this.$project) ? PropertyUtil.synchronousEnvProperty$default(this.$project, "GITHUB_WORKSPACE", null, 2, null) : this.$project.getRootProject().getProjectDir().getAbsolutePath();
                    Object[] objectArray2 = new Object[]{"-XX:+HeapDumpOnOutOfMemoryError", "-XX:+CrashOnOutOfMemoryError", "-XX:+UseGCOverheadLimit", "-XX:GCHeapFreeLimit=10", "-XX:GCTimeLimit=20", "-XX:HeapDumpPath=" + workspaceDir + "/fs_oom_err_pid<pid>.hprof", "-XX:ErrorFile=" + workspaceDir + "/fs_oom_err_pid<pid>.log"};
                    $this$configureEach.jvmArgs(objectArray2);
                }
            }
        };
        boolean $i$f$configureEach = false;
        $this$configureEach$iv.withType(Test.class).configureEach(new Action(action$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        if (isCi) {
            if (slackProperties.getTestRetryPluginType() == SlackProperties.TestRetryPluginType.RETRY_PLUGIN) {
                project.getPluginManager().withPlugin("org.gradle.test-retry", new Action(project, slackProperties){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ SlackProperties $slackProperties;
                    {
                        this.$project = $project;
                        this.$slackProperties = $slackProperties;
                    }

                    public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                        Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                        this.$project.getTasks().withType(Test.class).configureEach(new Action(this.$slackProperties){
                            final /* synthetic */ SlackProperties $slackProperties;
                            {
                                this.$slackProperties = $slackProperties;
                            }

                            public final void execute(@NotNull Test $this$configureEach) {
                                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                                org.gradle.kotlin.dsl.TestRetryKt.retry((Test)$this$configureEach, (Function1)((Function1)new Function1<TestRetryTaskExtension, Unit>(this.$slackProperties){
                                    final /* synthetic */ SlackProperties $slackProperties;
                                    {
                                        this.$slackProperties = $slackProperties;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull TestRetryTaskExtension $this$retry) {
                                        Intrinsics.checkNotNullParameter((Object)$this$retry, (String)"$this$retry");
                                        Property property = $this$retry.getFailOnPassedAfterRetry();
                                        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getFailOnPassedAfterRetry(...)");
                                        HasConfigurableValuesKt.setDisallowChanges(property, this.$slackProperties.getTestRetryFailOnPassedAfterRetry());
                                        Property property2 = $this$retry.getMaxFailures();
                                        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"getMaxFailures(...)");
                                        HasConfigurableValuesKt.setDisallowChanges(property2, this.$slackProperties.getTestRetryMaxFailures());
                                        Property property3 = $this$retry.getMaxRetries();
                                        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"getMaxRetries(...)");
                                        HasConfigurableValuesKt.setDisallowChanges(property3, this.$slackProperties.getTestRetryMaxRetries());
                                    }
                                }));
                            }
                        });
                    }
                });
            } else {
                project.getTasks().withType(Test.class).configureEach(new Action(slackProperties){
                    final /* synthetic */ SlackProperties $slackProperties;
                    {
                        this.$slackProperties = $slackProperties;
                    }

                    public final void execute(@NotNull Test $this$configureEach) {
                        Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                        TestRetryKt.retry((Test)$this$configureEach, (Function1)((Function1)new Function1<TestRetryExtension, Unit>(this.$slackProperties){
                            final /* synthetic */ SlackProperties $slackProperties;
                            {
                                this.$slackProperties = $slackProperties;
                                super(1);
                            }

                            public final void invoke(@NotNull TestRetryExtension $this$retry) {
                                Intrinsics.checkNotNullParameter((Object)$this$retry, (String)"$this$retry");
                                Property property = $this$retry.getFailOnPassedAfterRetry();
                                Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getFailOnPassedAfterRetry(...)");
                                HasConfigurableValuesKt.setDisallowChanges(property, this.$slackProperties.getTestRetryFailOnPassedAfterRetry());
                                Property property2 = $this$retry.getMaxFailures();
                                Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"getMaxFailures(...)");
                                HasConfigurableValuesKt.setDisallowChanges(property2, this.$slackProperties.getTestRetryMaxFailures());
                                Property property3 = $this$retry.getMaxRetries();
                                Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"getMaxRetries(...)");
                                HasConfigurableValuesKt.setDisallowChanges(property3, this.$slackProperties.getTestRetryMaxRetries());
                            }
                        }));
                    }
                });
            }
        }
    }

    private final TaskProvider<SimpleFileProducerTask> registerCiUnitTest(Project project, String dependencyTaskName) {
        SimpleFileProducerTask.Companion companion = SimpleFileProducerTask.Companion;
        String string = "Lifecycle task to run unit tests for " + project.getPath() + ".";
        Action action = new Action(dependencyTaskName){
            final /* synthetic */ String $dependencyTaskName;
            {
                this.$dependencyTaskName = $dependencyTaskName;
            }

            public final void execute(@NotNull SimpleFileProducerTask $this$registerOrConfigure) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$registerOrConfigure), (String)"$this$registerOrConfigure");
                Object[] objectArray = new Object[]{this.$dependencyTaskName};
                $this$registerOrConfigure.dependsOn(objectArray);
            }
        };
        return SimpleFileProducerTask.Companion.registerOrConfigure$default(companion, project, CI_UNIT_TEST_TASK_NAME, string, null, null, "verification", action, 24, null);
    }

    public static final /* synthetic */ int access$maxForks(UnitTests $this, SlackProperties slackProperties) {
        return $this.maxForks(slackProperties);
    }
}

