/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.txn.TxnEnd;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.util.PackedInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

public abstract class VersionedWriteTxnEnd
extends TxnEnd
implements VersionedWriteLoggable {
    private static final int LAST_FORMAT_CHANGE = 13;

    VersionedWriteTxnEnd(long id, long lastLsn, int masterId, long dtvlsn) {
        super(id, lastLsn, masterId, dtvlsn);
    }

    public VersionedWriteTxnEnd() {
    }

    @Override
    public int getLastFormatChange() {
        return 13;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.emptyList();
    }

    @Override
    public int getLogSize() {
        return this.getLogSize(16, false);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.writeToLog(logBuffer, 16, false);
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        if (this.dtvlsn == -1L) {
            throw new IllegalStateException("DTVLSN is null");
        }
        return LogUtils.getPackedLongLogSize(this.id) + LogUtils.getTimestampLogSize(this.time) + LogUtils.getPackedLongLogSize(forReplication ? -1L : this.lastLsn) + LogUtils.getPackedIntLogSize(this.repMasterNodeId) + (logVersion >= 13 ? LogUtils.getPackedLongLogSize(this.dtvlsn) : 0);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int entryVersion, boolean forReplication) {
        if (entryVersion >= 12) {
            LogUtils.writePackedLong(logBuffer, forReplication ? -1L : this.lastLsn);
        }
        LogUtils.writePackedLong(logBuffer, this.id);
        LogUtils.writeTimestamp(logBuffer, this.time);
        if (entryVersion < 12) {
            LogUtils.writePackedLong(logBuffer, forReplication ? -1L : this.lastLsn);
        }
        LogUtils.writePackedInt(logBuffer, this.repMasterNodeId);
        if (entryVersion >= 13) {
            if (this.dtvlsn == -1L) {
                throw new IllegalStateException("Unexpected null dtvlsn");
            }
            LogUtils.writePackedLong(logBuffer, this.dtvlsn);
        }
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        boolean isUnpacked;
        boolean bl = isUnpacked = entryVersion < 6;
        if (entryVersion >= 12) {
            this.lastLsn = LogUtils.readLong(logBuffer, isUnpacked);
        }
        this.id = LogUtils.readLong(logBuffer, isUnpacked);
        this.time = LogUtils.readTimestamp(logBuffer, isUnpacked);
        if (entryVersion < 12) {
            this.lastLsn = LogUtils.readLong(logBuffer, isUnpacked);
        }
        if (entryVersion >= 6) {
            this.repMasterNodeId = LogUtils.readInt(logBuffer, false);
        }
        if (entryVersion >= 13) {
            this.dtvlsn = LogUtils.readPackedLong(logBuffer);
            if (this.dtvlsn == -1L) {
                throw new IllegalStateException("Unexpected null dtvlsn");
            }
        } else {
            this.dtvlsn = 0L;
        }
    }

    @Override
    public boolean hasReplicationFormat() {
        return true;
    }

    @Override
    public boolean isReplicationFormatWorthwhile(ByteBuffer logBuffer, int srcVersion, int destVersion) {
        if (srcVersion < 12) {
            return false;
        }
        return PackedInteger.getReadLongLength(logBuffer.array(), logBuffer.arrayOffset() + logBuffer.position()) > 1;
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<").append(this.getTagName());
        sb.append(" id=\"").append(this.id);
        sb.append("\" time=\"").append(this.time);
        sb.append("\" master=\"").append(this.repMasterNodeId);
        sb.append("\" dtvlsn=\"").append(this.dtvlsn);
        sb.append("\">");
        sb.append(DbLsn.toString(this.lastLsn));
        sb.append("</").append(this.getTagName()).append(">");
    }
}

