/*
 * Decompiled with CFR 0.152.
 */
package com.slickqa.executioner.slickv4connector;

import com.google.inject.Inject;
import com.slickqa.executioner.base.AutoloadComponent;
import com.slickqa.executioner.base.OnStartup;
import com.slickqa.executioner.slickv4connector.Slickv4Configuration;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;

@AutoloadComponent
public class Slickv4Connector
implements OnStartup {
    private Vertx vertx;
    private EventBus eventBus;
    private Slickv4Configuration config;
    private HttpClient httpClient;
    private String newTestsUrl;
    private String alreadyScheduledTestsUrl;
    private boolean polling;
    private int pollingSkippedCount;
    private int pollingSkippedThreshold;
    private int workQueueCount = 0;
    private URL slickUrl;
    private Logger log;

    @Inject
    public Slickv4Connector(Vertx vertx, EventBus eventBus, Slickv4Configuration config) throws MalformedURLException {
        this.log = LoggerFactory.getLogger((String)(Slickv4Connector.class.getName() + "." + config.getExecutionerAgentName()));
        this.vertx = vertx;
        this.eventBus = eventBus;
        this.config = config;
        this.slickUrl = new URL(config.getSlickUrl());
        HttpClientOptions slickClientOptions = new HttpClientOptions();
        slickClientOptions.setDefaultHost(this.slickUrl.getHost());
        if (this.slickUrl.getPort() != -1) {
            slickClientOptions.setDefaultPort(this.slickUrl.getPort());
        } else if ("https".equals(this.slickUrl.getProtocol())) {
            slickClientOptions.setDefaultPort(443);
        } else {
            slickClientOptions.setDefaultPort(80);
        }
        slickClientOptions.setSsl("https".equals(this.slickUrl.getProtocol()));
        this.httpClient = vertx.createHttpClient(slickClientOptions);
        this.newTestsUrl = this.slickUrl.getPath() + "/api/results/schedulemorefor/" + config.getProjectName() + "/" + config.getExecutionerAgentName() + "?limit=" + config.getSimultaneousFetchLimit();
        this.alreadyScheduledTestsUrl = this.slickUrl.getPath() + "/api/results/scheduledfor/" + config.getProjectName() + "/" + config.getExecutionerAgentName() + "?limit=" + config.getSimultaneousFetchLimit();
        this.polling = false;
        this.workQueueCount = 0;
        this.pollingSkippedCount = 0;
        this.pollingSkippedThreshold = 24;
    }

    public void onStartup() {
        this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.alreadyScheduledTestsUrl, Boolean.valueOf(true)));
        this.httpClient.getNow(this.alreadyScheduledTestsUrl, httpClientResponse -> {
            if (httpClientResponse.statusCode() == 200) {
                httpClientResponse.bodyHandler(buffer -> {
                    JsonArray response = new JsonArray(buffer.toString());
                    JsonArray addToWorkQueue = new JsonArray();
                    for (Object item : response) {
                        if (item instanceof JsonObject) {
                            addToWorkQueue.add(this.slickResultToWorkQueueItem((JsonObject)item));
                            continue;
                        }
                        this.log.error((Object)"What did slick return in the json array, expecting Json Object, got ({0})", new Object[]{item.getClass().getName()});
                    }
                    if (addToWorkQueue.size() > 0) {
                        this.log.info((Object)"Sending {0} existing slick items to add to the work queue.", new Object[]{addToWorkQueue.size()});
                        this.eventBus.send("executioner.workqueue.add", (Object)addToWorkQueue);
                    }
                    this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.alreadyScheduledTestsUrl, Boolean.valueOf(false)));
                });
            } else {
                httpClientResponse.bodyHandler(buffer -> this.log.warn((Object)"Requesting existing scheduled results from slick return status code {0}: {1}", new Object[]{httpClientResponse.statusCode(), buffer}));
                this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.alreadyScheduledTestsUrl, Boolean.valueOf(false)));
            }
        });
        this.eventBus.consumer("executioner.workqueue.info").handler(this::onWorkQueueUpdate);
        this.eventBus.consumer("executioner.workqueue.itemCancelled", this::workItemCancelled);
        this.eventBus.send("executioner.workqueue.query", null);
        this.vertx.setPeriodic((long)(this.config.getPollingInterval() * 1000), this::pollForWorkIfNeeded);
    }

    public void onWorkQueueUpdate(Message<Object> message) {
        Object body = message.body();
        if (body instanceof JsonArray) {
            JsonArray workQueue = (JsonArray)body;
            this.workQueueCount = workQueue.size();
        }
    }

    protected JsonObject slickResultToWorkQueueItem(JsonObject result) {
        String resultId = result.getString("id");
        JsonObject workQueueItem = new JsonObject().put("name", result.getJsonObject("testcase").getString("name")).put("id", result.getString("id")).put("url", this.config.getSlickUrl() + "/testruns/" + result.getJsonObject("testrun").getString("testrunId") + "?result=" + result.getString("id")).put("groupName", result.getJsonObject("testrun").getString("name")).put("groupUrl", this.config.getSlickUrl() + "/testruns/" + result.getJsonObject("testrun").getString("testrunId")).put("slickResult", result);
        JsonArray requirements = new JsonArray();
        if (result.containsKey("project") && result.containsKey("release") && result.containsKey("build")) {
            String build = result.getJsonObject("build").getString("name").toLowerCase();
            if (build.contains("_")) {
                build = build.substring(0, build.indexOf(95));
            }
            requirements.add(result.getJsonObject("project").getString("name").toLowerCase() + "-" + result.getJsonObject("release").getString("name").toLowerCase() + "-" + build);
        }
        if (result.containsKey("attributes")) {
            JsonObject attributes = result.getJsonObject("attributes");
            for (String attrName : attributes.fieldNames()) {
                if (!"required".equals(attributes.getString(attrName))) continue;
                requirements.add(attrName.toLowerCase());
            }
        }
        if (result.getJsonObject("testcase").containsKey("automationTool")) {
            requirements.add(result.getJsonObject("testcase").getString("automationTool"));
        }
        workQueueItem.put("requirements", requirements);
        return workQueueItem;
    }

    public void workItemCancelled(Message<JsonObject> message) {
        JsonObject itemCancelled = (JsonObject)message.body();
        if (itemCancelled.containsKey("slickResult")) {
            JsonObject update = new JsonObject().put("status", "SKIPPED").put("reason", "Cancelled from Executioner");
            this.httpClient.put(this.slickUrl.getPath() + "/api/results/" + itemCancelled.getJsonObject("slickResult").getString("id"), response -> {}).putHeader("Content-Type", "application/json").end(update.encode());
        }
    }

    public void pollForWorkIfNeeded(Long id) {
        if (this.polling && this.pollingSkippedCount < this.pollingSkippedThreshold) {
            this.log.warn((Object)"Call for polling when we are already polling!");
            this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.newTestsUrl, Boolean.valueOf(true)));
            ++this.pollingSkippedCount;
            return;
        }
        if (this.workQueueCount < this.config.getQueueSizeLowerBound()) {
            this.pollingSkippedCount = 0;
            this.polling = true;
            this.log.info((Object)"Polling slick url {0}.", new Object[]{this.newTestsUrl});
            this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.newTestsUrl, Boolean.valueOf(true)));
            this.httpClient.getNow(this.newTestsUrl, httpClientResponse -> {
                if (httpClientResponse.statusCode() == 200) {
                    httpClientResponse.bodyHandler(buffer -> {
                        JsonArray response = new JsonArray(buffer.toString());
                        this.log.debug((Object)"Slick returned {0} potential items to add to the queue.", new Object[]{response.size()});
                        JsonArray addToWorkQueue = new JsonArray();
                        for (Object item : response) {
                            if (item instanceof JsonObject) {
                                addToWorkQueue.add(this.slickResultToWorkQueueItem((JsonObject)item));
                                continue;
                            }
                            this.log.error((Object)"What did slick return in the json array, expecting Json Object, got ({0})", new Object[]{item.getClass().getName()});
                        }
                        if (addToWorkQueue.size() > 0) {
                            this.log.info((Object)"Sending {0} items to add to the work queue.", new Object[]{addToWorkQueue.size()});
                            this.eventBus.send("executioner.workqueue.add", (Object)addToWorkQueue);
                        } else {
                            this.log.info((Object)"No new work from Slick");
                        }
                        this.polling = false;
                        this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.newTestsUrl, Boolean.valueOf(false)));
                    });
                } else {
                    httpClientResponse.bodyHandler(buffer -> this.log.warn((Object)"Polling return status code {0}: {1}", new Object[]{httpClientResponse.statusCode(), buffer}));
                    this.polling = false;
                    this.eventBus.publish("executioner.external-request", (Object)new JsonObject().put(this.newTestsUrl, Boolean.valueOf(false)));
                }
            });
        } else {
            this.log.info((Object)"Work Queue Count of {0} is above threshold for polling for work {1}.", new Object[]{this.workQueueCount, this.config.getQueueSizeLowerBound()});
        }
    }
}

