/*
 * Decompiled with CFR 0.152.
 */
package com.slickqa.executioner.slickv4connector;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.slickqa.executioner.base.OnStartup;
import com.slickqa.executioner.slickv4connector.Slickv4Configuration;
import com.slickqa.executioner.slickv4connector.Slickv4GuiceModule;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Set;

public class Slickv4ConnectorVerticle
extends AbstractVerticle {
    @Inject
    private Set<OnStartup> startupSet;
    @Inject
    private Slickv4Configuration config;

    public void start() throws Exception {
        Logger logger = LoggerFactory.getLogger(Slickv4ConnectorVerticle.class);
        logger.debug((Object)"Configuring Guice Injector for dummy agent.");
        Injector injector = Guice.createInjector((Module[])new Module[]{new Slickv4GuiceModule(this.vertx)});
        injector.injectMembers((Object)this);
        logger.info((Object)"Looking for scheduled results for project {0} on slick at {1}", new Object[]{this.config.getProjectName(), this.config.getSlickUrl()});
        for (OnStartup startupComponent : this.startupSet) {
            startupComponent.onStartup();
        }
        logger.info((Object)"Executioner Slickv4Connector Initialized.");
    }
}

