/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Parameters;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class ClassHelper {
    private static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    private static final String JUNIT_4_TESTRUNNER = "org.testng.junit.JUnit4TestRunner";
    private static final List<ClassLoader> classLoaders = new Vector<ClassLoader>();
    private static final String CANNOT_INSTANTIATE_CLASS = "Cannot instantiate class ";
    private static final String CLASS_HELPER = ClassHelper.class.getSimpleName();
    private static int lastGoodRootIndex = -1;

    private ClassHelper() {
    }

    public static void addClassLoader(ClassLoader loader) {
        classLoaders.add(loader);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NullPointerException | SecurityException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), e);
        }
    }

    public static <T> T newInstanceOrNull(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return ClassHelper.newInstance(constructor, new Object[0]);
        }
        catch (ExceptionInInitializerError | SecurityException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new TestNGException(CANNOT_INSTANTIATE_CLASS + constructor.getDeclaringClass().getName(), e);
        }
    }

    public static Class<?> forName(String className) {
        List<ClassLoader> allClassLoaders = Lists.newArrayList();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            allClassLoaders.add(contextClassLoader);
        }
        allClassLoaders.addAll(classLoaders);
        for (ClassLoader classLoader : allClassLoaders) {
            if (null == classLoader) continue;
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                if (!classLoaders.isEmpty()) continue;
                ClassHelper.logClassNotFoundError(className, ex);
            }
        }
        if (RuntimeBehavior.shouldSkipUsingCallerClassLoader()) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            ClassHelper.logClassNotFoundError(className, cnfe);
            return null;
        }
    }

    private static void logClassNotFoundError(String className, Exception ex) {
        Utils.log(CLASS_HELPER, 2, "Could not instantiate " + className + " : Class doesn't exist (" + ex.getMessage() + ")");
    }

    public static List<ConstructorOrMethod> findDeclaredFactoryMethods(Class<?> cls, IAnnotationFinder finder) {
        ArrayList<ConstructorOrMethod> result = new ArrayList<ConstructorOrMethod>();
        for (Method method : ClassHelper.getAvailableMethods(cls)) {
            IFactoryAnnotation f = finder.findAnnotation(method, IFactoryAnnotation.class);
            if (f == null) continue;
            ConstructorOrMethod factory = new ConstructorOrMethod(method);
            factory.setEnabled(f.getEnabled());
            result.add(factory);
        }
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            IFactoryAnnotation f = finder.findAnnotation(constructor, IFactoryAnnotation.class);
            if (f == null) continue;
            ConstructorOrMethod factory = new ConstructorOrMethod(constructor);
            factory.setEnabled(f.getEnabled());
            result.add(factory);
        }
        return result;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        Map<String, Set<Method>> methods = Maps.newHashMap();
        for (Method declaredMethod : ReflectionHelper.getLocalMethods(clazz)) {
            ClassHelper.appendMethod(methods, declaredMethod);
        }
        Class<?> parent = clazz.getSuperclass();
        if (null != parent) {
            while (!Object.class.equals(parent)) {
                Set<Map.Entry<String, Set<Method>>> extractedMethods = ClassHelper.extractMethods(clazz, parent, methods).entrySet();
                for (Map.Entry<String, Set<Method>> extractedMethod : extractedMethods) {
                    Set<Method> m = methods.get(extractedMethod.getKey());
                    if (m == null) {
                        methods.put(extractedMethod.getKey(), extractedMethod.getValue());
                        continue;
                    }
                    m.addAll((Collection<Method>)extractedMethod.getValue());
                }
                parent = parent.getSuperclass();
            }
        }
        Set<Method> returnValue = Sets.newHashSet();
        for (Set<Method> each : methods.values()) {
            returnValue.addAll(each);
        }
        return returnValue;
    }

    public static IJUnitTestRunner createTestRunner(TestRunner runner) {
        IJUnitTestRunner tr = null;
        try {
            Class.forName("org.junit.Test");
            Class<?> clazz = ClassHelper.forName(JUNIT_4_TESTRUNNER);
            if (clazz != null) {
                tr = (IJUnitTestRunner)clazz.newInstance();
                tr.setTestResultNotifier(runner);
            }
        }
        catch (Throwable t) {
            Utils.log(CLASS_HELPER, 2, "JUnit 4 was not found on the classpath");
            try {
                Class.forName("junit.framework.Test");
                Class<?> clazz = ClassHelper.forName(JUNIT_TESTRUNNER);
                if (clazz != null) {
                    tr = (IJUnitTestRunner)clazz.newInstance();
                    tr.setTestResultNotifier(runner);
                }
            }
            catch (Exception ex) {
                Utils.log(CLASS_HELPER, 2, "JUnit 3 was not found on the classpath");
                throw new TestNGException("Cannot create JUnit runner", ex);
            }
        }
        return tr;
    }

    private static void appendMethod(Map<String, Set<Method>> methods, Method declaredMethod) {
        Set declaredMethods = methods.computeIfAbsent(declaredMethod.getName(), k -> Sets.newHashSet());
        declaredMethods.add(declaredMethod);
    }

    private static Map<String, Set<Method>> extractMethods(Class<?> childClass, Class<?> clazz, Map<String, Set<Method>> collected) {
        Map<String, Set<Method>> methods = Maps.newHashMap();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = ClassHelper.isSamePackage(childPackage, classPackage);
        for (Method method : declaredMethods) {
            if (!ClassHelper.canInclude(isSamePackage, method, collected)) continue;
            ClassHelper.appendMethod(methods, method);
        }
        return methods;
    }

    private static boolean canInclude(boolean isSamePackage, Method method, Map<String, Set<Method>> collected) {
        int methodModifiers = method.getModifiers();
        boolean visible = Modifier.isPublic(methodModifiers) || Modifier.isProtected(methodModifiers) || isSamePackage && !Modifier.isPrivate(methodModifiers);
        boolean hasNoInheritanceTraits = !ClassHelper.isOverridden(method, collected) && !Modifier.isAbstract(methodModifiers);
        return visible && hasNoInheritanceTraits;
    }

    private static boolean isSamePackage(Package childPackage, Package classPackage) {
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        return isSamePackage;
    }

    private static boolean isOverridden(Method method, Map<String, Set<Method>> methodsByName) {
        Set<Method> collectedMethods = methodsByName.get(method.getName());
        if (collectedMethods == null) {
            return false;
        }
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static IMethodSelector createSelector(XmlMethodSelector selector) {
        try {
            Class<?> cls = Class.forName(selector.getClassName());
            return (IMethodSelector)cls.newInstance();
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't find method selector : " + selector.getClassName(), ex);
        }
    }

    public static Object createInstance(Class<?> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, ITestObjectFactory objectFactory, boolean create) {
        if (objectFactory instanceof IObjectFactory) {
            return ClassHelper.createInstance1(declaringClass, classes, xmlTest, finder, (IObjectFactory)objectFactory, create);
        }
        if (objectFactory instanceof IObjectFactory2) {
            return ClassHelper.createInstance2(declaringClass, (IObjectFactory2)objectFactory);
        }
        throw new AssertionError((Object)("Unknown object factory type:" + objectFactory));
    }

    private static Object createInstance2(Class<?> declaringClass, IObjectFactory2 objectFactory) {
        return objectFactory.newInstance(declaringClass);
    }

    public static Object createInstance1(Class<?> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IAnnotationFinder finder, IObjectFactory factory, boolean create) {
        Object result;
        block9: {
            result = null;
            try {
                Constructor<?> constructor = ClassHelper.findAnnotatedConstructor(finder, declaringClass);
                if (null != constructor) {
                    try {
                        result = ClassHelper.instantiateUsingParameterizedConstructor(finder, constructor, xmlTest, factory);
                        break block9;
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
                result = ClassHelper.instantiateUsingDefaultConstructor(declaringClass, classes, xmlTest, factory);
            }
            catch (TestNGException ex) {
                throw ex;
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Throwable cause) {
                throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ": " + cause.getMessage(), cause);
            }
        }
        if (result == null && create) {
            String suffix = "instantiated";
            if (!Modifier.isPublic(declaringClass.getModifiers())) {
                suffix = suffix + "/accessed.";
            }
            throw new TestNGException("An error occurred while instantiating class " + declaringClass.getName() + ". Check to make sure it can be " + suffix);
        }
        return result;
    }

    private static Object instantiateUsingParameterizedConstructor(IAnnotationFinder finder, Constructor<?> constructor, XmlTest xmlTest, IObjectFactory objectFactory) {
        IFactoryAnnotation factoryAnnotation = finder.findAnnotation(constructor, IFactoryAnnotation.class);
        if (factoryAnnotation != null) {
            throw new IllegalArgumentException("No factory annotation found.");
        }
        IParametersAnnotation parametersAnnotation = finder.findAnnotation(constructor, IParametersAnnotation.class);
        if (parametersAnnotation == null) {
            return null;
        }
        String[] parameterNames = parametersAnnotation.getValue();
        Object[] parameters = Parameters.createInstantiationParameters(constructor, "@Parameters", finder, parameterNames, xmlTest.getAllParameters(), xmlTest.getSuite());
        return objectFactory.newInstance(constructor, parameters);
    }

    private static Object instantiateUsingDefaultConstructor(Class<?> declaringClass, Map<Class<?>, IClass> classes, XmlTest xmlTest, IObjectFactory factory) throws NoSuchMethodException, IllegalAccessException, InstantiationException {
        Constructor<?> ct;
        boolean isStatic;
        Class[] parameterTypes = new Class[]{};
        Object[] parameters = new Object[]{};
        Class<?> ec = declaringClass.getEnclosingClass();
        boolean bl = isStatic = 0 != (declaringClass.getModifiers() & 8);
        if (null != ec && !isStatic) {
            parameterTypes = new Class[]{ec};
            parameters = new Object[]{ClassHelper.computeParameters(classes, ec, factory)};
        }
        try {
            ct = declaringClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            ct = declaringClass.getDeclaredConstructor(String.class);
            parameters = new Object[]{xmlTest.getName()};
        }
        return factory.newInstance(ct, parameters);
    }

    private static Object computeParameters(Map<Class<?>, IClass> classes, Class<?> ec, IObjectFactory factory) throws NoSuchMethodException, IllegalAccessException, InstantiationException {
        IClass enclosingIClass = classes.get(ec);
        if (enclosingIClass == null) {
            return ec.newInstance();
        }
        Object[] enclosingInstances = enclosingIClass.getInstances(false);
        if (enclosingInstances == null || enclosingInstances.length == 0) {
            return factory.newInstance(ec.getConstructor(ec), new Object[0]);
        }
        return enclosingInstances[0];
    }

    private static Constructor<?> findAnnotatedConstructor(IAnnotationFinder finder, Class<?> declaringClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> result : constructors = declaringClass.getDeclaredConstructors()) {
            IParametersAnnotation parametersAnnotation = finder.findAnnotation(result, IParametersAnnotation.class);
            if (parametersAnnotation != null) {
                Class<?>[] parameterTypes;
                String[] parameters = parametersAnnotation.getValue();
                if (parameters.length != (parameterTypes = result.getParameterTypes()).length) {
                    throw new TestNGException("Parameter count mismatch:  " + result + "\naccepts " + parameterTypes.length + " parameters but the @Test annotation declares " + parameters.length);
                }
                return result;
            }
            IFactoryAnnotation factoryAnnotation = finder.findAnnotation(result, IFactoryAnnotation.class);
            if (factoryAnnotation == null) continue;
            return result;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> declaringClass) {
        T result;
        try {
            if (declaringClass.getModifiers() == 0) {
                return null;
            }
            Constructor<T> ctor = declaringClass.getConstructor(String.class);
            result = ctor.newInstance("Default test name");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String error = "Could not create an instance of class " + declaringClass + (message != null ? ": " + message : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(error);
        }
        return result;
    }

    public static Class<?> fileToClass(String file) {
        int i;
        CharSequence className;
        Class<?> result = null;
        if (!file.endsWith(".class") && !file.endsWith(".java")) {
            if (file.startsWith("class ")) {
                file = file.substring("class ".length());
            }
            if (null == (result = ClassHelper.forName(file))) {
                throw new TestNGException("Cannot load class from file: " + file);
            }
            return result;
        }
        int classIndex = file.lastIndexOf(".class");
        if (-1 == classIndex) {
            classIndex = file.lastIndexOf(".java");
        }
        String shortFileName = file.substring(0, classIndex);
        String[] segments = shortFileName.split("[/\\\\]", -1);
        if (-1 != lastGoodRootIndex) {
            className = new StringBuilder(segments[lastGoodRootIndex]);
            for (i = lastGoodRootIndex + 1; i < segments.length; ++i) {
                ((StringBuilder)className).append(".").append(segments[i]);
            }
            result = ClassHelper.forName(((StringBuilder)className).toString());
            if (null != result) {
                return result;
            }
        }
        className = "";
        for (i = segments.length - 1; i >= 0; --i) {
            result = ClassHelper.forName((String)(className = ((String)className).length() == 0 ? segments[i] : segments[i] + "." + (String)className));
            if (null == result) continue;
            lastGoodRootIndex = i;
            break;
        }
        if (null == result) {
            throw new TestNGException("Cannot load class from file: " + file);
        }
        return result;
    }

    public static XmlClass[] findClassesInSameTest(Class<?> cls, XmlSuite suite) {
        Set vResult = Sets.newHashSet();
        for (XmlTest test : suite.getTests()) {
            vResult.addAll(ClassHelper.findClassesInSameTest(cls, test));
        }
        return vResult.toArray(new XmlClass[0]);
    }

    private static Collection<XmlClass> findClassesInSameTest(Class<?> cls, XmlTest xmlTest) {
        Set<XmlClass> vResult = Sets.newHashSet();
        String className = cls.getName();
        for (XmlClass testClass : xmlTest.getXmlClasses()) {
            if (!testClass.getName().equals(className)) continue;
            vResult.addAll(xmlTest.getXmlClasses());
            break;
        }
        return vResult;
    }
}

