/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ClassHelper;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class ClassImpl
implements IClass {
    private final Class<?> m_class;
    private Object m_defaultInstance = null;
    private final IAnnotationFinder m_annotationFinder;
    private List<Object> m_instances = Lists.newArrayList();
    private final Map<Class<?>, IClass> m_classes;
    private long[] m_instanceHashCodes;
    private final Object m_instance;
    private final ITestObjectFactory m_objectFactory;
    private String m_testName = null;
    private final XmlClass m_xmlClass;
    private final ITestContext m_testContext;
    private final boolean m_hasParentModule;

    public ClassImpl(ITestContext context, Class<?> cls, XmlClass xmlClass, Object instance, Map<Class<?>, IClass> classes, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        ITestAnnotation annotation;
        this.m_testContext = context;
        this.m_class = cls;
        this.m_classes = classes;
        this.m_xmlClass = xmlClass;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
        this.m_objectFactory = objectFactory;
        if (instance instanceof ITest) {
            this.m_testName = ((ITest)instance).getTestName();
        }
        if (this.m_testName == null && (annotation = this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class)) != null && !annotation.getTestName().isEmpty()) {
            this.m_testName = annotation.getTestName();
        }
        this.m_hasParentModule = Utils.isStringNotEmpty(this.m_testContext.getSuite().getParentModule());
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    public Class getRealClass() {
        return this.m_class;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_testContext.getCurrentXmlTest();
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private Object getDefaultInstance(boolean create) {
        if (this.m_defaultInstance == null) {
            Object instance;
            this.m_defaultInstance = this.m_instance != null ? this.m_instance : ((instance = this.getInstanceFromGuice()) != null ? instance : ClassHelper.createInstance(this.m_class, this.m_classes, this.m_testContext.getCurrentXmlTest(), this.m_annotationFinder, this.m_objectFactory, create));
        }
        return this.m_defaultInstance;
    }

    private Object getInstanceFromGuice() {
        Injector injector = this.m_testContext.getInjector(this);
        if (injector == null) {
            return null;
        }
        return injector.getInstance(this.m_class);
    }

    public Injector getParentInjector() {
        ISuite suite = this.m_testContext.getSuite();
        Injector injector = suite.getParentInjector();
        if (injector == null) {
            String stageString = suite.getGuiceStage();
            Stage stage = Utils.isStringNotEmpty(stageString) ? Stage.valueOf((String)stageString) : Stage.DEVELOPMENT;
            if (this.m_hasParentModule) {
                Class<Module> parentModule = ClassHelper.forName(suite.getParentModule());
                if (parentModule == null) {
                    throw new TestNGException("Cannot load parent Guice module class: " + suite.getParentModule());
                }
                Module module = this.newModule(parentModule);
                injector = Guice.createInjector((Stage)stage, (Module[])new Module[]{module});
            } else {
                injector = Guice.createInjector((Stage)stage, (Module[])new Module[0]);
            }
            suite.setParentInjector(injector);
        }
        return injector;
    }

    private Module newModule(Class<Module> module) {
        try {
            Constructor<Module> moduleConstructor = module.getDeclaredConstructor(ITestContext.class);
            return ClassHelper.newInstance(moduleConstructor, this.m_testContext);
        }
        catch (NoSuchMethodException e) {
            return ClassHelper.newInstance(module);
        }
    }

    @Override
    public Object[] getInstances(boolean create) {
        Object[] result = new Object[]{};
        if (this.m_testContext.getCurrentXmlTest().isJUnit()) {
            if (create) {
                result = new Object[]{ClassHelper.createInstance(this.m_class, this.m_classes, this.m_testContext.getCurrentXmlTest(), this.m_annotationFinder, this.m_objectFactory, create)};
            }
        } else {
            Object defaultInstance = this.getDefaultInstance(create);
            if (defaultInstance != null) {
                result = new Object[]{defaultInstance};
            }
        }
        if (this.m_instances.size() > 0) {
            result = this.m_instances.toArray(new Object[0]);
        }
        int m_instanceCount = this.m_instances.size();
        this.m_instanceHashCodes = new long[m_instanceCount];
        for (int i = 0; i < m_instanceCount; ++i) {
            this.m_instanceHashCodes[i] = this.m_instances.get(i).hashCode();
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_class.getName()).toString();
    }

    @Override
    public void addInstance(Object instance) {
        this.m_instances.add(instance);
    }
}

