/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import org.testng.IHookable;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodInvocationHelper;

public class InvokeMethodRunnable
implements Runnable {
    private ITestNGMethod m_method;
    private Object m_instance;
    private Object[] m_parameters;
    private final IHookable m_hookable;
    private final ITestResult m_testResult;

    public InvokeMethodRunnable(ITestNGMethod thisMethod, Object instance, Object[] parameters, IHookable hookable, ITestResult testResult) {
        this.m_method = thisMethod;
        this.m_instance = instance;
        this.m_parameters = parameters;
        this.m_hookable = hookable;
        this.m_testResult = testResult;
    }

    @Override
    public void run() throws TestNGRuntimeException {
        if (this.m_method.getInvocationTimeOut() > 0L) {
            for (int i = 0; i < this.m_method.getInvocationCount(); ++i) {
                this.runOne();
            }
        } else {
            this.runOne();
        }
    }

    private void runOne() {
        try {
            TestNGRuntimeException t = null;
            try {
                ConstructorOrMethod m = this.m_method.getConstructorOrMethod();
                if (this.m_hookable == null) {
                    MethodInvocationHelper.invokeMethod(m.getMethod(), this.m_instance, this.m_parameters);
                } else {
                    MethodInvocationHelper.invokeHookable(this.m_instance, this.m_parameters, this.m_hookable, m.getMethod(), this.m_testResult);
                }
            }
            catch (Throwable e) {
                t = new TestNGRuntimeException(e.getCause());
            }
            if (null != t) {
                Thread.currentThread().interrupt();
                throw t;
            }
        }
        finally {
            this.m_method.incrementCurrentInvocationCount();
        }
    }

    public static class TestNGRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -8619899270785596231L;

        public TestNGRuntimeException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

