/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IDataProviderListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.ExpectedExceptionsHolder;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHandler;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.PoolService;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestMethodWithDataProviderMethodWorker;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNgMethodUtils;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;

public class Invoker
implements IInvoker {
    private final ITestContext m_testContext;
    private final ITestResultNotifier m_notifier;
    private final IAnnotationFinder m_annotationFinder;
    private final SuiteRunState m_suiteState;
    private final boolean m_skipFailedInvocationCounts;
    private final Collection<IInvokedMethodListener> m_invokedMethodListeners;
    private final boolean m_continueOnFailedConfiguration;
    private final List<IClassListener> m_classListeners;
    private final Collection<IDataProviderListener> m_dataproviderListeners;
    private final Set<ITestNGMethod> m_executedConfigMethods = ConcurrentHashMap.newKeySet();
    private final Map<String, Boolean> m_beforegroupsFailures = Maps.newConcurrentMap();
    private final Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newConcurrentMap();
    private final Map<ITestNGMethod, Set<Object>> m_methodInvocationResults = Maps.newConcurrentMap();
    private IConfiguration m_configuration;
    private static final Predicate<ITestNGMethod, IClass> CAN_RUN_FROM_CLASS = new CanRunFromClassPredicate();
    private static final Predicate<ITestNGMethod, IClass> SAME_CLASS = new SameClassNamePredicate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassInvocationFailure(Class<?> clazz, Object instance) {
        Map<Class<?>, Set<Object>> map = this.m_classInvocationResults;
        synchronized (map) {
            Set instances = this.m_classInvocationResults.computeIfAbsent(clazz, k -> Sets.newHashSet());
            instances.add(instance);
        }
    }

    private void setMethodInvocationFailure(ITestNGMethod method, Object instance) {
        Set instances = this.m_methodInvocationResults.computeIfAbsent(method, k -> Sets.newHashSet());
        instances.add(TestNgMethodUtils.getMethodInvocationToken(method, instance));
    }

    public Invoker(IConfiguration configuration, ITestContext testContext, ITestResultNotifier notifier, SuiteRunState state, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners, Collection<IDataProviderListener> dataProviderListeners) {
        this.m_configuration = configuration;
        this.m_testContext = testContext;
        this.m_suiteState = state;
        this.m_notifier = notifier;
        this.m_annotationFinder = configuration.getAnnotationFinder();
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.m_invokedMethodListeners = invokedMethodListeners;
        this.m_continueOnFailedConfiguration = testContext.getSuite().getXmlSuite().getConfigFailurePolicy() == XmlSuite.FailurePolicy.CONTINUE;
        this.m_classListeners = classListeners;
        this.m_dataproviderListeners = dataProviderListeners;
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance) {
        this.invokeConfigurations(testClass, null, allMethods, suite, params, parameterValues, instance, null);
    }

    private void invokeConfigurations(IClass testClass, ITestNGMethod currentTestMethod, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance, ITestResult testMethodResult) {
        if (null == allMethods || allMethods.length == 0) {
            this.log(5, "No configuration methods found");
            return;
        }
        ITestNGMethod[] methods = TestNgMethodUtils.filterMethods(testClass, allMethods, SAME_CLASS);
        Object[] parameters = new Object[]{};
        for (ITestNGMethod tm : methods) {
            if (null == testClass) {
                testClass = tm.getTestClass();
            }
            long time = System.currentTimeMillis();
            TestResult testResult = new TestResult(testClass, tm, null, time, 0L, this.m_testContext);
            testResult.setStatus(16);
            IConfigurationAnnotation configurationAnnotation = null;
            try {
                boolean canProcessMethod;
                Object inst = tm.getInstance();
                if (inst == null) {
                    inst = instance;
                }
                Class<?> objectClass = inst.getClass();
                ConstructorOrMethod method = tm.getConstructorOrMethod();
                configurationAnnotation = AnnotationHelper.findConfiguration(this.m_annotationFinder, method);
                boolean alwaysRun = MethodHelper.isAlwaysRun(configurationAnnotation);
                boolean bl = canProcessMethod = MethodHelper.isEnabled(objectClass, this.m_annotationFinder) || alwaysRun;
                if (!canProcessMethod) {
                    this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because " + objectClass.getName() + " is not enabled");
                    continue;
                }
                if (MethodHelper.isDisabled(configurationAnnotation)) {
                    this.log(3, "Skipping " + Utils.detailedMethodName(tm, true) + " because it is not enabled");
                    continue;
                }
                if (!this.confInvocationPassed(tm, currentTestMethod, testClass, instance) && !alwaysRun) {
                    this.log(3, "Skipping " + Utils.detailedMethodName(tm, true));
                    InvokedMethod invokedMethod = new InvokedMethod(instance, tm, System.currentTimeMillis(), testResult);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
                    testResult.setStatus(3);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
                    this.handleConfigurationSkip(tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
                    continue;
                }
                this.log(3, "Invoking " + Utils.detailedMethodName(tm, true));
                if (testMethodResult != null) {
                    ((TestResult)testMethodResult).setMethod(currentTestMethod);
                }
                parameters = Parameters.createConfigurationParameters(tm.getConstructorOrMethod().getMethod(), params, parameterValues, currentTestMethod, this.m_annotationFinder, suite, this.m_testContext, testMethodResult);
                testResult.setParameters(parameters);
                this.runConfigurationListeners(testResult, true);
                Object newInstance = Invoker.computeInstance(instance, inst, tm);
                if (Invoker.isConfigMethodEligibleForScrutiny(tm)) {
                    if (this.m_executedConfigMethods.add(currentTestMethod)) {
                        this.invokeConfigurationMethod(newInstance, tm, parameters, testResult);
                    }
                } else {
                    this.invokeConfigurationMethod(newInstance, tm, parameters, testResult);
                }
                Invoker.copyAttributesFromNativelyInjectedTestResult(parameters, testMethodResult);
                this.runConfigurationListeners(testResult, false);
            }
            catch (Throwable ex) {
                this.handleConfigurationFailure(ex, tm, testResult, configurationAnnotation, currentTestMethod, instance, suite);
                Invoker.copyAttributesFromNativelyInjectedTestResult(parameters, testMethodResult);
            }
        }
    }

    private static void copyAttributesFromNativelyInjectedTestResult(Object[] source, ITestResult target) {
        if (source == null || target == null) {
            return;
        }
        Arrays.stream(source).filter(each -> each instanceof ITestResult).findFirst().ifPresent(eachSource -> Invoker.copyAttributes((ITestResult)eachSource, target));
    }

    private static void copyAttributes(ITestResult source, ITestResult target) {
        source.getAttributeNames().forEach(name -> target.setAttribute((String)name, source.getAttribute((String)name)));
    }

    private static Object computeInstance(Object instance, Object inst, ITestNGMethod tm) {
        if (instance == null || !tm.getConstructorOrMethod().getDeclaringClass().isAssignableFrom(instance.getClass())) {
            return inst;
        }
        return instance;
    }

    private void handleConfigurationSkip(ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        testResult.setStatus(3);
        this.runConfigurationListeners(testResult, false);
    }

    private void handleConfigurationFailure(Throwable ite, ITestNGMethod tm, ITestResult testResult, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        Throwable cause;
        Throwable throwable = cause = ite.getCause() != null ? ite.getCause() : ite;
        if (this.isSkipExceptionAndSkip(cause)) {
            testResult.setThrowable(cause);
            this.handleConfigurationSkip(tm, testResult, annotation, currentTestMethod, instance, suite);
            return;
        }
        Utils.log("", 3, "Failed to invoke configuration method " + tm.getQualifiedName() + ":" + cause.getMessage());
        this.handleException(cause, tm, testResult, 1);
        testResult.setStatus(2);
        this.runConfigurationListeners(testResult, false);
        if (null != annotation) {
            this.recordConfigurationInvocationFailed(tm, testResult.getTestClass(), annotation, currentTestMethod, instance, suite);
        }
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod tm, IClass testClass, IConfigurationAnnotation annotation, ITestNGMethod currentTestMethod, Object instance, XmlSuite suite) {
        if (annotation.getBeforeTestClass() || annotation.getAfterTestClass()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setClassInvocationFailure(testClass.getRealClass(), instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeTestMethod() || annotation.getAfterTestMethod()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setMethodInvocationFailure(currentTestMethod, instance);
            } else {
                this.setClassInvocationFailure(tm.getRealClass(), instance);
            }
        } else if (annotation.getBeforeSuite() || annotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (annotation.getBeforeTest() || annotation.getAfterTest()) {
            this.setClassInvocationFailure(tm.getRealClass(), instance);
            XmlClass[] classes = ClassHelper.findClassesInSameTest(tm.getRealClass(), suite);
            for (XmlClass xmlClass : classes) {
                this.setClassInvocationFailure(xmlClass.getSupportClass(), instance);
            }
        }
        String[] beforeGroups = annotation.getBeforeGroups();
        for (String group : beforeGroups) {
            this.m_beforegroupsFailures.put(group, Boolean.FALSE);
        }
    }

    private boolean classConfigurationFailed(Class<?> cls, Object instance) {
        return this.m_classInvocationResults.entrySet().stream().anyMatch(classSetEntry -> {
            Set obj = (Set)classSetEntry.getValue();
            Class c = (Class)classSetEntry.getKey();
            boolean containsBeforeTestOrBeforeSuiteFailure = obj.contains(null);
            return c == cls || c.isAssignableFrom(cls) && (obj.contains(instance) || containsBeforeTestOrBeforeSuiteFailure);
        });
    }

    private boolean confInvocationPassed(ITestNGMethod method, ITestNGMethod currentTestMethod, IClass testClass, Object instance) {
        boolean result = true;
        Class<?> cls = testClass.getRealClass();
        if (this.m_suiteState.isFailed()) {
            result = false;
        } else {
            boolean hasConfigurationFailures = this.classConfigurationFailed(cls, instance);
            if (hasConfigurationFailures) {
                Set<Object> set;
                result = !this.m_continueOnFailedConfiguration ? false : !(set = this.getInvocationResults(testClass)).contains(instance);
                return result;
            }
            if (this.m_continueOnFailedConfiguration && this.hasConfigFailure(currentTestMethod)) {
                Object key = TestNgMethodUtils.getMethodInvocationToken(currentTestMethod, instance);
                result = !this.m_methodInvocationResults.get(currentTestMethod).contains(key);
            } else if (!this.m_continueOnFailedConfiguration) {
                for (Class clazz : this.m_classInvocationResults.keySet()) {
                    if (!clazz.isAssignableFrom(cls) || !this.m_classInvocationResults.get(clazz).contains(instance)) continue;
                    result = false;
                    break;
                }
            }
        }
        String[] groups = method.getGroups();
        for (String group : groups) {
            if (!this.m_beforegroupsFailures.containsKey(group)) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean hasConfigFailure(ITestNGMethod currentTestMethod) {
        return currentTestMethod != null && this.m_methodInvocationResults.containsKey(currentTestMethod);
    }

    private Set<Object> getInvocationResults(IClass testClass) {
        Class<?> cls = testClass.getRealClass();
        Set<Object> set = null;
        while (!cls.equals(Object.class) && (set = this.m_classInvocationResults.get(cls)) == null) {
            cls = cls.getSuperclass();
        }
        if (set == null) {
            throw new IllegalStateException("No failure logs for " + testClass.getRealClass());
        }
        return set;
    }

    private static boolean isConfigMethodEligibleForScrutiny(ITestNGMethod tm) {
        if (!tm.isBeforeMethodConfiguration()) {
            return false;
        }
        if (!(tm instanceof ConfigurationMethod)) {
            return false;
        }
        ConfigurationMethod cfg = (ConfigurationMethod)tm;
        return cfg.isFirstTimeOnly();
    }

    private void invokeConfigurationMethod(Object targetInstance, ITestNGMethod tm, Object[] params, ITestResult testResult) throws InvocationTargetException, IllegalAccessException {
        tm.setId(ThreadUtil.currentThreadInfo());
        InvokedMethod invokedMethod = new InvokedMethod(targetInstance, tm, System.currentTimeMillis(), testResult);
        this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
        this.m_notifier.addInvokedMethod(invokedMethod);
        try {
            Reporter.setCurrentTestResult(testResult);
            ConstructorOrMethod method = tm.getConstructorOrMethod();
            IConfigurable configurableInstance = this.computeConfigurableInstance(method, targetInstance);
            if (RuntimeBehavior.isDryRun()) {
                testResult.setStatus(1);
                return;
            }
            if (configurableInstance != null) {
                MethodInvocationHelper.invokeConfigurable(targetInstance, params, configurableInstance, method.getMethod(), testResult);
            } else {
                MethodInvocationHelper.invokeMethodConsideringTimeout(tm, method, targetInstance, params, testResult);
            }
            testResult.setStatus(1);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.throwConfigurationFailure(testResult, ex);
            testResult.setStatus(2);
            throw ex;
        }
        catch (Throwable ex) {
            this.throwConfigurationFailure(testResult, ex);
            testResult.setStatus(2);
            throw new TestNGException(ex);
        }
        finally {
            testResult.setEndMillis(System.currentTimeMillis());
            Reporter.setCurrentTestResult(testResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            Reporter.setCurrentTestResult(null);
        }
    }

    private IConfigurable computeConfigurableInstance(ConstructorOrMethod method, Object targetInstance) {
        return IConfigurable.class.isAssignableFrom(method.getDeclaringClass()) ? (IConfigurable)targetInstance : this.m_configuration.getConfigurable();
    }

    private void throwConfigurationFailure(ITestResult testResult, Throwable ex) {
        testResult.setStatus(2);
        testResult.setThrowable(ex.getCause() == null ? ex : ex.getCause());
    }

    private void runInvokedMethodListeners(InvokedMethodListenerMethod listenerMethod, IInvokedMethod invokedMethod, ITestResult testResult) {
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invoker = new InvokedMethodListenerInvoker(listenerMethod, testResult, this.m_testContext);
        for (IInvokedMethodListener currentListener : this.m_invokedMethodListeners) {
            invoker.invokeListener(currentListener, invokedMethod);
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.isEmpty();
    }

    /*
     * Exception decompiling
     */
    private ITestResult invokeMethod(Object instance, ITestNGMethod tm, Object[] parameterValues, int parametersIndex, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, FailureContext failureContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setTestStatus(ITestResult result, int status) {
        if (result.getStatus() == 16) {
            result.setStatus(status);
        }
    }

    private void collectResults(ITestNGMethod testMethod, ITestResult result) {
        int status = result.getStatus();
        if (1 == status) {
            this.m_notifier.addPassedTest(testMethod, result);
        } else if (3 == status) {
            this.m_notifier.addSkippedTest(testMethod, result);
        } else if (2 == status) {
            this.m_notifier.addFailedTest(testMethod, result);
        } else if (4 == status) {
            this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, result);
        } else assert (false) : "UNKNOWN STATUS:" + status;
    }

    ITestResult invokeTestMethod(Object instance, ITestNGMethod tm, Object[] parameterValues, int parametersIndex, XmlSuite suite, Map<String, String> params, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, FailureContext failureContext) {
        tm.setId(ThreadUtil.currentThreadInfo());
        return this.invokeMethod(instance, tm, parameterValues, parametersIndex, suite, params, testClass, beforeMethods, afterMethods, groupMethods, failureContext);
    }

    private void invokeBeforeGroupsConfigurations(ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        String[] groups;
        List filteredMethods = Lists.newArrayList();
        for (String group : groups = currentTestMethod.getGroups()) {
            List<ITestNGMethod> methods = groupMethods.getBeforeGroupMethodsForGroup(group);
            if (methods == null) continue;
            filteredMethods.addAll(methods);
        }
        ITestNGMethod[] beforeMethodsArray = filteredMethods.toArray(new ITestNGMethod[0]);
        if (beforeMethodsArray.length > 0) {
            this.invokeConfigurations(null, beforeMethodsArray, suite, params, null, instance);
        }
        groupMethods.removeBeforeGroups(groups);
    }

    private void invokeAfterGroupsConfigurations(ITestNGMethod currentTestMethod, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> params, Object instance) {
        String[] groups;
        if (currentTestMethod.getGroups().length == 0) {
            return;
        }
        Map<String, String> filteredGroups = Maps.newHashMap();
        for (String group : groups = currentTestMethod.getGroups()) {
            if (!groupMethods.isLastMethodForGroup(group, currentTestMethod)) continue;
            filteredGroups.put(group, group);
        }
        if (filteredGroups.isEmpty()) {
            return;
        }
        Map<ITestNGMethod, ITestNGMethod> afterMethods = Maps.newHashMap();
        for (String g : filteredGroups.values()) {
            List<ITestNGMethod> methods = groupMethods.getAfterGroupMethodsForGroup(g);
            if (methods == null) continue;
            for (ITestNGMethod m : methods) {
                afterMethods.put(m, m);
            }
        }
        ITestNGMethod[] afterMethodsArray = afterMethods.keySet().toArray(new ITestNGMethod[0]);
        this.invokeConfigurations(null, afterMethodsArray, suite, params, null, instance);
        groupMethods.removeAfterGroups(filteredGroups.keySet());
    }

    FailureContext retryFailed(Object instance, ITestNGMethod tm, Object[] paramValues, ITestClass testClass, ITestNGMethod[] beforeMethods, ITestNGMethod[] afterMethods, ConfigurationGroupMethods groupMethods, List<ITestResult> result, int failureCount, ITestContext testContext, Map<String, String> parameters, int parametersIndex) {
        FailureContext failure = new FailureContext();
        failure.count = failureCount;
        do {
            failure.instances = Lists.newArrayList();
            Map<String, String> allParameters = Maps.newHashMap();
            ParameterHandler handler = new ParameterHandler(this.m_annotationFinder, this.m_dataproviderListeners);
            ParameterHandler.ParameterBag bag = handler.createParameters(tm, parameters, allParameters, testContext);
            Object[] parameterValues = Parameters.getParametersFromIndex(bag.parameterHolder.parameters, parametersIndex);
            if (bag.parameterHolder.origin == ParameterHolder.ParameterOrigin.NATIVE) {
                parameterValues = paramValues;
            }
            result.add(this.invokeMethod(instance, tm, parameterValues, parametersIndex, testContext.getSuite().getXmlSuite(), allParameters, testClass, beforeMethods, afterMethods, groupMethods, failure));
        } while (!failure.instances.isEmpty());
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, Map<String, String> testParameters, ConfigurationGroupMethods groupMethods, Object instance, ITestContext testContext) {
        if (testMethod.getTestClass() == null) {
            throw new IllegalArgumentException("COULDN'T FIND TESTCLASS FOR " + testMethod.getRealClass());
        }
        XmlSuite suite = testContext.getSuite().getXmlSuite();
        if (!MethodHelper.isEnabled(testMethod.getConstructorOrMethod().getMethod(), this.m_annotationFinder)) {
            return Collections.emptyList();
        }
        String okToProceed = this.checkDependencies(testMethod, testContext.getAllTestMethods());
        if (okToProceed != null) {
            ITestResult result = this.registerSkippedTestResult(testMethod, System.currentTimeMillis(), new Throwable(okToProceed));
            this.m_notifier.addSkippedTest(testMethod, result);
            return Collections.singletonList(result);
        }
        Map<String, String> parameters = testMethod.findMethodParameters(testContext.getCurrentXmlTest());
        if (testMethod.getInvocationCount() > 1 && testMethod.getThreadPoolSize() > 1) {
            return this.invokePooledTestMethods(testMethod, suite, parameters, groupMethods, testContext);
        }
        long timeOutInvocationCount = testMethod.getInvocationTimeOut();
        boolean onlyOne = testMethod.getThreadPoolSize() > 1 || timeOutInvocationCount > 0L;
        int invocationCount = onlyOne ? 1 : testMethod.getInvocationCount();
        ITestClass testClass = testMethod.getTestClass();
        List<ITestResult> result = Lists.newArrayList();
        FailureContext failure = new FailureContext();
        ITestNGMethod[] beforeMethods = TestNgMethodUtils.filterBeforeTestMethods(testClass, CAN_RUN_FROM_CLASS);
        ITestNGMethod[] afterMethods = TestNgMethodUtils.filterAfterTestMethods(testClass, CAN_RUN_FROM_CLASS);
        while (invocationCount-- > 0) {
            long start = System.currentTimeMillis();
            ParameterHandler handler = new ParameterHandler(this.m_annotationFinder, this.m_dataproviderListeners);
            Map<String, String> allParameterNames = Maps.newHashMap();
            ParameterHandler.ParameterBag bag = handler.createParameters(testMethod, parameters, allParameterNames, testContext, instance);
            if (bag.hasErrors()) {
                ITestResult tr = bag.errorResult;
                Throwable throwable = tr.getThrowable();
                if (throwable instanceof TestNGException) {
                    tr.setStatus(2);
                    this.m_notifier.addFailedTest(testMethod, tr);
                } else {
                    tr.setStatus(3);
                    this.m_notifier.addSkippedTest(testMethod, tr);
                }
                this.runTestListeners(tr);
                result.add(tr);
                continue;
            }
            Iterator<Object[]> allParameterValues = bag.parameterHolder.parameters;
            int parametersIndex = 0;
            try {
                if (bag.runInParallel()) {
                    List workers = Lists.newArrayList();
                    while (allParameterValues.hasNext()) {
                        Object[] next = allParameterValues.next();
                        if (next == null) {
                            ++parametersIndex;
                            continue;
                        }
                        Object[] parameterValues = Parameters.injectParameters(next, testMethod.getConstructorOrMethod().getMethod(), testContext);
                        TestMethodWithDataProviderMethodWorker w = new TestMethodWithDataProviderMethodWorker(this, testMethod, parametersIndex, parameterValues, instance, parameters, testClass, beforeMethods, afterMethods, groupMethods, testContext, this.m_skipFailedInvocationCounts, invocationCount, failure.count, this.m_notifier);
                        workers.add(w);
                        ++parametersIndex;
                    }
                    PoolService ps = new PoolService(suite.getDataProviderThreadCount());
                    List r = ps.submitTasksAndWait(workers);
                    for (List l2 : r) {
                        result.addAll(l2);
                    }
                    continue;
                }
                while (allParameterValues.hasNext()) {
                    boolean lastSucces;
                    List tmpResults;
                    Object[] parameterValues;
                    block27: {
                        Object[] next = allParameterValues.next();
                        if (next == null) {
                            ++parametersIndex;
                            continue;
                        }
                        parameterValues = Parameters.injectParameters(next, testMethod.getConstructorOrMethod().getMethod(), testContext);
                        tmpResults = Lists.newArrayList();
                        int tmpResultsIndex = -1;
                        try {
                            tmpResults.add(this.invokeTestMethod(instance, testMethod, parameterValues, parametersIndex, suite, parameters, testClass, beforeMethods, afterMethods, groupMethods, failure));
                            lastSucces = false;
                            if (++tmpResultsIndex < 0) break block27;
                            boolean bl = lastSucces = ((ITestResult)tmpResults.get(tmpResultsIndex)).getStatus() == 1;
                        }
                        catch (Throwable throwable) {
                            boolean lastSucces2 = false;
                            if (tmpResultsIndex >= 0) {
                                boolean bl = lastSucces2 = ((ITestResult)tmpResults.get(tmpResultsIndex)).getStatus() == 1;
                            }
                            if (failure.instances.isEmpty() || lastSucces2) {
                                result.addAll(tmpResults);
                            } else {
                                List<ITestResult> retryResults = Lists.newArrayList();
                                failure = this.retryFailed(instance, testMethod, parameterValues, testClass, beforeMethods, afterMethods, groupMethods, retryResults, failure.count, testContext, parameters, parametersIndex);
                                result.addAll(retryResults);
                            }
                            if (failure.count > 0 && (this.m_skipFailedInvocationCounts || testMethod.skipFailedInvocations())) {
                                while (invocationCount-- > 0) {
                                    result.add(this.registerSkippedTestResult(testMethod, System.currentTimeMillis(), null));
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (failure.instances.isEmpty() || lastSucces) {
                        result.addAll(tmpResults);
                    } else {
                        List<ITestResult> retryResults = Lists.newArrayList();
                        failure = this.retryFailed(instance, testMethod, parameterValues, testClass, beforeMethods, afterMethods, groupMethods, retryResults, failure.count, testContext, parameters, parametersIndex);
                        result.addAll(retryResults);
                    }
                    if (failure.count > 0 && (this.m_skipFailedInvocationCounts || testMethod.skipFailedInvocations())) {
                        while (invocationCount-- > 0) {
                            result.add(this.registerSkippedTestResult(testMethod, System.currentTimeMillis(), null));
                        }
                    }
                    ++parametersIndex;
                }
            }
            catch (Throwable cause) {
                TestResult r = new TestResult(testMethod.getTestClass(), testMethod, cause, start, System.currentTimeMillis(), this.m_testContext);
                r.setStatus(2);
                result.add(r);
                this.runTestListeners(r);
                this.m_notifier.addFailedTest(testMethod, r);
            }
        }
        return result;
    }

    private ITestResult registerSkippedTestResult(ITestNGMethod testMethod, long start, Throwable throwable) {
        TestResult result = new TestResult(testMethod.getTestClass(), testMethod, throwable, start, System.currentTimeMillis(), this.m_testContext);
        if (RuntimeBehavior.invokeListenersForSkippedTests()) {
            result.setStatus(16);
            this.runTestListeners(result);
        }
        result.setStatus(3);
        Reporter.setCurrentTestResult(result);
        this.runTestListeners(result);
        return result;
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod testMethod, XmlSuite suite, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ITestContext testContext) {
        List<IWorker<ITestNGMethod>> workers = Lists.newArrayList();
        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
            ITestNGMethod clonedMethod = testMethod.clone();
            clonedMethod.setInvocationCount(1);
            clonedMethod.setThreadPoolSize(1);
            MethodInstance mi = new MethodInstance(clonedMethod);
            workers.add(new SingleTestMethodWorker(this, mi, parameters, testContext, this.m_classListeners));
        }
        return this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize(), groupMethods, suite, parameters);
    }

    private StatusHolder considerExceptions(ITestNGMethod tm, ITestResult testresult, ExpectedExceptionsHolder exceptionsHolder, FailureContext failure) {
        TestException exception;
        StatusHolder holder = new StatusHolder();
        holder.status = testresult.getStatus();
        holder.handled = false;
        Throwable ite = testresult.getThrowable();
        if (holder.status == 2 && ite != null) {
            if (exceptionsHolder != null) {
                if (exceptionsHolder.isExpectedException(ite)) {
                    testresult.setStatus(1);
                    holder.status = 1;
                } else if (this.isSkipExceptionAndSkip(ite)) {
                    holder.status = 3;
                } else {
                    testresult.setThrowable(exceptionsHolder.wrongException(ite));
                    holder.status = 2;
                }
            } else {
                this.handleException(ite, tm, testresult, failure.count++);
                holder.handled = true;
                holder.status = testresult.getStatus();
            }
        } else if (holder.status != 3 && exceptionsHolder != null && (exception = exceptionsHolder.noException(tm)) != null) {
            testresult.setThrowable(exception);
            holder.status = 2;
        }
        return holder;
    }

    private void handleInvocationResults(ITestNGMethod testMethod, ITestResult testResult, FailureContext failure, StatusHolder holder, boolean wasResultUnaltered) {
        boolean willRetry;
        List resultsToRetry = Lists.newArrayList();
        Throwable ite = testResult.getThrowable();
        int status = Invoker.computeTestStatusComparingTestResultAndStatusHolder(testResult, holder, wasResultUnaltered);
        boolean handled = holder.handled;
        IRetryAnalyzer retryAnalyzer = testMethod.getRetryAnalyzer();
        boolean bl = willRetry = retryAnalyzer != null && status == 2 && failure.instances != null && retryAnalyzer.retry(testResult);
        if (willRetry) {
            resultsToRetry.add(testResult);
            Object instance = testResult.getInstance();
            if (!failure.instances.contains(instance)) {
                failure.instances.add(instance);
            }
            testResult.setStatus(3);
            testResult.setWasRetried(true);
        } else {
            testResult.setStatus(status);
            if (status == 2 && !handled) {
                int count = failure.count++;
                if (testMethod.isDataDriven()) {
                    count = 0;
                }
                this.handleException(ite, testMethod, testResult, count);
            }
        }
    }

    private static int computeTestStatusComparingTestResultAndStatusHolder(ITestResult testResult, StatusHolder holder, boolean wasResultUnaltered) {
        if (wasResultUnaltered) {
            return holder.status;
        }
        return testResult.getStatus();
    }

    private boolean isSkipExceptionAndSkip(Throwable ite) {
        return SkipException.class.isAssignableFrom(ite.getClass()) && ((SkipException)ite).isSkip();
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<IWorker<ITestNGMethod>> workers, int threadPoolSize, ConfigurationGroupMethods groupMethods, XmlSuite suite, Map<String, String> parameters) {
        Object[] instances;
        ITestClass testClass = testMethod.getTestClass();
        for (Object instance : instances = testClass.getInstances(true)) {
            this.invokeBeforeGroupsConfigurations(testMethod, groupMethods, suite, parameters, instance);
        }
        long maxTimeOut = -1L;
        for (IWorker<ITestNGMethod> tmw : workers) {
            long mt = tmw.getTimeOut();
            if (mt <= maxTimeOut) continue;
            maxTimeOut = mt;
        }
        ThreadUtil.execute("methods", workers, threadPoolSize, maxTimeOut, true);
        List<ITestResult> result = Lists.newArrayList();
        for (IWorker<ITestNGMethod> tmw : workers) {
            if (!(tmw instanceof TestMethodWorker)) continue;
            result.addAll(((TestMethodWorker)tmw).getTestResults());
        }
        for (Object instance : instances) {
            this.invokeAfterGroupsConfigurations(testMethod, groupMethods, suite, parameters, instance);
        }
        return result;
    }

    private String checkDependencies(ITestNGMethod testMethod, ITestNGMethod[] allTestMethods) {
        ITestNGMethod[] methods;
        if (testMethod.isAlwaysRun()) {
            return null;
        }
        if (testMethod.getMissingGroup() != null && !testMethod.ignoreMissingDependencies()) {
            return "Method " + testMethod + " depends on nonexistent group \"" + testMethod.getMissingGroup() + "\"";
        }
        String[] groups = testMethod.getGroupsDependedUpon();
        if (null != groups && groups.length > 0) {
            for (String element : groups) {
                ITestNGMethod[] methods2 = MethodGroupsHelper.findMethodsThatBelongToGroup(testMethod, this.m_testContext.getAllTestMethods(), element);
                if (methods2.length == 0 && !testMethod.ignoreMissingDependencies()) {
                    return "Method " + testMethod + " depends on nonexistent group \"" + element + "\"";
                }
                if (this.haveBeenRunSuccessfully(testMethod, methods2)) continue;
                return "Method " + testMethod + " depends on not successfully finished methods in group \"" + element + "\"";
            }
        }
        if (TestNgMethodUtils.cannotRunMethodIndependently(testMethod) && !this.haveBeenRunSuccessfully(testMethod, methods = MethodHelper.findDependedUponMethods(testMethod, allTestMethods))) {
            return "Method " + testMethod + " depends on not successfully finished methods";
        }
        return null;
    }

    private Set<ITestResult> keepSameInstances(ITestNGMethod method, Set<ITestResult> results) {
        Set<ITestResult> result = Sets.newHashSet();
        for (ITestResult r : results) {
            Object instance;
            Object o = method.getInstance();
            Object object = instance = r.getInstance() != null ? r.getInstance() : r.getMethod().getInstance();
            if (r.getTestClass() == method.getTestClass() && instance != o) continue;
            result.add(r);
        }
        return result;
    }

    private boolean haveBeenRunSuccessfully(ITestNGMethod testMethod, ITestNGMethod[] methods) {
        for (ITestNGMethod method : methods) {
            boolean wasMethodRetried;
            Set<ITestResult> results = this.keepSameInstances(testMethod, this.m_notifier.getPassedTests(method));
            Set<ITestResult> failedAndSkippedMethods = Sets.newHashSet();
            Set<ITestResult> skippedAttempts = this.m_notifier.getSkippedTests(method);
            failedAndSkippedMethods.addAll(this.m_notifier.getFailedTests(method));
            failedAndSkippedMethods.addAll(skippedAttempts);
            Set<ITestResult> failedresults = this.keepSameInstances(testMethod, failedAndSkippedMethods);
            boolean bl = wasMethodRetried = !results.isEmpty() && !skippedAttempts.isEmpty();
            if (!wasMethodRetried && !failedresults.isEmpty()) {
                return false;
            }
            for (ITestResult result : results) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        return true;
    }

    private void handleException(Throwable throwable, ITestNGMethod testMethod, ITestResult testResult, int failureCount) {
        int invocationCount;
        int successPercentage;
        float numberOfTestsThatCanFail;
        if (throwable != null && testResult.getThrowable() == null) {
            testResult.setThrowable(throwable);
        }
        if ((float)failureCount < (numberOfTestsThatCanFail = (float)((100 - (successPercentage = testMethod.getSuccessPercentage())) * (invocationCount = testMethod.getInvocationCount())) / 100.0f)) {
            testResult.setStatus(4);
        } else {
            testResult.setStatus(2);
        }
    }

    private void runConfigurationListeners(ITestResult tr, boolean before) {
        if (before) {
            TestListenerHelper.runPreConfigurationListeners(tr, this.m_notifier.getConfigurationListeners());
        } else {
            TestListenerHelper.runPostConfigurationListeners(tr, this.m_notifier.getConfigurationListeners());
        }
    }

    void runTestListeners(ITestResult tr) {
        TestListenerHelper.runTestListeners(tr, this.m_notifier.getTestListeners());
    }

    private void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }

    static class SameClassNamePredicate
    implements Predicate<ITestNGMethod, IClass> {
        SameClassNamePredicate() {
        }

        @Override
        public boolean isTrue(ITestNGMethod m, IClass c) {
            return c == null || m.getTestClass().getName().equals(c.getName());
        }
    }

    static class CanRunFromClassPredicate
    implements Predicate<ITestNGMethod, IClass> {
        CanRunFromClassPredicate() {
        }

        @Override
        public boolean isTrue(ITestNGMethod m, IClass v) {
            return m.canRunFromClass(v);
        }
    }

    static interface Predicate<K, T> {
        public boolean isTrue(K var1, T var2);
    }

    private static class StatusHolder {
        boolean handled = false;
        int status;

        private StatusHolder() {
        }
    }

    static class FailureContext {
        int count = 0;
        List<Object> instances = Lists.newArrayList();

        FailureContext() {
        }
    }
}

