/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.testng.IDataProviderListener;
import org.testng.IDataProviderMethod;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Factory;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.DataProviderMethod;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.IDataProvidable;
import org.testng.internal.collections.ArrayIterator;
import org.testng.internal.reflect.DataProviderMethodMatcher;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.MethodMatcherContext;
import org.testng.internal.reflect.Parameter;
import org.testng.internal.reflect.ReflectionRecipes;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Parameters {
    public static final String NULL_VALUE = "null";
    private static final Map<Class<? extends Annotation>, Class<? extends IAnnotation>> ANNOTATION_MAP = new ConcurrentHashMap<Class<? extends Annotation>, Class<? extends IAnnotation>>();
    private static List<Class<? extends Annotation>> annotationList;
    private static Map<String, List<Class<?>>> mapping;
    private static final List<Class<?>> INJECTED_TYPES;

    public static Object[] createInstantiationParameters(Constructor ctor, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParametersForConstructor(ctor, ctor.getParameterTypes(), finder.findOptionalValues(ctor), methodAnnotation, parameterNames, new MethodParameters(params, Collections.emptyMap()), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, Object[] parameterValues, @Nullable ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite, ITestContext ctx, ITestResult testResult) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getConstructorOrMethod().getMethod() : null;
        Map<String, String> methodParams = currentTestMethod != null ? currentTestMethod.findMethodParameters(ctx.getCurrentXmlTest()) : Collections.emptyMap();
        Class<? extends Annotation> annotation = Parameters.retrieveConfigAnnotation(m);
        String name = annotation == null ? "" : annotation.getSimpleName();
        Class<? extends IAnnotation> annotationClass = null;
        if (annotation != null) {
            annotationClass = ANNOTATION_MAP.get(annotation);
        }
        return Parameters.createParameters(new ConstructorOrMethod(m), new MethodParameters(params, methodParams, parameterValues, currentTestMeth, ctx, testResult), finder, xmlSuite, annotationClass, name);
    }

    private static Class<? extends Annotation> retrieveConfigAnnotation(Method m) {
        return annotationList.stream().filter(annotation -> m.getAnnotation(annotation) != null).findAny().orElse(null);
    }

    @Deprecated
    public static Object getInjectedParameter(Class<?> c, Method method, ITestContext context, ITestResult testResult) {
        Object result = null;
        if (Method.class.equals(c)) {
            result = method;
        } else if (ITestContext.class.equals(c)) {
            result = context;
        } else if (XmlTest.class.equals(c)) {
            result = context.getCurrentXmlTest();
        } else if (ITestResult.class.equals(c)) {
            result = testResult;
        }
        return result;
    }

    private static Object[] createParametersForConstructor(Constructor constructor, Class<?>[] parameterTypes, String[] optionalValues, String methodAnnotation, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Parameter[] paramsArray;
        Object[] inject;
        if (parameterTypes.length == 0) {
            return new Object[0];
        }
        Parameters.checkParameterTypes(constructor.getName(), parameterTypes, methodAnnotation, parameterNames);
        List vResult = Lists.newArrayList();
        if (Parameters.canInject(methodAnnotation) && (inject = ReflectionRecipes.inject(paramsArray = ReflectionRecipes.getConstructorParameters(constructor), InjectableParameter.Assistant.ALL_INJECTS, new Object[0], constructor, params.context, params.testResult)) != null) {
            vResult.addAll(Arrays.asList(inject));
        }
        List<Object> consParams = Parameters.createParams(constructor.getName(), "constructor", methodAnnotation, parameterTypes, optionalValues, parameterNames, params, xmlSuite);
        vResult.addAll(consParams);
        return vResult.toArray(new Object[0]);
    }

    private static List<Object> createParams(String name, String prefix, String methodAnnotation, Class<?>[] parameterTypes, String[] optionalValues, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        List<Object> vResult = Lists.newArrayList();
        if (optionalValues.length != parameterNames.length) {
            FilterOutInJectedTypesResult filterOutResult = Parameters.filterOutInJectedTypesFromOptionalValues(parameterTypes, optionalValues);
            optionalValues = filterOutResult.getOptionalValues();
            parameterTypes = filterOutResult.getParameterTypes();
        }
        if (parameterNames.length == 0 && optionalValues.length > 0) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                vResult.add(Parameters.convertType(parameterTypes[i], optionalValues[i], ""));
            }
            return vResult;
        }
        for (int i = 0; i < parameterNames.length; ++i) {
            String p = parameterNames[i];
            String value = (String)params.xmlParameters.get(p);
            if (null == value) {
                value = System.getProperty(p);
            }
            if (null == value) {
                if (optionalValues != null) {
                    value = optionalValues[i];
                }
                if (null == value) {
                    throw new TestNGException("Parameter '" + p + "' is required by " + methodAnnotation + " on " + prefix + " " + name + " but has not been marked @Optional or defined\n" + (xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                }
            }
            vResult.add(Parameters.convertType(parameterTypes[i], value, p));
        }
        return vResult;
    }

    static FilterOutInJectedTypesResult filterOutInJectedTypesFromOptionalValues(Class<?>[] parameterTypes, String[] optionalValues) {
        List<Class<?>> typeList = Lists.newArrayList(parameterTypes);
        List<String> optionalValueList = Lists.newArrayList(optionalValues);
        Iterator<Class<?>> typeIterator = typeList.iterator();
        Iterator<String> optionalIterator = optionalValueList.iterator();
        while (typeIterator.hasNext()) {
            Class<?> parameterType = typeIterator.next();
            optionalIterator.next();
            if (!INJECTED_TYPES.contains(parameterType)) continue;
            optionalIterator.remove();
            typeIterator.remove();
        }
        return new FilterOutInJectedTypesResult(typeList.toArray(new Class[0]), optionalValueList.toArray(new String[0]));
    }

    private static boolean areAllOptionalValuesNull(String[] optionalValues) {
        if (optionalValues == null || optionalValues.length == 0) {
            return true;
        }
        boolean isNull = true;
        for (String optionalValue : optionalValues) {
            if (optionalValue == null) continue;
            isNull = false;
            break;
        }
        return isNull;
    }

    private static Object[] createParametersForMethod(ConstructorOrMethod method, Class<?>[] parameterTypes, String[] optionalValues, String methodAnnotation, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        if (parameterTypes.length == 0) {
            return new Object[0];
        }
        if (Parameters.areAllOptionalValuesNull(optionalValues)) {
            Parameters.checkParameterTypes(method.getName(), parameterTypes, methodAnnotation, parameterNames);
        }
        List vResult = Lists.newArrayList();
        List<Object> consParams = Parameters.createParams(method.getName(), "method", methodAnnotation, parameterTypes, optionalValues, parameterNames, params, xmlSuite);
        if (Parameters.canInject(methodAnnotation)) {
            Parameter[] paramsArray = Parameters.extractParameters(method);
            Object[] inject = ReflectionRecipes.inject(paramsArray, InjectableParameter.Assistant.ALL_INJECTS, consParams.toArray(new Object[0]), params.currentTestMethod, params.context, params.testResult);
            if (inject != null) {
                vResult.addAll(Arrays.asList(inject));
            }
        } else {
            vResult.addAll(consParams);
        }
        return vResult.toArray(new Object[0]);
    }

    private static Parameter[] extractParameters(ConstructorOrMethod method) {
        if (method.getMethod() != null) {
            return ReflectionRecipes.getMethodParameters(method.getMethod());
        }
        return ReflectionRecipes.getConstructorParameters(method.getConstructor());
    }

    private static boolean canInject(String annotation) {
        return !("@" + Test.class.getSimpleName()).equalsIgnoreCase(annotation);
    }

    private static void checkParameterTypes(String methodName, Class<?>[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        int totalLength = parameterTypes.length;
        for (Class<?> parameterType : parameterTypes) {
            if (!INJECTED_TYPES.contains(parameterType)) continue;
            --totalLength;
        }
        if (parameterNames.length == 0) {
            boolean invalid;
            boolean bl = invalid = totalLength != 0 || !Parameters.validParameters(methodAnnotation, parameterTypes);
            if (invalid) {
                String annotation = methodAnnotation;
                if (!methodAnnotation.startsWith("@")) {
                    annotation = "@" + methodAnnotation;
                }
                String errPrefix = mapping.containsKey(methodAnnotation) ? "Can inject only one of " + Parameters.prettyFormat(mapping.get(methodAnnotation)) + " into a " + annotation + " annotated " + methodName : "Cannot inject " + annotation + " annotated Method [" + methodName + "] with " + Arrays.toString(parameterTypes);
                throw new TestNGException(errPrefix + ".\nFor more information on native dependency injection please refer to http://testng.org/doc/documentation-main.html#native-dependency-injection");
            }
        }
        if (parameterNames.length != totalLength) {
            throw new TestNGException("Method " + methodName + " requires " + parameterTypes.length + " parameters but " + parameterNames.length + " were supplied in the " + methodAnnotation + " annotation.");
        }
    }

    private static boolean validParameters(String methodAnnotation, Class[] parameterTypes) {
        List<Class<?>> localMapping = mapping.get(methodAnnotation.replace("@", ""));
        if (localMapping == null) {
            return false;
        }
        for (Class parameterType : parameterTypes) {
            if (localMapping.contains(parameterType)) continue;
            return false;
        }
        return true;
    }

    private static String prettyFormat(List<Class<?>> classes) {
        StringBuilder builder = new StringBuilder("<");
        if (classes.size() == 1) {
            builder.append(classes.get(0));
        } else {
            int length = classes.size();
            for (int i = 0; i < length - 1; ++i) {
                builder.append(classes.get(i).getSimpleName()).append(", ");
            }
            builder.append(classes.get(length - 1).getSimpleName());
        }
        builder.append(">");
        return builder.toString();
    }

    public static <T> T convertType(Class<T> type, String value, String paramName) {
        try {
            if (value == null || NULL_VALUE.equals(value.toLowerCase())) {
                if (type.isPrimitive()) {
                    Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + paramName + "'");
                }
                return null;
            }
            if (type == String.class) {
                return (T)value;
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return (T)Integer.valueOf(value);
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return (T)Boolean.valueOf(value);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return (T)Byte.valueOf(value);
            }
            if (type == Character.TYPE || type == Character.class) {
                return (T)Character.valueOf(value.charAt(0));
            }
            if (type == Double.TYPE || type == Double.class) {
                return (T)Double.valueOf(value);
            }
            if (type == Float.TYPE || type == Float.class) {
                return (T)Float.valueOf(value);
            }
            if (type == Long.TYPE || type == Long.class) {
                return (T)Long.valueOf(value);
            }
            if (type == Short.TYPE || type == Short.class) {
                return (T)Short.valueOf(value);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, value);
            }
        }
        catch (Exception e) {
            throw new TestNGException("Conversion issue on parameter: " + paramName, e);
        }
        throw new TestNGException("Unsupported type parameter : " + type);
    }

    private static IDataProviderMethod findDataProvider(Object instance, ITestClass clazz, ConstructorOrMethod m, IAnnotationFinder finder, ITestContext context) {
        IDataProviderMethod result = null;
        IDataProvidable dp = Parameters.findDataProviderInfo(clazz, m, finder);
        if (dp != null) {
            String dataProviderName = dp.getDataProvider();
            Class<?> dataProviderClass = dp.getDataProviderClass();
            if (!Utils.isStringEmpty(dataProviderName) && null == (result = Parameters.findDataProvider(instance, clazz, finder, dataProviderName, dataProviderClass, context))) {
                throw new TestNGException("Method " + m + " requires a @DataProvider named : " + dataProviderName + (dataProviderClass != null ? " in class " + dataProviderClass.getName() : ""));
            }
        }
        return result;
    }

    private static IDataProvidable findDataProviderInfo(ITestClass clazz, ConstructorOrMethod m, IAnnotationFinder finder) {
        IDataProvidable result;
        if (m.getMethod() != null) {
            result = AnnotationHelper.findTest(finder, m.getMethod());
            if (result == null) {
                result = AnnotationHelper.findFactory(finder, m.getMethod());
            }
            if (result == null) {
                result = AnnotationHelper.findTest(finder, clazz.getRealClass());
            }
        } else {
            result = AnnotationHelper.findFactory(finder, m.getConstructor());
        }
        return result;
    }

    private static IDataProviderMethod findDataProvider(Object instance, ITestClass clazz, IAnnotationFinder finder, String name, Class<?> dataProviderClass, ITestContext context) {
        DataProviderMethod result = null;
        Class<?> cls = clazz.getRealClass();
        boolean shouldBeStatic = false;
        if (dataProviderClass != null) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            Injector injector;
            IDataProviderAnnotation dp = finder.findAnnotation(m, IDataProviderAnnotation.class);
            if (null == dp || !name.equals(Parameters.getDataProviderName(dp, m))) continue;
            Object instanceToUse = shouldBeStatic && (m.getModifiers() & 8) == 0 ? ((injector = context.getInjector(clazz)) != null ? injector.getInstance(dataProviderClass) : ClassHelper.newInstance(dataProviderClass)) : instance;
            if ((m.getModifiers() & 8) == 0 && instanceToUse == null) {
                instanceToUse = ClassHelper.newInstanceOrNull(cls);
            }
            if (result != null) {
                throw new TestNGException("Found two providers called '" + name + "' on " + cls);
            }
            result = new DataProviderMethod(instanceToUse, m, dp);
        }
        return result;
    }

    private static String getDataProviderName(IDataProviderAnnotation dp, Method m) {
        return Strings.isNullOrEmpty(dp.getName()) ? m.getName() : dp.getName();
    }

    private static String[] extractOptionalValues(IAnnotationFinder finder, ConstructorOrMethod consMethod) {
        if (consMethod.getMethod() != null) {
            return finder.findOptionalValues(consMethod.getMethod());
        }
        return finder.findOptionalValues(consMethod.getConstructor());
    }

    private static Object[] createParameters(ConstructorOrMethod m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, Class<? extends IAnnotation> annotationClass, String atName) {
        Object[] extraParameters;
        List result = Lists.newArrayList();
        String[] extraOptionalValues = Parameters.extractOptionalValues(finder, m);
        IParametersAnnotation annotation = finder.findAnnotation(m, IParametersAnnotation.class);
        Class[] types = m.getParameterTypes();
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            extraParameters = Parameters.createParametersForMethod(m, types, extraOptionalValues, atName, parameterNames, params, xmlSuite);
        } else {
            extraParameters = Parameters.createParametersForMethod(m, types, extraOptionalValues, atName, new String[0], params, xmlSuite);
        }
        Collections.addAll(result, extraParameters);
        for (int i = 0; i < types.length; ++i) {
            if (!Object[].class.equals((Object)types[i])) continue;
            result.add(i, params.parameterValues);
        }
        return result.toArray(new Object[0]);
    }

    public static ParameterHolder handleParameters(ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance, Collection<IDataProviderListener> dataProviderListeners) {
        return Parameters.handleParameters(testMethod, allParameterNames, instance, methodParams, xmlSuite, annotationFinder, fedInstance, dataProviderListeners, "@Test");
    }

    public static ParameterHolder handleParameters(final ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance, Collection<IDataProviderListener> dataProviderListeners, String annotationName) {
        final IDataProviderMethod dataProviderMethod = Parameters.findDataProvider(instance, testMethod.getTestClass(), testMethod.getConstructorOrMethod(), annotationFinder, methodParams.context);
        if (null != dataProviderMethod) {
            int parameterCount = testMethod.getConstructorOrMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String string = "param" + i;
                allParameterNames.put(string, string);
            }
            for (IDataProviderListener iDataProviderListener : dataProviderListeners) {
                iDataProviderListener.beforeDataProviderExecution(dataProviderMethod, testMethod, methodParams.context);
            }
            final Iterator<Object[]> parameters = MethodInvocationHelper.invokeDataProvider(dataProviderMethod.getInstance(), dataProviderMethod.getMethod(), testMethod, methodParams.context, fedInstance, annotationFinder);
            for (IDataProviderListener dataProviderListener : dataProviderListeners) {
                dataProviderListener.afterDataProviderExecution(dataProviderMethod, testMethod, methodParams.context);
            }
            final ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.addAll(testMethod.getInvocationNumbers());
            arrayList.addAll(dataProviderMethod.getIndices());
            Iterator<Object[]> filteredParameters = new Iterator<Object[]>(){
                int index = 0;
                boolean hasWarn = false;

                @Override
                public boolean hasNext() {
                    if (this.index == 0 && !parameters.hasNext() && !this.hasWarn) {
                        this.hasWarn = true;
                        Utils.log("", 2, "Warning: the data provider '" + dataProviderMethod.getName() + "' returned an empty array or iterator, so this test is not doing anything");
                    }
                    return parameters.hasNext();
                }

                @Override
                public Object[] next() {
                    testMethod.setParameterInvocationCount(this.index);
                    Object[] next = (Object[])parameters.next();
                    if (next == null) {
                        throw new TestNGException("Parameters must not be null");
                    }
                    if (!arrayList.isEmpty() && !arrayList.contains(this.index)) {
                        next = null;
                    }
                    ++this.index;
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
            testMethod.setMoreInvocationChecker(filteredParameters::hasNext);
            return new ParameterHolder(filteredParameters, ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER, dataProviderMethod);
        }
        ParameterHolder.ParameterOrigin origin = methodParams.xmlParameters.isEmpty() ? ParameterHolder.ParameterOrigin.NATIVE : ParameterHolder.ParameterOrigin.ORIGIN_XML;
        allParameterNames.putAll(methodParams.xmlParameters);
        Object[][] allParameterValuesArray = new Object[][]{Parameters.createParameters(testMethod.getConstructorOrMethod(), methodParams, annotationFinder, xmlSuite, ITestAnnotation.class, annotationName)};
        testMethod.setParameterInvocationCount(allParameterValuesArray.length);
        ArrayIterator parameters = new ArrayIterator(allParameterValuesArray);
        return new ParameterHolder(parameters, origin, null);
    }

    public static Object[] injectParameters(Object[] parameterValues, Method method, ITestContext context) throws TestNGException {
        MethodMatcherContext matcherContext = new MethodMatcherContext(method, parameterValues, context, null);
        DataProviderMethodMatcher matcher = new DataProviderMethodMatcher(matcherContext);
        return matcher.getConformingArguments();
    }

    public static Object[] getParametersFromIndex(Iterator<Object[]> parametersValues, int index) {
        while (parametersValues.hasNext()) {
            Object[] parameters = parametersValues.next();
            if (index == 0) {
                return parameters;
            }
            --index;
        }
        return null;
    }

    static {
        ANNOTATION_MAP.put(BeforeSuite.class, IBeforeSuite.class);
        ANNOTATION_MAP.put(AfterSuite.class, IAfterSuite.class);
        ANNOTATION_MAP.put(BeforeTest.class, IBeforeTest.class);
        ANNOTATION_MAP.put(AfterTest.class, IAfterTest.class);
        ANNOTATION_MAP.put(BeforeClass.class, IBeforeClass.class);
        ANNOTATION_MAP.put(AfterClass.class, IAfterClass.class);
        ANNOTATION_MAP.put(BeforeGroups.class, IBeforeGroups.class);
        ANNOTATION_MAP.put(AfterGroups.class, IAfterGroups.class);
        ANNOTATION_MAP.put(BeforeMethod.class, IBeforeMethod.class);
        ANNOTATION_MAP.put(AfterMethod.class, IAfterMethod.class);
        annotationList = Arrays.asList(BeforeSuite.class, AfterSuite.class, BeforeTest.class, AfterTest.class, BeforeClass.class, AfterClass.class, BeforeGroups.class, AfterGroups.class, BeforeMethod.class, AfterMethod.class, Factory.class);
        mapping = Maps.newHashMap();
        List<Class> ctxTest = Arrays.asList(ITestContext.class, XmlTest.class);
        List<Class> beforeAfterMethod = Arrays.asList(ITestContext.class, XmlTest.class, Method.class, Object[].class, ITestResult.class);
        mapping.put(BeforeSuite.class.getSimpleName(), ctxTest);
        mapping.put(AfterSuite.class.getSimpleName(), ctxTest);
        mapping.put(BeforeTest.class.getSimpleName(), ctxTest);
        mapping.put(AfterTest.class.getSimpleName(), ctxTest);
        mapping.put(BeforeGroups.class.getSimpleName(), ctxTest);
        mapping.put(AfterGroups.class.getSimpleName(), ctxTest);
        mapping.put(BeforeClass.class.getSimpleName(), ctxTest);
        mapping.put(AfterClass.class.getSimpleName(), ctxTest);
        mapping.put(BeforeMethod.class.getSimpleName(), beforeAfterMethod);
        mapping.put(AfterMethod.class.getSimpleName(), beforeAfterMethod);
        mapping.put(Test.class.getSimpleName(), Arrays.asList(ITestContext.class, XmlTest.class, Method.class));
        mapping.put(Factory.class.getSimpleName(), ctxTest);
        INJECTED_TYPES = Arrays.asList(ITestContext.class, ITestResult.class, XmlTest.class, Method.class, Object[].class);
    }

    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private Object[] parameterValues;
        private final ITestResult testResult;

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams) {
            this(params, methodParams, null, null, null, null);
        }

        public static MethodParameters newInstance(Map<String, String> params, ITestNGMethod testNGMethod, ITestContext context) {
            Map<String, String> methodParams = testNGMethod.findMethodParameters(context.getCurrentXmlTest());
            Method method = testNGMethod.getConstructorOrMethod().getMethod();
            return new MethodParameters(params, methodParams, null, method, context, null);
        }

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams, Object[] pv, Method m, ITestContext ctx, ITestResult tr) {
            Map<String, String> allParams = Maps.newHashMap();
            allParams.putAll(params);
            allParams.putAll(methodParams);
            this.xmlParameters = allParams;
            this.currentTestMethod = m;
            this.context = ctx;
            this.parameterValues = pv;
            this.testResult = tr;
        }
    }

    static final class FilterOutInJectedTypesResult {
        private Class<?>[] parameterTypes;
        private String[] optionalValues;

        private FilterOutInJectedTypesResult(Class<?>[] parameterTypes, String[] optionalValues) {
            this.parameterTypes = parameterTypes;
            this.optionalValues = optionalValues;
        }

        Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        String[] getOptionalValues() {
            return this.optionalValues;
        }
    }
}

