/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.testng.ClassMethodMap;
import org.testng.IClassListener;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.thread.graph.IWorker;

public class TestMethodWorker
implements IWorker<ITestNGMethod> {
    private List<IMethodInstance> m_methodInstances;
    private final IInvoker m_invoker;
    private final Map<String, String> m_parameters;
    private List<ITestResult> m_testResults = Lists.newArrayList();
    private final ConfigurationGroupMethods m_groupMethods;
    private final ClassMethodMap m_classMethodMap;
    private final ITestContext m_testContext;
    private final List<IClassListener> m_listeners;
    private long currentThreadId;
    private long threadIdToRunOn = -1L;
    private boolean completed = true;

    public TestMethodWorker(IInvoker invoker, List<IMethodInstance> testMethods, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ClassMethodMap classMethodMap, ITestContext testContext, List<IClassListener> listeners) {
        this.m_invoker = invoker;
        this.m_methodInstances = testMethods;
        this.m_parameters = parameters;
        this.m_groupMethods = groupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = testContext;
        this.m_listeners = listeners;
    }

    @Override
    public long getTimeOut() {
        long result = 0L;
        for (IMethodInstance mi : this.m_methodInstances) {
            ITestNGMethod tm = mi.getMethod();
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Worker thread:" + Thread.currentThread().getId() + " priority:" + this.getPriority() + " ");
        for (IMethodInstance m : this.m_methodInstances) {
            result.append(m.getMethod()).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.currentThreadId = Thread.currentThread().getId();
        if (RuntimeBehavior.enforceThreadAffinity() && this.doesTaskHavePreRequistes() && this.currentThreadId != this.threadIdToRunOn) {
            this.completed = false;
            return;
        }
        for (IMethodInstance testMthdInst : this.m_methodInstances) {
            ITestNGMethod testMethod = testMthdInst.getMethod();
            ITestClass testClass = testMethod.getTestClass();
            this.invokeBeforeClassMethods(testClass, testMthdInst);
            try {
                this.invokeTestMethods(testMethod, testMthdInst.getInstance());
            }
            finally {
                this.invokeAfterClassMethods(testClass, testMthdInst);
            }
        }
    }

    private boolean doesTaskHavePreRequistes() {
        return this.threadIdToRunOn != -1L;
    }

    protected void invokeTestMethods(ITestNGMethod tm, Object instance) {
        List<ITestResult> testResults = this.m_invoker.invokeTestMethods(tm, this.m_parameters, this.m_groupMethods, instance, this.m_testContext);
        if (testResults != null) {
            this.m_testResults.addAll(testResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeBeforeClassMethods(ITestClass testClass, IMethodInstance mi) {
        if (this.m_classMethodMap == null) {
            return;
        }
        ITestClass iTestClass = testClass;
        synchronized (iTestClass) {
            Map<ITestClass, Set<Object>> invokedBeforeClassMethods = this.m_classMethodMap.getInvokedBeforeClassMethods();
            Set instances = invokedBeforeClassMethods.computeIfAbsent(testClass, key -> Sets.newHashSet());
            Object instance = mi.getInstance();
            if (!instances.contains(instance)) {
                instances.add(instance);
                for (IClassListener listener : this.m_listeners) {
                    listener.onBeforeClass(testClass);
                }
                this.m_invoker.invokeConfigurations(testClass, testClass.getBeforeClassMethods(), this.m_testContext.getSuite().getXmlSuite(), this.m_parameters, null, instance);
            }
        }
    }

    protected void invokeAfterClassMethods(ITestClass testClass, IMethodInstance mi) {
        Object inst;
        if (this.m_classMethodMap == null) {
            return;
        }
        List<IClassListener> invokeInstances = Lists.newArrayList();
        ITestNGMethod tm = mi.getMethod();
        boolean removalSuccessful = this.m_classMethodMap.removeAndCheckIfLast(tm, mi.getInstance());
        if (!removalSuccessful) {
            return;
        }
        Map<ITestClass, Set<Object>> invokedAfterClassMethods = this.m_classMethodMap.getInvokedAfterClassMethods();
        Set instances = invokedAfterClassMethods.computeIfAbsent(testClass, key -> Sets.newHashSet());
        if (!instances.contains(inst = mi.getInstance())) {
            invokeInstances.add((IClassListener)inst);
        }
        for (IClassListener listener : this.m_listeners) {
            listener.onAfterClass(testClass);
        }
        for (IClassListener invokeInstance : invokeInstances) {
            this.m_invoker.invokeConfigurations(testClass, testClass.getAfterClassMethods(), this.m_testContext.getSuite().getXmlSuite(), this.m_parameters, null, invokeInstance);
        }
    }

    protected int indexOf(ITestNGMethod tm, ITestNGMethod[] allTestMethods) {
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (allTestMethods[i] != tm) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    @Override
    public List<ITestNGMethod> getTasks() {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (IMethodInstance m : this.m_methodInstances) {
            result.add(m.getMethod());
        }
        return result;
    }

    @Override
    public int compareTo(@Nonnull IWorker<ITestNGMethod> other) {
        return this.getPriority() - other.getPriority();
    }

    @Override
    public int getPriority() {
        return this.m_methodInstances.size() > 0 ? this.m_methodInstances.get(0).getMethod().getPriority() : 0;
    }

    @Override
    public long getCurrentThreadId() {
        return this.currentThreadId;
    }

    @Override
    public void setThreadIdToRunOn(long threadIdToRunOn) {
        this.threadIdToRunOn = threadIdToRunOn;
    }

    @Override
    public boolean completed() {
        return this.completed;
    }
}

