/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.ScriptMethodSelector;
import org.testng.internal.ScriptSelectorFactory;
import org.testng.internal.Utils;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlScript;

public class XmlMethodSelector
implements IMethodSelector {
    private static final String QUOTED_DOLLAR = Matcher.quoteReplacement("\\$");
    private final ListMultiMap<String, XmlInclude> m_includedMethods = Maps.newListMultiMap();
    private final Map<String, String> m_logged = Maps.newHashMap();
    private Map<String, String> m_includedGroups = Maps.newHashMap();
    private Map<String, String> m_excludedGroups = Maps.newHashMap();
    private List<XmlClass> m_classes = Collections.emptyList();
    private ScriptMethodSelector scriptSelector;
    private boolean m_isInitialized = false;
    private List<ITestNGMethod> m_testMethods = Collections.emptyList();

    @Override
    public boolean includeMethod(IMethodSelectorContext context, ITestNGMethod tm, boolean isTestMethod) {
        if (!this.m_isInitialized) {
            this.m_isInitialized = true;
            this.init(context);
        }
        if (this.scriptSelector != null) {
            return this.scriptSelector.includeMethodFromExpression(tm);
        }
        return this.includeMethodFromIncludeExclude(tm, isTestMethod);
    }

    private boolean includeMethodFromIncludeExclude(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        ConstructorOrMethod method = tm.getConstructorOrMethod();
        Map<String, String> includedGroups = this.m_includedGroups;
        Map<String, String> excludedGroups = this.m_excludedGroups;
        boolean hasTestClass = tm.getTestClass() != null;
        String key = hasTestClass ? XmlMethodSelector.makeMethodName(tm.getTestClass().getRealClass().getName(), method.getName()) : MethodHelper.calculateMethodCanonicalName(tm);
        List includeList = (List)this.m_includedMethods.get(key);
        if (includedGroups.isEmpty() && excludedGroups.isEmpty() && !this.hasIncludedMethods() && !this.hasExcludedMethods()) {
            result = true;
        } else if (includedGroups.isEmpty() && excludedGroups.isEmpty() && !isTestMethod) {
            result = true;
        } else if (!includeList.isEmpty()) {
            result = true;
        } else {
            boolean noGroupsSpecified = false;
            String[] groups = tm.getGroups();
            boolean isIncludedInGroups = XmlMethodSelector.isIncluded(this.m_includedGroups.values(), noGroupsSpecified, groups);
            boolean isExcludedInGroups = XmlMethodSelector.isExcluded(this.m_excludedGroups.values(), groups);
            if (isIncludedInGroups && !isExcludedInGroups) {
                result = true;
            } else if (isExcludedInGroups) {
                result = false;
            }
            if (isTestMethod) {
                Class<?> methodClass = method.getDeclaringClass();
                String fullMethodName = XmlMethodSelector.makeMethodName(methodClass.getName(), method.getName());
                noGroupsSpecified = this.m_includedGroups.isEmpty() && this.m_excludedGroups.isEmpty();
                for (XmlClass xmlClass : this.m_classes) {
                    Class<?> cls = xmlClass.getSupportClass();
                    if (!XmlMethodSelector.assignable(methodClass, cls)) continue;
                    List<String> includedMethods = XmlMethodSelector.createQualifiedMethodNames(xmlClass, XmlMethodSelector.toStringList(xmlClass.getIncludedMethods()));
                    boolean isIncludedInMethods = XmlMethodSelector.isIncluded(includedMethods, noGroupsSpecified, fullMethodName);
                    List<String> excludedMethods = XmlMethodSelector.createQualifiedMethodNames(xmlClass, xmlClass.getExcludedMethods());
                    boolean isExcludedInMethods = XmlMethodSelector.isExcluded(excludedMethods, fullMethodName);
                    if (!result) continue;
                    if (!xmlClass.getIncludedMethods().isEmpty()) {
                        result = isIncludedInMethods;
                    }
                    if (xmlClass.getExcludedMethods().isEmpty()) continue;
                    result = result && !isExcludedInMethods;
                }
            }
        }
        Package pkg = method.getDeclaringClass().getPackage();
        String methodName = pkg != null ? pkg.getName() + "." + method.getName() : method.getName();
        this.logInclusion(result ? "Including" : "Excluding", "method", methodName + "()");
        return result;
    }

    private static boolean assignable(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass.isAssignableFrom(targetClass) || targetClass.isAssignableFrom(sourceClass);
    }

    private void logInclusion(String including, String type, String name) {
        if (!this.m_logged.containsKey(name)) {
            XmlMethodSelector.log(including + " " + type + " " + name);
            this.m_logged.put(name, name);
        }
    }

    private boolean hasIncludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getIncludedMethods().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getExcludedMethods().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static List<String> toStringList(List<XmlInclude> methods) {
        List<String> result = Lists.newArrayList();
        for (XmlInclude m : methods) {
            result.add(m.getName());
        }
        return result;
    }

    private static List<String> createQualifiedMethodNames(XmlClass xmlClass, List<String> methods) {
        List<String> vResult = Lists.newArrayList();
        for (Class<?> cls = xmlClass.getSupportClass(); cls != null; cls = cls.getSuperclass()) {
            for (String im : methods) {
                Method[] allMethods;
                Pattern pattern = Pattern.compile(XmlMethodSelector.methodName(im));
                for (Method m : allMethods = ReflectionHelper.getLocalMethods(cls)) {
                    if (!pattern.matcher(m.getName()).matches()) continue;
                    vResult.add(XmlMethodSelector.makeMethodName(m.getDeclaringClass().getName(), m.getName()));
                }
            }
        }
        return vResult;
    }

    private static String methodName(String methodName) {
        if (methodName.contains("\\$")) {
            return methodName;
        }
        return methodName.replaceAll("\\Q$\\E", QUOTED_DOLLAR);
    }

    private static String makeMethodName(String className, String methodName) {
        return className + "." + methodName;
    }

    private static void checkMethod(Class<?> c, String methodName) {
        Pattern p = Pattern.compile(methodName);
        for (Method m : c.getMethods()) {
            if (!p.matcher(m.getName()).matches()) continue;
            return;
        }
        Utils.log("Warning", 2, "The regular expression \"" + methodName + "\" didn't match any method in class " + c.getName());
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_classes = classes;
        for (XmlClass c : classes) {
            for (XmlInclude m : c.getIncludedMethods()) {
                XmlMethodSelector.checkMethod(c.getSupportClass(), m.getName());
                String methodName = XmlMethodSelector.makeMethodName(c.getName(), m.getName());
                this.m_includedMethods.put(methodName, m);
            }
        }
    }

    public Map<String, String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public Map<String, String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setExcludedGroups(Map<String, String> excludedGroups) {
        this.m_excludedGroups = excludedGroups;
    }

    public void setIncludedGroups(Map<String, String> includedGroups) {
        this.m_includedGroups = includedGroups;
    }

    private static boolean isIncluded(Collection<String> includedGroups, boolean noGroupsSpecified, String ... groups) {
        if (noGroupsSpecified) {
            return XmlMethodSelector.isMemberOf(includedGroups, groups);
        }
        return includedGroups.isEmpty() || XmlMethodSelector.isMemberOf(includedGroups, groups);
    }

    private static boolean isExcluded(Collection<String> excludedGroups, String ... groups) {
        return XmlMethodSelector.isMemberOf(excludedGroups, groups);
    }

    private static boolean isMemberOf(Collection<String> list, String ... groups) {
        for (String group : groups) {
            for (String o : list) {
                String regexpStr = XmlMethodSelector.methodName(o);
                if (!Pattern.matches(regexpStr, group)) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(String s) {
        Utils.log("XmlMethodSelector", 4, s);
    }

    @Deprecated
    public void setExpression(String expression) {
        XmlScript script = new XmlScript();
        script.setLanguage("BeanShell");
        script.setExpression(expression);
        this.setScript(script);
    }

    public void setScript(XmlScript script) {
        this.scriptSelector = script == null ? null : ScriptSelectorFactory.getScriptSelector(script);
    }

    @Override
    public void setTestMethods(List<ITestNGMethod> testMethods) {
        this.m_testMethods = testMethods;
    }

    private void init(IMethodSelectorContext context) {
        String[] groups = this.m_includedGroups.keySet().toArray(new String[0]);
        HashSet<String> groupClosure = new HashSet<String>();
        HashSet<ITestNGMethod> methodClosure = new HashSet<ITestNGMethod>();
        List<ITestNGMethod> includedMethods = Lists.newArrayList();
        for (ITestNGMethod m : this.m_testMethods) {
            if (!this.includeMethod(context, m, true)) continue;
            includedMethods.add(m);
        }
        MethodGroupsHelper.findGroupTransitiveClosure(includedMethods, this.m_testMethods, groups, groupClosure, methodClosure);
        if (!this.m_includedGroups.isEmpty()) {
            for (String g : groupClosure) {
                XmlMethodSelector.log("Including group " + (this.m_includedGroups.containsKey(g) ? ": " : "(implicitly): ") + g);
                this.m_includedGroups.put(g, g);
            }
            for (ITestNGMethod m : methodClosure) {
                String methodName = m.getQualifiedName();
                XmlInclude xi = new XmlInclude(methodName);
                this.m_includedMethods.put(methodName, xi);
                this.logInclusion("Including", "method ", methodName);
            }
        }
    }
}

