/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread.graph;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.testng.TestNGException;
import org.testng.collections.Maps;
import org.testng.internal.DynamicGraph;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.thread.TestNGThreadFactory;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;
import org.testng.log4testng.Logger;

public class GraphThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    private final DynamicGraph<T> m_graph;
    private final IThreadWorkerFactory<T> m_factory;
    private final Map<T, IWorker<T>> mapping = Maps.newConcurrentMap();
    private final Map<T, T> upstream = Maps.newConcurrentMap();

    public GraphThreadPoolExecutor(String name, DynamicGraph<T> graph, IThreadWorkerFactory<T> factory, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new TestNGThreadFactory(name));
        this.m_graph = graph;
        this.m_factory = factory;
        if (this.m_graph.getFreeNodes().isEmpty()) {
            throw new TestNGException("The graph of methods contains a cycle:" + graph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            List<T> freeNodes = this.m_graph.getFreeNodes();
            this.runNodes(freeNodes);
        }
    }

    private void runNodes(List<T> freeNodes) {
        List<IWorker<T>> workers = this.m_factory.createWorkers(freeNodes);
        this.mapNodeToWorker(workers, freeNodes);
        for (int ix = 0; ix < workers.size(); ++ix) {
            IWorker<T> worker = workers.get(ix);
            this.mapNodeToParent(freeNodes, ix);
            this.setStatus(worker, DynamicGraph.Status.RUNNING);
            try {
                this.execute(worker);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(GraphThreadPoolExecutor.class).error(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable r, Throwable t) {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            this.setStatus((IWorker)r, this.computeStatus(r));
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED)) {
                this.shutdown();
            } else {
                List<T> freeNodes = this.m_graph.getFreeNodes();
                this.handleThreadAffinity(freeNodes);
                this.runNodes(freeNodes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IWorker<T> worker, DynamicGraph.Status status) {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            for (T m : worker.getTasks()) {
                this.m_graph.setStatus(m, status);
            }
        }
    }

    private DynamicGraph.Status computeStatus(Runnable r) {
        IWorker worker = (IWorker)r;
        DynamicGraph.Status status = DynamicGraph.Status.FINISHED;
        if (RuntimeBehavior.enforceThreadAffinity() && !worker.completed()) {
            status = DynamicGraph.Status.READY;
        }
        return status;
    }

    private void mapNodeToWorker(List<IWorker<T>> runnables, List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        int index = 0;
        for (IWorker<T> runnable : runnables) {
            T freeNode;
            IWorker<T> w;
            if ((w = this.mapping.get(freeNode = freeNodes.get(index++))) != null) {
                long current = w.getThreadIdToRunOn();
                runnable.setThreadIdToRunOn(current);
            }
            this.mapping.put(freeNode, runnable);
        }
    }

    private void mapNodeToParent(List<T> freeNodes, int ix) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        T key = freeNodes.get(ix);
        List<Object> nodes = this.m_graph.getDependenciesFor(key);
        nodes.forEach(eachNode -> this.upstream.put(eachNode, key));
    }

    private void handleThreadAffinity(List<T> freeNodes) {
        if (!RuntimeBehavior.enforceThreadAffinity()) {
            return;
        }
        for (T node : freeNodes) {
            IWorker<T> w = this.mapping.get(this.upstream.get(node));
            long threadId = w.getCurrentThreadId();
            this.mapping.put(node, new PhoneyWorker(threadId));
        }
    }

    private class PhoneyWorker
    implements IWorker<T> {
        private long threadId;

        public PhoneyWorker(long threadId) {
            this.threadId = threadId;
        }

        @Override
        public List<T> getTasks() {
            return null;
        }

        @Override
        public long getTimeOut() {
            return 0L;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public int compareTo(@Nonnull IWorker<T> o) {
            return 0;
        }

        @Override
        public void run() {
        }

        @Override
        public long getThreadIdToRunOn() {
            return this.threadId;
        }
    }
}

