/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethodListener;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.TestResult;
import org.testng.junit.IJUnitTestRunner;
import org.testng.junit.JUnit4TestClass;
import org.testng.junit.JUnit4TestMethod;

public class JUnit4TestRunner
implements IJUnitTestRunner {
    private ITestResultNotifier m_parentRunner;
    private List<ITestNGMethod> m_methods = Lists.newArrayList();
    private List<ITestListener> m_listeners = Lists.newArrayList();
    private Collection<IInvokedMethodListener> m_invokeListeners = Lists.newArrayList();
    private Map<Description, ITestResult> m_findedMethods = new WeakHashMap<Description, ITestResult>();

    public JUnit4TestRunner() {
    }

    public JUnit4TestRunner(ITestResultNotifier tr) {
        this.m_parentRunner = tr;
        this.m_listeners = this.m_parentRunner.getTestListeners();
    }

    @Override
    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    @Override
    public void setTestResultNotifier(ITestResultNotifier notifier) {
        this.m_parentRunner = notifier;
        this.m_listeners = this.m_parentRunner.getTestListeners();
    }

    @Override
    public void setInvokedMethodListeners(Collection<IInvokedMethodListener> listeners) {
        this.m_invokeListeners = listeners;
    }

    @Override
    public void run(Class testClass, String ... methods) {
        this.start(testClass, methods);
    }

    public Result start(Class testCase, final String ... methods) {
        try {
            JUnitCore core = new JUnitCore();
            core.addListener((RunListener)new RL());
            Request r = Request.aClass((Class)testCase);
            return core.run(r.filterWith(new Filter(){

                public boolean shouldRun(Description description) {
                    if (description == null) {
                        return false;
                    }
                    if (methods.length == 0) {
                        if (description.getTestClass() != null) {
                            ITestResult tr = JUnit4TestRunner.this.createTestResult(description);
                            JUnit4TestRunner.this.m_findedMethods.put(description, tr);
                        }
                        return true;
                    }
                    for (String m : methods) {
                        Pattern p = Pattern.compile(m);
                        if (!p.matcher(description.getMethodName()).matches()) continue;
                        ITestResult tr = JUnit4TestRunner.this.createTestResult(description);
                        JUnit4TestRunner.this.m_findedMethods.put(description, tr);
                        return true;
                    }
                    return false;
                }

                public String describe() {
                    return "TestNG method filter";
                }
            }));
        }
        catch (Throwable t) {
            throw new TestNGException("Failure in JUnit mode for class " + testCase.getName(), t);
        }
    }

    private ITestResult createTestResult(Description test) {
        JUnit4TestClass tc = new JUnit4TestClass(test);
        JUnit4TestMethod tm = new JUnit4TestMethod(tc, test);
        TestResult tr = new TestResult(tc, tm, null, Calendar.getInstance().getTimeInMillis(), 0L, null);
        InvokedMethod im = new InvokedMethod(tr.getTestClass(), tr.getMethod(), tr.getStartMillis(), tr);
        this.m_parentRunner.addInvokedMethod(im);
        for (IInvokedMethodListener l : this.m_invokeListeners) {
            l.beforeInvocation(im, tr);
        }
        return tr;
    }

    private static boolean isAssumptionFailed(Failure failure) {
        Throwable exception = failure.getException();
        if (exception == null) {
            return false;
        }
        return "org.junit.internal.AssumptionViolatedException".equals(exception.getClass().getCanonicalName());
    }

    private class RL
    extends RunListener {
        private List<Description> notified = new LinkedList<Description>();

        private RL() {
        }

        public void testAssumptionFailure(Failure failure) {
            this.notified.add(failure.getDescription());
            ITestResult tr = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(failure.getDescription());
            this.validate(tr, failure.getDescription());
            this.runAfterInvocationListeners(tr);
            tr.setStatus(3);
            tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
            tr.setThrowable(failure.getException());
            JUnit4TestRunner.this.m_parentRunner.addSkippedTest(tr.getMethod(), tr);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestSkipped(tr);
            }
        }

        public void testFailure(Failure failure) throws Exception {
            if (failure == null) {
                return;
            }
            if (JUnit4TestRunner.isAssumptionFailed(failure)) {
                this.testAssumptionFailure(failure);
                return;
            }
            this.notified.add(failure.getDescription());
            ITestResult tr = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(failure.getDescription());
            if (tr == null) {
                tr = JUnit4TestRunner.this.createTestResult(failure.getDescription());
                this.runAfterInvocationListeners(tr);
                tr.setStatus(2);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                tr.setThrowable(failure.getException());
                for (IConfigurationListener l : JUnit4TestRunner.this.m_parentRunner.getConfigurationListeners()) {
                    l.onConfigurationFailure(tr);
                }
                for (Description childDesc : failure.getDescription().getChildren()) {
                    this.testIgnored(childDesc);
                }
            } else {
                this.runAfterInvocationListeners(tr);
                tr.setStatus(2);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                tr.setThrowable(failure.getException());
                JUnit4TestRunner.this.m_parentRunner.addFailedTest(tr.getMethod(), tr);
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestFailure(tr);
                }
            }
        }

        public void testFinished(Description description) throws Exception {
            ITestResult tr = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(description);
            this.validate(tr, description);
            this.runAfterInvocationListeners(tr);
            if (!this.notified.contains(description)) {
                tr.setStatus(1);
                tr.setEndMillis(Calendar.getInstance().getTimeInMillis());
                JUnit4TestRunner.this.m_parentRunner.addPassedTest(tr.getMethod(), tr);
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestSuccess(tr);
                }
            }
            JUnit4TestRunner.this.m_methods.add(tr.getMethod());
        }

        public void testIgnored(Description description) throws Exception {
            if (!this.notified.contains(description)) {
                this.notified.add(description);
                ITestResult tr = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(description);
                this.validate(tr, description);
                this.runAfterInvocationListeners(tr);
                tr.setStatus(3);
                tr.setEndMillis(tr.getStartMillis());
                JUnit4TestRunner.this.m_parentRunner.addSkippedTest(tr.getMethod(), tr);
                JUnit4TestRunner.this.m_methods.add(tr.getMethod());
                for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                    l.onTestSkipped(tr);
                }
            }
        }

        public void testRunFinished(Result result) throws Exception {
        }

        public void testRunStarted(Description description) throws Exception {
        }

        public void testStarted(Description description) throws Exception {
            ITestResult tr = (ITestResult)JUnit4TestRunner.this.m_findedMethods.get(description);
            this.validate(tr, description);
            for (ITestListener l : JUnit4TestRunner.this.m_listeners) {
                l.onTestStart(tr);
            }
        }

        private void runAfterInvocationListeners(ITestResult tr) {
            InvokedMethod im = new InvokedMethod(tr.getTestClass(), tr.getMethod(), tr.getEndMillis(), tr);
            for (IInvokedMethodListener l : JUnit4TestRunner.this.m_invokeListeners) {
                l.afterInvocation(im, tr);
            }
        }

        private void validate(ITestResult tr, Description description) {
            if (tr == null) {
                throw new TestNGException(this.stringify(description));
            }
        }

        private String stringify(Description description) {
            return description.getClassName() + "." + description.getMethodName() + "()";
        }
    }
}

