/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlDependencies;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlRun;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlWeaver;
import org.testng.xml.dom.ParentSetter;

public class XmlTest
implements Cloneable {
    public static final int DEFAULT_TIMEOUT_MS = Integer.MAX_VALUE;
    private XmlSuite m_suite;
    private String m_name;
    private Integer m_verbose = XmlSuite.DEFAULT_VERBOSE;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private int m_threadCount = -1;
    private List<XmlClass> m_xmlClasses = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private XmlSuite.ParallelMode m_parallel;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_timeOut;
    private Boolean m_skipFailedInvocationCounts = XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    private Map<String, List<Integer>> m_failedInvocationNumbers = null;
    private Boolean m_preserveOrder = XmlSuite.DEFAULT_PRESERVE_ORDER;
    private int m_index;
    private Boolean m_groupByInstances;
    private Boolean m_allowReturnValues = null;
    private Map<String, String> m_xmlDependencyGroups = Maps.newHashMap();
    private XmlGroups m_xmlGroups;

    public XmlTest(XmlSuite suite, int index) {
        this.init(suite, index);
    }

    public XmlTest(XmlSuite suite) {
        this.init(suite, 0);
    }

    private void init(XmlSuite suite, int index) {
        this.m_suite = suite;
        this.m_suite.getTests().add(this);
        this.m_index = index;
        this.m_name = "Command line test " + UUID.randomUUID().toString();
    }

    public XmlTest() {
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = Lists.newArrayList(packages);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    public void setPackages(List<XmlPackage> p) {
        this.setXmlPackages(p);
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = Lists.newArrayList(methodSelectors);
    }

    public final XmlSuite getSuite() {
        if (this.m_suite == null) {
            throw new IllegalStateException("Current [XmlTest] object is not associated with any [XmlSuite] yet.");
        }
        return this.m_suite;
    }

    public List<String> getIncludedGroups() {
        List result = Lists.newArrayList();
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            result.addAll(this.m_xmlGroups.getRun().getIncludes());
        }
        result.addAll(this.getSuite().getIncludedGroups());
        return Collections.unmodifiableList(result);
    }

    @Deprecated
    public void setClassNames(List<XmlClass> classes) {
        this.m_xmlClasses = classes;
    }

    public List<XmlClass> getXmlClasses() {
        return this.m_xmlClasses;
    }

    public List<XmlClass> getClasses() {
        return this.getXmlClasses();
    }

    public void setClasses(List<XmlClass> c) {
        this.setXmlClasses(c);
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_xmlClasses = classes;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVerbose(int v) {
        this.m_verbose = v;
    }

    public int getThreadCount() {
        return this.m_threadCount > 0 ? this.m_threadCount : this.getSuite().getThreadCount();
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public void setIncludedGroups(List<String> g) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        if (this.m_xmlGroups.getRun() == null) {
            this.m_xmlGroups.setRun(new XmlRun());
        }
        List<String> includes = this.m_xmlGroups.getRun().getIncludes();
        includes.clear();
        includes.addAll(g);
    }

    public void setExcludedGroups(List<String> g) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        if (this.m_xmlGroups.getRun() == null) {
            this.m_xmlGroups.setRun(new XmlRun());
        }
        List<String> excludes = this.m_xmlGroups.getRun().getExcludes();
        excludes.clear();
        excludes.addAll(g);
    }

    public List<String> getExcludedGroups() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            result.addAll(this.m_xmlGroups.getRun().getExcludes());
        }
        result.addAll(this.getSuite().getExcludedGroups());
        return Collections.unmodifiableList(result);
    }

    public void addIncludedGroup(String g) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
            this.m_xmlGroups.setRun(new XmlRun());
        }
        this.m_xmlGroups.getRun().getIncludes().add(g);
    }

    public void addExcludedGroup(String g) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        if (this.m_xmlGroups.getRun() == null) {
            this.m_xmlGroups.setRun(new XmlRun());
        }
        this.m_xmlGroups.getRun().getExcludes().add(g);
    }

    public int getVerbose() {
        Integer result = this.m_verbose;
        if (null == result || XmlSuite.DEFAULT_VERBOSE.equals(this.m_verbose)) {
            result = this.getSuite().getVerbose();
        }
        if (null != result) {
            return result;
        }
        return 1;
    }

    public boolean getGroupByInstances() {
        Boolean result = this.m_groupByInstances;
        if (result == null || XmlSuite.DEFAULT_GROUP_BY_INSTANCES.equals(this.m_groupByInstances)) {
            result = this.getSuite().getGroupByInstances();
        }
        if (result != null) {
            return result;
        }
        return XmlSuite.DEFAULT_GROUP_BY_INSTANCES;
    }

    public void setGroupByInstances(boolean f) {
        this.m_groupByInstances = f;
    }

    public boolean isJUnit() {
        Boolean result = this.m_isJUnit;
        if (null == result || XmlSuite.DEFAULT_JUNIT.equals(result)) {
            result = this.getSuite().isJUnit();
        }
        return result;
    }

    public void setJUnit(boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setJunit(boolean isJUnit) {
        this.setJUnit(isJUnit);
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public boolean skipFailedInvocationCounts() {
        Boolean result = this.m_skipFailedInvocationCounts;
        if (null == result) {
            result = this.getSuite().skipFailedInvocationCounts();
        }
        return result;
    }

    public void addMetaGroup(String name, List<String> metaGroup) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        XmlDefine define = new XmlDefine();
        define.setName(name);
        define.getIncludes().addAll(metaGroup);
        this.m_xmlGroups.getDefines().add(define);
    }

    public void addMetaGroup(String name, String ... metaGroup) {
        this.addMetaGroup(name, Arrays.asList(metaGroup));
    }

    public void setMetaGroups(Map<String, List<String>> metaGroups) {
        for (Map.Entry<String, List<String>> entry : metaGroups.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, List<String>> getMetaGroups() {
        if (this.m_xmlGroups == null) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> result = Maps.newHashMap();
        List<XmlDefine> defines = this.m_xmlGroups.getDefines();
        for (XmlDefine xd : defines) {
            result.put(xd.getName(), xd.getIncludes());
        }
        return result;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.m_parameters.put(key, value);
    }

    public String getParameter(String name) {
        String result = this.m_parameters.get(name);
        if (null == result) {
            result = this.getSuite().getParameter(name);
        }
        return result;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> result = Maps.newHashMap();
        result.putAll(this.getSuite().getParameters());
        result.putAll(this.m_parameters);
        return result;
    }

    public Map<String, String> getLocalParameters() {
        return this.m_parameters;
    }

    @Deprecated
    public Map<String, String> getParameters() {
        return this.getAllParameters();
    }

    @Deprecated
    public Map<String, String> getTestParameters() {
        return this.getLocalParameters();
    }

    public void setParallel(XmlSuite.ParallelMode parallel) {
        this.m_parallel = XmlSuite.ParallelMode.skipDeprecatedValues(parallel);
    }

    public XmlSuite.ParallelMode getParallel() {
        XmlSuite.ParallelMode result = this.getSuite().getParallel();
        if (null != this.m_parallel) {
            result = this.m_parallel;
        }
        return result;
    }

    public String getTimeOut() {
        String result = this.getSuite().getTimeOut();
        if (null != this.m_timeOut) {
            result = this.m_timeOut;
        }
        return result;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.getTimeOut() != null) {
            result = Long.parseLong(this.getTimeOut());
        }
        return result;
    }

    public void setTimeOut(long timeOut) {
        this.m_timeOut = Long.toString(timeOut);
    }

    private void setTimeOut(String timeOut) {
        this.m_timeOut = timeOut;
    }

    @Deprecated
    public void setExpression(String expression) {
        this.setBeanShellExpression(expression);
    }

    @Deprecated
    public void setBeanShellExpression(String expression) {
        if (expression != null) {
            XmlScript script = new XmlScript();
            script.setExpression(expression);
            script.setLanguage("BeanShell");
        }
    }

    public void setScript(XmlScript script) {
        List<XmlMethodSelector> selectors = this.getMethodSelectors();
        if (selectors.size() > 0) {
            XmlMethodSelector xms = selectors.get(0);
            xms.setScript(script);
        } else if (script != null) {
            XmlMethodSelector xms = new XmlMethodSelector();
            selectors.add(xms);
            xms.setScript(script);
        }
    }

    @Deprecated
    public String getExpression() {
        XmlScript script = this.getScript();
        if (script == null) {
            return null;
        }
        return script.getExpression();
    }

    public XmlScript getScript() {
        List<XmlMethodSelector> selectors = this.getMethodSelectors();
        if (selectors.isEmpty()) {
            return null;
        }
        return selectors.get(0).getScript();
    }

    public String toXml(String indent) {
        return XmlWeaver.asXml(this, indent);
    }

    public Object clone() {
        XmlTest result = new XmlTest(this.getSuite());
        result.setName(this.getName());
        result.setIncludedGroups(this.getIncludedGroups());
        result.setExcludedGroups(this.getExcludedGroups());
        result.setJUnit(this.isJUnit());
        result.setParallel(this.getParallel());
        result.setVerbose(this.getVerbose());
        result.setParameters(this.getLocalParameters());
        result.setXmlPackages(this.getXmlPackages());
        result.setTimeOut(this.getTimeOut());
        Map<String, List<String>> metagroups = this.getMetaGroups();
        for (Map.Entry<String, List<String>> group : metagroups.entrySet()) {
            result.addMetaGroup(group.getKey(), group.getValue());
        }
        return result;
    }

    public List<Integer> getInvocationNumbers(String method) {
        List<Integer> result;
        if (this.m_failedInvocationNumbers == null) {
            this.m_failedInvocationNumbers = Maps.newHashMap();
            for (XmlClass c : this.getXmlClasses()) {
                for (XmlInclude xi : c.getIncludedMethods()) {
                    List<Integer> invocationNumbers = xi.getInvocationNumbers();
                    if (invocationNumbers.size() <= 0) continue;
                    String methodName = c.getName() + "." + xi.getName();
                    this.m_failedInvocationNumbers.put(methodName, invocationNumbers);
                }
            }
        }
        if ((result = this.m_failedInvocationNumbers.get(method)) == null) {
            return Lists.newArrayList();
        }
        return result;
    }

    @Deprecated
    public void setPreserveOrder(String preserveOrder) {
        this.setPreserveOrder(Boolean.valueOf(preserveOrder));
    }

    public void setPreserveOrder(Boolean preserveOrder) {
        this.m_preserveOrder = preserveOrder;
    }

    public Boolean getPreserveOrder() {
        if (this.m_preserveOrder == null) {
            return this.getSuite().getPreserveOrder();
        }
        return this.m_preserveOrder;
    }

    public void setSuite(XmlSuite result) {
        this.m_suite = result;
    }

    public Boolean getAllowReturnValues() {
        if (this.m_allowReturnValues != null) {
            return this.m_allowReturnValues;
        }
        return this.getSuite().getAllowReturnValues();
    }

    public void setAllowReturnValues(Boolean allowReturnValues) {
        this.m_allowReturnValues = allowReturnValues;
    }

    public int getIndex() {
        return this.m_index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_xmlGroups == null || this.m_xmlGroups.getRun() == null ? 0 : this.m_xmlGroups.getRun().getExcludes().hashCode());
        result = 31 * result + (this.m_failedInvocationNumbers == null ? 0 : this.m_failedInvocationNumbers.hashCode());
        result = 31 * result + (this.m_xmlGroups == null || this.m_xmlGroups.getRun() == null ? 0 : this.m_xmlGroups.getRun().getIncludes().hashCode());
        result = 31 * result + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        result = 31 * result + (this.m_xmlGroups == null ? 0 : this.m_xmlGroups.getDefines().hashCode());
        result = 31 * result + (this.m_methodSelectors == null ? 0 : this.m_methodSelectors.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        result = 31 * result + (this.m_parameters == null ? 0 : this.m_parameters.hashCode());
        result = 31 * result + (this.m_preserveOrder == null ? 0 : this.m_preserveOrder.hashCode());
        result = 31 * result + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        result = 31 * result + this.m_threadCount;
        result = 31 * result + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        result = 31 * result + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        result = 31 * result + (this.m_xmlClasses == null ? 0 : this.m_xmlClasses.hashCode());
        result = 31 * result + (this.m_xmlPackages == null ? 0 : this.m_xmlPackages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlTest other = (XmlTest)obj;
        if (this.m_xmlGroups == null) {
            if (other.m_xmlGroups != null) {
                return XmlSuite.f();
            }
        } else {
            if (other.m_xmlGroups == null) {
                return false;
            }
            if (this.m_xmlGroups.getRun() == null && other.m_xmlGroups != null || this.m_xmlGroups.getRun() != null && other.m_xmlGroups == null) {
                return false;
            }
            if (!this.m_xmlGroups.getRun().getExcludes().equals(other.m_xmlGroups.getRun().getExcludes())) {
                return XmlSuite.f();
            }
            if (!this.m_xmlGroups.getRun().getIncludes().equals(other.m_xmlGroups.getRun().getIncludes())) {
                return XmlSuite.f();
            }
            if (!this.m_xmlGroups.getDefines().equals(other.m_xmlGroups.getDefines())) {
                return false;
            }
        }
        if (this.m_failedInvocationNumbers == null ? other.m_failedInvocationNumbers != null : !this.m_failedInvocationNumbers.equals(other.m_failedInvocationNumbers)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? other.m_isJUnit != null && !other.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT) : !this.m_isJUnit.equals(other.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? other.m_methodSelectors != null : !this.m_methodSelectors.equals(other.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? other.m_parallel != null : !this.m_parallel.equals((Object)other.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_parameters == null ? other.m_parameters != null : !this.m_parameters.equals(other.m_parameters)) {
            return XmlSuite.f();
        }
        if (this.m_preserveOrder == null ? other.m_preserveOrder != null : !this.m_preserveOrder.equals(other.m_preserveOrder)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? other.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(other.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != other.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? other.m_timeOut != null : !this.m_timeOut.equals(other.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? other.m_verbose != null : !this.m_verbose.equals(other.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlClasses == null ? other.m_xmlClasses != null : !this.m_xmlClasses.equals(other.m_xmlClasses)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? other.m_xmlPackages != null : !this.m_xmlPackages.equals(other.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void addXmlDependencyGroup(String group, String dependsOn) {
        if (this.m_xmlDependencyGroups.containsKey(group)) {
            throw new TestNGException("Duplicate group dependency found for group \"" + group + "\", use a space-separated list of groups in the \"depends-on\" attribute");
        }
        this.m_xmlDependencyGroups.put(group, dependsOn);
    }

    public Map<String, String> getXmlDependencyGroups() {
        Map<String, String> result = this.m_xmlDependencyGroups;
        if (this.m_xmlGroups != null) {
            List<XmlDependencies> deps = this.m_xmlGroups.getDependencies();
            for (XmlDependencies d : deps) {
                result.putAll(d.getDependencies());
            }
        }
        return result;
    }

    @ParentSetter
    public void setXmlSuite(XmlSuite suite) {
        this.m_suite = suite;
    }

    public void setGroups(XmlGroups xmlGroups) {
        this.m_xmlGroups = xmlGroups;
    }

    public XmlGroups getXmlGroups() {
        return this.m_xmlGroups;
    }

    public boolean nameMatchesAny(List<String> names) {
        return names.contains(this.getName());
    }
}

